/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.io;

import com.metamatrix.api.core.message.MessageList;
import com.metamatrix.api.core.xmi.EntityInfo;
import com.metamatrix.api.core.xmi.FeatureInfo;
import com.metamatrix.api.core.xmi.XMIHeader;
import com.metamatrix.api.core.xmi.XMIReaderAdapter;
import com.metamatrix.bridges.BridgesPlugin;
import com.metamatrix.bridges.io.BridgeEntityFactory;
import com.metamatrix.bridges.io.BridgeFeatureMapper;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.bridges.xml.xmi.BridgeXmiContentHandler;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.UserCancelledException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.xml.sax.SAXException;

public class BridgeReaderAdapter
implements XMIReaderAdapter {
    private final BridgeImporter importer;
    private final IProgressMonitor monitor;
    private BridgeEntityFactory entityFactory;
    private BridgeFeatureMapper featureMapper;
    private MtkXmiResourceImpl logicalResource;
    private MtkXmiResourceImpl physicalResource;
    private MtkXmiResourceImpl relationshipResource;
    private XSDResourceImpl dataTypeResource;

    public BridgeReaderAdapter(BridgeImporter importer) {
        this.importer = importer;
        this.monitor = importer.getProgressMonitor();
        this.entityFactory = new BridgeEntityFactory(this, importer);
        this.featureMapper = new BridgeFeatureMapper(importer, this.entityFactory);
    }

    public XMIHeader getHeader() {
        return null;
    }

    public Object setHeader(XMIHeader xmiHeader) {
        return null;
    }

    public Object createEntity(EntityInfo entityInfo, Object parentBusObj) {
        if (this.monitor.isCanceled()) {
            throw new UserCancelledException();
        }
        try {
            Object result = this.entityFactory.createEntity(entityInfo, parentBusObj);
            return result;
        }
        catch (Exception e) {
            String qName = entityInfo.getQMetaClassName();
            int i = qName == null ? -1 : qName.lastIndexOf("/");
            String key = i == -1 ? qName : qName.substring(i + 1);
            String name = this.entityFactory.getName(parentBusObj);
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_creating_child", (Object)key, (Object)name);
            this.importer.log(msg, 4, e);
            return null;
        }
    }

    public void createFeature(FeatureInfo featureInfo, Object parentBusObj) {
        try {
            this.featureMapper.setFeatureValue(featureInfo, parentBusObj);
        }
        catch (Exception e) {
            String key = featureInfo.getMetaClassName() + "." + featureInfo.getName();
            String name = this.entityFactory.getName(parentBusObj);
            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unexpected_exception_setting_value", (Object)key, (Object)name);
            this.importer.log(msg, 4, e);
        }
    }

    public void finishEntity(Object busObj) {
    }

    public void finishFeature(FeatureInfo featureInfo, Object parentBusObj) {
    }

    public void finishDocument() {
        if (this.importer.getProgressMonitor().isCanceled()) {
            this.removeResources();
            return;
        }
        this.entityFactory.postProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish(boolean doSave) {
        block27: {
            try {
                try {
                    String msg;
                    if (!doSave) {
                        Object var6_2 = null;
                        this.logicalResource = null;
                        this.physicalResource = null;
                        this.relationshipResource = null;
                        this.dataTypeResource = null;
                        this.entityFactory.cleanup();
                        this.entityFactory = null;
                        this.featureMapper.cleanup();
                        this.featureMapper = null;
                        return;
                    }
                    HashMap options = new HashMap();
                    if (this.isWorkspaceResource((Resource)this.logicalResource)) {
                        try {
                            if (this.entityFactory.isPhysicalOnlyModel() || this.logicalResource.getContents().size() < 2) {
                                this.logicalResource.getResourceSet().getResources().remove((Object)this.logicalResource);
                                this.logicalResource = null;
                            } else {
                                this.logicalResource.save(options);
                            }
                        }
                        catch (Exception e1) {
                            msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_logical_resource_1");
                            this.importer.log(msg, 4, e1);
                        }
                    }
                    if (this.isWorkspaceResource((Resource)this.physicalResource)) {
                        try {
                            if (this.entityFactory.isLogicalOnlyModel() || this.physicalResource.getContents().size() < 2) {
                                this.physicalResource.getResourceSet().getResources().remove((Object)this.physicalResource);
                                this.physicalResource = null;
                            } else {
                                this.physicalResource.save(options);
                            }
                        }
                        catch (Exception e1) {
                            msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_physical_resource_2");
                            this.importer.log(msg, 4, e1);
                        }
                    }
                    if (this.isWorkspaceResource((Resource)this.relationshipResource)) {
                        try {
                            if (this.entityFactory.isLogicalOnlyModel() || this.entityFactory.isPhysicalOnlyModel() || this.relationshipResource.getContents().size() < 2) {
                                this.relationshipResource.getResourceSet().getResources().remove((Object)this.relationshipResource);
                                this.relationshipResource = null;
                            } else {
                                this.relationshipResource.save(options);
                            }
                        }
                        catch (Exception e1) {
                            msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_relationship_resource_3");
                            this.importer.log(msg, 4, e1);
                        }
                    }
                    if (!this.isWorkspaceResource((Resource)this.dataTypeResource)) break block27;
                    try {
                        if (this.dataTypeResource.getSchema() != null && !this.dataTypeResource.getSchema().getTypeDefinitions().isEmpty()) {
                            this.dataTypeResource.save(options);
                            break block27;
                        }
                        this.dataTypeResource.getResourceSet().getResources().remove((Object)this.dataTypeResource);
                        this.dataTypeResource = null;
                    }
                    catch (Exception e1) {
                        msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_error_saving_data_type_resource_4");
                        this.importer.log(msg, 4, e1);
                    }
                }
                catch (Exception e) {
                    this.importer.log(e.getMessage(), 4, e);
                    Object var6_4 = null;
                    this.logicalResource = null;
                    this.physicalResource = null;
                    this.relationshipResource = null;
                    this.dataTypeResource = null;
                    this.entityFactory.cleanup();
                    this.entityFactory = null;
                    this.featureMapper.cleanup();
                    this.featureMapper = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.logicalResource = null;
                this.physicalResource = null;
                this.relationshipResource = null;
                this.dataTypeResource = null;
                this.entityFactory.cleanup();
                this.entityFactory = null;
                this.featureMapper.cleanup();
                this.featureMapper = null;
                throw throwable;
            }
        }
        Object var6_3 = null;
        this.logicalResource = null;
        this.physicalResource = null;
        this.relationshipResource = null;
        this.dataTypeResource = null;
        this.entityFactory.cleanup();
        this.entityFactory = null;
        this.featureMapper.cleanup();
        this.featureMapper = null;
    }

    private boolean isWorkspaceResource(Resource rsrc) {
        ResourceSet rs;
        if (rsrc == null) {
            return false;
        }
        ContainerImpl updateCntr = (ContainerImpl)this.importer.getUpdateContainer();
        return updateCntr != (rs = rsrc.getResourceSet()) && updateCntr.getResourceSet() != rs;
    }

    public void read(InputStream is) throws MetaMatrixCoreException {
        ArgCheck.isNotNull((Object)is);
        MessageList messages = new MessageList();
        try {
            BridgeXmiContentHandler.read((InputStream)is, (MessageList)messages, (XMIReaderAdapter)this, (boolean)true);
        }
        catch (Exception e) {
            if (e instanceof UserCancelledException) {
                throw (UserCancelledException)e;
            }
            if (e instanceof SAXException) {
                Exception cause = ((SAXException)e).getException();
                if (!(cause instanceof UserCancelledException)) {
                    String msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_Exception_reading_model___{0}_2", (Object)e.getMessage());
                    BridgesPlugin.Util.log(4, (Throwable)e, msg);
                    this.importer.log(msg, 4, e);
                }
            }
            String msg = BridgesPlugin.Util.getString("BridgeReaderAdapter.Unexpected_Exception_reading_model___{0}_2", (Object)e.getMessage());
            BridgesPlugin.Util.log(4, (Throwable)e, msg);
            this.importer.log(msg, 4, e);
        }
    }

    public MessageList getMessages() {
        return null;
    }

    public MtkXmiResourceImpl getPhysicalResource() {
        if (this.physicalResource == null) {
            try {
                this.physicalResource = (MtkXmiResourceImpl)this.importer.createResource(this.importer.getTargetPhysicalModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.physicalResource;
    }

    public MtkXmiResourceImpl getLogicalResource() {
        if (this.logicalResource == null) {
            try {
                this.logicalResource = (MtkXmiResourceImpl)this.importer.createResource(this.importer.getTargetLogicalModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.logicalResource;
    }

    public MtkXmiResourceImpl getRelationshipResource() {
        if (this.relationshipResource == null) {
            try {
                this.relationshipResource = (MtkXmiResourceImpl)this.importer.createResource(this.importer.getTargetRelationshipsModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.relationshipResource;
    }

    public XSDResourceImpl getDatatypeResource() {
        if (this.dataTypeResource == null) {
            try {
                this.dataTypeResource = (XSDResourceImpl)this.importer.createResource(this.importer.getTargetDatatypeModelName());
            }
            catch (MetaMatrixCoreException e) {
                this.importer.log(e.getMessage(), 4, (Exception)((Object)e));
            }
        }
        return this.dataTypeResource;
    }

    private void removeResources() {
        if (this.logicalResource != null) {
            this.logicalResource.getResourceSet().getResources().remove((Object)this.logicalResource);
        }
        if (this.physicalResource != null) {
            this.physicalResource.getResourceSet().getResources().remove((Object)this.physicalResource);
        }
        if (this.relationshipResource != null) {
            this.relationshipResource.getResourceSet().getResources().remove((Object)this.relationshipResource);
        }
        if (this.dataTypeResource != null) {
            this.dataTypeResource.getResourceSet().getResources().remove((Object)this.dataTypeResource);
        }
    }
}

