/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.jdbcx.db2.DB2Xid;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;
import javax.transaction.xa.XAException;

public class DRDASyncRequest
extends DRDARequest {
    private static String footprint = "$Revision:   3.2.4.0  $";
    public DB2Xid[] recoveredXids;
    private int currentRecoverPos;
    public int xaStatus;

    public DRDASyncRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
    }

    public void start(DB2Xid dB2Xid, int n) throws XAException {
        try {
            int n2 = this.writer.writePacketHeader((short)1, (short)0, 1);
            int n3 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(9);
            this.writer.writeInt16(dB2Xid.formattedLen + 4);
            this.writer.writeInt16(6145);
            this.writer.writeBytes(dB2Xid.formatted);
            this.writer.writeInt16(8);
            this.writer.writeInt16(6403);
            switch (n) {
                case 0: {
                    this.writer.writeInt32(0);
                    break;
                }
                case 0x8000000: {
                    this.writer.writeInt32(0x200000);
                    break;
                }
                case 0x200000: {
                    this.writer.writeInt32(0x200000);
                    break;
                }
                default: {
                    this.writer.writeInt32(0);
                }
            }
            this.writer.writeCodePointLength(n3);
            this.writer.writePacketLength(n2);
        }
        catch (Exception exception) {
            throw new XAException(exception.getMessage());
        }
    }

    public void end(DB2Xid dB2Xid, int n) throws XAException {
        try {
            int n2 = this.writer.writePacketHeader((short)1, (short)0, 1);
            int n3 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(11);
            this.writer.writeInt16(dB2Xid.formattedLen + 4);
            this.writer.writeInt16(6145);
            this.writer.writeBytes(dB2Xid.formatted);
            this.writer.writeInt16(8);
            this.writer.writeInt16(6403);
            switch (n) {
                case 0x4000000: {
                    this.writer.writeInt32(0x4000000);
                    break;
                }
                case 0x2000000: {
                    this.writer.writeInt32(0x4000000);
                    break;
                }
                default: {
                    this.writer.writeInt32(0x4000000);
                }
            }
            this.writer.writeCodePointLength(n3);
            this.writer.writePacketLength(n2);
        }
        catch (Exception exception) {
            throw new XAException(exception.getMessage());
        }
    }

    public void prepareToCommit(DB2Xid dB2Xid) throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)0, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(1);
            this.writer.writeInt16(dB2Xid.formattedLen + 4);
            this.writer.writeInt16(6145);
            this.writer.writeBytes(dB2Xid.formatted);
            this.writer.writeInt16(8);
            this.writer.writeInt16(6403);
            this.writer.writeInt32(0);
            this.writer.writeCodePointLength(n2);
            this.writer.writeCodePointLength(n);
        }
        catch (UtilException utilException) {
            throw new XAException(utilException.getMessage());
        }
    }

    public void commit(DB2Xid dB2Xid, boolean bl) throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)0, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(3);
            this.writer.writeInt16(dB2Xid.formattedLen + 4);
            this.writer.writeInt16(6145);
            this.writer.writeBytes(dB2Xid.formatted);
            this.writer.writeInt16(8);
            this.writer.writeInt16(6403);
            if (bl) {
                this.writer.writeInt32(0x40000000);
            } else {
                this.writer.writeInt32(0);
            }
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n);
        }
        catch (UtilException utilException) {
            throw new XAException(utilException.getMessage());
        }
    }

    public void rollBack(DB2Xid dB2Xid) throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)0, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(4);
            this.writer.writeInt16(dB2Xid.formattedLen + 4);
            this.writer.writeInt16(6145);
            this.writer.writeBytes(dB2Xid.formatted);
            this.writer.writeInt16(8);
            this.writer.writeInt16(6403);
            this.writer.writeInt32(0);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n);
        }
        catch (UtilException utilException) {
            throw new XAException(utilException.getMessage());
        }
    }

    public void recover() throws XAException {
        try {
            int n = this.writer.writePacketHeader((short)1, (short)0, 1);
            int n2 = this.writer.writeCodePoint((short)4181);
            this.writer.writeInt16(5);
            this.writer.writeInt16(4487);
            this.writer.writeInt8(12);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n);
        }
        catch (UtilException utilException) {
            throw new XAException(utilException.getMessage());
        }
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 4680: 
                case 6405: {
                    break;
                }
                case 6404: {
                    this.xaStatus = this.reader.readInt32();
                    break;
                }
                case 6406: {
                    this.recoveredXids = new DB2Xid[this.reader.readInt16()];
                    this.currentRecoverPos = 0;
                    break;
                }
                case 6145: {
                    int n3 = this.reader.readInt32();
                    byte[] byArray = new byte[this.reader.readInt32()];
                    byte[] byArray2 = new byte[this.reader.readInt32()];
                    this.reader.readBytes(byArray, 0, byArray.length);
                    this.reader.readBytes(byArray2, 0, byArray2.length);
                    this.recoveredXids[this.currentRecoverPos++] = new DB2Xid(n3, byArray, byArray2);
                    break;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
        return true;
    }
}

