/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class OracleNet8NSPTCNPacket {
    private static String footprint = "$Revision:   3.4.1.0  $";
    OracleNet8Communication comm;
    String OraConnString;
    OracleDataProvider reader;
    OracleDataConsumer writer;
    int SDUSize;
    int TDUSize;
    int ANOFlag;

    public OracleNet8NSPTCNPacket(OracleNet8Communication oracleNet8Communication, String string) {
        this.comm = oracleNet8Communication;
        this.OraConnString = string;
        this.SDUSize = 2048;
        this.TDUSize = Short.MAX_VALUE;
        this.ANOFlag = 4;
        this.reader = this.comm.getReader();
        this.writer = this.comm.getWriter();
    }

    public void setANOFlag(int n) {
        this.ANOFlag = n;
    }

    public void submitRequest() throws SQLException {
        try {
            this.comm.setNSPTPacketType(1);
            this.writer.writeByte((byte)1);
            this.writer.writeByte((byte)52);
            this.writer.writeByte((byte)1);
            this.writer.writeByte((byte)44);
            this.writer.writeByte((byte)0);
            this.writer.writeByte((byte)0);
            this.writer.writeBigEndianInt16(this.SDUSize);
            this.writer.writeBigEndianInt16(this.TDUSize);
            this.writer.writeByte((byte)79);
            this.writer.writeByte((byte)-104);
            this.writer.writeBigEndianInt16(0);
            this.writer.writeByte((byte)0);
            this.writer.writeByte((byte)1);
            this.writer.writeBigEndianInt16(this.OraConnString.length());
            this.writer.writeByte((byte)0);
            this.writer.writeByte((byte)34);
            this.writer.writeBigEndianInt32(0);
            this.writer.writeByte((byte)this.ANOFlag);
            this.writer.writeByte((byte)this.ANOFlag);
            this.writer.writeString(this.OraConnString);
            this.writer.send();
            this.reader.receive();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public int getReplyNSPTPacketType() throws SQLException {
        return this.reader.getNSPacketType();
    }

    public void receiveReply() throws SQLException {
    }
}

