/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.tns;

import com.metamatrix.jdbc.oracle.tns.TnsValueInfo;
import java.util.ArrayList;

public class TnsFailoverMode {
    private static String footprint = "$Revision:   1.0.2.0  $";
    static final int TNSFAILOVERTYPE_DEFAULT = 0;
    static final int TNSFAILOVERTYPE_NONE = 1;
    static final int TNSFAILOVERTYPE_SESSION = 2;
    static final int TNSFAILOVERTYPE_SELECT = 3;
    static final int TNSFAILOVERMETHOD_DEFAULT = 0;
    static final int TNSFAILOVERMETHOD_PRECONNECT = 1;
    static final int TNSFAILOVERMETHOD_BASIC = 2;
    private String m_backup = "";
    private int m_type = 0;
    private int m_method = 0;
    private int m_retries = Integer.MAX_VALUE;
    private int m_delay = Integer.MAX_VALUE;

    TnsFailoverMode(TnsValueInfo tnsValueInfo) {
        ArrayList arrayList = tnsValueInfo.getValues();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            TnsValueInfo tnsValueInfo2 = new TnsValueInfo((String)arrayList.get(n2));
            if (tnsValueInfo2.Equals("BACKUP")) {
                this.m_backup = tnsValueInfo2.getValue();
            } else if (tnsValueInfo2.Equals("TYPE")) {
                if (tnsValueInfo2.ValueEquals("SESSION")) {
                    this.m_type = 2;
                } else if (tnsValueInfo2.ValueEquals("SELECT")) {
                    this.m_type = 3;
                } else if (tnsValueInfo2.ValueEquals("NONE")) {
                    this.m_type = 1;
                }
            } else if (tnsValueInfo2.Equals("METHOD")) {
                if (tnsValueInfo2.ValueEquals("PRECONNECT")) {
                    this.m_method = 1;
                } else if (tnsValueInfo2.ValueEquals("BASIC")) {
                    this.m_method = 2;
                }
            } else if (tnsValueInfo2.Equals("RETRIES")) {
                this.m_retries = Integer.parseInt(tnsValueInfo2.getValue());
            } else if (tnsValueInfo2.Equals("DELAY")) {
                this.m_delay = Integer.parseInt(tnsValueInfo2.getValue());
            }
            ++n2;
        }
    }

    public String getBackup() {
        return this.m_backup;
    }

    public int getFailoverType() {
        return this.m_type;
    }

    public int getMethod() {
        return this.m_method;
    }

    public int getDelay() {
        return this.m_delay;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(FAILOVER_MODE=");
        if (this.m_type != 0) {
            stringBuffer.append("(TYPE=");
            switch (this.m_type) {
                case 1: {
                    stringBuffer.append("none");
                    break;
                }
                case 3: {
                    stringBuffer.append("select");
                    break;
                }
                case 2: {
                    stringBuffer.append("session");
                }
            }
            stringBuffer.append(")");
        }
        if (this.m_method != 0) {
            stringBuffer.append("(METHOD=" + (this.m_method == 1 ? "preconnect" : "basic") + ")");
        }
        if (this.m_backup.length() != 0) {
            stringBuffer.append("(BACKUP=" + this.m_backup + ")");
        }
        if (this.m_retries != Integer.MAX_VALUE) {
            stringBuffer.append("(RETRIES=" + this.m_retries + ")");
        }
        if (this.m_delay != Integer.MAX_VALUE) {
            stringBuffer.append("(DELAY=" + this.m_delay + ")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

