/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mapping.MappedObjectState;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.impl.MappingImpl;

public class MappingRootImpl
extends MappingImpl
implements MappingRoot {
    protected static final boolean OUTPUT_READ_ONLY_EDEFAULT = false;
    protected boolean outputReadOnly = false;
    protected static final boolean TOP_TO_BOTTOM_EDEFAULT = false;
    protected boolean topToBottom = false;
    protected static final String COMMAND_STACK_EDEFAULT = null;
    protected String commandStack = COMMAND_STACK_EDEFAULT;
    protected MappingDomain domain;
    protected boolean outputDirty = false;
    protected AdapterImpl mappedObjectListener;
    protected AdapterFactory mappedObjectStateAdapterFactory = this.createMappedObjectStateAdapterFactory();
    static /* synthetic */ Class class$org$eclipse$emf$mapping$Mapping;
    static /* synthetic */ Class class$org$eclipse$emf$mapping$MappedObjectState;

    protected MappingRootImpl() {
    }

    protected EClass eStaticClass() {
        return MappingPackage.eINSTANCE.getMappingRoot();
    }

    public boolean isOutputReadOnly() {
        return this.outputReadOnly;
    }

    public void setOutputReadOnly(boolean newOutputReadOnly) {
        boolean oldOutputReadOnly = this.outputReadOnly;
        this.outputReadOnly = newOutputReadOnly;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldOutputReadOnly, this.outputReadOnly));
        }
    }

    public boolean isTopToBottom() {
        return this.topToBottom;
    }

    public void setTopToBottom(boolean newTopToBottom) {
        boolean oldTopToBottom = this.topToBottom;
        this.topToBottom = newTopToBottom;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldTopToBottom, this.topToBottom));
        }
    }

    public String getCommandStack() {
        return this.commandStack;
    }

    public void setCommandStack(String newCommandStack) {
        String oldCommandStack = this.commandStack;
        this.commandStack = newCommandStack;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldCommandStack, (Object)this.commandStack));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    if (this.helper != null) {
                        msgs = ((InternalEObject)this.helper).eInverseRemove((InternalEObject)this, -1, null, msgs);
                    }
                    return this.basicSetHelper((MappingHelper)otherEnd, msgs);
                }
                case 1: {
                    return ((InternalEList)this.getNested()).basicAdd((Object)otherEnd, msgs);
                }
                case 2: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 2, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return this.basicSetHelper(null, msgs);
                }
                case 1: {
                    return ((InternalEList)this.getNested()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return this.eBasicSetContainer(null, 2, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 2: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 1, class$org$eclipse$emf$mapping$Mapping == null ? (class$org$eclipse$emf$mapping$Mapping = MappingRootImpl.class$("org.eclipse.emf.mapping.Mapping")) : class$org$eclipse$emf$mapping$Mapping, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getHelper();
            }
            case 1: {
                return this.getNested();
            }
            case 2: {
                return this.getNestedIn();
            }
            case 3: {
                return this.getInputs();
            }
            case 4: {
                return this.getOutputs();
            }
            case 5: {
                if (resolve) {
                    return this.getTypeMapping();
                }
                return this.basicGetTypeMapping();
            }
            case 6: {
                return this.isOutputReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isTopToBottom() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getCommandStack();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setHelper((MappingHelper)newValue);
                return;
            }
            case 1: {
                this.getNested().clear();
                this.getNested().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setNestedIn((Mapping)newValue);
                return;
            }
            case 3: {
                this.getInputs().clear();
                this.getInputs().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getOutputs().clear();
                this.getOutputs().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setTypeMapping((Mapping)newValue);
                return;
            }
            case 6: {
                this.setOutputReadOnly((Boolean)newValue);
                return;
            }
            case 7: {
                this.setTopToBottom((Boolean)newValue);
                return;
            }
            case 8: {
                this.setCommandStack((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setHelper(null);
                return;
            }
            case 1: {
                this.getNested().clear();
                return;
            }
            case 2: {
                this.setNestedIn(null);
                return;
            }
            case 3: {
                this.getInputs().clear();
                return;
            }
            case 4: {
                this.getOutputs().clear();
                return;
            }
            case 5: {
                this.setTypeMapping(null);
                return;
            }
            case 6: {
                this.setOutputReadOnly(false);
                return;
            }
            case 7: {
                this.setTopToBottom(false);
                return;
            }
            case 8: {
                this.setCommandStack(COMMAND_STACK_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.helper != null;
            }
            case 1: {
                return this.nested != null && !this.nested.isEmpty();
            }
            case 2: {
                return this.getNestedIn() != null;
            }
            case 3: {
                return this.inputs != null && !this.inputs.isEmpty();
            }
            case 4: {
                return this.outputs != null && !this.outputs.isEmpty();
            }
            case 5: {
                return this.typeMapping != null;
            }
            case 6: {
                return this.outputReadOnly;
            }
            case 7: {
                return this.topToBottom;
            }
            case 8: {
                return COMMAND_STACK_EDEFAULT == null ? this.commandStack != null : !COMMAND_STACK_EDEFAULT.equals(this.commandStack);
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (outputReadOnly: ");
        result.append(this.outputReadOnly);
        result.append(", topToBottom: ");
        result.append(this.topToBottom);
        result.append(", commandStack: ");
        result.append(this.commandStack);
        result.append(')');
        return result.toString();
    }

    public MappingDomain getDomain() {
        return this.domain;
    }

    public void setDomain(MappingDomain domain) {
        if (this.domain != domain) {
            if (this.domain != null) {
                this.eAdapters.remove((Object)this.mappedObjectListener);
            }
            this.domain = domain;
            domain.setMappingRoot(this);
            this.mappedObjectListener = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    Object feature = notification.getFeature();
                    if (feature == MappingPackage.eINSTANCE.getMapping_Inputs() || feature == MappingPackage.eINSTANCE.getMapping_Outputs()) {
                        MappingRootImpl.this.initializeMappedObjectStates();
                    }
                }
            };
            this.eAdapters().add((Object)this.mappedObjectListener);
            this.initializeMappedObjectStates();
        }
    }

    public void refreshMappedObjectStates(Mapping subtree) {
        TreeIterator objects;
        Iterator inputs = subtree.getInputs().iterator();
        while (inputs.hasNext()) {
            objects = this.domain.treeIterator(inputs.next());
            while (objects.hasNext()) {
                Object object = objects.next();
                MappedObjectState mappedObjectState = this.getMappedObjectState(object);
                if (mappedObjectState == null) continue;
                mappedObjectState.setInput();
            }
        }
        Iterator outputs = subtree.getOutputs().iterator();
        while (outputs.hasNext()) {
            objects = this.domain.treeIterator(outputs.next());
            while (objects.hasNext()) {
                MappedObjectState mappedObjectState = this.getMappedObjectState(objects.next());
                if (mappedObjectState == null) continue;
                mappedObjectState.setOutput();
            }
        }
        TreeIterator mappings = subtree.treeIterator();
        while (mappings.hasNext()) {
            MappedObjectState mappedObjectState;
            Mapping mapping = (Mapping)mappings.next();
            Iterator inputs2 = mapping.getInputs().iterator();
            while (inputs2.hasNext()) {
                Object input = inputs2.next();
                mappedObjectState = this.getMappedObjectState(input);
                if (mappedObjectState == null) continue;
                mappedObjectState.getMappings().add(mapping);
            }
            Iterator outputs2 = mapping.getOutputs().iterator();
            while (outputs2.hasNext()) {
                Object output = outputs2.next();
                mappedObjectState = this.getMappedObjectState(output);
                if (mappedObjectState == null) continue;
                mappedObjectState.getMappings().add(mapping);
            }
        }
    }

    protected void initializeMappedObjectStates() {
        this.refreshMappedObjectStates(this);
        if (this.getTypeMapping() instanceof MappingRootImpl) {
            ((MappingRootImpl)this.getTypeMapping()).initializeMappedObjectStates();
        }
    }

    public Mapping getParentMapping(Collection collection) {
        Mapping result = this;
        ArrayList<List> allTreePaths = new ArrayList<List>();
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            allTreePaths.add(this.domain.getTreePath(objects.next()));
        }
        TreeIterator mappings = this.treeIterator();
        block1: while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            Iterator treePaths = allTreePaths.iterator();
            while (treePaths.hasNext()) {
                Collection treePath = (Collection)treePaths.next();
                Collection mappedObjects = mapping.getMappedObjects();
                mappedObjects.retainAll(treePath);
                if (!mappedObjects.isEmpty()) continue;
                mappings.prune();
                continue block1;
            }
            Collection mappedObjects = mapping.getMappedObjects();
            if (collection.containsAll(mappedObjects) && mappedObjects.containsAll(collection)) continue;
            result = mapping;
        }
        return result;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isOutputDirty() {
        return this.outputDirty;
    }

    public void register(Mapping mapping) {
        MappedObjectState mappedObjectState;
        Iterator inputs = mapping.getInputs().iterator();
        while (inputs.hasNext()) {
            Object input = inputs.next();
            mappedObjectState = this.getMappedObjectState(input);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().add(mapping);
        }
        Iterator outputs = mapping.getOutputs().iterator();
        while (outputs.hasNext()) {
            Object output = outputs.next();
            mappedObjectState = this.getMappedObjectState(output);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().add(mapping);
        }
    }

    public void deregister(Mapping mapping) {
        MappedObjectState mappedObjectState;
        Iterator inputs = mapping.getInputs().iterator();
        while (inputs.hasNext()) {
            Object input = inputs.next();
            mappedObjectState = this.getMappedObjectState(input);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().remove(mapping);
        }
        Iterator outputs = mapping.getOutputs().iterator();
        while (outputs.hasNext()) {
            Object output = outputs.next();
            mappedObjectState = this.getMappedObjectState(output);
            if (mappedObjectState == null) continue;
            mappedObjectState.getMappings().remove(mapping);
        }
    }

    public boolean canCreateMapping(Collection inputs, Collection outputs, Mapping mapping) {
        int enablementFlags = this.domain.getMappingEnablementFlags();
        if ((enablementFlags & 0x40) == 0 && inputs.size() == 0 || (enablementFlags & 0x80) == 0 && outputs.size() == 0 || inputs.size() == 0 && outputs.size() == 0 || (enablementFlags & 1) == 0 && inputs.size() > 1 || (enablementFlags & 2) == 0 && outputs.size() > 1 || (enablementFlags & 4) == 0 && this.isMapped(inputs, mapping) || (enablementFlags & 8) == 0 && this.isMapped(outputs, mapping) || (enablementFlags & 0x100) == 0 && !this.hasMappedParents(inputs, outputs) || (enablementFlags & 0x10) == 0 && !this.hasCompatibleMetaObjects(inputs, outputs) || (enablementFlags & 0x20) == 0 && !this.hasCompatibleTypes(inputs, outputs)) {
            return false;
        }
        Iterator i = inputs.iterator();
        while (i.hasNext()) {
            if (this.isAttachedObject(i.next())) continue;
            return false;
        }
        i = outputs.iterator();
        while (i.hasNext()) {
            if (this.isAttachedObject(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveMapping(Mapping mapping) {
        int enablementFlags = this.domain.getMappingEnablementFlags();
        return mapping.getNestedIn() != null && ((enablementFlags & 0x100) != 0 || !this.hasMappedChildren(mapping));
    }

    protected boolean hasMappedChildren(Mapping mapping) {
        return !mapping.getNested().isEmpty();
    }

    protected boolean hasMappedParents(Collection inputs, Collection outputs) {
        HashSet<Object> parents = new HashSet<Object>();
        Iterator inputIter = inputs.iterator();
        while (inputIter.hasNext()) {
            parents.add(this.domain.getParent(inputIter.next()));
        }
        Iterator outputIter = outputs.iterator();
        while (outputIter.hasNext()) {
            parents.add(this.domain.getParent(outputIter.next()));
        }
        return !this.getAllMappings(parents).isEmpty();
    }

    protected boolean isMapped(Collection collection, Mapping mapping) {
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            Collection mappings = this.getMappings(objects.next());
            if (mappings.isEmpty() || mapping != null && mappings.size() <= 1 && mappings.contains(mapping)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasCompatibleMetaObjects(Collection inputs, Collection outputs) {
        Iterator inputIter = inputs.iterator();
        while (inputIter.hasNext()) {
            EClass inputType = ((EObject)inputIter.next()).eClass();
            EObject convertedInputType = this.domain.getOutputMetaObject((EObject)inputType);
            Iterator outputIter = outputs.iterator();
            while (outputIter.hasNext()) {
                EClass outputType = ((EObject)outputIter.next()).eClass();
                if (convertedInputType == outputType) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean hasCompatibleTypes(Collection inputs, Collection outputs) {
        MappingRoot typeMappingRoot = this.getTypeMappingRoot();
        if (typeMappingRoot != null) {
            Collection outputTypes;
            Collection inputTypes = this.getTypeClassifiers(inputs);
            if (((Object)inputTypes).equals(outputTypes = this.getTypeClassifiers(outputs))) {
                return true;
            }
            if (inputTypes.size() != inputs.size() || outputTypes.size() != outputs.size()) {
                return false;
            }
            if (this.getTypeMappings(inputTypes, outputTypes).isEmpty() && this.hasTypeMappings(inputTypes) && this.hasTypeMappings(outputTypes)) {
                return false;
            }
        }
        return true;
    }

    protected Collection getTypeMappings(Collection inputTypes, Collection outputTypes) {
        Collection typeMappings;
        if (outputTypes.isEmpty()) {
            typeMappings = this.getTypeMappingRoot().getAllMappings(inputTypes);
        } else {
            ArrayList allTypes = new ArrayList(inputTypes);
            allTypes.addAll(outputTypes);
            typeMappings = this.getTypeMappingRoot().getExactMappings(allTypes);
        }
        return typeMappings;
    }

    protected boolean hasTypeMappings(Collection types) {
        return !this.getTypeMappingRoot().getAllMappings(types).isEmpty();
    }

    protected Collection getTypeClassifiers(Collection collection) {
        ArrayList<Object> types = new ArrayList<Object>();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object type = this.domain.getTypeClassifier(iter.next());
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    public Mapping createMapping(Collection inputs, Collection outputs) {
        Mapping newMapping = this.createMapping();
        this.initializeNewMapping(newMapping, inputs, outputs);
        return newMapping;
    }

    protected Mapping createMapping() {
        return MappingFactory.eINSTANCE.createMapping();
    }

    protected void initializeNewMapping(Mapping newMapping, Collection inputs, Collection outputs) {
        Collection outputTypes;
        Collection typeMappings;
        Collection inputTypes;
        newMapping.getInputs().addAll(inputs);
        newMapping.getOutputs().addAll(outputs);
        if (this.getTypeMappingRoot() != null && !(inputTypes = this.getTypeClassifiers(inputs)).isEmpty() && !(typeMappings = this.getTypeMappings(inputTypes, outputTypes = this.getTypeClassifiers(outputs))).isEmpty()) {
            newMapping.setTypeMapping((Mapping)typeMappings.iterator().next());
        }
    }

    public void resetDirty() {
        this.setOutputDirty(false);
    }

    public void setOutputDirty(boolean dirty) {
        this.outputDirty = dirty;
    }

    public boolean isInputObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, (Object)(class$org$eclipse$emf$mapping$MappedObjectState == null ? (class$org$eclipse$emf$mapping$MappedObjectState = MappingRootImpl.class$("org.eclipse.emf.mapping.MappedObjectState")) : class$org$eclipse$emf$mapping$MappedObjectState));
        return mappedObjectState != null && mappedObjectState.isInput();
    }

    public boolean isOutputObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, (Object)(class$org$eclipse$emf$mapping$MappedObjectState == null ? (class$org$eclipse$emf$mapping$MappedObjectState = MappingRootImpl.class$("org.eclipse.emf.mapping.MappedObjectState")) : class$org$eclipse$emf$mapping$MappedObjectState));
        return mappedObjectState != null && mappedObjectState.isOutput();
    }

    public boolean isTopObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, (Object)(class$org$eclipse$emf$mapping$MappedObjectState == null ? (class$org$eclipse$emf$mapping$MappedObjectState = MappingRootImpl.class$("org.eclipse.emf.mapping.MappedObjectState")) : class$org$eclipse$emf$mapping$MappedObjectState));
        if (mappedObjectState != null) {
            return this.isTopToBottom() ? mappedObjectState.isInput() : mappedObjectState.isOutput();
        }
        return false;
    }

    public boolean isBottomObject(Object object) {
        MappedObjectState mappedObjectState = (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, (Object)(class$org$eclipse$emf$mapping$MappedObjectState == null ? (class$org$eclipse$emf$mapping$MappedObjectState = MappingRootImpl.class$("org.eclipse.emf.mapping.MappedObjectState")) : class$org$eclipse$emf$mapping$MappedObjectState));
        if (mappedObjectState != null) {
            return !this.isTopToBottom() ? mappedObjectState.isInput() : mappedObjectState.isOutput();
        }
        return false;
    }

    public boolean isAttachedObject(Object object) {
        Object root = object;
        Object parent = this.domain.getParent(object);
        while (parent instanceof EObject) {
            root = parent;
            parent = this.domain.getParent(parent);
        }
        return this.getInputs().contains(root) || this.getOutputs().contains(root);
    }

    public Collection getMappings(Object object) {
        MappedObjectState mappedObjectState = this.getMappedObjectState(object);
        return mappedObjectState == null ? Collections.EMPTY_SET : mappedObjectState.getMappings();
    }

    public Collection getAllMappings(Collection collection) {
        Iterator objects = collection.iterator();
        if (objects.hasNext()) {
            ArrayList result = new ArrayList(this.getMappings(objects.next()));
            while (objects.hasNext() && !result.isEmpty()) {
                result.retainAll(this.getMappings(objects.next()));
            }
            return result;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getExactMappings(Collection collection) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        Iterator mappings = this.getAllMappings(collection).iterator();
        while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            if (!collection.containsAll(mapping.getMappedObjects())) continue;
            result.add(mapping);
        }
        return result;
    }

    public MappedObjectState getMappedObjectState(Object object) {
        return (MappedObjectState)this.mappedObjectStateAdapterFactory.adapt(object, (Object)(class$org$eclipse$emf$mapping$MappedObjectState == null ? (class$org$eclipse$emf$mapping$MappedObjectState = MappingRootImpl.class$("org.eclipse.emf.mapping.MappedObjectState")) : class$org$eclipse$emf$mapping$MappedObjectState));
    }

    public MappingRoot getTypeMappingRoot() {
        return (MappingRoot)this.getTypeMapping();
    }

    protected AdapterFactory createMappedObjectStateAdapterFactory() {
        return new MappedObjectStateAdapterFactory();
    }

    protected Adapter createMappedObjectStateAdapter(Notifier target) {
        return new MappedObjectStateAdapter();
    }

    public void dispose() {
        MappingRoot typeMappingRoot;
        if (this.mappedObjectStateAdapterFactory instanceof IDisposable) {
            ((IDisposable)this.mappedObjectStateAdapterFactory).dispose();
        }
        if ((typeMappingRoot = this.getTypeMappingRoot()) != null) {
            typeMappingRoot.dispose();
        }
    }

    protected void printAdapters() {
        this.walk(this);
        TreeIterator mappings = this.treeIterator();
        while (mappings.hasNext()) {
            Iterator objects = ((Mapping)mappings.next()).getMappedObjects().iterator();
            while (objects.hasNext()) {
                this.walk((EObject)objects.next());
            }
        }
    }

    protected void walk(EObject object) {
        Iterator iterator = object.eContents().iterator();
        while (iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            EList adapters = child.eAdapters();
            if (adapters != null) {
                boolean once = false;
                Iterator i = adapters.iterator();
                while (i.hasNext()) {
                    Object adapter = i.next();
                    if (adapter == null) continue;
                    if (!once) {
                        System.out.println("*** " + child);
                        once = true;
                    }
                    System.out.println("  * " + adapter);
                }
            }
            this.walk(child);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MappedObjectStateAdapterFactory
    extends AdapterFactoryImpl
    implements IDisposable {
        protected Disposable disposable = new Disposable();

        public Adapter createAdapter(Notifier target) {
            return MappingRootImpl.this.createMappedObjectStateAdapter(target);
        }

        public boolean isFactoryForType(Object type) {
            return super.isFactoryForType(type) || type == (class$org$eclipse$emf$mapping$MappedObjectState == null ? (class$org$eclipse$emf$mapping$MappedObjectState = MappingRootImpl.class$("org.eclipse.emf.mapping.MappedObjectState")) : class$org$eclipse$emf$mapping$MappedObjectState);
        }

        public Adapter adapt(Notifier notifier, Object type) {
            return super.adapt(notifier, (Object)this);
        }

        public Object adapt(Object object, Object type) {
            Object result = super.adapt(object, type);
            return result instanceof MappedObjectState ? result : null;
        }

        public Adapter adaptNew(Notifier object, Object type) {
            Adapter result = super.adaptNew(object, type);
            this.disposable.add((Object)result);
            return result;
        }

        public void dispose() {
            this.disposable.dispose();
        }
    }

    protected class MappedObjectStateAdapter
    extends AdapterImpl
    implements MappedObjectState,
    IDisposable {
        protected boolean isInput;
        protected boolean isOutput;
        protected Object originatingInput;
        protected Collection mappings = new NotifyingListImpl(this){
            private final /* synthetic */ MappedObjectStateAdapter this$1;
            {
                this.this$1 = this$1;
            }

            public Object getNotifier() {
                return this.this$1.getTarget();
            }

            protected boolean isNotificationRequired() {
                return true;
            }

            protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index, boolean wasSet) {
                Object object = oldObject == null ? newObject : oldObject;
                ENotificationImpl notification = new ENotificationImpl((InternalEObject)this.this$1.getTarget(), 1, -2, object, object, -1, wasSet);
                this.this$1.fireNotifyChanged((Notification)notification);
                return notification;
            }

            protected boolean isUnique() {
                return true;
            }
        };
        protected ChangeNotifier changeNotifier = new ChangeNotifier();

        protected MappedObjectStateAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == MappingRootImpl.this.mappedObjectStateAdapterFactory;
        }

        public boolean isInput() {
            return this.isInput;
        }

        public void setInput() {
            this.isInput = true;
        }

        public boolean isOutput() {
            return this.isOutput;
        }

        public void setOutput() {
            this.isOutput = true;
            ENotificationImpl note = new ENotificationImpl((InternalEObject)this.getTarget(), 1, -3, (Object)Boolean.TRUE, (Object)Boolean.TRUE, -1);
            this.changeNotifier.fireNotifyChanged((Notification)note);
        }

        public Object getOriginatingInput() {
            return this.originatingInput;
        }

        public void setOriginatingInput(Object originatingInput) {
            this.setOutput();
            this.originatingInput = originatingInput;
        }

        public Collection getMappings() {
            return this.mappings;
        }

        public void addListener(INotifyChangedListener notifyChangedListener) {
            this.changeNotifier.addListener(notifyChangedListener);
        }

        public void removeListener(INotifyChangedListener notifyChangedListener) {
            this.changeNotifier.removeListener(notifyChangedListener);
        }

        public void fireNotifyChanged(Notification notification) {
            this.changeNotifier.fireNotifyChanged(notification);
        }

        public void dispose() {
            if (this.target != null) {
                this.target.eAdapters().remove((Object)this);
            }
        }
    }
}

