/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.domain;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.domain.AdapterFactoryMappingDomain;

public class PluginAdapterFactoryMappingDomain
extends AdapterFactoryMappingDomain {
    public final String MAPPING_EXTENSION_POINT_ID = "configuration";

    public PluginAdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory editingDomainAdapterFactory, CommandStack commandStack, String mappingDomainKey) {
        super(mappingDomainAdapterFactory, editingDomainAdapterFactory, commandStack);
        this.initializeFromPlugin(mappingDomainKey);
    }

    public PluginAdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory editingDomainAdapterFactory, CommandStack commandStack, ResourceSet resourceSet, String mappingDomainKey) {
        super(mappingDomainAdapterFactory, editingDomainAdapterFactory, commandStack, resourceSet);
        this.initializeFromPlugin(mappingDomainKey);
    }

    public PluginAdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory topDomainAdapterFactory, AdapterFactory bottomDomainAdapterFactory, CommandStack commandStack, String mappingDomainKey) {
        super(mappingDomainAdapterFactory, topDomainAdapterFactory, bottomDomainAdapterFactory, commandStack);
        this.initializeFromPlugin(mappingDomainKey);
    }

    public PluginAdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory topDomainAdapterFactory, AdapterFactory bottomDomainAdapterFactory, CommandStack commandStack, ResourceSet resourceSet, String mappingDomainKey) {
        super(mappingDomainAdapterFactory, topDomainAdapterFactory, bottomDomainAdapterFactory, commandStack, resourceSet);
        this.initializeFromPlugin(mappingDomainKey);
    }

    protected void initializeFromPlugin(String mappingDomainKey) {
        if (mappingDomainKey == null) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint pct = registry.getExtensionPoint(MappingPlugin.getPlugin().getBundle().getSymbolicName(), "configuration");
        IExtension[] extension = pct.getExtensions();
        block0: for (int l = 0; l < extension.length; ++l) {
            IExtension config = extension[l];
            IConfigurationElement[] cElems = config.getConfigurationElements();
            for (int i = 0; i < cElems.length; ++i) {
                IConfigurationElement[] bottomLabelCaseAll;
                IConfigurationElement[] topLabelCaseAll;
                String sep;
                IConfigurationElement[] bottomLabelSeparatorAll;
                String sep2;
                IConfigurationElement d = cElems[i];
                if (!d.getName().equals("mapping-domain") || !mappingDomainKey.equals(d.getAttribute("key"))) continue;
                IConfigurationElement[] typeMappings = d.getChildren("type-mappings");
                for (int j = 0; j < typeMappings.length; ++j) {
                    IConfigurationElement[] mapping = typeMappings[j].getChildren("type-mapping");
                    for (int k = 0; k < mapping.length; ++k) {
                        this.addTypeMapping(mapping[k].getAttribute("top"), mapping[k].getAttribute("bottom"));
                    }
                }
                IConfigurationElement[] topLabelSeparatorAll = d.getChildren("top-label-separator");
                if (topLabelSeparatorAll.length > 0 && (sep2 = topLabelSeparatorAll[0].getAttribute("value")).length() > 0) {
                    this.topLabelSeparator = sep2.charAt(0);
                }
                if ((bottomLabelSeparatorAll = d.getChildren("bottom-label-separator")).length > 0 && (sep = bottomLabelSeparatorAll[0].getAttribute("value")).length() > 0) {
                    this.bottomLabelSeparator = sep.charAt(0);
                }
                if ((topLabelCaseAll = d.getChildren("top-label-case")).length > 0) {
                    String labelCase = topLabelCaseAll[0].getAttribute("value");
                    if (labelCase.equalsIgnoreCase("upper")) {
                        this.topLabelCase = 1;
                    } else if (labelCase.equalsIgnoreCase("lower")) {
                        this.topLabelCase = 2;
                    } else if (labelCase.equalsIgnoreCase("mixed")) {
                        this.topLabelCase = 3;
                    }
                }
                if ((bottomLabelCaseAll = d.getChildren("bottom-label-case")).length > 0) {
                    String labelCase = bottomLabelCaseAll[0].getAttribute("value");
                    if (labelCase.equalsIgnoreCase("upper")) {
                        this.bottomLabelCase = 1;
                    } else if (labelCase.equalsIgnoreCase("lower")) {
                        this.bottomLabelCase = 2;
                    } else if (labelCase.equalsIgnoreCase("mixed")) {
                        this.bottomLabelCase = 3;
                    }
                }
                IConfigurationElement[] topLabelForms = d.getChildren("top-label-forms");
                for (int j = 0; j < topLabelForms.length; ++j) {
                    IConfigurationElement[] labelForm = topLabelForms[j].getChildren("label-form");
                    for (int k = 0; k < labelForm.length; ++k) {
                        this.topLabelLongForms.add(labelForm[k].getAttribute("long"));
                        this.topLabelShortForms.add(labelForm[k].getAttribute("short"));
                    }
                }
                IConfigurationElement[] bottomLabelForms = d.getChildren("bottom-label-forms");
                for (int j = 0; j < bottomLabelForms.length; ++j) {
                    IConfigurationElement[] labelForm = bottomLabelForms[j].getChildren("label-form");
                    for (int k = 0; k < labelForm.length; ++k) {
                        this.bottomLabelLongForms.add(labelForm[k].getAttribute("long"));
                        this.bottomLabelShortForms.add(labelForm[k].getAttribute("short"));
                    }
                }
                continue block0;
            }
        }
    }

    protected void addTypeMapping(String topType, String bottomType) {
        this.topToBottomTypeTable.put(topType, bottomType);
        this.bottomToTopTypeTable.put(bottomType, topType);
    }
}

