/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import com.metamatrix.sequelink.security.ByteSwapKey;
import com.metamatrix.sequelink.security.Message;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.ShortBufferException;

public class ByteSwapCipher {
    private static final int A = 205;
    private static final int B = 29573;
    private static final int M = 139968;
    private boolean isEncryption;
    private int[] mappingTable = new int[256];
    private boolean isInitialized;

    public ByteSwapCipher(int n2, Key key) throws InvalidKeyException {
        switch (n2) {
            case 1: {
                this.isEncryption = true;
                break;
            }
            case 2: {
                this.isEncryption = false;
                break;
            }
            default: {
                throw new IllegalArgumentException(Message.Gen.getException(7622));
            }
        }
        if (!(key instanceof ByteSwapKey)) {
            throw new InvalidKeyException(Message.Gen.getException(7626));
        }
        this.generateMappingTable(((ByteSwapKey)key).getKey());
        this.isInitialized = true;
    }

    public int getOutputSize(int n2) {
        return n2;
    }

    public byte[] doFinal(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException(Message.Gen.getException(7627));
        }
        byte[] byArray2 = new byte[n3];
        try {
            this.doFinal(byArray, n2, n3, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return byArray2;
    }

    public int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (!this.isInitialized) {
            throw new IllegalStateException(Message.Gen.getException(7629));
        }
        if (byArray == null || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException(Message.Gen.getException(7627));
        }
        if (byArray2 == null || n4 < 0 || n4 + n3 > byArray2.length) {
            throw new IllegalArgumentException(Message.Gen.getException(7628));
        }
        int n5 = n3 + n2;
        int n6 = n2;
        int n7 = n4;
        while (n6 < n5) {
            int n8 = byArray[n6];
            if (n8 < 0) {
                n8 += 256;
            }
            byArray2[n7] = (byte)this.mappingTable[n8];
            ++n6;
            ++n7;
        }
        return n3;
    }

    private void generateMappingTable(int n2) {
        int n3;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int n4 = n2;
        for (n3 = 0; n3 <= 255; ++n3) {
            nArray2[n3] = n4 = (205 * n4 + 29573) % 139968;
            nArray[n3] = n3;
        }
        for (n3 = 0; n3 <= 255; ++n3) {
            int n5 = nArray2[n3] % 256;
            int n6 = nArray[n3];
            nArray[n3] = nArray[n5];
            nArray[n5] = n6;
        }
        if (this.isEncryption) {
            System.arraycopy(nArray, 0, this.mappingTable, 0, 256);
        } else {
            for (n3 = 0; n3 <= 255; ++n3) {
                this.mappingTable[nArray[n3]] = n3;
            }
        }
    }
}

