/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.util;

import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.emf.ecore.xml.type.internal.QName;
import org.eclipse.emf.ecore.xml.type.internal.RegEx;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.ecore.xml.type.internal.XMLDuration;

public final class XMLTypeUtil {
    public static final int EQUALS = 0;
    public static final int LESS_THAN = -1;
    public static final int GREATER_THAN = 1;
    public static final int INDETERMINATE = 2;

    public static int compareCalendar(Object calendar1, Object calendar2) {
        return XMLCalendar.compare((XMLCalendar)calendar1, (XMLCalendar)calendar2);
    }

    public static int compareDuration(Object duration1, Object duration2) {
        return XMLDuration.compare((XMLDuration)duration1, (XMLDuration)duration2);
    }

    public static boolean isSpace(char value) {
        return DataValue.XMLChar.isSpace(value);
    }

    public static String normalize(String value, boolean collapse) {
        if (value == null) {
            return null;
        }
        StringBuffer buffer = null;
        boolean skipSpace = collapse;
        int size = value.length();
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (XMLTypeUtil.isSpace(c)) {
                if (skipSpace) {
                    if (buffer == null) {
                        buffer = new StringBuffer(value);
                    }
                    buffer.deleteCharAt(i - offset++);
                    continue;
                }
                skipSpace = collapse;
                if (c == ' ') continue;
                if (buffer == null) {
                    buffer = new StringBuffer(value);
                }
                buffer.setCharAt(i - offset, ' ');
                continue;
            }
            skipSpace = false;
        }
        if (skipSpace) {
            int length;
            if (buffer == null) {
                length = value.length();
                if (length > 0) {
                    return value.substring(0, length - 1);
                }
                return value;
            }
            length = buffer.length();
            if (length > 0) {
                return buffer.substring(0, length - 1);
            }
            return buffer.toString();
        }
        if (buffer == null) {
            return value;
        }
        return buffer.toString();
    }

    public static EValidator.PatternMatcher createPatternMatcher(String pattern) {
        return new PatternMatcherImpl(pattern);
    }

    public static Object createQName(String namespaceUri, String localPart, String prefix) {
        return new QName(namespaceUri, localPart, prefix);
    }

    public static void setQNameValues(Object qname, String namespaceUri, String localPart, String prefix) {
        QName qn = (QName)qname;
        qn.setLocalPart(localPart);
        qn.setNamespaceURI(namespaceUri);
        qn.setPrefix(prefix);
    }

    public static String getQNameNamespaceURI(Object qname) {
        return ((QName)qname).getNamespaceURI();
    }

    public static String getQNameLocalPart(Object qname) {
        return ((QName)qname).getLocalPart();
    }

    public static String getQNamePrefix(Object qname) {
        return ((QName)qname).getPrefix();
    }

    private static class PatternMatcherImpl
    implements EValidator.PatternMatcher {
        protected RegEx.RegularExpression regularExpression;

        public PatternMatcherImpl(String pattern) {
            this.regularExpression = new RegEx.RegularExpression(pattern, "X");
        }

        public boolean matches(String value) {
            return this.regularExpression.matches(value);
        }

        public String toString() {
            return this.regularExpression.getPattern();
        }
    }
}

