/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class EModelElementImpl
extends EObjectImpl
implements EModelElement {
    protected EList eAnnotations = null;
    protected static final int EFROZEN = 8;
    protected static final int ELAST_EMODEL_ELEMENT_FLAG = 8;
    static /* synthetic */ Class class$org$eclipse$emf$ecore$EAnnotation;

    protected EModelElementImpl() {
    }

    protected void freeze() {
        this.eFlags |= 8;
        Iterator i = this.eContents().iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (!(child instanceof EModelElementImpl)) continue;
            ((EModelElementImpl)child).freeze();
        }
    }

    protected boolean isFrozen() {
        return (this.eFlags & 8) != 0;
    }

    protected EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getEModelElement();
    }

    public EList getEAnnotations() {
        if (this.eAnnotations == null) {
            this.eAnnotations = new EObjectContainmentWithInverseEList(class$org$eclipse$emf$ecore$EAnnotation == null ? (class$org$eclipse$emf$ecore$EAnnotation = EModelElementImpl.class$("org.eclipse.emf.ecore.EAnnotation")) : class$org$eclipse$emf$ecore$EAnnotation, this, 0, 3);
        }
        return this.eAnnotations;
    }

    public EAnnotation getEAnnotation(String source) {
        if (source == null) {
            Iterator i = this.getEAnnotations().iterator();
            while (i.hasNext()) {
                EAnnotation eAnnotation = (EAnnotation)i.next();
                if (eAnnotation.getSource() != null) continue;
                return eAnnotation;
            }
        } else {
            Iterator i = this.getEAnnotations().iterator();
            while (i.hasNext()) {
                EAnnotation eAnnotation = (EAnnotation)i.next();
                if (!source.equals(eAnnotation.getSource())) continue;
                return eAnnotation;
            }
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        EAnnotation eAnnotation;
        String source;
        if (eObject instanceof ENamedElement) {
            ENamedElement eNamedElement = (ENamedElement)eObject;
            String name = eNamedElement.getName();
            if (name != null) {
                Object otherEObject;
                int count = 0;
                Iterator i = this.eContents().iterator();
                while (i.hasNext() && (otherEObject = i.next()) != eObject) {
                    ENamedElement otherENamedElement;
                    if (!(otherEObject instanceof ENamedElement) || !name.equals((otherENamedElement = (ENamedElement)otherEObject).getName())) continue;
                    ++count;
                }
                return count > 0 ? name + "." + count : name;
            }
        } else if (eObject instanceof EAnnotation && (source = (eAnnotation = (EAnnotation)eObject).getSource()) != null) {
            Object otherEObject;
            int count = 0;
            Iterator i = this.eContents().iterator();
            while (i.hasNext() && (otherEObject = i.next()) != eObject) {
                EAnnotation otherEAnnotation;
                if (!(otherEObject instanceof EAnnotation) || !source.equals((otherEAnnotation = (EAnnotation)otherEObject).getSource())) continue;
                ++count;
            }
            StringBuffer result = new StringBuffer(source.length() + 5);
            result.append('%');
            result.append(URI.encodeSegment((String)source, (boolean)false));
            result.append('%');
            if (count > 0) {
                result.append('.');
                result.append(count);
            }
            return result.toString();
        }
        return super.eURIFragmentSegment(eStructuralFeature, eObject);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        char firstCharacter;
        if (uriFragmentSegment.length() > 0 && (firstCharacter = uriFragmentSegment.charAt(0)) != '@') {
            if (firstCharacter == '%') {
                int index = uriFragmentSegment.lastIndexOf("%");
                if (index != -1) {
                    String source = URI.decode((String)uriFragmentSegment.substring(1, index));
                    int count = 0;
                    if (uriFragmentSegment.length() > ++index && uriFragmentSegment.charAt(index) == '.') {
                        try {
                            count = Integer.parseInt(uriFragmentSegment.substring(index + 1));
                        }
                        catch (NumberFormatException exception) {
                            throw new WrappedException((Exception)exception);
                        }
                    }
                    Iterator i = this.eContents().iterator();
                    while (i.hasNext()) {
                        EAnnotation eAnnotation;
                        Object object = i.next();
                        if (!(object instanceof EAnnotation) || !source.equals((eAnnotation = (EAnnotation)object).getSource()) || count-- != 0) continue;
                        return eAnnotation;
                    }
                }
            } else {
                int index = uriFragmentSegment.lastIndexOf(".");
                String name = index == -1 ? uriFragmentSegment : uriFragmentSegment.substring(0, index);
                int count = 0;
                if (index != -1) {
                    try {
                        count = Integer.parseInt(uriFragmentSegment.substring(index + 1));
                    }
                    catch (NumberFormatException exception) {
                        name = uriFragmentSegment;
                    }
                }
                Iterator i = this.eContents().iterator();
                while (i.hasNext()) {
                    ENamedElement eNamedElement;
                    Object object = i.next();
                    if (!(object instanceof ENamedElement) || !name.equals((eNamedElement = (ENamedElement)object).getName()) || count-- != 0) continue;
                    return eNamedElement;
                }
            }
            return null;
        }
        return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

