/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.io;

import com.metamatrix.api.core.xmi.EntityInfo;
import com.metamatrix.api.core.xmi.FeatureInfo;
import com.metamatrix.bridges.BridgeConstants;
import com.metamatrix.bridges.BridgesPlugin;
import com.metamatrix.bridges.io.BridgeEntityFactory;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ColumnSet;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.types.DatatypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.EnumerationLiteral;
import org.eclipse.uml2.Property;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;

public class BridgeFeatureMapper
implements BridgeConstants {
    private final BridgeImporter importer;
    private final BridgeEntityFactory entityFactory;
    private final DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
    private final XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    private final Collection ignoredEntities;

    public BridgeFeatureMapper(BridgeImporter importer, BridgeEntityFactory entityFactory) {
        this.importer = importer;
        this.entityFactory = entityFactory;
        this.ignoredEntities = entityFactory.getIgnoredEntities();
        this.init();
    }

    public void setFeatureValue(FeatureInfo info, Object owner) {
        if (owner == null || info == null || info.getValue() == null) {
            return;
        }
        String key = info.getMetaClassName() + "." + info.getName();
        if (this.ignoredEntities.contains(info.getMetaClassName())) {
            return;
        }
        if (key.endsWith(".description")) {
            String ownerId = this.getOwnerId(info);
            if (owner instanceof XSDConcreteComponent) {
                this.entityFactory.addAnnotation((EObject)((XSDConcreteComponent)owner), info.getValue().toString(), 3);
            } else if (owner instanceof BridgeEntityFactory.AssociationMapper) {
                ((BridgeEntityFactory.AssociationMapper)owner).description = info.getValue().toString();
            } else if (key.equals("Attribute.description")) {
                if (owner instanceof Property) {
                    this.entityFactory.addAnnotation((EObject)owner, info.getValue().toString(), 0);
                    EObject physical = (EObject)this.entityFactory.getPhysicalObject(ownerId);
                    if (physical != null && physical != owner) {
                        this.entityFactory.addAnnotation(physical, info.getValue().toString(), 1);
                    }
                } else if (owner instanceof Column) {
                    this.entityFactory.addAnnotation((EObject)owner, info.getValue().toString(), 1);
                }
            } else {
                String id;
                EObject physical;
                int rsrcType = this.entityFactory.getResourceType(owner);
                this.entityFactory.addAnnotation((EObject)owner, info.getValue().toString(), rsrcType);
                if (rsrcType != 1 && (physical = (EObject)this.entityFactory.getPhysicalObject(id = this.getOwnerId(info))) != null && physical != owner) {
                    this.entityFactory.addAnnotation(physical, info.getValue().toString(), 1);
                }
            }
        } else if (key.endsWith(".comment")) {
            String ownerId = this.getOwnerId(info);
            if (owner instanceof BridgeEntityFactory.AssociationMapper) {
                ((BridgeEntityFactory.AssociationMapper)owner).comment = info.getValue().toString();
            } else {
                int rsrcType = this.entityFactory.getResourceType(owner);
                this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), rsrcType);
                String id = this.getOwnerId(info);
                EObject physical = (EObject)this.entityFactory.getPhysicalObject(id);
                if (physical != null) {
                    this.entityFactory.addTag(ownerId, physical, info.getName(), info.getValue().toString(), 1);
                }
            }
        } else if (key.endsWith(".physicalID")) {
            if (owner instanceof EObject) {
                String ownerId = this.getOwnerId(info);
                int rsrcType = this.entityFactory.getResourceType(owner);
                this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), rsrcType);
                String id = this.getOwnerId(info);
                EObject physical = (EObject)this.entityFactory.getPhysicalObject(id);
                if (physical != null) {
                    this.entityFactory.addTag(ownerId, physical, info.getName(), info.getValue().toString(), 1);
                }
            }
        } else if (key.equals("Association.aggregation")) {
            String val = info.getValue().toString();
            boolean aggregation = false;
            aggregation = val.equals("1") ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
            ((BridgeEntityFactory.AssociationMapper)owner).isAggregation = aggregation;
        } else if (key.equals("Association.designLevel")) {
            ((BridgeEntityFactory.AssociationMapper)owner).designLevel = info.getValue().toString();
        } else if (key.equals("Association.name")) {
            ((BridgeEntityFactory.AssociationMapper)owner).logicalName = info.getValue().toString();
        } else if (key.equals("Association.physicalName")) {
            ((BridgeEntityFactory.AssociationMapper)owner).physicalName = info.getValue().toString();
        } else if (key.equals("AssociationRole.designLevel")) {
            ((BridgeEntityFactory.AssociationRoleMapper)owner).designLevel = info.getValue().toString();
        } else if (key.equals("AssociationRole.extraConstraint")) {
            ((BridgeEntityFactory.AssociationRoleMapper)owner).constraint = info.getValue().toString();
        } else if (key.equals("AssociationRole.multiplicity")) {
            ((BridgeEntityFactory.AssociationRoleMapper)owner).multiplicity = info.getValue().toString();
        } else if (key.equals("AssociationRole.name")) {
            ((BridgeEntityFactory.AssociationRoleMapper)owner).name = info.getValue().toString();
        } else if (!(key.equals("AssociationRole.onDelete") || key.equals("AssociationRole.onInsert") || key.equals("AssociationRole.onUpdate"))) {
            if (key.equals("AssociationRole.source")) {
                ((BridgeEntityFactory.AssociationRoleMapper)owner).isSource = info.getValue().toString().equals("1") ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
            } else if (!key.equals("Attribute.designLevel")) {
                if (key.equals("Attribute.extraConstraint")) {
                    String ownerId = this.getOwnerId(info);
                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                } else if (key.equals("Attribute.initialValue")) {
                    String ownerId = this.getOwnerId(info);
                    if (owner instanceof Property) {
                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                        EObject physical = (EObject)this.entityFactory.getPhysicalObject(ownerId);
                        if (physical != null) {
                            this.entityFactory.addTag(ownerId, physical, info.getName(), info.getValue().toString(), 1);
                        }
                    } else {
                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                    }
                } else if (!key.equals("Attribute.name")) {
                    if (key.equals("Attribute.optional")) {
                        String ownerId = this.getOwnerId(info);
                        int rsrcType = this.entityFactory.getResourceType(owner);
                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), rsrcType);
                    } else if (key.equals("Attribute.physicalName")) {
                        Object col;
                        String physicalEntityId = this.getPhysicalEntityId(info);
                        if (physicalEntityId == null) {
                            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_ID_for_pysical_object_to_set_physical_attribute_name_1");
                            this.importer.log(msg, 4, null);
                        }
                        if ((col = this.entityFactory.getPhysicalObject(physicalEntityId)) instanceof Column) {
                            Column column = (Column)col;
                            String physicalName = this.createValidName(info);
                            String uniqueName = this.entityFactory.getNameValidator().createUniqueName(physicalName, this.getSiblingColumnNames(column));
                            if (uniqueName != null) {
                                column.setName(uniqueName);
                            } else {
                                column.setName(physicalName);
                            }
                        } else if (col != null) {
                            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_find_corresponding_physical_entity_attribute_name_2");
                            this.importer.log(msg, 4, null);
                        }
                    } else if (key.equals("Attribute.position") || key.equals("SQLViewAttribute.position")) {
                        int index = Integer.parseInt(info.getValue().toString());
                        String ownerId = this.getOwnerId(info);
                        if (ownerId != null) {
                            this.moveEObject(index, (EObject)owner, ownerId);
                        } else {
                            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_owner_xmi_id_for_move_attribute_1");
                            this.importer.log(msg, 4, null);
                        }
                    } else if (key.equals("Attribute.status")) {
                        String ownerId = this.getOwnerId(info);
                        if (owner instanceof Property) {
                            this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                            EObject col = (EObject)this.entityFactory.getPhysicalObject(ownerId);
                            if (col != null) {
                                this.entityFactory.addTag(ownerId, col, info.getName(), info.getValue().toString(), 1);
                            }
                        } else if (owner instanceof Column) {
                            this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                        }
                    } else if (key.equals("BaseType.dataType")) {
                        String val = info.getValue().toString();
                        XSDSimpleTypeDefinition bt = this.getBaseType(val);
                        if (bt != null) {
                            ((XSDSimpleTypeDefinition)owner).setBaseTypeDefinition(bt);
                            this.entityFactory.setNeedsBuiltInImport(true);
                        }
                    } else if (!(key.equals("BaseType.name") || key.startsWith("BusinessRule.") || key.equals("CandidateKey.name"))) {
                        if (key.equals("CandidateKey.physicalName")) {
                            if (owner instanceof PrimaryKey) {
                                ((PrimaryKey)owner).setName(this.createValidName(info));
                            }
                        } else if (!key.equals("CandidateKey.uniqueKey")) {
                            if (key.equals("DatabaseCatalog.majorVersion")) {
                                String ownerId = this.getOwnerId(info);
                                this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                            } else if (key.equals("DatabaseCatalog.minorVersion")) {
                                String ownerId = this.getOwnerId(info);
                                this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                            } else if (key.equals("DatabaseCatalog.systemType")) {
                                String ownerId = this.getOwnerId(info);
                                this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                            } else if (key.equals("DatabaseCatalog.tertiaryVersion")) {
                                String ownerId = this.getOwnerId(info);
                                this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                            } else if (key.equals("Class.cppClassType")) {
                                String ownerId = this.getOwnerId(info);
                                if (owner instanceof Class) {
                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                } else if (owner instanceof Table) {
                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                                }
                            } else if (key.equals("Class.cppPersistent")) {
                                String ownerId = this.getOwnerId(info);
                                if (owner instanceof Class) {
                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                } else if (owner instanceof Table) {
                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                                }
                            } else if (!key.equals("Class.designLevel") && !key.equals("Class.name")) {
                                if (key.equals("Class.physicalName")) {
                                    Object table;
                                    String physicalEntityId = this.getPhysicalEntityId(info);
                                    if (physicalEntityId == null) {
                                        String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_ID_for_pysical_object_to_set_physical_class_name_3");
                                        this.importer.log(msg, 4, null);
                                    }
                                    if ((table = this.entityFactory.getPhysicalObject(physicalEntityId)) instanceof Table) {
                                        ((Table)table).setName(this.createValidName(info));
                                    } else if (table != null) {
                                        String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_find_corresponding_physical_entity_class_name_4");
                                        this.importer.log(msg, 4, null);
                                    }
                                } else if (key.equals("Class.status")) {
                                    String ownerId = this.getOwnerId(info);
                                    if (owner instanceof Class) {
                                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                        EObject table = (EObject)this.entityFactory.getPhysicalObject(ownerId);
                                        if (table != null) {
                                            this.entityFactory.addTag(ownerId, table, info.getName(), info.getValue().toString(), 1);
                                        }
                                    } else if (owner instanceof Table) {
                                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                                    }
                                } else if (!key.equals("ClassDiagram.name") && !key.equals("DatabaseCatalog.system")) {
                                    if (key.equals("DerivedType.dataType")) {
                                        String ownerId = this.getOwnerId(info);
                                        this.entityFactory.addTag(ownerId, (EObject)((XSDSimpleTypeDefinition)owner), "nativeType", info.getValue().toString(), 3);
                                    } else if (key.equals("DerivedType.initialValue")) {
                                        String ownerId = this.getOwnerId(info);
                                        String val = info.getValue().toString();
                                        this.entityFactory.addTag(ownerId, (EObject)((XSDSimpleTypeDefinition)owner), info.getName(), val, 3);
                                    } else if (key.equals("DerivedType.length") || key.equals("BaseType.length")) {
                                        String val = info.getValue().toString();
                                        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)owner;
                                        this.setLength(type, val);
                                    } else if (key.equals("DerivedType.lowerBound") || key.equals("BaseType.lowerBound")) {
                                        String val = info.getValue().toString();
                                        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)owner;
                                        this.setLowerBound(type, val);
                                    } else if (!key.equals("DerivedType.name")) {
                                        if (key.equals("DerivedType.nativeDataType")) {
                                            Object col;
                                            String physicalEntityId = this.getPhysicalEntityId(info);
                                            if (physicalEntityId == null) {
                                                String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_ID_for_pysical_object_to_set_physical_attribute_name_1");
                                                this.importer.log(msg, 4, null);
                                            }
                                            if ((col = this.entityFactory.getPhysicalObject(physicalEntityId)) instanceof Column) {
                                                ((Column)col).setNativeType(info.getValue().toString());
                                            } else if (col != null && !(col instanceof XSDSimpleTypeDefinition)) {
                                                String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_find_corresponding_physical_entity_attribute_name_2");
                                                this.importer.log(msg, 4, null);
                                            }
                                        } else if (key.equals("DerivedType.nativeLogicalDataType")) {
                                            String ownerId = this.getOwnerId(info);
                                            String val = info.getValue().toString();
                                            this.entityFactory.addTag(ownerId, (EObject)((XSDSimpleTypeDefinition)owner), info.getName(), val, 3);
                                        } else if (key.equals("DerivedType.precision") || key.equals("BaseType.precision")) {
                                            String val = info.getValue().toString();
                                            XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)owner;
                                            this.setPrecision(type, val);
                                        } else if (key.equals("DerivedType.physicalName") || key.equals("BaseType.physicalName")) {
                                            String ownerId = this.getOwnerId(info);
                                            this.entityFactory.addTag(ownerId, (EObject)((XSDSimpleTypeDefinition)owner), "physicalName", info.getValue().toString(), 3);
                                        } else if (key.equals("DerivedType.scale")) {
                                            String val = info.getValue().toString();
                                            XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)owner;
                                            this.setScale(type, val);
                                        } else if (!key.equals("DerivedType.userDataType") && !key.equals("DerivedType.userDefined")) {
                                            if (key.equals("DerivedType.upperBound") || key.equals("BaseType.upperBound")) {
                                                String val = info.getValue().toString();
                                                XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)owner;
                                                this.setUpperBound(type, val);
                                            } else if (!key.equals("ForeignKey.name")) {
                                                if (key.equals("Index.clustered")) {
                                                    if (owner instanceof Index) {
                                                        String ownerId = this.getOwnerId(info);
                                                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                                                    }
                                                } else if (key.equals("Index.generate")) {
                                                    if (owner instanceof Index) {
                                                        String ownerId = this.getOwnerId(info);
                                                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                                                    }
                                                } else if (key.equals("Index.unique")) {
                                                    if (owner instanceof Index) {
                                                        String ownerId = this.getOwnerId(info);
                                                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                                                    }
                                                } else if (!key.equals("Index.name")) {
                                                    if (key.equals("Index.physicalName")) {
                                                        if (owner instanceof Index) {
                                                            String physicalName = this.createValidName(info);
                                                            HashSet existingNames = this.entityFactory.getIndexNames();
                                                            String uniqueName = this.entityFactory.getNameValidator().createUniqueName(physicalName, (Collection)existingNames);
                                                            if (uniqueName != null) {
                                                                ((Index)owner).setName(uniqueName);
                                                                existingNames.add(uniqueName);
                                                            } else {
                                                                ((Index)owner).setName(physicalName);
                                                                existingNames.add(physicalName);
                                                            }
                                                        }
                                                    } else if (key.equals("ForeignKey.physicalName")) {
                                                        if (owner instanceof ForeignKey) {
                                                            ((ForeignKey)owner).setName(this.createValidName(info));
                                                        }
                                                    } else if (!key.startsWith("MetadataOrigin.")) {
                                                        if (key.equals("Model.designLevel")) {
                                                            String value = info.getValue().toString();
                                                            if ("LOGICAL_ONLY".equals(value)) {
                                                                this.entityFactory.setAsLogicalOnlyModel();
                                                            } else if ("PHYSICAL_ONLY".equals(value)) {
                                                                this.entityFactory.setAsPhysicalOnlyModel();
                                                            }
                                                        } else if (!key.equals("Model.name")) {
                                                            if (key.equals("Model.targetDatabase")) {
                                                                this.entityFactory.setTargetDatabase(info.getValue().toString());
                                                            } else if (!(key.equals("Note.value") || key.equals("Note.position") || key.equals("DesignPackage.name") || key.equals("PrimaryKey.name") || key.startsWith("Projection.") || key.equals("PropertyElementTypeScope.name"))) {
                                                                if (key.equals("PropertyElementTypeScope.scope")) {
                                                                    String ownerId = this.getOwnerId(info);
                                                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                                                } else if (key.equals("PropertyType.dataType")) {
                                                                    String ownerId = this.getOwnerId(info);
                                                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                                                } else if (key.equals("PropertyType.designLevel")) {
                                                                    String ownerId = this.getOwnerId(info);
                                                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                                                } else if (key.equals("PropertyType.initialValue")) {
                                                                    String ownerId = this.getOwnerId(info);
                                                                    this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                                                } else if (!key.equals("PropertyType.name")) {
                                                                    if (key.equals("PropertyType.position")) {
                                                                        String ownerId = this.getOwnerId(info);
                                                                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                                                    } else if (key.equals("PropertyType.usage")) {
                                                                        String ownerId = this.getOwnerId(info);
                                                                        this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 0);
                                                                    } else if (!(key.equals("PropertyValue.name") || key.equals("PropertyValue.value") || key.startsWith("RelationshipProjection.") || key.equals("DatabaseSchema.name") || key.equals("SQLViewAssociation.sQLTableSequence"))) {
                                                                        if (key.equals("SQLViewAttribute.expression")) {
                                                                            String ownerId = this.getOwnerId(info);
                                                                            this.entityFactory.addTag(ownerId, (EObject)owner, info.getName(), info.getValue().toString(), 1);
                                                                        } else if (!key.equals("SQLViewAttribute.name")) {
                                                                            if (key.equals("SQLViewAttribute.physicalName")) {
                                                                                if (owner instanceof Column) {
                                                                                    ((Column)owner).setName(this.createValidName(info));
                                                                                }
                                                                            } else if (!key.equals("SQLViewEntity.designLevel") && !key.equals("SQLViewEntity.name")) {
                                                                                if (key.equals("SQLViewEntity.physicalName")) {
                                                                                    if (owner instanceof Table) {
                                                                                        ((Table)owner).setName(this.createValidName(info));
                                                                                    } else {
                                                                                        Object table;
                                                                                        String physicalEntityId = this.getPhysicalEntityId(info);
                                                                                        if (physicalEntityId == null) {
                                                                                            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_ID_for_pysical_object_to_set_physical_view_name_5");
                                                                                            this.importer.log(msg, 4, null);
                                                                                        }
                                                                                        if ((table = this.entityFactory.getPhysicalObject(physicalEntityId)) instanceof Table) {
                                                                                            ((Table)table).setName(this.createValidName(info));
                                                                                        } else {
                                                                                            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_find_corresponding_physical_entity_view_name_6");
                                                                                            this.importer.log(msg, 4, null);
                                                                                        }
                                                                                    }
                                                                                } else if (key.equals("TypeValue.position")) {
                                                                                    int index = Integer.parseInt(info.getValue().toString());
                                                                                    String ownerId = this.getOwnerId(info);
                                                                                    if (ownerId != null) {
                                                                                        this.moveEObject(index, (EObject)owner, ownerId);
                                                                                    } else {
                                                                                        String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_owner_xmi_id_for_move_index_2");
                                                                                        this.importer.log(msg, 4, null);
                                                                                    }
                                                                                } else if (!key.equals("TypeValue.name")) {
                                                                                    if (key.equals("TypeValue.value")) {
                                                                                        if (owner instanceof XSDFacet) {
                                                                                            ((XSDFacet)owner).setLexicalValue(info.getValue().toString());
                                                                                        } else if (owner instanceof EnumerationLiteral) {
                                                                                            ((EnumerationLiteral)owner).setName(this.createValidName(info));
                                                                                        }
                                                                                    } else {
                                                                                        String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_find_property_mapping", (Object)key);
                                                                                        this.entityFactory.addUnresolvedPropName(msg);
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private Collection getSiblingColumnNames(Column col) {
        ArrayList<String> names = new ArrayList<String>();
        if (col == null) {
            return names;
        }
        ColumnSet table = col.getOwner();
        if (table == null) {
            return names;
        }
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column next = (Column)it.next();
            if (next == col) continue;
            names.add(next.getName());
        }
        return names;
    }

    public void cleanup() {
    }

    private void moveEObject(int index, EObject child, String id) {
        if (index == -1 || child == null) {
            return;
        }
        EObject parent = child.eContainer();
        if (parent == null) {
            return;
        }
        int existingCount = 0;
        int currentIndex = 0;
        int matchIndex = 0;
        if (child instanceof XSDFacet) {
            XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)parent;
            type.getFacetContents().remove((Object)child);
            Iterator facets = type.getFacetContents().iterator();
            while (facets.hasNext() && existingCount < index) {
                Object next = facets.next();
                if (next.getClass() == child.getClass()) {
                    ++existingCount;
                    matchIndex = currentIndex;
                }
                ++currentIndex;
            }
            if (existingCount == 0) {
                currentIndex = type.getFacetContents().size();
            } else if (existingCount < index) {
                currentIndex = matchIndex + 1;
            } else if (currentIndex > 0) {
                --currentIndex;
            }
            type.getFacetContents().add(currentIndex, (Object)child);
        } else if (child instanceof Property) {
            Class clazz = (Class)child.eContainer();
            clazz.getOwnedAttributes().remove((Object)child);
            Iterator atts = clazz.getOwnedAttributes().iterator();
            while (atts.hasNext() && existingCount < index) {
                Object next = atts.next();
                if (next.getClass() == child.getClass()) {
                    ++existingCount;
                    matchIndex = currentIndex;
                }
                ++currentIndex;
            }
            if (existingCount == 0) {
                currentIndex = clazz.getOwnedAttributes().size();
            } else if (existingCount < index) {
                currentIndex = matchIndex + 1;
            } else if (currentIndex > 0) {
                --currentIndex;
            }
            clazz.getOwnedAttributes().add(currentIndex, (Object)child);
            EObject physChild = (EObject)this.entityFactory.getPhysicalObject(id);
            if (physChild != null) {
                this.moveEObject(index, physChild, id);
            }
        } else if (child instanceof Column) {
            Table table = (Table)child.eContainer();
            table.getColumns().remove((Object)child);
            Iterator atts = table.getColumns().iterator();
            while (atts.hasNext() && existingCount < index) {
                Object next = atts.next();
                if (next.getClass() == child.getClass()) {
                    ++existingCount;
                    matchIndex = currentIndex;
                }
                ++currentIndex;
            }
            if (existingCount == 0) {
                currentIndex = table.getColumns().size();
            } else if (existingCount < index) {
                currentIndex = matchIndex + 1;
            } else if (currentIndex > 0) {
                --currentIndex;
            }
            table.getColumns().add(currentIndex, (Object)child);
        } else if (child instanceof EnumerationLiteral) {
            Enumeration umlEnum = (Enumeration)child.eContainer();
            umlEnum.getOwnedLiterals().remove((Object)child);
            Iterator atts = umlEnum.getOwnedLiterals().iterator();
            while (atts.hasNext() && existingCount < index) {
                Object next = atts.next();
                if (next.getClass() == child.getClass()) {
                    ++existingCount;
                    matchIndex = currentIndex;
                }
                ++currentIndex;
            }
            if (existingCount == 0) {
                currentIndex = umlEnum.getOwnedLiterals().size();
            } else if (existingCount < index) {
                currentIndex = matchIndex + 1;
            } else if (currentIndex > 0) {
                --currentIndex;
            }
            umlEnum.getOwnedLiterals().add(currentIndex, (Object)child);
        } else {
            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unexpected_move_entity1", (Object)this.entityFactory.getName(child));
            this.importer.log(msg, 4, null);
        }
    }

    private String getOwnerId(FeatureInfo feature) {
        EntityInfo entityInfo = feature.getOwnerEntityInfo();
        if (entityInfo != null) {
            return entityInfo.getID();
        }
        return null;
    }

    private XSDSimpleTypeDefinition getBaseType(String bt) {
        try {
            XSDSimpleTypeDefinition type = null;
            if (bt.equals("SQL_CHAR")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("string");
            } else if (bt.equals("SQL_INTEGER")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("integer");
            } else if (bt.equals("SQL_LONGVARCHAR")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("string");
            } else if (bt.equals("SQL_NUMERIC")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("decimal");
            } else if (bt.equals("SQL_TIMESTAMP")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("timestamp");
            } else if (bt.equals("undefined")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("string");
            } else if (bt.equals("SQL_LONGVARBINARY")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("blob");
            } else if (bt.equals("SQL_BOOLEAN")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("boolean");
            } else {
                String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unexpected_data_type_found", (Object)bt);
                this.importer.log(msg, 4, null);
            }
            return type;
        }
        catch (ModelerCoreException e) {
            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_Datatype_for1", (Object)bt);
            this.importer.log(msg, 4, (Exception)((Object)e));
            return null;
        }
    }

    private String getPhysicalEntityId(FeatureInfo info) {
        if (info == null) {
            return null;
        }
        EntityInfo owner = info.getOwnerEntityInfo();
        if (owner == null) {
            return null;
        }
        return owner.getID();
    }

    private void init() {
    }

    private String createValidName(FeatureInfo info) {
        String name = info.getValue().toString();
        String newName = this.entityFactory.getNameValidator().createValidName(name);
        if (newName != null) {
            name = newName;
        }
        return name;
    }

    private void setLength(XSDSimpleTypeDefinition type, String length) {
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDTotalDigitsFacet facet = type.getTotalDigitsFacet() == null ? this.xsdFactory.createXSDTotalDigitsFacet() : type.getTotalDigitsFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(length);
        } else {
            XSDLengthFacet facet = type.getLengthFacet() == null ? this.xsdFactory.createXSDLengthFacet() : type.getLengthFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(length);
        }
    }

    private void setUpperBound(XSDSimpleTypeDefinition type, String upperBound) {
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDMaxInclusiveFacet facet = type.getMaxInclusiveFacet() == null ? this.xsdFactory.createXSDMaxInclusiveFacet() : type.getMaxInclusiveFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(upperBound);
        } else {
            this.entityFactory.addTag(null, (EObject)type, "upperBound", upperBound, 3);
        }
    }

    private void setLowerBound(XSDSimpleTypeDefinition type, String lowerBound) {
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDMinInclusiveFacet facet = type.getMinInclusiveFacet() == null ? this.xsdFactory.createXSDMinInclusiveFacet() : type.getMinInclusiveFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(lowerBound);
        } else {
            this.entityFactory.addTag(null, (EObject)type, "lowerBound", lowerBound, 3);
        }
    }

    private void setScale(XSDSimpleTypeDefinition type, String scale) {
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDFractionDigitsFacet facet = type.getFractionDigitsFacet() == null ? this.xsdFactory.createXSDFractionDigitsFacet() : type.getFractionDigitsFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(scale);
        } else {
            this.entityFactory.addTag(null, (EObject)type, "scale", scale, 3);
        }
    }

    private void setPrecision(XSDSimpleTypeDefinition type, String precision) {
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDTotalDigitsFacet facet = type.getTotalDigitsFacet() == null ? this.xsdFactory.createXSDTotalDigitsFacet() : type.getTotalDigitsFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(precision);
        } else {
            this.entityFactory.addTag(null, (EObject)type, "precision", precision, 3);
        }
    }
}

