/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xsd.ui.wizards;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelProjectSelectionStatusValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.xsd.ui.wizards.GlobalEntitiesPage;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.xsd.ui.ModelerXsdUiConstants;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.widget.accumulator.AccumulatorPanel;
import com.metamatrix.ui.internal.widget.accumulator.IAccumulatedValuesChangeListener;
import com.metamatrix.ui.internal.widget.accumulator.IAccumulatorSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public class GlobalEntitiesPage
extends WizardPage
implements InternalUiConstants.Widgets,
IAccumulatedValuesChangeListener {
    private static final String TITLE = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.title");
    private static final String DESCRIPTION = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.description");
    private static final int STATUS_OK = 0;
    private static final int STATUS_NO_LOCATION = 1;
    private static final int STATUS_NO_FILENAME = 2;
    private static final int STATUS_FILE_EXISTS = 3;
    private static final int STATUS_BAD_FILENAME = 4;
    private static final int STATUS_CLOSED_PROJECT = 5;
    private static final int STATUS_NO_PROJECT_NATURE = 6;
    private final String leftHeader = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.leftHeader");
    private final String rightHeader = ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.rightHeader");
    private final Collection globalElements = new HashSet();
    private final Collection globalTypes = new HashSet();
    private final ILabelProvider accumulatorLabelProvider = ModelUtilities.getEMFLabelProvider();
    private Text containerText;
    private Resource xsdRsrc;
    private Text fileText;
    private IPath filePath;
    protected int currentStatus = 0;
    private String fileNameMessage = null;
    private String fileExtension = ".xmi";
    private TableViewer typeViewer;
    private AccumulatorPanel panel;
    private Collection typesToCreate;

    public GlobalEntitiesPage(Resource rsrc) {
        super("complexTypesPage");
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.initialize(rsrc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Composite topComposite = new Composite(container, 0);
        GridData topCompositeGridData = new GridData(768);
        topComposite.setLayoutData((Object)topCompositeGridData);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topComposite.setLayout((Layout)topLayout);
        GridData gd = null;
        Label locationLabel = new Label(topComposite, 0);
        locationLabel.setText(UiConstants.Util.getString("NewModelWizard.location"));
        this.containerText = new Text(topComposite, 2052);
        gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.containerText.setEditable(false);
        Button browseButton = new Button(topComposite, 8);
        GridData buttonGridData = new GridData();
        browseButton.setLayoutData((Object)buttonGridData);
        browseButton.setText(UiConstants.Util.getString("NewModelWizard.browse"));
        browseButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label fileLabel = new Label(topComposite, 0);
        fileLabel.setText(UiConstants.Util.getString("NewModelWizard.fileName"));
        this.fileText = new Text(topComposite, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite bottomComposite = new Composite(container, 0);
        GridData bottomCompositeGridData = new GridData(1808);
        bottomComposite.setLayoutData((Object)bottomCompositeGridData);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.numColumns = 2;
        bottomComposite.setLayout((Layout)bottomLayout);
        GlobalEntitiesAccumulatorSource source = new GlobalEntitiesAccumulatorSource(this, this, bottomComposite);
        this.panel = new AccumulatorPanel(bottomComposite, (IAccumulatorSource)source, new ArrayList(), this.accumulatorLabelProvider, this.leftHeader, this.rightHeader);
        this.panel.addAccumulatedValuesChangeListener((IAccumulatedValuesChangeListener)this);
        this.setControl((Control)container);
        this.typeViewer.add(this.globalElements.toArray());
        this.typeViewer.add(this.globalTypes.toArray());
        this.setDefaults();
        this.checkStatus();
    }

    public void accumulatedValuesChanged(AccumulatorPanel source) {
        this.typesToCreate = source.getItemsMovedToSelected();
        this.checkStatus();
    }

    public Collection getTypesToConvert() {
        if (this.typesToCreate == null) {
            return Collections.EMPTY_LIST;
        }
        return this.typesToCreate;
    }

    private void initialize(Resource rsrc) {
        if (rsrc != null) {
            this.addComplexTypes(rsrc);
            this.xsdRsrc = rsrc;
        }
    }

    private void setDefaults() {
        this.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addComplexTypes(Resource xsdRsrc) {
        Iterator eObjects = xsdRsrc.getContents().iterator();
        while (eObjects.hasNext()) {
            Object next = eObjects.next();
            if (!(next instanceof XSDSchema)) continue;
            XSDSchema schema = (XSDSchema)next;
            Iterator children = schema.eContents().iterator();
            while (children.hasNext()) {
                Object child = children.next();
                if (child instanceof XSDComplexTypeDefinition) {
                    this.globalTypes.add(child);
                    continue;
                }
                if (!(child instanceof XSDElementDeclaration)) continue;
                this.globalElements.add(child);
            }
        }
    }

    private void checkStatus() {
        String container = this.getContainerName();
        if (StringUtil.isEmpty((String)container)) {
            this.setMessage("No Model Location Selected", 3);
            this.currentStatus = 1;
            this.setPageComplete(false);
            return;
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            this.currentStatus = 1;
            return;
        }
        if (!project.isOpen()) {
            this.currentStatus = 5;
            return;
        }
        try {
            if (project.getNature("com.metamatrix.modeler.core.modelNature") == null) {
                this.currentStatus = 6;
                return;
            }
        }
        catch (CoreException ex) {
            this.currentStatus = 6;
            return;
        }
        String fileText = this.getFileText();
        if (fileText.length() == 0) {
            this.currentStatus = 2;
            this.setMessage("No File Name Provided", 3);
            return;
        }
        this.fileNameMessage = ModelUtilities.validateModelName((String)fileText, (String)this.fileExtension);
        if (this.fileNameMessage != null) {
            this.currentStatus = 4;
            this.setMessage("File name is not valid. " + this.fileNameMessage, 3);
            return;
        }
        String fileName = this.getFileName();
        this.filePath = new Path(container).append(fileName);
        if (ResourcesPlugin.getWorkspace().getRoot().exists(this.filePath)) {
            this.currentStatus = 3;
            this.setMessage("File already exists. Input another valid name.", 3);
            return;
        }
        if (this.globalElements.isEmpty() && this.globalTypes.isEmpty()) {
            this.setMessage(ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.none"), 3);
            this.setPageComplete(false);
            return;
        }
        if (this.typesToCreate == null || this.typesToCreate.isEmpty()) {
            this.setMessage(ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.noneSelected"), 3);
            this.setPageComplete(false);
            return;
        }
        this.setMessage(ModelerXsdUiConstants.Util.getString("ComplexSchemaTypesPage.done"), 0);
        this.setPageComplete(true);
    }

    private void typesToConvertChanged() {
    }

    private void typesToConvertRemoved(Collection values) {
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            this.typeViewer.add(value);
        }
    }

    private void typesToConvertAdded(Collection values) {
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            this.typeViewer.remove(value);
        }
    }

    private Collection getAvailableTypes() {
        int count = this.typeViewer.getTable().getItemCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object value = this.typeViewer.getElementAt(i);
            values.add(value);
        }
        return values;
    }

    private int getAvailableTypesCount() {
        return this.typeViewer.getTable().getItemCount();
    }

    private Collection getSelectedAvailableTypes() {
        int[] selectionIndices = this.typeViewer.getTable().getSelectionIndices();
        ArrayList<Object> selectedValues = new ArrayList<Object>(selectionIndices.length);
        for (int i = 0; i < selectionIndices.length; ++i) {
            int index = selectionIndices[i];
            selectedValues.add(this.typeViewer.getElementAt(index));
        }
        return selectedValues;
    }

    private int getSelectedAvailableTypeCount() {
        if (this.typeViewer != null) {
            return this.typeViewer.getTable().getSelectionCount();
        }
        return 0;
    }

    private Control createTypeControl(Composite parent) {
        this.typeViewer = new TableViewer(parent, 2);
        this.typeViewer.setLabelProvider((IBaseLabelProvider)this.accumulatorLabelProvider);
        return this.typeViewer.getControl();
    }

    private void addTypeSelectionListener(SelectionListener listener) {
        this.typeViewer.getTable().addSelectionListener(listener);
    }

    private void handleBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)((IContainer)this.getTargetContainer()), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.containerText != null) {
            this.containerText.setText(folder.getFullPath().makeRelative().toString());
        }
        this.checkStatus();
    }

    public IProject getTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getContainerName();
        if (!StringUtil.isEmpty((String)containerName) && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    public IResource getTargetContainer() {
        IWorkspaceRoot root;
        IResource resource;
        IResource result = null;
        String containerName = this.getContainerName();
        if (!StringUtil.isEmpty((String)containerName) && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource;
        }
        return result;
    }

    public String getContainerName() {
        String result = null;
        result = this.containerText.getText().trim();
        return result;
    }

    public String getFileName() {
        String result = this.fileText.getText().trim();
        if (!result.endsWith(this.fileExtension)) {
            result = result + this.fileExtension;
        }
        return result;
    }

    public String getFileText() {
        return this.fileText.getText().trim();
    }

    public IPath getFilePath() {
        return this.filePath;
    }

    static /* synthetic */ void access$000(GlobalEntitiesPage x0) {
        x0.checkStatus();
    }

    static /* synthetic */ void access$100(GlobalEntitiesPage x0) {
        x0.handleBrowse();
    }

    static /* synthetic */ Resource access$200(GlobalEntitiesPage x0) {
        return x0.xsdRsrc;
    }

    static /* synthetic */ Text access$300(GlobalEntitiesPage x0) {
        return x0.containerText;
    }

    static /* synthetic */ Text access$400(GlobalEntitiesPage x0) {
        return x0.fileText;
    }

    static /* synthetic */ void access$500(GlobalEntitiesPage x0, Collection x1) {
        x0.typesToConvertRemoved(x1);
    }

    static /* synthetic */ void access$600(GlobalEntitiesPage x0) {
        x0.typesToConvertChanged();
    }

    static /* synthetic */ void access$700(GlobalEntitiesPage x0, Collection x1) {
        x0.typesToConvertAdded(x1);
    }

    static /* synthetic */ Collection access$800(GlobalEntitiesPage x0) {
        return x0.getAvailableTypes();
    }

    static /* synthetic */ int access$900(GlobalEntitiesPage x0) {
        return x0.getAvailableTypesCount();
    }

    static /* synthetic */ Collection access$1000(GlobalEntitiesPage x0) {
        return x0.getSelectedAvailableTypes();
    }

    static /* synthetic */ int access$1100(GlobalEntitiesPage x0) {
        return x0.getSelectedAvailableTypeCount();
    }

    static /* synthetic */ Control access$1200(GlobalEntitiesPage x0, Composite x1) {
        return x0.createTypeControl(x1);
    }

    static /* synthetic */ void access$1300(GlobalEntitiesPage x0, SelectionListener x1) {
        x0.addTypeSelectionListener(x1);
    }
}

