/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.db2.DB2Connection;
import com.metamatrix.jdbc.db2.DB2EscapeTranslator;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.DB2License;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACancelRequest;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.jdbc.db2.drda.DRDALoginRequest;
import com.metamatrix.jdbc.db2.drda.DRDATransactionRequest;
import com.metamatrix.util.UtilException;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.LinkedList;

public class DB2ImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.65.1.5  $";
    public DRDAByteOrderedDataWriter dataWriter;
    public DRDAByteOrderedDataReader dataReader;
    public DRDACommunication comm;
    private boolean isUDBCompatible;
    public DB2Connection db2Connection;
    public boolean inLocalTransaction;
    public boolean isXAImplConn;
    DRDACancelRequest cancelRequest;
    public byte[] cancelToken;
    LinkedList implStatements;
    public String cancelHost;
    public String cancelPort;
    public String databaseName;
    public String addToCreateTable;
    public String collectionId;
    public String packageCollection;
    public String dynSectionsString;
    public int transactionIsolationLevel;
    public String grantee;
    public String grantExecute;
    public String replacePackage;
    public String packageOwner;
    public String defaultQualifier;
    public String user;
    public String password;
    public String host;
    public String port;
    public String holdCursor;
    public String stripNewlines;
    public String alternateID;
    public boolean holdCursorsOverCommit;
    public boolean catalogIncludesSynonyms;
    public String codePageOverride;
    public boolean batchPerformanceWorkaround;
    public String securityMechanism;
    public String authenticationMethod;
    public String charSetFor65535;
    public String catalogSchema;
    public boolean useCurrentSchema;
    private boolean sendClientInfo = true;
    public boolean allowImplicitResultSetCloseForXA;
    public int resultSetMetaDataOptions = 0;
    public boolean enableCancelTimeout;
    public boolean autoCommitResults = true;
    public boolean inAutoCommit;
    protected DRDATransactionRequest transactionRequest;
    public DRDALoginRequest loginRequest;

    public DB2ImplConnection(DB2Connection dB2Connection) {
        this.quotingChar = (char)39;
        this.db2Connection = dB2Connection;
        this.implStatements = new LinkedList();
    }

    public Socket getQueryTimeoutSocket() {
        return this.comm.socket;
    }

    public void open() throws SQLException {
        this.inAutoCommit = true;
        this.transactionIsolationLevel = 2;
        this.inLocalTransaction = true;
        this.isXAImplConn = this.isXAConnection;
        this.collectionId = this.connectProps.get("collectionId");
        this.packageCollection = this.connectProps.get("packageCollection");
        this.databaseName = this.connectProps.get("databaseName");
        this.addToCreateTable = this.connectProps.get("addtoCreateTable");
        this.dynSectionsString = this.connectProps.get("dynamicSections");
        this.grantee = this.connectProps.get("grantee");
        this.grantExecute = this.connectProps.get("grantExecute");
        this.replacePackage = this.connectProps.get("replacePackage");
        this.packageOwner = this.connectProps.get("packageOwner");
        this.defaultQualifier = this.connectProps.get("defaultQualifier");
        this.user = this.connectProps.get("user");
        this.password = this.connectProps.get("password");
        this.host = this.connectProps.get("serverName");
        this.port = this.connectProps.get("portNumber");
        this.cancelHost = this.host;
        this.cancelPort = this.port;
        this.holdCursor = this.connectProps.get("withholdcursors");
        this.stripNewlines = this.connectProps.get("stripNewlines");
        this.alternateID = this.connectProps.get("alternateID");
        this.securityMechanism = this.connectProps.get("securityMechanism");
        this.authenticationMethod = this.connectProps.get("authenticationMethod");
        this.charSetFor65535 = this.connectProps.get("charSetFor65535");
        this.catalogIncludesSynonyms = new Boolean(this.connectProps.get("catalogIncludesSynonyms"));
        this.codePageOverride = this.connectProps.get("codePageOverride");
        this.catalogSchema = this.connectProps.get("catalogSchema");
        this.useCurrentSchema = new Boolean(this.connectProps.get("useCurrentSchema"));
        this.enableCancelTimeout = new Boolean(this.connectProps.get("enableCancelTimeout"));
        this.allowImplicitResultSetCloseForXA = new Boolean(this.connectProps.get("allowImplicitResultSetCloseForXA"));
        String string = this.connectProps.get("AutoCommitResults");
        if (string != null) {
            this.autoCommitResults = new Boolean(string);
        }
        String string2 = this.connectProps.get("resultsetMetaDataOptions");
        this.resultSetMetaDataOptions = Integer.parseInt(string2);
        if (this.collectionId == null) {
            this.collectionId = this.packageCollection.toUpperCase();
        } else if (this.packageCollection.equalsIgnoreCase(DRDAConstants.DEFAULT_COLLECTION_ID_PROP) && this.collectionId != null && !this.collectionId.equalsIgnoreCase(DRDAConstants.DEFAULT_COLLECTION_ID_PROP)) {
            this.collectionId.toUpperCase();
        } else {
            this.collectionId = this.packageCollection.toUpperCase();
        }
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            this.batchPerformanceWorkaround = new Boolean(this.connectProps.get("batchPerformanceWorkaround"));
            this.holdCursorsOverCommit = new Boolean(this.holdCursor);
        } else {
            this.batchPerformanceWorkaround = false;
            this.holdCursorsOverCommit = true;
        }
        if (this.addToCreateTable != null) {
            this.addToCreateTable.toUpperCase();
        }
        if (!this.securityMechanism.equalsIgnoreCase(this.authenticationMethod)) {
            if (this.securityMechanism.equalsIgnoreCase("ClearText")) {
                this.securityMechanism = this.authenticationMethod;
            } else if (!this.authenticationMethod.equalsIgnoreCase("ClearText")) {
                throw this.exceptions.getException(7116);
            }
        }
        if (!(this.user != null && this.user.length() != 0 || this.securityMechanism.equalsIgnoreCase("client"))) {
            throw this.exceptions.getException(7091);
        }
        if (!(this.password != null && this.password.length() != 0 || this.securityMechanism.equalsIgnoreCase("client"))) {
            throw this.exceptions.getException(7092);
        }
        if (this.databaseName != null) {
            this.databaseName.toUpperCase();
            this.isUDBCompatible = true;
        } else {
            this.databaseName = this.connectProps.get("locationName");
            if (this.databaseName != null) {
                this.databaseName = this.databaseName.toUpperCase();
                this.isUDBCompatible = false;
            } else {
                throw this.exceptions.getException(7083);
            }
        }
        this.comm = new DRDACommunication(this, this.host, this.port, this.exceptions);
        this.comm.setClientSideTransliteration();
        this.dataWriter = new DRDAByteOrderedDataWriter(this.comm, this.comm.defaultCCSIDTransliterator);
        this.dataWriter.setToBigEndian();
        this.dataReader = this.comm.createReader();
        this.dataReader.setToBigEndian();
        this.transactionRequest = new DRDATransactionRequest(this, this.comm, this.dataReader, this.dataWriter);
        this.loginRequest = new DRDALoginRequest(this, this.comm, this.dataReader, this.dataWriter);
        this.loginRequest.setSecurityMechanism(this.securityMechanism);
        if (this.isXAConnection) {
            this.loginRequest.useTXNMGR = true;
        }
        try {
            this.loginRequest.submitRequest();
            this.loginRequest.processReply(this.warnings);
        }
        catch (SQLException sQLException) {
            try {
                if (this.isXAConnection && !this.comm.supportsXA) {
                    if (this.comm.SQLAMLevel < 7 || this.comm.ServerReleaseLevel != null && !this.comm.ServerReleaseLevel.startsWith("SQL08") && !this.comm.ServerReleaseLevel.startsWith("DSN08")) {
                        throw this.comm.exceptions.getException(7094);
                    }
                    throw sQLException;
                }
                throw sQLException;
            }
            catch (NullPointerException nullPointerException) {
                throw sQLException;
            }
        }
        this.comm.setServerInfo();
        if (this.isUDBCompatible && (this.comm.serverOS == 8 || this.comm.serverOS == 3)) {
            throw this.exceptions.getException(7096);
        }
        if (!(this.isUDBCompatible || this.comm.serverOS != 2 && this.comm.serverOS != 6 && this.comm.serverOS != 4 && this.comm.serverOS != 1 && this.comm.serverOS != 5)) {
            throw this.exceptions.getException(7097);
        }
        if (this.isXAConnection && !this.comm.supportsXA) {
            throw this.comm.exceptions.getException(7094);
        }
        this.comm.fixSQLAMLevels();
        this.checkLicense();
        this.comm.packageManager.initialize(this.loginRequest);
        if (this.alternateID != null) {
            if (this.comm.serverOS == 3) {
                String string3 = new String("SET CURRENT SQLID = '" + this.alternateID.toUpperCase() + "'");
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.setSQL(new BaseSQL(string3, 0, this.quotingChar, (BaseEscapeTranslator)new DB2EscapeTranslator(this), this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
            } else {
                String string4 = new String("SET CURRENT SCHEMA = '" + this.alternateID.toUpperCase() + "'");
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.setSQL(new BaseSQL(string4, 0, this.quotingChar, (BaseEscapeTranslator)new DB2EscapeTranslator(this), this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
            }
        }
        if (this.comm.serverType == 5 || this.comm.serverType == 2 || this.comm.serverType == 3 || this.comm.serverType == 1 || this.comm.serverType == 5 || this.comm.serverType == 8) {
            this.sendClientInfo = false;
        }
    }

    public void setUpCancelRequest() throws SQLException {
        DRDACommunication dRDACommunication = new DRDACommunication(this, this.cancelHost, this.cancelPort, this.exceptions);
        dRDACommunication.setClientSideTransliteration();
        DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter = new DRDAByteOrderedDataWriter(dRDACommunication, dRDACommunication.defaultCCSIDTransliterator);
        dRDAByteOrderedDataWriter.setToBigEndian();
        DRDAByteOrderedDataReader dRDAByteOrderedDataReader = dRDACommunication.createReader();
        dRDAByteOrderedDataReader.setToBigEndian();
        this.cancelRequest = new DRDACancelRequest(this, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
        if (this.enableCancelTimeout) {
            try {
                dRDACommunication.getSocket().setSoTimeout(this.comm.getSocket().getSoTimeout());
            }
            catch (SocketException socketException) {
                throw this.exceptions.getException((Exception)socketException);
            }
        }
    }

    protected void checkLicense() throws SQLException {
        try {
            int n;
            Object obj = Class.forName("com.metamatrix.jdbc.db2.DB2License").newInstance();
            if (obj != null && ((n = ((DB2License)obj).getConnectionType()) == DB2License.CONNECT_TO_UDB ? this.comm.serverOS == 8 || this.comm.serverOS == 3 : n == DB2License.CONNECT_TO_MVS && this.comm.serverOS != 8 && this.comm.serverOS != 3)) {
                throw this.exceptions.getException(7042, null, "57015", -923);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw this.exceptions.getException((Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.exceptions.getException((Exception)illegalAccessException);
        }
    }

    protected void startManualTransactionMode() throws SQLException {
        this.inAutoCommit = false;
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.commitTransaction();
        this.inAutoCommit = true;
    }

    protected void commitTransaction() throws SQLException {
        if (this.isXAConnection && this.inLocalTransaction) {
            if (this.comm.useBetaXAImplementation) {
                this.transactionRequest.commitXA();
                this.transactionRequest.submitRequest();
                this.transactionRequest.processReply(this.warnings);
            } else {
                this.transactionRequest.submitRequest(1);
                this.transactionRequest.processReply(this.warnings);
            }
        } else if (!this.isXAConnection) {
            this.transactionRequest.submitRequest(1);
            this.transactionRequest.processReply(this.warnings);
        }
        this.comm.packageManager.updatePackageSections();
    }

    protected void rollbackTransaction() throws SQLException {
        if (this.isXAConnection && this.inLocalTransaction) {
            if (this.comm.useBetaXAImplementation) {
                this.transactionRequest.rollBackXA();
                this.transactionRequest.submitRequest();
                this.transactionRequest.processReply(this.warnings);
            } else {
                this.transactionRequest.submitRequest(2);
                this.transactionRequest.processReply(this.warnings);
            }
        } else if (!this.isXAConnection) {
            this.transactionRequest.submitRequest(2);
            this.transactionRequest.processReply(this.warnings);
        }
        this.comm.packageManager.updatePackageSections();
    }

    public void endUnitOfWork(int n) throws SQLException {
        if (this.implStatements != null) {
            int n2 = this.implStatements.size();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)((Object)this.implStatements.get(n3));
                if (!dB2ImplStatement.isCursorSelect && !dB2ImplStatement.isStoredProc && dB2ImplStatement.isParameterSetsEmpty()) {
                    this.comm.packageManager.freeThisSectionNumber(dB2ImplStatement.packageConsistencyToken);
                    if (dB2ImplStatement.packageConsistencyToken != null) {
                        dB2ImplStatement.packageConsistencyToken.sectionNumber = 0;
                    }
                }
                if (dB2ImplStatement.request != null && !dB2ImplStatement.request.isCursorHeldOpen) {
                    dB2ImplStatement.request.isCursorOpen = dB2ImplStatement.request.isCursorHeldOpen;
                    dB2ImplStatement.request.moreData = dB2ImplStatement.request.isCursorHeldOpen;
                    if (dB2ImplStatement.resultSet != null) {
                        dB2ImplStatement.resultSet.request.isCursorOpen = dB2ImplStatement.resultSet.request.isCursorHeldOpen;
                        dB2ImplStatement.resultSet.request.moreData = dB2ImplStatement.resultSet.request.isCursorHeldOpen;
                    } else if (dB2ImplStatement.resultSetArray != null) {
                        n4 = 0;
                        while (n4 < dB2ImplStatement.request.numResultSets) {
                            dB2ImplStatement.resultSetArray[n4].request.isCursorOpen = dB2ImplStatement.resultSetArray[n4].request.isCursorHeldOpen;
                            dB2ImplStatement.resultSetArray[n4].request.moreData = dB2ImplStatement.resultSetArray[n4].request.isCursorHeldOpen;
                            ++n4;
                        }
                    }
                }
                if (this.comm.serverType == 5 && n == 2 && dB2ImplStatement.request != null) {
                    dB2ImplStatement.request.isCursorOpen = false;
                    dB2ImplStatement.request.moreData = false;
                    if (dB2ImplStatement.resultSet != null) {
                        dB2ImplStatement.resultSet.request.isCursorOpen = false;
                        dB2ImplStatement.resultSet.request.moreData = false;
                    } else if (dB2ImplStatement.resultSetArray != null) {
                        n4 = 0;
                        while (n4 < dB2ImplStatement.request.numResultSets) {
                            dB2ImplStatement.resultSetArray[n4].request.isCursorOpen = false;
                            dB2ImplStatement.resultSetArray[n4].request.moreData = false;
                            ++n4;
                        }
                    }
                }
                ++n3;
            }
        }
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        DB2ImplStatement dB2ImplStatement = new DB2ImplStatement(this, n, n2, this.exceptions);
        dB2ImplStatement.setCursorHoldability(Boolean.valueOf(this.holdCursor));
        dB2ImplStatement.setAddToCreateTable(this.addToCreateTable);
        DRDAByteOrderedDataReader dRDAByteOrderedDataReader = this.comm.createReader();
        dRDAByteOrderedDataReader.setToBigEndian();
        dB2ImplStatement.setReader(dRDAByteOrderedDataReader);
        dB2ImplStatement.setWriter(this.dataWriter);
        this.implStatements.addFirst(dB2ImplStatement);
        return dB2ImplStatement;
    }

    protected int getTransactionIsolation() throws SQLException {
        return this.transactionIsolationLevel;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        switch (n) {
            case 0: {
                if (this.comm.serverOS != 8) {
                    String[] stringArray = new String[]{new String(Integer.toString(n))};
                    throw this.exceptions.getException(7072, stringArray);
                }
                this.transactionIsolationLevel = n;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.transactionIsolationLevel = n;
                break;
            }
            default: {
                String[] stringArray = new String[]{new String(Integer.toString(n))};
                throw this.exceptions.getException(7072, stringArray);
            }
        }
    }

    public void close() throws SQLException {
        try {
            if (this.dataReader != null) {
                this.dataReader.close();
            }
            if (this.dataWriter != null) {
                this.dataWriter.close();
            }
            if (this.cancelRequest != null) {
                if (this.cancelRequest.reader != null) {
                    this.cancelRequest.reader.close();
                }
                if (this.cancelRequest.writer != null) {
                    this.cancelRequest.writer.close();
                }
            }
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
        this.comm.close();
    }

    public void reset() throws SQLException {
        this.commitTransaction();
        this.comm.transliteratorPool.reset();
    }

    public boolean isUDBCompatible() {
        return this.isUDBCompatible;
    }

    protected void setSavepoint(String string) throws SQLException {
        String string2 = new String("SAVEPOINT " + string + " ON ROLLBACK RETAIN CURSORS");
        DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
        dB2ImplStatement.setup(this, this.warnings);
        dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
        dB2ImplStatement.execute();
        dB2ImplStatement.getNextResultType();
    }

    protected void implicitReleaseSavepoint(String string) throws SQLException {
        if (this.comm.serverType == 9) {
            String string2 = new String("RELEASE SAVEPOINT " + string);
            DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
            dB2ImplStatement.setup(this, this.warnings);
            dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
            dB2ImplStatement.execute();
            dB2ImplStatement.getNextResultType();
        }
    }

    protected void releaseSavepoint(String string) throws SQLException {
        String string2 = new String("RELEASE SAVEPOINT " + string);
        DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
        dB2ImplStatement.setup(this, this.warnings);
        dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
        dB2ImplStatement.execute();
        dB2ImplStatement.getNextResultType();
    }

    protected void rollbackTransaction(String string) throws SQLException {
        String string2 = new String("ROLLBACK TO SAVEPOINT " + string);
        DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
        dB2ImplStatement.setup(this, this.warnings);
        dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
        dB2ImplStatement.execute();
        dB2ImplStatement.getNextResultType();
    }

    public String getCatalog() throws SQLException {
        return this.databaseName.toUpperCase();
    }

    public boolean supportsCancel() {
        return this.comm.supportsCancel;
    }

    public boolean supportsSelectStarCommaColumn() {
        return false;
    }

    public int getEmptyRowInsertSyntax() {
        return 4;
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    protected void fixupAutoIncrement(BaseColumn baseColumn) throws SQLException {
        String string = "";
        if (baseColumn.tableName != null && this.comm.serverOS != 8) {
            if (this.comm.serverOS == 3) {
                String string2 = "SELECT DEFAULT FROM SYSIBM.SYSCOLUMNS WHERE TBNAME='" + baseColumn.tableName.toUpperCase() + "'" + "AND NAME='" + baseColumn.name.toUpperCase() + "'";
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, (BaseEscapeTranslator)new DB2EscapeTranslator(this), this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
                BaseImplResultSet baseImplResultSet = dB2ImplStatement.getNextResultSet();
                baseImplResultSet.setImplStatement((BaseImplStatement)dB2ImplStatement);
                baseImplResultSet.setWarnings(this.warnings);
                if (baseImplResultSet.fetchAtPosition(0)) {
                    string = baseImplResultSet.getData(1, 1).getString(-1, this.exceptions);
                }
                baseImplResultSet.close();
                dB2ImplStatement.close();
                if (string.equalsIgnoreCase("A") || string.equalsIgnoreCase("D") || string.equalsIgnoreCase("Y")) {
                    baseColumn.isAutoIncrement = true;
                }
            } else {
                String string3 = "SELECT GENERATED FROM SYSIBM.SYSCOLUMNS WHERE TBNAME='" + baseColumn.tableName.toUpperCase() + "'" + "AND NAME='" + baseColumn.name.toUpperCase() + "'";
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.setSQL(new BaseSQL(string3, 0, this.quotingChar, (BaseEscapeTranslator)new DB2EscapeTranslator(this), this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
                BaseImplResultSet baseImplResultSet = dB2ImplStatement.getNextResultSet();
                baseImplResultSet.setImplStatement((BaseImplStatement)dB2ImplStatement);
                baseImplResultSet.setWarnings(this.warnings);
                if (baseImplResultSet.fetchAtPosition(0)) {
                    string = baseImplResultSet.getData(1, 1).getString(-1, this.exceptions);
                }
                baseImplResultSet.close();
                dB2ImplStatement.close();
                if (string.equalsIgnoreCase("A") || string.equalsIgnoreCase("D")) {
                    baseColumn.isAutoIncrement = true;
                }
            }
        }
    }

    protected String setClientApplicationName(String string) throws SQLException {
        block3: {
            if (string.length() > 255) {
                string = string.substring(0, 255);
            }
            if (!this.sendClientInfo) break block3;
            try {
                String string2 = new String("SET CLIENT APPLNAME '" + string + "'");
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.settingSpecialRegister = true;
                dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
            }
            catch (SQLException sQLException) {}
        }
        return string;
    }

    protected String setClientHostName(String string) throws SQLException {
        block3: {
            if (string.length() > 255) {
                string = string.substring(0, 255);
            }
            if (!this.sendClientInfo) break block3;
            try {
                String string2 = new String("SET CLIENT WRKSTNNAME '" + string + "'");
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.settingSpecialRegister = true;
                dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
            }
            catch (SQLException sQLException) {}
        }
        return string;
    }

    protected String setClientUser(String string) throws SQLException {
        block3: {
            if (string.length() > 255) {
                string = string.substring(0, 255);
            }
            if (!this.sendClientInfo) break block3;
            try {
                String string2 = new String("SET CLIENT USERID '" + string + "'");
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.settingSpecialRegister = true;
                dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
            }
            catch (SQLException sQLException) {}
        }
        return string;
    }

    protected String setClientAccountingInfo(String string) throws SQLException {
        block3: {
            if (string.length() > 255) {
                string = string.substring(0, 255);
            }
            if (!this.sendClientInfo) break block3;
            try {
                String string2 = new String("SET CLIENT ACCTNG '" + string + "'");
                DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.createImplStatement(1000, 1003);
                dB2ImplStatement.setup(this, this.warnings);
                dB2ImplStatement.settingSpecialRegister = true;
                dB2ImplStatement.setSQL(new BaseSQL(string2, 0, this.quotingChar, null, this.exceptions));
                dB2ImplStatement.execute();
                dB2ImplStatement.getNextResultType();
            }
            catch (SQLException sQLException) {}
        }
        return string;
    }

    public boolean supportsIntegratedSecurity() {
        return true;
    }
}

