/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilByteArray;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class UtilTransliteratorForASCII
extends UtilTransliterator {
    private static String footprint = "$Revision:   3.5.2.0  $";
    private int[] rl;
    private InputStream _in;

    public UtilTransliteratorForASCII() {
        this.setDefaultCacheSize();
    }

    public boolean isFixedBytesPerChar() {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 1;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        return UtilByteArray.duplicate(this.encode(string, this.rl), string.length());
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        this.setCacheSize(n);
        string.getChars(0, n, this.charsCache, 0);
        int n2 = 0;
        while (n2 < n) {
            this.bytesCache[n2] = (byte)this.charsCache[n2];
            ++n2;
        }
        nArray[0] = n;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                outputStream.write(this.bytesCache, 0, n3);
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                int n4 = 0;
                while (n4 < n3) {
                    this.bytesCache[n4] = (byte)this.charsCache[n4];
                    ++n4;
                }
                outputStream.write(this.bytesCache, 0, n3);
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private void _decode(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4 + n2] = (char)(byArray[n4 + n] & 0xFF);
            ++n4;
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return UtilTransliterator.EMPTY_STRING;
        }
        this.setCacheSize(n2);
        this._decode(byArray, n, this.charsCache, 0, n2);
        return new String(this.charsCache, 0, n2);
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        if (n2 > cArray.length) {
            n2 = cArray.length;
        }
        this._decode(byArray, n, cArray, 0, n2);
        return n2;
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        int n4 = StrictMath.max(n2, n3);
        this.setCacheSize(n4);
        this._decode(byArray, n, this.charsCache, 0, n2);
        int n5 = n2;
        while (n5 < n3) {
            this.charsCache[n5] = 32;
            ++n5;
        }
        return new String(this.charsCache, 0, n3);
    }

    public InputStream decodeAsAsciiStream(InputStream inputStream) throws UtilException {
        return inputStream;
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorForASCII.this._in;
            }

            public int read() throws IOException {
                int n = this.in.read();
                if (n == -1) {
                    return -1;
                }
                return (char)(n & 0xFF);
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                if (this.cache == null || this.cache.length < n2) {
                    this.cache = new byte[n2];
                }
                if ((n3 = this.in.read(this.cache, 0, n2)) <= 0) {
                    return n3;
                }
                UtilTransliteratorForASCII.this._decode(this.cache, 0, cArray, n, n3);
                return n3;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }
}

