/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class BaseParameter
extends BaseData {
    private static String footprint = "$Revision:   3.6.1.2  $";
    public static final int DIR_IN = 1;
    public static final int DIR_OUT = 2;
    public static final int DIR_INOUT = 4;
    public static final int TYPE_UNSPECIFIED = Integer.MAX_VALUE;
    public int sqlType = Integer.MAX_VALUE;
    public int scale = -1;
    public int nativeType;
    public Calendar cal;
    public UtilTransliterator transliterator;
    public String transliteratorCharSet;

    public BaseParameter(BaseConnection baseConnection) {
        super(baseConnection);
    }

    public BaseParameter(BaseParameter baseParameter, BaseConnection baseConnection) {
        super(baseConnection);
        this.copy(baseParameter, baseConnection);
    }

    public BaseParameter(int n, int n2, Object object, BaseConnection baseConnection) {
        super(n2, object, baseConnection);
        this.sqlType = n;
    }

    public BaseParameter(int n, int n2, Object object, int n3, BaseConnection baseConnection) {
        super(n2, object, baseConnection);
        this.sqlType = n;
        this.scale = n3;
    }

    public BaseParameter(int n, int n2, Object object, Calendar calendar, BaseConnection baseConnection) {
        super(n2, object, baseConnection);
        this.sqlType = n;
        this.cal = calendar;
    }

    public void copy(BaseParameter baseParameter, BaseConnection baseConnection) {
        super.populate(baseParameter);
        this.sqlType = baseParameter.sqlType;
        this.scale = baseParameter.scale;
        this.cal = baseParameter.cal;
    }

    public Time getTime(BaseExceptions baseExceptions) throws SQLException {
        if (this.getType() == 12 && !this.isNull()) {
            if (this.sqlType == 93 || this.sqlType == 92) {
                Time time = (Time)this.getObject();
                return new Time(time.getHours(), time.getMinutes(), time.getSeconds());
            }
            if (this.sqlType == 91) {
                this.unsupportedConversion(baseExceptions);
            }
        }
        return super.getTime(baseExceptions);
    }

    public Date getDate(BaseExceptions baseExceptions) throws SQLException {
        if (this.getType() == 11 && !this.isNull()) {
            if (this.sqlType == 93 || this.sqlType == 91) {
                Date date = (Date)this.getObject();
                return new Date(date.getYear(), date.getMonth(), date.getDate());
            }
            if (this.sqlType == 92) {
                this.unsupportedConversion(baseExceptions);
            }
        }
        return super.getDate(baseExceptions);
    }

    public BaseTimestamp getTimestamp(BaseExceptions baseExceptions) throws SQLException {
        if (this.getType() == 13 && !this.isNull()) {
            if (this.sqlType == 91) {
                BaseTimestamp baseTimestamp = (BaseTimestamp)this.getObject();
                return new BaseTimestamp(baseTimestamp.getYear(), baseTimestamp.getMonth(), baseTimestamp.getDate(), 0, 0, 0, 0, null);
            }
            if (this.sqlType == 92) {
                BaseTimestamp baseTimestamp = (BaseTimestamp)this.getObject();
                return new BaseTimestamp(1970, 0, 1, baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds(), baseTimestamp.getNanos(), null);
            }
        }
        return super.getTimestamp(baseExceptions);
    }

    public UtilTransliterator getTransliterator() {
        UtilTransliterator utilTransliterator;
        block3: {
            block2: {
                utilTransliterator = null;
                if (this.transliterator == null) break block2;
                utilTransliterator = this.transliterator;
                break block3;
            }
            if (this.transliteratorCharSet == null) break block3;
            try {
                utilTransliterator = UtilTransliterator.GetNewTransliterator((String)this.transliteratorCharSet);
            }
            catch (UtilException utilException) {}
        }
        return utilTransliterator;
    }
}

