/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.dqp.ui.dialogs;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.dqp.internal.config.VdbDefnHelper;
import com.metamatrix.modeler.dqp.ui.DqpUiConstants;
import com.metamatrix.modeler.dqp.util.ModelerDqpUtils;
import com.metamatrix.modeler.internal.dqp.ui.actions.ImportAction;
import com.metamatrix.modeler.internal.dqp.ui.config.ConnectorBindingsPropertySourceProvider;
import com.metamatrix.modeler.internal.dqp.ui.dialogs.BaseNewConnectorBindingPanel;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class NewConnectorBindingPanel
extends BaseNewConnectorBindingPanel
implements DqpUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$dqp$ui$dialogs$NewConnectorBindingPanel == null ? (class$com$metamatrix$modeler$internal$dqp$ui$dialogs$NewConnectorBindingPanel = NewConnectorBindingPanel.class$("com.metamatrix.modeler.internal.dqp.ui.dialogs.NewConnectorBindingPanel")) : class$com$metamatrix$modeler$internal$dqp$ui$dialogs$NewConnectorBindingPanel));
    private Map componentTypes;
    private List sortedTypes;
    private Text nameField;
    private Combo typeCombo;
    private PropertySheetPage propertyPage;
    private InternalVdbEditingContext vdbContext;
    private BaseID currentTypeID;
    private ComponentType currentType;
    private ConnectorBinding binding;
    private String originalName;
    private ImportAction importAction = null;
    private IChangeListener configListener;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$dqp$ui$dialogs$NewConnectorBindingPanel;

    public NewConnectorBindingPanel(Composite parent, String name, ComponentType type, InternalVdbEditingContext theContext) {
        super(parent);
        this.currentType = type;
        this.originalName = name;
        this.vdbContext = theContext;
        this.importAction = new ImportAction(2);
        this.importAction.setAllowConfigurationImport(false);
        this.importAction.setShell(this.getShell());
        this.configListener = new /* Unavailable Anonymous Inner Class!! */;
        DqpPlugin.getInstance().getConfigurationManager().addChangeListener(this.configListener);
        this.buildControls();
    }

    protected String getI18nPrefix() {
        return PREFIX;
    }

    protected IStatus getStatus() {
        IStatus result = ModelerDqpUtils.isValidBindingName((String)this.getNewBindingName());
        if (result.getSeverity() != 4) {
            int severity = 4;
            String msg = "Message has not been set";
            VdbDefnHelper helper = DqpPlugin.getInstance().getVdbDefnHelper(this.vdbContext);
            if (ModelerDqpUtils.isUniqueBindingName((String)this.getNewBindingName(), (VDBDefn)helper.getVdbDefn())) {
                if (this.typeCombo.getSelectionIndex() == -1) {
                    msg = this.getString("noConnectorTypeMsg");
                } else {
                    severity = 0;
                    msg = DqpUiConstants.UTIL.getString(PREFIX + "okMsg", (Object)this.getNewBindingName());
                }
            } else {
                severity = 4;
                msg = DqpUiConstants.UTIL.getString(PREFIX + "duplicateNameMsg", (Object)this.getNewBindingName());
            }
            result = BaseNewConnectorBindingPanel.createStatus((int)severity, (String)msg);
        }
        return result;
    }

    public ConnectorBinding getConnectorBinding() {
        return this.getConnectorBinding(true);
    }

    private ConnectorBinding getConnectorBinding(boolean theAddToConfigurationFlag) {
        ConnectorBinding result = null;
        boolean createBinding = false;
        boolean useExisting = false;
        if (this.currentType != null) {
            if (!StringUtil.isEmpty((String)this.getNewBindingName())) {
                if (this.binding == null) {
                    createBinding = true;
                } else if (this.binding.getComponentTypeID() == this.currentTypeID) {
                    createBinding = theAddToConfigurationFlag;
                    useExisting = true;
                    result = this.binding;
                } else {
                    createBinding = true;
                }
            } else if (this.binding != null && this.binding.getComponentTypeID() != this.currentTypeID) {
                this.binding = null;
            }
        } else {
            this.currentTypeID = null;
            this.binding = null;
        }
        if (createBinding) {
            if (theAddToConfigurationFlag && useExisting) {
                try {
                    VdbDefnHelper helper = DqpPlugin.getInstance().getVdbDefnHelper(this.vdbContext);
                    result = this.binding = helper.createConnectorBinding(this.binding, this.getNewBindingName());
                }
                catch (Exception theException) {
                    DqpUiConstants.UTIL.log((Throwable)theException);
                    theException.printStackTrace();
                    MessageDialog.openError((Shell)this.getShell(), (String)this.getString("errorDialog.creatingConnector.title"), (String)this.getString("errorDialog.creatingConnector.msg"));
                }
            } else {
                try {
                    VdbDefnHelper helper = DqpPlugin.getInstance().getVdbDefnHelper(this.vdbContext);
                    result = this.binding = helper.createConnectorBinding(this.currentType, this.getNewBindingName(), theAddToConfigurationFlag);
                }
                catch (Exception theException) {
                    DqpUiConstants.UTIL.log((Throwable)theException);
                    theException.printStackTrace();
                    MessageDialog.openError((Shell)this.getShell(), (String)this.getString("errorDialog.creatingConnector.title"), (String)this.getString("errorDialog.creatingConnector.msg"));
                }
            }
        }
        return result;
    }

    private String getNewBindingName() {
        return this.nameField.getText();
    }

    private void buildControls() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        WidgetFactory.createLabel((Composite)this, (String)this.getString("lblName"));
        this.nameField = WidgetFactory.createTextField((Composite)this, (int)768, (int)2);
        this.nameField.setText(this.originalName == null ? "" : this.originalName);
        this.nameField.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetFactory.createLabel((Composite)this, (String)this.getString("lblType"));
        this.typeCombo = WidgetFactory.createCombo((Composite)this, (int)8, (int)768);
        this.typeCombo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.handleConfigurationChanged();
        Button button = WidgetFactory.createButton((Composite)this, (String)(this.importAction.getText() + InternalUiConstants.Widgets.BROWSE_BUTTON));
        button.setToolTipText(this.getString("btnImport.tip"));
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buildProperties((Composite)this);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void buildProperties(Composite parent) {
        Composite c = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808, (int)3, (int)1);
        WidgetFactory.createLabel((Composite)c, (String)this.getString("lblProperties"));
        this.propertyPage = new PropertySheetPage();
        ConnectorBindingsPropertySourceProvider sourceProvider = new ConnectorBindingsPropertySourceProvider(this.vdbContext);
        sourceProvider.setEditable(true);
        this.propertyPage.setPropertySourceProvider((IPropertySourceProvider)sourceProvider);
        this.propertyPage.createControl(c);
        Control propertyControl = this.propertyPage.getControl();
        GridData gid = new GridData(1808);
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        propertyControl.setLayoutData((Object)gid);
        c.layout();
    }

    private void connectorTypeChanged() {
        int index = this.typeCombo.getSelectionIndex();
        if (index != -1) {
            this.currentType = (ComponentType)this.componentTypes.get(this.sortedTypes.get(index));
            if (this.currentTypeID == null || this.currentTypeID != this.currentType.getID()) {
                this.currentTypeID = this.currentType.getID();
            }
        }
        this.getConnectorBinding(false);
        this.refreshPropertyPage();
        this.fireChangeEvent();
    }

    private void handleBindingNameChanged() {
        boolean noCurrentBinding;
        boolean bl = noCurrentBinding = this.binding == null;
        if (this.getConnectorBinding(false) != null && noCurrentBinding) {
            this.refreshPropertyPage();
        }
        this.fireChangeEvent();
    }

    private void handleImportConnectorType() {
        this.importAction.run();
        this.connectorTypeChanged();
    }

    private void handleConfigurationChanged() {
        if (!this.typeCombo.isDisposed()) {
            this.loadConnectorTypes();
            final Combo combo = this.typeCombo;
            final String selection = this.currentType == null ? "" : this.currentType.getName();
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!combo.isDisposed()) {
                        WidgetUtil.setComboItems((Combo)combo, (List)NewConnectorBindingPanel.this.sortedTypes, null, (boolean)false, (String)selection);
                        ComponentType type = (ComponentType)NewConnectorBindingPanel.this.componentTypes.get(selection);
                        if (type != null) {
                            NewConnectorBindingPanel.this.currentType = type;
                            NewConnectorBindingPanel.this.currentTypeID = type.getID();
                        }
                        NewConnectorBindingPanel.this.connectorTypeChanged();
                    }
                }
            });
        }
    }

    private void handleDispose() {
        DqpPlugin.getInstance().getConfigurationManager().removeChangeListener(this.configListener);
    }

    private void loadConnectorTypes() {
        this.componentTypes = ModelerDqpUtils.getConnectorTypes();
        this.sortedTypes = new ArrayList(new TreeSet(this.componentTypes.keySet()));
        if (this.currentType != null) {
            boolean foundIt = false;
            int size = this.sortedTypes.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)this.sortedTypes.get(i);
                if (!this.currentType.getName().equals(name)) continue;
                foundIt = true;
                break;
            }
            if (!foundIt) {
                this.currentType = null;
            }
        }
    }

    private void refreshPropertyPage() {
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (this.binding != null) {
            selection = new StructuredSelection((Object)this.binding);
        }
        if (this.propertyPage != null) {
            this.propertyPage.selectionChanged(null, (ISelection)selection);
            Control c = this.propertyPage.getControl();
            if (c instanceof Tree) {
                TreeColumn[] cols = ((Tree)c).getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    cols[i].pack();
                }
            }
        }
    }

    public boolean setFocus() {
        return this.typeCombo.setFocus();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$000(NewConnectorBindingPanel x0) {
        x0.handleConfigurationChanged();
    }

    static /* synthetic */ void access$100(NewConnectorBindingPanel x0) {
        x0.handleBindingNameChanged();
    }

    static /* synthetic */ void access$300(NewConnectorBindingPanel x0) {
        x0.handleImportConnectorType();
    }

    static /* synthetic */ void access$400(NewConnectorBindingPanel x0) {
        x0.handleDispose();
    }
}

