/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.AbstractSymbolMappingVisitor;
import java.util.HashMap;
import java.util.Map;

public class RemoveGroupAliasMappingVisitor
extends AbstractSymbolMappingVisitor {
    private Map symbolMap = new HashMap();

    protected Symbol getMappedSymbol(Symbol symbol) {
        if (symbol instanceof ElementSymbol) {
            return this.mapElement((ElementSymbol)symbol);
        }
        if (symbol instanceof GroupSymbol) {
            return this.mapGroup((GroupSymbol)symbol);
        }
        return symbol;
    }

    private ElementSymbol mapElement(ElementSymbol symbol) {
        GroupSymbol mappedGroup;
        GroupSymbol group = symbol.getGroupSymbol();
        if (group != null && (mappedGroup = this.mapGroup(group)) != group) {
            ElementSymbol mapped = (ElementSymbol)symbol.clone();
            mapped.setGroupSymbol(mappedGroup);
            mapped.setName(mappedGroup.getName() + "." + symbol.getShortName());
            mapped.setDisplayFullyQualified(true);
            this.symbolMap.put(symbol, mapped);
            return mapped;
        }
        return symbol;
    }

    private GroupSymbol mapGroup(GroupSymbol symbol) {
        if (symbol.getDefinition() != null) {
            GroupSymbol newSymbol = (GroupSymbol)symbol.clone();
            newSymbol.setName(symbol.getDefinition());
            newSymbol.setDefinition(null);
            return newSymbol;
        }
        return symbol;
    }

    private Map getSymbolMap() {
        return this.symbolMap;
    }

    public static final Map removeAliases(LanguageObject obj) {
        RemoveGroupAliasMappingVisitor visitor = new RemoveGroupAliasMappingVisitor();
        PreOrderNavigator.doVisit(obj, visitor);
        return visitor.getSymbolMap();
    }
}

