/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.api.exception.security.MetaBaseResourceNotResolvedException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class AuthorizationPermissionsImpl
implements AuthorizationPermissions {
    private Set thePermissions = new HashSet();
    private Serializable lockObj = Boolean.FALSE;
    private boolean readOnly = false;

    public AuthorizationPermissionsImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationPermissionsImpl(AuthorizationPermissions orig) {
        this();
        Serializable serializable = this.lockObj;
        synchronized (serializable) {
            Iterator permItr = orig.iterator();
            while (permItr.hasNext()) {
                AuthorizationPermission aPerm = (AuthorizationPermission)permItr.next();
                if (aPerm == null) continue;
                try {
                    this.thePermissions.add(aPerm.clone());
                }
                catch (CloneNotSupportedException e) {
                    Object[] params = new Object[]{aPerm};
                    String msg = PlatformPlugin.Util.getString("ERR.014.107.0005", params);
                    LogManager.logError("AUTHORIZATION", (Throwable)e, msg);
                }
            }
        }
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AuthorizationPermission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException(PlatformPlugin.Util.getString("ERR.014.107.0017"));
        }
        boolean result = false;
        if (permission != null) {
            Serializable serializable = this.lockObj;
            synchronized (serializable) {
                result = this.thePermissions.add(permission);
            }
        }
        return result;
    }

    public boolean add(AuthorizationPermissions permissions) {
        if (this.isReadOnly()) {
            throw new SecurityException(PlatformPlugin.Util.getString("ERR.014.107.0017"));
        }
        boolean result = false;
        if (permissions != null) {
            result = this.addPermissions(permissions.iterator());
        }
        return result;
    }

    public boolean add(Set permissions) {
        if (this.isReadOnly()) {
            throw new SecurityException(PlatformPlugin.Util.getString("ERR.014.107.0017"));
        }
        boolean result = false;
        if (permissions != null) {
            result = this.addPermissions(permissions.iterator());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AuthorizationPermission permission) {
        boolean result = false;
        Serializable serializable = this.lockObj;
        synchronized (serializable) {
            result = this.thePermissions.remove(permission);
        }
        return result;
    }

    public boolean removeAll(Set permissions) {
        boolean result = false;
        if (permissions != null) {
            result = this.removePermissions(permissions.iterator());
        }
        return result;
    }

    public boolean removeAll(AuthorizationPermissions permissions) {
        boolean result = false;
        if (permissions != null) {
            result = this.removePermissions(permissions.iterator());
        }
        return result;
    }

    public void clear() {
        this.thePermissions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        Iterator permItr = Collections.EMPTY_SET.iterator();
        Serializable serializable = this.lockObj;
        synchronized (serializable) {
            permItr = this.thePermissions.iterator();
        }
        return permItr;
    }

    public boolean implies(AuthorizationPermission permission) throws MetaBaseResourceNotResolvedException {
        if (permission == null) {
            return false;
        }
        Iterator permIter = this.thePermissions.iterator();
        while (permIter.hasNext()) {
            AuthorizationPermission aPerm = (AuthorizationPermission)permIter.next();
            if (!aPerm.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.thePermissions.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            try {
                sb.append(iter.next().toString() + ',');
            }
            catch (NoSuchElementException e) {}
        }
        int sbLen = sb.length();
        if (sbLen > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPermissions(Iterator permIter) {
        boolean result = false;
        Serializable serializable = this.lockObj;
        synchronized (serializable) {
            while (permIter.hasNext()) {
                AuthorizationPermission aPerm = (AuthorizationPermission)permIter.next();
                if (aPerm == null || !this.thePermissions.add(aPerm) || result) continue;
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePermissions(Iterator permIter) {
        boolean result = false;
        Serializable serializable = this.lockObj;
        synchronized (serializable) {
            while (permIter.hasNext()) {
                AuthorizationPermission aPerm = (AuthorizationPermission)permIter.next();
                if (aPerm == null || !this.thePermissions.remove(aPerm) || result) continue;
                result = true;
            }
        }
        return result;
    }
}

