/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.lob.LobChunkReader;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.common.types.XMLType;
import com.metamatrix.core.jdbc.SQLXML;
import com.metamatrix.core.log.Logger;
import com.metamatrix.dqp.message.CloseLobRequestMessage;
import com.metamatrix.dqp.message.LobRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMStatement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class MMSQLXML
implements SQLXML {
    private MMStatement statement;
    private XMLType srcXML;
    static /* synthetic */ Class class$com$metamatrix$common$types$XMLType;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMSQLXML;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;

    public static MMSQLXML newInstance(MMStatement statement, XMLType srcXML) throws SQLException {
        if (AOP.useproxy()) {
            Class<?> clazz;
            Class<?> clazz2 = class$com$metamatrix$jdbc$MMSQLXML;
            if (clazz2 == null) {
                clazz2 = class$com$metamatrix$jdbc$MMSQLXML = new MMSQLXML[0].getClass().getComponentType();
            }
            Class[] classArray = new Class[2];
            Class clazz3 = class$com$metamatrix$jdbc$MMStatement;
            if (clazz3 == null) {
                clazz3 = classArray[0] = (class$com$metamatrix$jdbc$MMStatement = new MMStatement[0].getClass().getComponentType());
            }
            if ((clazz = class$com$metamatrix$common$types$XMLType) == null) {
                clazz = class$com$metamatrix$common$types$XMLType = new XMLType[0].getClass().getComponentType();
            }
            classArray[1] = clazz;
            return (MMSQLXML)ProxyFactory.extend(clazz2, classArray, new Object[]{statement, srcXML});
        }
        return new MMSQLXML(statement, srcXML);
    }

    public MMSQLXML(MMStatement statement, XMLType srcXML) throws SQLException {
        this.statement = statement;
        this.srcXML = srcXML;
    }

    public Logger getLogger() {
        return this.statement.getLogger();
    }

    public Source getSource(Class sourceClass) throws SQLException {
        try {
            this.checkReference();
            return this.srcXML.getSource(sourceClass);
        }
        catch (InvalidReferenceException e) {
            return new StreamSource(new LobReader(this.statement, this.srcXML));
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            this.checkReference();
            return this.srcXML.getCharacterStream();
        }
        catch (InvalidReferenceException e) {
            return new LobReader(this.statement, this.srcXML);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            this.checkReference();
            return this.srcXML.getBinaryStream();
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public String getString() throws SQLException {
        try {
            this.checkReference();
            return this.srcXML.getString();
        }
        catch (InvalidReferenceException e) {
            LobReader in = new LobReader(this.statement, this.srcXML);
            return new String(in.getCharacterContents());
        }
    }

    public OutputStream setBinaryStream() throws SQLException {
        try {
            this.checkReference();
            return this.srcXML.setBinaryStream();
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public Writer setCharacterStream() throws SQLException {
        try {
            this.checkReference();
            return this.srcXML.setCharacterStream();
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public void setString(String value) throws SQLException {
        try {
            this.checkReference();
            this.srcXML.setString(value);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkReference() {
        if (Boolean.getBoolean("FORCE_STREAMING")) {
            throw new InvalidReferenceException();
        }
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static class LobReader
    extends LobChunkReader {
        static int counter = 0;

        public LobReader(final MMStatement statement, final XMLType xmlReference) {
            super(new LobChunkProducer(){
                int streamRequestId = counter++;

                public LobChunk getNextChunk() throws IOException {
                    try {
                        LobRequestMessage request = new LobRequestMessage();
                        request.setStreamId(xmlReference.getReferenceStreamId());
                        request.setStreamRequestId(this.streamRequestId);
                        request.setRequestID(new RequestID(statement.getCurrentRequestID()));
                        request.setMessageKey("LOB_" + Long.toString(statement.getCurrentRequestID()));
                        ResultsMessage message = (ResultsMessage)statement.executeAsynchAndWait(request);
                        if (message.getException() != null) {
                            MetaMatrixException e = message.getException();
                            if (e instanceof IOException) {
                                throw (IOException)((Object)e);
                            }
                            throw new IOException(message.getException().getMessage());
                        }
                        return message.getLobChunk();
                    }
                    catch (SQLException e) {
                        IOException ex = new IOException(JDBCPlugin.Util.getString("StreamImpl.Unable_to_read_data_from_stream", e.getMessage()));
                        ex.initCause(e);
                        throw ex;
                    }
                }

                public void close() throws IOException {
                    try {
                        CloseLobRequestMessage request = new CloseLobRequestMessage();
                        request.setStreamId(xmlReference.getReferenceStreamId());
                        request.setStreamRequestId(this.streamRequestId);
                        request.setRequestID(new RequestID(statement.getCurrentRequestID()));
                        request.setMessageKey("LOB_" + Long.toString(statement.getCurrentRequestID()));
                        statement.executeAsynch(request);
                    }
                    catch (SQLException e) {
                        IOException ex = new IOException(e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                }
            });
        }
    }
}

