/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import java.io.File;

public final class FileSeparatorUtil {
    private static final String FILE_SEPARATOR_OS = File.separator;
    public static final String FILE_SEPARATOR_WIN32 = "\\";
    public static final String FILE_SEPARATOR_LINUX = "/";

    public static boolean hasFileSeparator(String somePath) {
        if (somePath == null) {
            String msg = "file path cannot be NULL";
            throw new IllegalArgumentException("file path cannot be NULL");
        }
        return somePath.indexOf(FILE_SEPARATOR_WIN32) > -1 || somePath.indexOf(FILE_SEPARATOR_LINUX) > -1;
    }

    public static String getFileSeparator(String somePath) {
        if (somePath.indexOf(FILE_SEPARATOR_WIN32) > -1) {
            return FILE_SEPARATOR_WIN32;
        }
        if (somePath.indexOf(FILE_SEPARATOR_LINUX) > -1) {
            return FILE_SEPARATOR_LINUX;
        }
        return FILE_SEPARATOR_OS;
    }

    public static String getOSFileSeparator() {
        return FILE_SEPARATOR_OS;
    }
}

