/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.factory;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.FileUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ComponentLoader {
    private Object interpreter;
    private Method evalMethod;
    private Method setMethod;
    private Method setClassLoaderMethod;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$String;

    public ComponentLoader(ClassLoader classLoader, String scriptName) {
        this.init(classLoader, scriptName);
    }

    private void init(ClassLoader classLoader, String scriptName) {
        InputStream scriptStream = classLoader.getResourceAsStream(scriptName);
        if (scriptStream == null) {
            throw new MetaMatrixRuntimeException(CorePlugin.Util.getString("ComponentLoader.Resource_not_found__{0}_1", scriptName));
        }
        InputStreamReader scriptReader = new InputStreamReader(scriptStream);
        String script = FileUtil.read(scriptReader);
        try {
            Class<?> interpreterClass = classLoader.loadClass("bsh.Interpreter");
            this.interpreter = interpreterClass.newInstance();
            this.initMethods();
            this.execute(this.setClassLoaderMethod, new Object[]{classLoader});
            this.execute(script);
        }
        catch (ClassNotFoundException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    private void initMethods() {
        try {
            Class<?> clazz;
            Class<?> clazz2 = this.interpreter.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz3 = class$java$lang$String;
            if (clazz3 == null) {
                clazz3 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            classArray[0] = clazz3;
            this.evalMethod = clazz2.getMethod("eval", classArray);
            Class<?> clazz4 = this.interpreter.getClass();
            Class[] classArray2 = new Class[2];
            Class clazz5 = class$java$lang$String;
            if (clazz5 == null) {
                clazz5 = classArray2[0] = (class$java$lang$String = new String[0].getClass().getComponentType());
            }
            if ((clazz = class$java$lang$Object) == null) {
                clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            classArray2[1] = clazz;
            this.setMethod = clazz4.getMethod("set", classArray2);
            Class<?> clazz6 = this.interpreter.getClass();
            Class[] classArray3 = new Class[1];
            Class<?> clazz7 = class$java$lang$ClassLoader;
            if (clazz7 == null) {
                clazz7 = class$java$lang$ClassLoader = new ClassLoader[0].getClass().getComponentType();
            }
            classArray3[0] = clazz7;
            this.setClassLoaderMethod = clazz6.getMethod("setClassLoader", classArray3);
        }
        catch (SecurityException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new MetaMatrixRuntimeException(e);
        }
    }

    public void set(String name, Object value) {
        this.execute(this.setMethod, new Object[]{name, value});
    }

    public Object execute(String command) {
        return this.execute(this.evalMethod, new Object[]{command});
    }

    private Object execute(Method method, Object[] args) {
        try {
            return method.invoke(this.interpreter, args);
        }
        catch (IllegalAccessException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
    }

    public Object load(String name) {
        return this.execute("load" + name + "()");
    }
}

