/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.net;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoKeyManager;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import com.metamatrix.core.util.Assertion;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SocketHelper {
    private static final String SSL_ENABLED = "metamatrix.encryption.secure.sockets";
    private static final String INTERNAL_SSL_ENABLED = "metamatrix.encryption.internal.secure.sockets";
    private static final String INTERNAL_ENCRYPT_ALL = "metamatrix.encryption.internal.encryptAll";
    private static final String INTERANL_AUTHENTICATION_MODE = "metamatrix.encryption.internal.authenticationMode";
    private static final String KEYSTORE_FILENAME = "com.metamatrix.ssl.keystore.filename";
    private static final String KEYSTORE_PASSWORD = "com.metamatrix.ssl.keystore.Password";
    private static final String KEYSTORE_TYPE = "com.metamatrix.ssl.keystoretype";
    private static final String SSL_PROTOCOL = "com.metamatrix.ssl.protocol";
    private static final String KEY_MANAGER_ALGORITHM = "com.metamatrix.ssl.keymanagementalgorithm";
    private static final String TRUSTSTORE_FILENAME = "com.metamatrix.ssl.truststore.filename";
    private static final String TRUSTSTORE_PASSWORD = "com.metamatrix.ssl.truststore.Password";
    private static final String AUTHENTICATION_MODE = "com.metamatrix.ssl.authenticationMode";
    public static final String ONEWAY = "1-way";
    public static final String TWOWAY = "2-way";
    public static final String ANONYMOUS = "anonymous";
    private static final String DEFAULT_SSL_PROTOCOL = "SSLv3";
    private static final String DEFAULT_KEY_MANAGER_ALGORITHM = "SunX509";
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String ANON_CIPHER_SUITE = "TLS_DH_anon_WITH_AES_128_CBC_SHA";
    public static final String ANON_PROTOCOL = "TLS";
    public static final String UNENCRYPTED_CIPHER_SUITE = "SSL_RSA_WITH_NULL_SHA";
    static boolean initialized = false;
    static boolean ssl_enabled = false;
    static String sslProtocol;
    static String keyManagerFactoryAlgorithm;
    static String keyStoreType;
    static String keyStoreFileName;
    static String keyStorePassword;
    static String trustStoreFileName;
    static String trustStorePassword;
    static String authenticationMode;
    static boolean internal_ssl_enabled;
    static boolean internal_encrypt_all;
    static String internal_authenticationMode;
    static boolean client_encryption_enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void initProperties() {
        if (initialized) {
            return;
        }
        String server_val = CurrentConfiguration.getProperty((String)SSL_ENABLED);
        ssl_enabled = Boolean.valueOf(server_val);
        internal_ssl_enabled = Boolean.valueOf(CurrentConfiguration.getProperty((String)INTERNAL_SSL_ENABLED, (String)Boolean.TRUE.toString()));
        internal_encrypt_all = Boolean.valueOf(CurrentConfiguration.getProperty((String)INTERNAL_ENCRYPT_ALL, (String)Boolean.FALSE.toString()));
        internal_authenticationMode = CurrentConfiguration.getProperty((String)INTERANL_AUTHENTICATION_MODE, (String)TWOWAY);
        String clientEncrypt = CurrentConfiguration.getProperty((String)"metamatrix.encryption.client.encryption", (String)Boolean.TRUE.toString());
        client_encryption_enabled = Boolean.valueOf(clientEncrypt);
        try {
            Properties serverProps = CurrentConfiguration.getResourceProperties((String)"SSL");
            keyStoreFileName = serverProps.getProperty(KEYSTORE_FILENAME);
            try {
                keyStorePassword = new String(CryptoUtil.stringDecrypt(serverProps.getProperty(KEYSTORE_PASSWORD, "").toCharArray()));
            }
            catch (CryptoException err) {
                throw new MetaMatrixRuntimeException(err);
            }
            keyStoreType = serverProps.getProperty(KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
            keyManagerFactoryAlgorithm = serverProps.getProperty(KEY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
            authenticationMode = serverProps.getProperty(AUTHENTICATION_MODE);
            trustStoreFileName = serverProps.getProperty(TRUSTSTORE_FILENAME);
            try {
                trustStorePassword = new String(CryptoUtil.stringDecrypt(serverProps.getProperty(TRUSTSTORE_PASSWORD, "").toCharArray()));
            }
            catch (CryptoException err) {
                throw new MetaMatrixRuntimeException(err);
            }
            sslProtocol = serverProps.getProperty(SSL_PROTOCOL, DEFAULT_SSL_PROTOCOL);
        }
        catch (ConfigurationException ce) {
            keyStoreType = DEFAULT_KEYSTORE_TYPE;
            sslProtocol = DEFAULT_SSL_PROTOCOL;
            keyManagerFactoryAlgorithm = DEFAULT_KEY_MANAGER_ALGORITHM;
            keyStoreFileName = null;
            trustStoreFileName = null;
            authenticationMode = ONEWAY;
        }
        finally {
            initialized = true;
        }
    }

    public static Socket getClientSocket(InetAddress bindAddr, int port) throws Exception {
        SocketHelper.initProperties();
        if (!ssl_enabled || !CryptoUtil.isEncryptionEnabled()) {
            return new Socket(bindAddr, port);
        }
        SSLContext context = null;
        context = ANONYMOUS.equals(authenticationMode) ? SocketHelper.getAnonSSLContext() : SocketHelper.getSSLContext(keyStoreFileName, keyStorePassword, trustStoreFileName, trustStorePassword, keyManagerFactoryAlgorithm, keyStoreType, sslProtocol);
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocket clientSocket = (SSLSocket)factory.createSocket(bindAddr, port);
        if (ANONYMOUS.equals(authenticationMode)) {
            SocketHelper.addCipherSuite(clientSocket, ANON_CIPHER_SUITE);
        }
        return clientSocket;
    }

    public static Socket getInternalClientSocket(InetAddress bindAddr, int port, boolean requiresEncryption) throws IOException {
        SocketHelper.initProperties();
        if (!internal_ssl_enabled || !CryptoUtil.isEncryptionEnabled() || !(requiresEncryption |= internal_encrypt_all) && ANONYMOUS.equals(internal_authenticationMode)) {
            return new Socket(bindAddr, port);
        }
        SSLContext context = null;
        context = ANONYMOUS.equals(internal_authenticationMode) ? SocketHelper.getAnonSSLContext() : SocketHelper.getInternalSSLContext(keyManagerFactoryAlgorithm, DEFAULT_SSL_PROTOCOL);
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocket clientSocket = (SSLSocket)factory.createSocket(bindAddr, port);
        if (!requiresEncryption) {
            SocketHelper.addCipherSuite(clientSocket, UNENCRYPTED_CIPHER_SUITE);
        } else if (ANONYMOUS.equals(internal_authenticationMode)) {
            SocketHelper.addCipherSuite(clientSocket, ANON_CIPHER_SUITE);
        }
        return clientSocket;
    }

    public static ServerSocket getServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        SocketHelper.initProperties();
        if (!ssl_enabled || !CryptoUtil.isEncryptionEnabled()) {
            return new ServerSocket(port, backlog, bindAddr);
        }
        SSLContext context = null;
        context = ANONYMOUS.equals(authenticationMode) ? SocketHelper.getAnonSSLContext() : SocketHelper.getSSLContext(keyStoreFileName, keyStorePassword, trustStoreFileName, trustStorePassword, keyManagerFactoryAlgorithm, keyStoreType, sslProtocol);
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        SSLServerSocket serverSocket = null;
        serverSocket = bindAddr != null ? (SSLServerSocket)factory.createServerSocket(port, backlog, bindAddr) : (SSLServerSocket)factory.createServerSocket(port, backlog);
        if (ANONYMOUS.equals(authenticationMode)) {
            Assertion.assertTrue(Arrays.asList(factory.getSupportedCipherSuites()).contains(ANON_CIPHER_SUITE));
            serverSocket.setEnabledCipherSuites(new String[]{ANON_CIPHER_SUITE});
        }
        serverSocket.setNeedClientAuth(TWOWAY.equals(authenticationMode));
        return serverSocket;
    }

    public static ServerSocket getInternalServerSocket(int port, int backlog, InetAddress bindAddr, boolean requiresEncryption) throws IOException {
        SocketHelper.initProperties();
        if (!internal_ssl_enabled || !CryptoUtil.isEncryptionEnabled() || !(requiresEncryption |= internal_encrypt_all) && ANONYMOUS.equals(internal_authenticationMode)) {
            return new ServerSocket(port, backlog, bindAddr);
        }
        SSLContext context = null;
        context = ANONYMOUS.equals(internal_authenticationMode) ? SocketHelper.getAnonSSLContext() : SocketHelper.getInternalSSLContext(keyManagerFactoryAlgorithm, DEFAULT_SSL_PROTOCOL);
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        SSLServerSocket serverSocket = null;
        serverSocket = bindAddr != null ? (SSLServerSocket)factory.createServerSocket(port, backlog, bindAddr) : (SSLServerSocket)factory.createServerSocket(port, backlog);
        if (!requiresEncryption) {
            Assertion.assertTrue(Arrays.asList(factory.getSupportedCipherSuites()).contains(UNENCRYPTED_CIPHER_SUITE));
            serverSocket.setEnabledCipherSuites(new String[]{UNENCRYPTED_CIPHER_SUITE});
        } else if (ANONYMOUS.equals(internal_authenticationMode)) {
            Assertion.assertTrue(Arrays.asList(factory.getSupportedCipherSuites()).contains(ANON_CIPHER_SUITE));
            serverSocket.setEnabledCipherSuites(new String[]{ANON_CIPHER_SUITE});
        }
        serverSocket.setNeedClientAuth(TWOWAY.equals(internal_authenticationMode));
        return serverSocket;
    }

    public static SSLContext getInternalSSLContext(String algorithm, String protocol) throws IOException {
        try {
            CryptoKeyManager keyManager = PasswordCryptoFactory.getCryptoKeyManager();
            KeyManager[] keyManagers = null;
            KeyStore ks = keyManager.getKeyStore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, keyManager.getStorePassword());
            keyManagers = kmf.getKeyManagers();
            TrustManager[] trustManagers = null;
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            trustManagers = tmf.getTrustManagers();
            SSLContext sslc = SSLContext.getInstance(protocol);
            sslc.init(keyManagers, trustManagers, null);
            return sslc;
        }
        catch (GeneralSecurityException err) {
            IOException exception = new IOException(err.getMessage());
            exception.initCause(err);
            throw exception;
        }
        catch (CryptoException err) {
            IOException exception = new IOException(err.getMessage());
            exception.initCause(err);
            throw exception;
        }
    }

    public static SSLContext getAnonSSLContext() throws IOException {
        return SocketHelper.getSSLContext(null, null, null, null, null, null, ANON_PROTOCOL);
    }

    public static SSLContext getSSLContext(String keystore, String password, String truststore, String truststorePassword, String algorithm, String keystoreType, String protocol) throws IOException {
        try {
            KeyStore ks;
            KeyStore ks2;
            KeyManager[] keyManagers = null;
            if (keystore != null && (ks2 = SocketHelper.loadKeyStore(keystore, password, keystoreType)) != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(ks2, password.toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            if (truststore != null && (ks = SocketHelper.loadKeyStore(truststore, truststorePassword, keystoreType)) != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(ks);
                trustManagers = tmf.getTrustManagers();
            }
            SSLContext sslc = SSLContext.getInstance(protocol);
            sslc.init(keyManagers, trustManagers, null);
            return sslc;
        }
        catch (GeneralSecurityException err) {
            IOException exception = new IOException(err.getMessage());
            exception.initCause(err);
            throw exception;
        }
    }

    static KeyStore loadKeyStore(String name, String password, String type) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (stream == null) {
            try {
                stream = new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                IOException exception = new IOException(CommonPlugin.Util.getString("SocketHelper.keystore_not_found", name));
                exception.initCause(e);
                throw exception;
            }
        }
        KeyStore ks = KeyStore.getInstance(type);
        ks.load(stream, password != null ? password.toCharArray() : null);
        return ks;
    }

    public static boolean isServerSSLEnabled() {
        SocketHelper.initProperties();
        return ssl_enabled;
    }

    public static boolean isClientEncryptionEnabled() {
        SocketHelper.initProperties();
        return CryptoUtil.isEncryptionEnabled() && client_encryption_enabled;
    }

    public static void addCipherSuite(SSLSocket socket, String cipherSuite) {
        Assertion.assertTrue(Arrays.asList(socket.getSupportedCipherSuites()).contains(cipherSuite));
        String[] suites = socket.getEnabledCipherSuites();
        String[] newSuites = new String[suites.length + 1];
        System.arraycopy(suites, 0, newSuites, 0, suites.length);
        newSuites[suites.length] = cipherSuite;
        socket.setEnabledCipherSuites(newSuites);
    }

    public static void setClientEncryptionEnabled(boolean client_encryption_enabled) {
        SocketHelper.client_encryption_enabled = client_encryption_enabled;
    }

    static {
        client_encryption_enabled = false;
    }
}

