/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.XMLConnection;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.BaseBatchProducer;
import com.metamatrix.connector.xml.base.BaseResultsProducer;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.QueryAnalyzer;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLConnectionImpl;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class XMLExecutionImpl
implements SynchQueryExecution,
XMLExecution {
    private XMLConnectionImpl m_conn;
    private ConnectorLogger m_logger;
    public ExecutionContext exeContext;
    private ConnectorEnvironment connectorEnv;
    private RuntimeMetadata m_metadata;
    private int m_maxBatch;
    private int resultSize = 0;
    private ExecutionInfo m_info;
    private List m_resultList;
    private int returnIndex;

    public XMLExecutionImpl(XMLConnectionImpl conn, RuntimeMetadata metadata, ExecutionContext exeContext, ConnectorEnvironment connectorEnv) {
        this.setConnection(conn);
        this.m_metadata = metadata;
        this.m_logger = this.m_conn.getState().getLogger();
        this.m_resultList = null;
        this.exeContext = exeContext;
        this.connectorEnv = connectorEnv;
        this.m_logger.logTrace("ConnectionIdentifier: " + exeContext.getConnectionIdentifier());
        this.m_logger.logTrace("ConnectorIdentifier: " + exeContext.getConnectorIdentifier());
        this.m_logger.logTrace("ExecutionCountIdentifier: " + exeContext.getExecutionCountIdentifier());
        this.m_logger.logTrace("PartIdentifier: " + exeContext.getPartIdentifier());
        this.m_logger.logTrace("RequestIdentifier: " + exeContext.getRequestIdentifier());
        exeContext.keepExecutionAlive(true);
    }

    public void execute(IQuery query, int maxBatchSize) throws ConnectorException {
        try {
            List columnResult;
            XMLConnectorState state = this.m_conn.getState();
            this.m_maxBatch = maxBatchSize;
            QueryAnalyzer analyzer = new QueryAnalyzer(query, this.m_metadata, state.getPreprocessor(), this.m_logger, this.exeContext, this.connectorEnv);
            this.m_info = analyzer.getExecutionInfo();
            List requestPerms = analyzer.getRequestPerms();
            this.m_resultList = new ArrayList();
            int invocationCount = 0;
            Iterator iter = requestPerms.iterator();
            while (iter.hasNext()) {
                List<CriteriaDesc> criteriaListForOnePerm = Arrays.asList((CriteriaDesc[])iter.next());
                this.m_info.setParameters(criteriaListForOnePerm);
                DocumentProducer requestExecutor = state.makeExecutor(this);
                Response response = requestExecutor.getXMLResponse(invocationCount);
                IDocumentCache cache = this.m_conn.getConnector().getStatementCache();
                BaseResultsProducer resProducer = new BaseResultsProducer(cache, this.getLogger());
                List resultList = resProducer.getResult(this.m_info, response);
                this.m_resultList = BaseResultsProducer.combineResults(resultList, this.m_resultList);
                ++invocationCount;
            }
            if (!this.m_resultList.isEmpty() && !(columnResult = (List)this.m_resultList.get(0)).isEmpty()) {
                this.resultSize = columnResult.size();
            }
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public Batch nextBatch() throws ConnectorException {
        try {
            BasicBatch batch = new BasicBatch();
            if (this.m_resultList == null) {
                batch.setLast();
                return batch;
            }
            BaseBatchProducer batchProducer = new BaseBatchProducer();
            batch = BaseBatchProducer.createBatch(this.m_resultList, this.returnIndex, this.m_maxBatch, this.m_info, this.exeContext, this.connectorEnv);
            batchProducer.getCurrentReturnIndex();
            this.returnIndex = batchProducer.getCurrentReturnIndex();
            this.testBatchForLast(this.returnIndex, this.resultSize, (Batch)batch);
            return batch;
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void close() throws ConnectorException {
        try {
            this.m_conn.getConnector().deleteCacheItems(this.exeContext.getRequestIdentifier(), this.exeContext.getPartIdentifier(), this.exeContext.getExecutionCountIdentifier());
            this.m_logger.logTrace("XMLExecution closed for ConnectionIdentifier " + this.exeContext.getConnectionIdentifier() + " and PartIdentifier " + this.exeContext.getPartIdentifier());
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void cancel() throws ConnectorException {
    }

    private void testBatchForLast(int currentSize, int totalSize, Batch testBatch) {
        if (currentSize >= totalSize) {
            testBatch.setLast();
        }
    }

    public XMLConnection getConnection() {
        return this.m_conn;
    }

    void setConnection(XMLConnectionImpl conn) {
        this.m_conn = conn;
    }

    public ExecutionInfo getInfo() {
        return this.m_info;
    }

    public ConnectorLogger getLogger() {
        return this.m_logger;
    }

    public String getSystemName() {
        return this.connectorEnv.getConnectorName();
    }

    public IDocumentCache getCache() {
        return this.m_conn.getConnector().getCache();
    }

    public ExecutionContext getExeContext() {
        return this.exeContext;
    }
}

