/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.data.api.ConnectorLogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileLifeManager {
    private File file;
    private ConnectorLogger logger;
    private List openFiles;

    protected FileLifeManager(File file, ConnectorLogger logger) throws IOException {
        this.file = file.getCanonicalFile();
        this.logger = logger;
        if (logger != null) {
            logger.logInfo("XML Connector Framework: Creating FileLifeManager to manage lifetime of file " + file.toString());
        }
        this.openFiles = new ArrayList();
    }

    public RandomAccessFile createRandomAccessFile() throws IOException {
        RandomAccessFile openFile = new RandomAccessFile(this.file, "r");
        this.openFiles.add(openFile);
        return openFile;
    }

    private File getFile() {
        return this.file;
    }

    public boolean doesMatch(String filename) throws IOException {
        File otherFile = new File(filename).getCanonicalFile();
        String thisFilename = this.file.toString();
        String otherFilename = otherFile.toString();
        return this.file.equals(otherFile);
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    public void finalize() {
        if (this.logger != null) {
            this.logger.logInfo("XML Connector Framework: FileLifeManager is deleting file " + this.file.toString());
        }
        Iterator iter = this.openFiles.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            RandomAccessFile openFile = (RandomAccessFile)o;
            try {
                openFile.close();
            }
            catch (IOException e) {
                if (this.logger == null) continue;
                this.logger.logInfo("XML Connector Framework: Unable to close file " + this.file.toString() + ".");
            }
        }
        boolean success = this.file.delete();
        if (this.logger != null) {
            this.logger.logInfo("XML Connector Framework: Delete of file " + (success ? "succeeded" : "failed"));
        }
    }
}

