/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.file;

import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.Executor;
import com.metamatrix.connector.xml.base.NamedDocumentExecutor;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.SAXFilterProvider;
import com.metamatrix.connector.xml.base.StreamProducer;
import com.metamatrix.connector.xml.base.XMLConnectorState;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.base.XMLExecution;
import com.metamatrix.connector.xml.file.FileConnectorState;
import com.metamatrix.connector.xml.file.Messages;
import com.metamatrix.data.exception.ConnectorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class FileExecutor
extends Executor
implements StreamProducer,
NamedDocumentExecutor {
    public static final String PARM_FILE_NAME_TABLE_PROPERTY_NAME = "FileName";
    private String[] m_docs;
    private String m_directory;

    public FileExecutor(FileConnectorState state, XMLExecution execution) {
        super((XMLConnectorState)state, execution);
    }

    public void validate() throws ConnectorException {
        super.validate();
        this.validateParams();
        String tableFileName = this.getTableFileName();
        FileConnectorState state = (FileConnectorState)this.getState();
        String xmlFileName = state.getFileName();
        if (tableFileName != null && tableFileName.trim().length() == 0) {
            tableFileName = null;
        }
        if (xmlFileName.trim().length() == 0) {
            xmlFileName = null;
        }
        String xmlFileDir = state.getDirectoryPath();
        this.m_directory = this.normalizePath(xmlFileDir);
        if (tableFileName == null && xmlFileName == null) {
            this.validateDirectory();
        } else {
            this.validateFile(tableFileName, xmlFileName, xmlFileDir);
        }
    }

    private String getTableFileName() {
        String retval = this.getExecutionInfo().getLocation();
        if (retval == null) {
            retval = this.getExecutionInfo().getOtherProperties().getProperty(PARM_FILE_NAME_TABLE_PROPERTY_NAME);
        }
        return retval;
    }

    private String normalizePath(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return new String(path + File.separator);
    }

    private void validateParams() throws ConnectorException {
        for (int i = 0; i < this.getExecutionInfo().getRequestedColumns().size(); ++i) {
            OutputXPathDesc xPath = (OutputXPathDesc)this.getExecutionInfo().getRequestedColumns().get(i);
            if (!xPath.isParameter()) continue;
            throw new ConnectorException(Messages.getString((String)"FileExecutor.input.not.supported.on.files"));
        }
    }

    private void validateDirectory() throws ConnectorException {
        File dirFile = new File(this.m_directory);
        String[] files = dirFile.list();
        ArrayList<String> xmlFiles = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            boolean valid = this.validateFile(files[i], this.m_directory, true);
            if (!valid) continue;
            xmlFiles.add(files[i]);
        }
        files = new String[xmlFiles.size()];
        xmlFiles.toArray(files);
        this.m_docs = files;
        if (this.m_docs.length <= 0) {
            throw new ConnectorException(Messages.getString((String)"FileExecutor.empty.directory"));
        }
    }

    private boolean validateFile(String fileName, String directory, boolean validateExtension) {
        boolean result = false;
        String myXmlFileName = this.normalizePath(directory) + fileName;
        File xmlFile = new File(myXmlFileName);
        if (xmlFile.isFile()) {
            if (validateExtension) {
                if (myXmlFileName.toLowerCase().endsWith(".xml")) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private void validateFile(String tableFileName, String xmlFileName, String xmlFileDir) throws ConnectorException {
        this.m_docs = new String[1];
        this.m_docs[0] = tableFileName == null ? xmlFileName : tableFileName;
        boolean valid = this.validateFile(this.m_docs[0], xmlFileDir, false);
        if (!valid) {
            throw new ConnectorException(Messages.getString((String)"FileExecutor.not.file"));
        }
    }

    public int getDocumentCount() throws ConnectorException {
        return this.m_docs.length;
    }

    public String getCacheKey(int i) throws ConnectorException {
        String myXmlFileName = this.m_directory + this.m_docs[i];
        return myXmlFileName;
    }

    public InputStream getDocumentStream(int i) throws ConnectorException {
        try {
            String xmlFileName = this.m_directory + this.m_docs[i];
            File xmlFile = new File(xmlFileName);
            this.getLogger().logDetail("XML Connector Framework: retrieving document from " + xmlFileName);
            FileInputStream retval = new FileInputStream(xmlFile);
            this.getLogger().logDetail("XML Connector Framework: retrieved file " + xmlFileName);
            return retval;
        }
        catch (IOException ioe) {
            throw new ConnectorException((Throwable)ioe);
        }
    }

    public void releaseDocumentStream(int i) throws ConnectorException {
    }

    public String getDocumentName(int i) throws ConnectorException {
        return this.m_docs[i];
    }

    protected Serializable getRequestObject(int i) throws ConnectorException {
        return this.m_docs[i];
    }

    protected XMLDocument recreateDocument(Serializable requestObject) throws ConnectorException {
        String request = (String)((Object)requestObject);
        XMLDocument doc = null;
        try {
            String xmlFileName = request;
            File xmlFile = new File(xmlFileName);
            this.getLogger().logDetail("XML Connector Framework: retrieving document from " + xmlFileName);
            FileInputStream retval = new FileInputStream(xmlFile);
            this.getLogger().logDetail("XML Connector Framework: retrieved file " + xmlFileName);
            SAXFilterProvider provider = null;
            try {
                provider = (SAXFilterProvider)Class.forName(this.getState().getSaxProviderClass()).newInstance();
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e);
            }
            InputStream filteredStream = this.addStreamFilters(retval, this.getLogger());
            DocumentInfo info = this.getExtractor().createDocumentFromStream(filteredStream, request, provider);
            doc = new XMLDocument();
            doc.setContextRoot((Object)info.m_domDoc);
            doc.setExternalFiles(info.m_externalFiles);
        }
        catch (IOException ioe) {
            throw new ConnectorException((Throwable)ioe);
        }
        return doc;
    }
}

