/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.commons.cache.DocumentCache;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.DocumentProducer;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.Executor;
import com.metamatrix.connector.xml.base.JDomProducer;
import com.metamatrix.connector.xml.base.LargeOrSmallString;
import com.metamatrix.connector.xml.base.LargeTextExtractingXmlFilter;
import com.metamatrix.connector.xml.base.LoggingInputStreamFilter;
import com.metamatrix.connector.xml.base.NamedDocumentExecutor;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.SAXFilterProvider;
import com.metamatrix.connector.xml.base.StreamProducer;
import com.metamatrix.connector.xml.base.XMLConnectorState;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.base.XMLExecution;
import com.metamatrix.connector.xml.base.XMLExtractor;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.internal.core.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.expr.XPathExpr;
import org.jaxen.jdom.JDOMXPath;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public abstract class Executor
implements DocumentProducer {
    protected static final String NAMESPACE_PREFIX_PROPERTY_NAME = "NamespacePrefixes";
    private XMLConnectorState m_state;
    private String m_queryId;
    private XMLExecution m_execution;
    protected XMLExtractor xmlExtractor;

    protected Executor(XMLConnectorState state, XMLExecution execution) {
        this.m_state = state;
        this.m_execution = execution;
        this.m_queryId = execution.getConnection().getQueryId();
        String cacheLocation = this.m_state.getCacheLocation();
        File cacheFolder = cacheLocation == null || cacheLocation.trim().length() == 0 ? null : new File(cacheLocation);
        this.xmlExtractor = new XMLExtractor(state.getMaxInMemoryStringSize(), state.isPreprocess(), state.isLogRequestResponse(), cacheFolder, execution.getLogger());
    }

    public void validate() throws ConnectorException {
        ArrayList requestedXPathColumns = this.getExecutionInfo().getRequestedColumns();
        ArrayList parameterPairs = this.getExecutionInfo().getParameters();
        this.processOutputXPathDescs(requestedXPathColumns, parameterPairs);
    }

    public ArrayList getResult() throws ConnectorException {
        if (this.getExecutionInfo().getTableXPath() == null || this.getExecutionInfo().getTableXPath().trim().length() == 0) {
            throw new ConnectorException(Messages.getString((String)"Executor.name.in.source.required"));
        }
        Response response = this.getXMLResponse();
        XMLDocument[] docs = response.getDocuments();
        if (docs == null || docs.length == 0) {
            throw new ConnectorException(Messages.getString((String)"Executor.xml.docs.not.found"));
        }
        ArrayList resultData = new ArrayList(this.m_execution.getInfo().getRequestedColumns().size());
        for (int i = 0; i < this.m_execution.getInfo().getRequestedColumns().size(); ++i) {
            ArrayList columnData = new ArrayList();
            resultData.add(columnData);
        }
        XMLDocument xmlDocument = null;
        for (int docCtr = 0; docCtr < docs.length; ++docCtr) {
            xmlDocument = docs[docCtr];
            List groupList = this.generateGroupList(xmlDocument);
            this.processRecords(groupList, resultData, xmlDocument, response);
        }
        return resultData;
    }

    /*
     * WARNING - void declaration
     */
    public Response getXMLResponse() throws ConnectorException {
        CriteriaDesc criterion = this.getExecutionInfo().getResponseIDCriterion();
        if (null != criterion) {
            String responseid = (String)criterion.getValues().get(0);
            return new Response(this, responseid);
        }
        int documentCount = this.getDocumentCount();
        String[] cacheKeys = new String[documentCount];
        XMLDocument[] docs = new XMLDocument[documentCount];
        DocumentCache cache = this.getExecution().getConnection().getConnector().getCache();
        for (int i = 0; i < documentCount; ++i) {
            String cacheKey = this.getCacheKey(i);
            XMLDocument doc = this.cacheLookup(cache, cacheKey);
            if (doc == null) {
                void var10_11;
                DocumentInfo info;
                String documentDistinguishingId = "";
                if (documentCount > 1) {
                    documentDistinguishingId = this instanceof NamedDocumentExecutor ? ((NamedDocumentExecutor)this).getDocumentName(i) : new Integer(i).toString();
                }
                if (this instanceof StreamProducer) {
                    SAXFilterProvider provider = null;
                    try {
                        provider = (SAXFilterProvider)Class.forName(this.getState().getSaxProviderClass()).newInstance();
                    }
                    catch (Exception cnf) {
                        throw new ConnectorException((Throwable)cnf);
                    }
                    InputStream responseBody = ((StreamProducer)this).getDocumentStream(i);
                    InputStream filteredStream = this.addStreamFilters(responseBody, this.m_execution.getLogger());
                    info = this.xmlExtractor.createDocumentFromStream(filteredStream, documentDistinguishingId, provider);
                } else if (this instanceof JDomProducer) {
                    Document jdomDoc = ((JDomProducer)this).getJDomDocument(i);
                    info = this.xmlExtractor.createDocumentFromJDOM(jdomDoc, documentDistinguishingId);
                } else {
                    String message = Messages.getString((String)"Executor.unknown.document.producer");
                    message = MessageFormat.format((String)message, (Object[])new Object[]{this.getClass().toString()});
                    throw new ConnectorException(message);
                }
                Document domDoc = var10_11.m_domDoc;
                doc = new XMLDocument((Object)domDoc, var10_11.m_externalFiles);
                if (this.getState().isCacheEnabled()) {
                    cache.addToCache(cacheKey, (Object)doc, var10_11.m_memoryCacheSize);
                }
            }
            docs[i] = doc;
            cacheKeys[i] = cacheKey;
        }
        return new Response(this, docs, cacheKeys);
    }

    private XMLDocument cacheLookup(DocumentCache cache, String cacheKey) {
        Object tmpObject;
        XMLDocument doc = null;
        if (this.getState().isCacheEnabled() && (tmpObject = cache.fetchObject(cacheKey)) != null) {
            doc = (XMLDocument)tmpObject;
        }
        return doc;
    }

    protected XMLConnectorState getState() {
        return this.m_state;
    }

    protected ExecutionInfo getExecutionInfo() {
        return this.m_execution.getInfo();
    }

    private void processRecords(List groupList, ArrayList resultData, XMLDocument xmlDocument, Response response) throws ConnectorException {
        Iterator groupNodeIterator = groupList.iterator();
        ArrayList requestedColumns = this.m_execution.getInfo().getRequestedColumns();
        ArrayList xpaths = this.generateXPaths(requestedColumns);
        while (groupNodeIterator.hasNext()) {
            Object groupNode = groupNodeIterator.next();
            Iterator requestedXPathIterator = requestedColumns.iterator();
            Iterator actualXpathIterator = xpaths.iterator();
            int colNum = 0;
            while (requestedXPathIterator.hasNext()) {
                LargeOrSmallString data;
                ArrayList columnData = (ArrayList)resultData.get(colNum);
                OutputXPathDesc columnDesc = (OutputXPathDesc)requestedXPathIterator.next();
                XPath xpath = (XPath)actualXpathIterator.next();
                if (columnDesc.isResponseId()) {
                    String r = response.getResponseId();
                    data = LargeOrSmallString.createSmallString((String)r);
                } else {
                    data = this.getColumnData(xmlDocument, columnDesc, groupNode, xpath);
                }
                columnData.add(data);
                ++colNum;
            }
        }
    }

    private ArrayList generateXPaths(ArrayList requestedColumns) throws ConnectorException {
        ArrayList<XPath> xpaths = new ArrayList<XPath>();
        OutputXPathDesc xPathDesc = null;
        try {
            Iterator iter = requestedColumns.iterator();
            while (iter.hasNext()) {
                String xpathString;
                xPathDesc = (OutputXPathDesc)iter.next();
                XPath xpath = null;
                if (!xPathDesc.isResponseId() && (xpathString = xPathDesc.getXPath()) != null) {
                    xpathString = this.relativizeAbsoluteXpath(xpathString);
                    xpath = this.createXPath(xpathString);
                }
                xpaths.add(xpath);
            }
        }
        catch (SAXPathException sex) {
            String msgRaw = Messages.getString((String)"Executor.saxpath.error.on.column");
            String msg = MessageFormat.format((String)msgRaw, (Object[])new Object[]{xPathDesc.getColumnName()});
            throw new ConnectorException((Throwable)sex, msg);
        }
        return xpaths;
    }

    private LargeOrSmallString getColumnData(XMLDocument xmlDocument, OutputXPathDesc xPath, Object groupNode, XPath colExpression) throws ConnectorException {
        String data = null;
        if (xPath.getXPath() == null) {
            data = (String)xPath.getCurrentValue();
        } else {
            Object node = null;
            try {
                node = colExpression.selectSingleNode(groupNode);
            }
            catch (JaxenException jex) {
                String msgRaw = Messages.getString((String)"Executor.jaxen.error.on.selectsinglenode");
                String msg = MessageFormat.format((String)msgRaw, (Object[])new Object[]{xPath.getColumnName()});
                throw new ConnectorException((Throwable)jex, msg);
            }
            data = this.getNodeValue(node);
        }
        LargeOrSmallString los = LargeTextExtractingXmlFilter.stringOrValueReference((String)data, (XMLDocument)xmlDocument);
        return los;
    }

    protected static String getDistinctPrefixes(Map otherNamespaces) {
        String distinctPrefix = null;
        int i = 0;
        while (distinctPrefix == null) {
            int j = i;
            String s = "";
            do {
                char digit = (char)(j % 26);
                char c = (char)(97 + digit);
                s = s + c;
            } while ((j /= 26) > 0);
            Object found = otherNamespaces.get(s);
            if (found == null) {
                distinctPrefix = s;
            }
            ++i;
        }
        return distinctPrefix;
    }

    private XPath createXPath(String xpathString) throws SAXPathException, ConnectorException {
        XPath expression;
        String namespacePrefixes = this.getNamespacePrefixes();
        String lookup = namespacePrefixes == null ? xpathString : xpathString + namespacePrefixes;
        DocumentCache statementCache = this.getExecution().getConnection().getConnector().getStatementCache();
        Object o = statementCache.fetchObject(lookup);
        if (o instanceof XPath) {
            expression = (XPath)o;
        } else {
            HashMap<String, String> otherNamespaces = new HashMap<String, String>();
            String defaultNamespace = this.getNamespaces(otherNamespaces);
            if (defaultNamespace == null) {
                expression = new JDOMXPath(xpathString);
            } else {
                XPathReader reader = XPathReaderFactory.createReader();
                DefaultNamespaceWorkaroundHander handler = new DefaultNamespaceWorkaroundHander(otherNamespaces, null);
                reader.setXPathHandler((XPathHandler)handler);
                reader.parse(xpathString);
                XPathExpr xpath = handler.getXPathExpr();
                String xpathWithPrefixes = xpath.getText();
                this.getLogger().logInfo("Rewriting XPath expression due to use of default namespace.");
                this.getLogger().logInfo("Was: \"" + xpathString + "\". ");
                this.getLogger().logInfo("Now: \"" + xpathWithPrefixes + "\". " + "");
                this.getLogger().logInfo("and adding namespace declaration xmlns:" + handler.getNonceNamespacePrefix() + "=" + defaultNamespace);
                expression = new JDOMXPath(xpathWithPrefixes);
                otherNamespaces.put(handler.getNonceNamespacePrefix(), defaultNamespace);
            }
            this.addNamespacePairs(expression, otherNamespaces);
            statementCache.addToCache(lookup, (Object)expression, lookup.length());
        }
        return expression;
    }

    private String getNodeValue(Object node) {
        String value = null;
        if (node != null) {
            if (node instanceof Attribute) {
                value = ((Attribute)node).getValue();
            } else if (node instanceof Text) {
                value = ((Text)node).getValue();
            } else if (node instanceof CDATA) {
                value = ((CDATA)node).getText();
            } else if (node instanceof Element) {
                Element elem = (Element)node;
                XMLOutputter out = new XMLOutputter();
                value = out.outputString(elem);
            } else {
                value = node.toString();
            }
        }
        return value;
    }

    private List generateGroupList(XMLDocument xmlDocument) throws ConnectorException {
        XPath groupExpression = null;
        try {
            String groupString = this.m_execution.getInfo().getTableXPath();
            groupString = this.relativizeAbsoluteXpath(groupString);
            groupExpression = this.createXPath(groupString);
        }
        catch (SAXPathException sex) {
            throw new ConnectorException((Throwable)sex, Messages.getString((String)"Executor.saxpath.error.on.group"));
        }
        List groupList = null;
        try {
            Object contextRoot = xmlDocument.getContextRoot();
            groupList = groupExpression.selectNodes(contextRoot);
        }
        catch (JaxenException jex) {
            throw new ConnectorException((Throwable)jex, Messages.getString((String)"Executor.jaxen.error.on.selectnodes"));
        }
        return groupList;
    }

    private String relativizeAbsoluteXpath(String xpath) throws ConnectorException {
        String retval;
        if (xpath.indexOf(124) != -1 && xpath.indexOf(40) == -1) {
            throw new ConnectorException(Messages.getString((String)"Executor.unsupported.compound.xpath"));
        }
        if (xpath.equals("/")) {
            retval = ".";
        } else if (xpath.startsWith("/") && !xpath.startsWith("//")) {
            retval = xpath.substring(1);
        } else if (xpath.startsWith("(")) {
            xpath = xpath.replaceAll("\\(/", "(");
            retval = xpath = xpath.replaceAll("\\|/", "|");
        } else {
            retval = xpath;
        }
        return retval;
    }

    protected String getNamespaces(Map namespacePairs) throws ConnectorException {
        String namespacePrefixes = this.getNamespacePrefixes();
        return this.getNamespaces(namespacePairs, namespacePrefixes);
    }

    private String getNamespacePrefixes() {
        String namespacePrefixes = this.getExecutionInfo().getOtherProperties().getProperty(NAMESPACE_PREFIX_PROPERTY_NAME);
        return namespacePrefixes;
    }

    protected String getNamespaces(Map namespacePairs, String namespacePrefixes) throws ConnectorException {
        if (namespacePrefixes == null || namespacePrefixes.trim().length() == 0) {
            return null;
        }
        String prefix = null;
        String uri = null;
        try {
            String xml = "<e " + namespacePrefixes + "/>";
            StringReader reader = new StringReader(xml);
            SAXBuilder builder = new SAXBuilder();
            Document domDoc = builder.build((Reader)reader);
            Element elem = domDoc.getRootElement();
            List namespaces = elem.getAdditionalNamespaces();
            Iterator iter = namespaces.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                Namespace namespace = (Namespace)o;
                prefix = namespace.getPrefix();
                uri = namespace.getURI();
                namespacePairs.put(prefix, uri);
            }
            Namespace defaultNamespace = elem.getNamespace();
            String defaultUri = defaultNamespace.getURI();
            if (defaultUri != null && defaultUri.equals("")) {
                defaultUri = null;
            }
            return defaultUri;
        }
        catch (JDOMException e) {
            String rawMsg = Messages.getString((String)"Executor.jaxen.error.on.namespace.pairs");
            Object[] objs = new Object[]{prefix, uri};
            String msg = MessageFormat.format((String)rawMsg, (Object[])objs);
            throw new ConnectorException((Throwable)e, msg);
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e, e.getMessage());
        }
    }

    protected void addNamespacePairs(XPath expression, Map namespacePairs) throws ConnectorException {
        try {
            Iterator iter = namespacePairs.keySet().iterator();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                String uri = (String)namespacePairs.get(prefix);
                expression.addNamespace(prefix, uri);
            }
        }
        catch (JaxenException e) {
            throw new ConnectorException((Throwable)e, Messages.getString((String)"Executor.jaxen.error.on.namespace.pairs"));
        }
    }

    protected abstract XMLDocument recreateDocument(Serializable var1) throws ConnectorException;

    protected abstract Serializable getRequestObject(int var1) throws ConnectorException;

    protected String getQueryId() {
        return this.m_queryId;
    }

    protected XMLExecution getExecution() {
        return this.m_execution;
    }

    protected ConnectorLogger getLogger() {
        return this.getExecution().getConnection().getConnector().getLogger();
    }

    protected XMLExtractor getExtractor() {
        return this.xmlExtractor;
    }

    public void processOutputXPathDescs(ArrayList requestedXPathColumns, ArrayList parameterPairs) throws ConnectorException {
        for (int i = 0; i < requestedXPathColumns.size(); ++i) {
            OutputXPathDesc xPath = (OutputXPathDesc)requestedXPathColumns.get(i);
            if (!xPath.isParameter() || xPath.getXPath() != null) continue;
            this.setOutputValues(parameterPairs, xPath);
        }
    }

    public boolean cannotProjectParameter(CriteriaDesc parmCriteria) {
        return false;
    }

    public void setOutputValues(ArrayList parameterPairs, OutputXPathDesc xPath) throws ConnectorException {
        int colNum = xPath.getColumnNumber();
        for (int x = 0; x < parameterPairs.size(); ++x) {
            CriteriaDesc parmCriteria = (CriteriaDesc)parameterPairs.get(x);
            if (parmCriteria.getColumnNumber() != colNum) continue;
            if (this.cannotProjectParameter(parmCriteria)) {
                throw new ConnectorException(Messages.getString((String)"HTTPExecutor.cannot.project.repeating.values"));
            }
            xPath.setCurrentValue((Object)parmCriteria.getCurrentIndexValue());
            break;
        }
    }

    public InputStream addStreamFilters(InputStream response, ConnectorLogger logger) throws ConnectorException {
        LoggingInputStreamFilter lFilter = new LoggingInputStreamFilter(response, logger);
        InputStream filter = null;
        try {
            Class<?> pluggableFilter = Class.forName(this.getState().getPluggableInputStreamFilterClass());
            Constructor<?> ctor = pluggableFilter.getConstructor(InputStream.class, ConnectorLogger.class);
            filter = (InputStream)ctor.newInstance(lFilter, logger);
        }
        catch (Exception cnf) {
            throw new ConnectorException((Throwable)cnf);
        }
        return filter;
    }

    static /* synthetic */ XMLDocument access$000(Executor x0, DocumentCache x1, String x2) {
        return x0.cacheLookup(x1, x2);
    }

    static /* synthetic */ XMLConnectorState access$100(Executor x0) {
        return x0.m_state;
    }
}

