package com.amentra.metamatrix.solr;

import java.util.Properties;

import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SingleIdentity;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.SourceConnectionFactory;
/**
 * Creates connections, in support of connection pooling.
 * @author Michael Walker
 *
 */
public class SolrConnectionFactory implements SourceConnectionFactory {
	private ConnectorEnvironment env;
	private SingleIdentity id = null;
	private Properties props;
	private ConnectorLogger logger;

	public SolrConnectionFactory(Properties props, ConnectorLogger logger) {
		this.props = props;
		this.logger = logger;
	}


	public SourceConnection createConnection(ConnectorIdentity arg0)
			throws ConnectorException {
		return new SolrConnection(logger, props);
	}

	/** 
	 * Returns a SingleIdentity, using the cached identity if one exists. 
	 * Note that per-user identities are not supported, and no attempt is made to 
	 * identity each security context separately.
	 * (non-Javadoc)
	 * @see com.metamatrix.data.pool.SourceConnectionFactory#createIdentity(com.metamatrix.data.api.SecurityContext)
	 */
	public ConnectorIdentity createIdentity(SecurityContext context)
			throws ConnectorException {
		if(id == null) {
			id = new SingleIdentity(context);
		}
		return id;
	}


	public void initialize(ConnectorEnvironment env) throws ConnectorException {
		this.env = env;
	}

	/**
	 * 
	 */
	public boolean isSingleIdentity() {
		return true;
	}

}
