// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package bigtableadmin provides access to the Cloud Bigtable Admin API.
//
// For product documentation, see: https://cloud.google.com/bigtable/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/bigtableadmin/v1"
//   ...
//   ctx := context.Background()
//   bigtableadminService, err := bigtableadmin.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   bigtableadminService, err := bigtableadmin.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   bigtableadminService, err := bigtableadmin.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package bigtableadmin // import "google.golang.org/api/bigtableadmin/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "bigtableadmin:v1"
const apiName = "bigtableadmin"
const apiVersion = "v1"
const basePath = "https://bigtableadmin.googleapis.com/"
const mtlsBasePath = "https://bigtableadmin.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

// AutoscalingLimits: Limits for the number of nodes a Cluster can
// autoscale up/down to.
type AutoscalingLimits struct {
	// MaxServeNodes: Required. Maximum number of nodes to scale up to.
	MaxServeNodes int64 `json:"maxServeNodes,omitempty"`

	// MinServeNodes: Required. Minimum number of nodes to scale down to.
	MinServeNodes int64 `json:"minServeNodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxServeNodes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxServeNodes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingLimits) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingLimits
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingTargets: The Autoscaling targets for a Cluster. These
// determine the recommended nodes.
type AutoscalingTargets struct {
	// CpuUtilizationPercent: The cpu utilization that the Autoscaler should
	// be trying to achieve. This number is on a scale from 0 (no
	// utilization) to 100 (total utilization).
	CpuUtilizationPercent int64 `json:"cpuUtilizationPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CpuUtilizationPercent") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CpuUtilizationPercent") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingTargets) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingTargets
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Backup: A backup of a Cloud Bigtable table.
type Backup struct {
	// EncryptionInfo: Output only. The encryption information for the
	// backup.
	EncryptionInfo *EncryptionInfo `json:"encryptionInfo,omitempty"`

	// EndTime: Output only. `end_time` is the time that the backup was
	// finished. The row data in the backup will be no newer than this
	// timestamp.
	EndTime string `json:"endTime,omitempty"`

	// ExpireTime: Required. The expiration time of the backup, with
	// microseconds granularity that must be at least 6 hours and at most 30
	// days from the time the request is received. Once the `expire_time`
	// has passed, Cloud Bigtable will delete the backup and free the
	// resources used by the backup.
	ExpireTime string `json:"expireTime,omitempty"`

	// Name: A globally unique identifier for the backup which cannot be
	// changed. Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}/
	// backups/_a-zA-Z0-9*` The final segment of the name must be between 1
	// and 50 characters in length. The backup is stored in the cluster
	// identified by the prefix of the backup name of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}`.
	Name string `json:"name,omitempty"`

	// SizeBytes: Output only. Size of the backup in bytes.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`

	// SourceTable: Required. Immutable. Name of the table from which this
	// backup was created. This needs to be in the same instance as the
	// backup. Values are of the form
	// `projects/{project}/instances/{instance}/tables/{source_table}`.
	SourceTable string `json:"sourceTable,omitempty"`

	// StartTime: Output only. `start_time` is the time that the backup was
	// started (i.e. approximately the time the CreateBackup request is
	// received). The row data in this backup will be no older than this
	// timestamp.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The current state of the backup.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not specified.
	//   "CREATING" - The pending backup is still being created. Operations
	// on the backup may fail with `FAILED_PRECONDITION` in this state.
	//   "READY" - The backup is complete and ready for use.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EncryptionInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EncryptionInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Backup) MarshalJSON() ([]byte, error) {
	type NoMethod Backup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackupInfo: Information about a backup.
type BackupInfo struct {
	// Backup: Output only. Name of the backup.
	Backup string `json:"backup,omitempty"`

	// EndTime: Output only. This time that the backup was finished. Row
	// data in the backup will be no newer than this timestamp.
	EndTime string `json:"endTime,omitempty"`

	// SourceTable: Output only. Name of the table the backup was created
	// from.
	SourceTable string `json:"sourceTable,omitempty"`

	// StartTime: Output only. The time that the backup was started. Row
	// data in the backup will be no older than this timestamp.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Backup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Backup") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackupInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BackupInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Cluster: A resizable group of nodes in a particular cloud location,
// capable of serving all Tables in the parent Instance.
type Cluster struct {
	// ClusterConfig: Configuration for this cluster.
	ClusterConfig *ClusterConfig `json:"clusterConfig,omitempty"`

	// DefaultStorageType: Immutable. The type of storage used by this
	// cluster to serve its parent instance's tables, unless explicitly
	// overridden.
	//
	// Possible values:
	//   "STORAGE_TYPE_UNSPECIFIED" - The user did not specify a storage
	// type.
	//   "SSD" - Flash (SSD) storage should be used.
	//   "HDD" - Magnetic drive (HDD) storage should be used.
	DefaultStorageType string `json:"defaultStorageType,omitempty"`

	// EncryptionConfig: Immutable. The encryption configuration for
	// CMEK-protected clusters.
	EncryptionConfig *EncryptionConfig `json:"encryptionConfig,omitempty"`

	// Location: Immutable. The location where this cluster's nodes and
	// storage reside. For best performance, clients should be located as
	// close as possible to this cluster. Currently only zones are
	// supported, so values should be of the form
	// `projects/{project}/locations/{zone}`.
	Location string `json:"location,omitempty"`

	// Name: The unique name of the cluster. Values are of the form
	// `projects/{project}/instances/{instance}/clusters/a-z*`.
	Name string `json:"name,omitempty"`

	// ServeNodes: The number of nodes allocated to this cluster. More nodes
	// enable higher throughput and more consistent performance.
	ServeNodes int64 `json:"serveNodes,omitempty"`

	// State: Output only. The current state of the cluster.
	//
	// Possible values:
	//   "STATE_NOT_KNOWN" - The state of the cluster could not be
	// determined.
	//   "READY" - The cluster has been successfully created and is ready to
	// serve requests.
	//   "CREATING" - The cluster is currently being created, and may be
	// destroyed if the creation process encounters an error. A cluster may
	// not be able to serve requests while being created.
	//   "RESIZING" - The cluster is currently being resized, and may revert
	// to its previous node count if the process encounters an error. A
	// cluster is still capable of serving requests while being resized, but
	// may exhibit performance as if its number of allocated nodes is
	// between the starting and requested states.
	//   "DISABLED" - The cluster has no backing nodes. The data (tables)
	// still exist, but no operations can be performed on the cluster.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClusterConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Cluster) MarshalJSON() ([]byte, error) {
	type NoMethod Cluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ClusterAutoscalingConfig: Autoscaling config for a cluster.
type ClusterAutoscalingConfig struct {
	// AutoscalingLimits: Required. Autoscaling limits for this cluster.
	AutoscalingLimits *AutoscalingLimits `json:"autoscalingLimits,omitempty"`

	// AutoscalingTargets: Required. Autoscaling targets for this cluster.
	AutoscalingTargets *AutoscalingTargets `json:"autoscalingTargets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoscalingLimits")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoscalingLimits") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ClusterAutoscalingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterAutoscalingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ClusterConfig: Configuration for a cluster.
type ClusterConfig struct {
	// ClusterAutoscalingConfig: Autoscaling configuration for this cluster.
	ClusterAutoscalingConfig *ClusterAutoscalingConfig `json:"clusterAutoscalingConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ClusterAutoscalingConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterAutoscalingConfig")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateBackupMetadata: Metadata type for the operation returned by
// CreateBackup.
type CreateBackupMetadata struct {
	// EndTime: If set, the time at which this operation finished or was
	// cancelled.
	EndTime string `json:"endTime,omitempty"`

	// Name: The name of the backup being created.
	Name string `json:"name,omitempty"`

	// SourceTable: The name of the table the backup is created from.
	SourceTable string `json:"sourceTable,omitempty"`

	// StartTime: The time at which this operation started.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateBackupMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CreateBackupMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateClusterMetadata: The metadata for the Operation returned by
// CreateCluster.
type CreateClusterMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// CreateCluster operation.
	OriginalRequest *CreateClusterRequest `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// Tables: Keys: the full `name` of each table that existed in the
	// instance when CreateCluster was first called, i.e.
	// `projects//instances//tables/`. Any table added to the instance by a
	// later API call will be created in the new cluster by that API call,
	// not this one. Values: information on how much of a table's data has
	// been copied to the newly-created cluster so far.
	Tables map[string]TableProgress `json:"tables,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateClusterMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CreateClusterMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateClusterRequest: Request message for
// BigtableInstanceAdmin.CreateCluster.
type CreateClusterRequest struct {
	// Cluster: Required. The cluster to be created. Fields marked
	// `OutputOnly` must be left blank.
	Cluster *Cluster `json:"cluster,omitempty"`

	// ClusterId: Required. The ID to be used when referring to the new
	// cluster within its instance, e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	ClusterId string `json:"clusterId,omitempty"`

	// Parent: Required. The unique name of the instance in which to create
	// the new cluster. Values are of the form
	// `projects/{project}/instances/{instance}`.
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cluster") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cluster") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateClusterRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateInstanceMetadata: The metadata for the Operation returned by
// CreateInstance.
type CreateInstanceMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// CreateInstance operation.
	OriginalRequest *CreateInstanceRequest `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateInstanceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CreateInstanceMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateInstanceRequest: Request message for
// BigtableInstanceAdmin.CreateInstance.
type CreateInstanceRequest struct {
	// Clusters: Required. The clusters to be created within the instance,
	// mapped by desired cluster ID, e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
	// marked `OutputOnly` must be left blank. Currently, at most four
	// clusters can be specified.
	Clusters map[string]Cluster `json:"clusters,omitempty"`

	// Instance: Required. The instance to create. Fields marked
	// `OutputOnly` must be left blank.
	Instance *Instance `json:"instance,omitempty"`

	// InstanceId: Required. The ID to be used when referring to the new
	// instance within its project, e.g., just `myinstance` rather than
	// `projects/myproject/instances/myinstance`.
	InstanceId string `json:"instanceId,omitempty"`

	// Parent: Required. The unique name of the project in which to create
	// the new instance. Values are of the form `projects/{project}`.
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Clusters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Clusters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateInstanceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EncryptionConfig: Cloud Key Management Service (Cloud KMS) settings
// for a CMEK-protected cluster.
type EncryptionConfig struct {
	// KmsKeyName: Describes the Cloud KMS encryption key that will be used
	// to protect the destination Bigtable cluster. The requirements for
	// this key are: 1) The Cloud Bigtable service account associated with
	// the project that contains this cluster must be granted the
	// `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only
	// regional keys can be used and the region of the CMEK key must match
	// the region of the cluster. 3) All clusters within an instance must
	// use the same CMEK key. Values are of the form
	// `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys
	// /{key}`
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KmsKeyName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EncryptionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EncryptionInfo: Encryption information for a given resource. If this
// resource is protected with customer managed encryption, the in-use
// Cloud Key Management Service (Cloud KMS) key version is specified
// along with its status.
type EncryptionInfo struct {
	// EncryptionStatus: Output only. The status of encrypt/decrypt calls on
	// underlying data for this resource. Regardless of status, the existing
	// data is always encrypted at rest.
	EncryptionStatus *Status `json:"encryptionStatus,omitempty"`

	// EncryptionType: Output only. The type of encryption used to protect
	// this resource.
	//
	// Possible values:
	//   "ENCRYPTION_TYPE_UNSPECIFIED" - Encryption type was not specified,
	// though data at rest remains encrypted.
	//   "GOOGLE_DEFAULT_ENCRYPTION" - The data backing this resource is
	// encrypted at rest with a key that is fully managed by Google. No key
	// version or status will be populated. This is the default state.
	//   "CUSTOMER_MANAGED_ENCRYPTION" - The data backing this resource is
	// encrypted at rest with a key that is managed by the customer. The
	// in-use version of the key and its status are populated for
	// CMEK-protected tables. CMEK-protected backups are pinned to the key
	// version that was in use at the time the backup was taken. This key
	// version is populated but its status is not tracked and is reported as
	// `UNKNOWN`.
	EncryptionType string `json:"encryptionType,omitempty"`

	// KmsKeyVersion: Output only. The version of the Cloud KMS key
	// specified in the parent cluster that is in use for the data
	// underlying this table.
	KmsKeyVersion string `json:"kmsKeyVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EncryptionStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EncryptionStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EncryptionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FailureTrace: Added to the error payload.
type FailureTrace struct {
	Frames []*Frame `json:"frames,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Frames") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Frames") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FailureTrace) MarshalJSON() ([]byte, error) {
	type NoMethod FailureTrace
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Frame struct {
	TargetName string `json:"targetName,omitempty"`

	WorkflowGuid string `json:"workflowGuid,omitempty"`

	ZoneId string `json:"zoneId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Frame) MarshalJSON() ([]byte, error) {
	type NoMethod Frame
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Instance: A collection of Bigtable Tables and the resources that
// serve them. All tables in an instance are served from all Clusters in
// the instance.
type Instance struct {
	// CreateTime: Output only. A server-assigned timestamp representing
	// when this Instance was created. For instances created before this
	// field was added (August 2021), this value is `seconds: 0, nanos: 1`.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Required. The descriptive name for this instance as it
	// appears in UIs. Can be changed at any time, but should be kept
	// globally unique to avoid confusion.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Required. Labels are a flexible and lightweight mechanism for
	// organizing cloud resources into groups that reflect a customer's
	// organizational needs and deployment strategies. They can be used to
	// filter resources and aggregate metrics. * Label keys must be between
	// 1 and 63 characters long and must conform to the regular expression:
	// `\p{Ll}\p{Lo}{0,62}`. * Label values must be between 0 and 63
	// characters long and must conform to the regular expression:
	// `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more than 64 labels can be
	// associated with a given resource. * Keys and values must both be
	// under 128 bytes.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: The unique name of the instance. Values are of the form
	// `projects/{project}/instances/a-z+[a-z0-9]`.
	Name string `json:"name,omitempty"`

	// State: Output only. The current state of the instance.
	//
	// Possible values:
	//   "STATE_NOT_KNOWN" - The state of the instance could not be
	// determined.
	//   "READY" - The instance has been successfully created and can serve
	// requests to its tables.
	//   "CREATING" - The instance is currently being created, and may be
	// destroyed if the creation process encounters an error.
	State string `json:"state,omitempty"`

	// Type: Required. The type of the instance. Defaults to `PRODUCTION`.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type of the instance is unspecified. If
	// set when creating an instance, a `PRODUCTION` instance will be
	// created. If set when updating an instance, the type will be left
	// unchanged.
	//   "PRODUCTION" - An instance meant for production use. `serve_nodes`
	// must be set on the cluster.
	//   "DEVELOPMENT" - DEPRECATED: Prefer PRODUCTION for all use cases, as
	// it no longer enforces a higher minimum node count than DEVELOPMENT.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Instance) MarshalJSON() ([]byte, error) {
	type NoMethod Instance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OperationProgress: Encapsulates progress related information for a
// Cloud Bigtable long running operation.
type OperationProgress struct {
	// EndTime: If set, the time at which this operation failed or was
	// completed successfully.
	EndTime string `json:"endTime,omitempty"`

	// ProgressPercent: Percent completion of the operation. Values are
	// between 0 and 100 inclusive.
	ProgressPercent int64 `json:"progressPercent,omitempty"`

	// StartTime: Time the request was received.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OperationProgress) MarshalJSON() ([]byte, error) {
	type NoMethod OperationProgress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OptimizeRestoredTableMetadata: Metadata type for the long-running
// operation used to track the progress of optimizations performed on a
// newly restored table. This long-running operation is automatically
// created by the system after the successful completion of a table
// restore, and cannot be cancelled.
type OptimizeRestoredTableMetadata struct {
	// Name: Name of the restored table being optimized.
	Name string `json:"name,omitempty"`

	// Progress: The progress of the post-restore optimizations.
	Progress *OperationProgress `json:"progress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OptimizeRestoredTableMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OptimizeRestoredTableMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PartialUpdateClusterMetadata: The metadata for the Operation returned
// by PartialUpdateCluster.
type PartialUpdateClusterMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The original request for PartialUpdateCluster.
	OriginalRequest *PartialUpdateClusterRequest `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PartialUpdateClusterMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod PartialUpdateClusterMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PartialUpdateClusterRequest: Request message for
// BigtableInstanceAdmin.PartialUpdateCluster.
type PartialUpdateClusterRequest struct {
	// Cluster: Required. The Cluster which contains the partial updates to
	// be applied, subject to the update_mask.
	Cluster *Cluster `json:"cluster,omitempty"`

	// UpdateMask: Required. The subset of Cluster fields which should be
	// replaced.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cluster") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cluster") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PartialUpdateClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PartialUpdateClusterRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PartialUpdateInstanceRequest: Request message for
// BigtableInstanceAdmin.PartialUpdateInstance.
type PartialUpdateInstanceRequest struct {
	// Instance: Required. The Instance which will (partially) replace the
	// current value.
	Instance *Instance `json:"instance,omitempty"`

	// UpdateMask: Required. The subset of Instance fields which should be
	// replaced. Must be explicitly set.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PartialUpdateInstanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PartialUpdateInstanceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RestoreTableMetadata: Metadata type for the long-running operation
// returned by RestoreTable.
type RestoreTableMetadata struct {
	BackupInfo *BackupInfo `json:"backupInfo,omitempty"`

	// Name: Name of the table being created and restored to.
	Name string `json:"name,omitempty"`

	// OptimizeTableOperationName: If exists, the name of the long-running
	// operation that will be used to track the post-restore optimization
	// process to optimize the performance of the restored table. The
	// metadata type of the long-running operation is
	// OptimizeRestoreTableMetadata. The response type is Empty. This
	// long-running operation may be automatically created by the system if
	// applicable after the RestoreTable long-running operation completes
	// successfully. This operation may not be created if the table is
	// already optimized or the restore was not successful.
	OptimizeTableOperationName string `json:"optimizeTableOperationName,omitempty"`

	// Progress: The progress of the RestoreTable operation.
	Progress *OperationProgress `json:"progress,omitempty"`

	// SourceType: The type of the restore source.
	//
	// Possible values:
	//   "RESTORE_SOURCE_TYPE_UNSPECIFIED" - No restore associated.
	//   "BACKUP" - A backup was used as the source of the restore.
	SourceType string `json:"sourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackupInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackupInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RestoreTableMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod RestoreTableMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TableProgress: Progress info for copying a table's data to the new
// cluster.
type TableProgress struct {
	// EstimatedCopiedBytes: Estimate of the number of bytes copied so far
	// for this table. This will eventually reach 'estimated_size_bytes'
	// unless the table copy is CANCELLED.
	EstimatedCopiedBytes int64 `json:"estimatedCopiedBytes,omitempty,string"`

	// EstimatedSizeBytes: Estimate of the size of the table to be copied.
	EstimatedSizeBytes int64 `json:"estimatedSizeBytes,omitempty,string"`

	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING" - The table has not yet begun copying to the new cluster.
	//   "COPYING" - The table is actively being copied to the new cluster.
	//   "COMPLETED" - The table has been fully copied to the new cluster.
	//   "CANCELLED" - The table was deleted before it finished copying to
	// the new cluster. Note that tables deleted after completion will stay
	// marked as COMPLETED, not CANCELLED.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EstimatedCopiedBytes") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EstimatedCopiedBytes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *TableProgress) MarshalJSON() ([]byte, error) {
	type NoMethod TableProgress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UndeleteTableMetadata: Metadata type for the operation returned by
// google.bigtable.admin.v2.BigtableTableAdmin.UndeleteTable.
type UndeleteTableMetadata struct {
	// EndTime: If set, the time at which this operation finished or was
	// cancelled.
	EndTime string `json:"endTime,omitempty"`

	// Name: The name of the table being restored.
	Name string `json:"name,omitempty"`

	// StartTime: The time at which this operation started.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UndeleteTableMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UndeleteTableMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateAppProfileMetadata: The metadata for the Operation returned by
// UpdateAppProfile.
type UpdateAppProfileMetadata struct {
}

// UpdateClusterMetadata: The metadata for the Operation returned by
// UpdateCluster.
type UpdateClusterMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// UpdateCluster operation.
	OriginalRequest *Cluster `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateClusterMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateClusterMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateInstanceMetadata: The metadata for the Operation returned by
// UpdateInstance.
type UpdateInstanceMetadata struct {
	// FinishTime: The time at which the operation failed or was completed
	// successfully.
	FinishTime string `json:"finishTime,omitempty"`

	// OriginalRequest: The request that prompted the initiation of this
	// UpdateInstance operation.
	OriginalRequest *PartialUpdateInstanceRequest `json:"originalRequest,omitempty"`

	// RequestTime: The time at which the original request was received.
	RequestTime string `json:"requestTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateInstanceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateInstanceMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}
