// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package locationserviceiface provides an interface to enable mocking the Amazon Location Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package locationserviceiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/locationservice"
)

// LocationServiceAPI provides an interface to enable mocking the
// locationservice.LocationService service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Location Service.
//    func myFunc(svc locationserviceiface.LocationServiceAPI) bool {
//        // Make svc.AssociateTrackerConsumer request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := locationservice.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockLocationServiceClient struct {
//        locationserviceiface.LocationServiceAPI
//    }
//    func (m *mockLocationServiceClient) AssociateTrackerConsumer(input *locationservice.AssociateTrackerConsumerInput) (*locationservice.AssociateTrackerConsumerOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockLocationServiceClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type LocationServiceAPI interface {
	AssociateTrackerConsumer(*locationservice.AssociateTrackerConsumerInput) (*locationservice.AssociateTrackerConsumerOutput, error)
	AssociateTrackerConsumerWithContext(aws.Context, *locationservice.AssociateTrackerConsumerInput, ...request.Option) (*locationservice.AssociateTrackerConsumerOutput, error)
	AssociateTrackerConsumerRequest(*locationservice.AssociateTrackerConsumerInput) (*request.Request, *locationservice.AssociateTrackerConsumerOutput)

	BatchDeleteDevicePositionHistory(*locationservice.BatchDeleteDevicePositionHistoryInput) (*locationservice.BatchDeleteDevicePositionHistoryOutput, error)
	BatchDeleteDevicePositionHistoryWithContext(aws.Context, *locationservice.BatchDeleteDevicePositionHistoryInput, ...request.Option) (*locationservice.BatchDeleteDevicePositionHistoryOutput, error)
	BatchDeleteDevicePositionHistoryRequest(*locationservice.BatchDeleteDevicePositionHistoryInput) (*request.Request, *locationservice.BatchDeleteDevicePositionHistoryOutput)

	BatchDeleteGeofence(*locationservice.BatchDeleteGeofenceInput) (*locationservice.BatchDeleteGeofenceOutput, error)
	BatchDeleteGeofenceWithContext(aws.Context, *locationservice.BatchDeleteGeofenceInput, ...request.Option) (*locationservice.BatchDeleteGeofenceOutput, error)
	BatchDeleteGeofenceRequest(*locationservice.BatchDeleteGeofenceInput) (*request.Request, *locationservice.BatchDeleteGeofenceOutput)

	BatchEvaluateGeofences(*locationservice.BatchEvaluateGeofencesInput) (*locationservice.BatchEvaluateGeofencesOutput, error)
	BatchEvaluateGeofencesWithContext(aws.Context, *locationservice.BatchEvaluateGeofencesInput, ...request.Option) (*locationservice.BatchEvaluateGeofencesOutput, error)
	BatchEvaluateGeofencesRequest(*locationservice.BatchEvaluateGeofencesInput) (*request.Request, *locationservice.BatchEvaluateGeofencesOutput)

	BatchGetDevicePosition(*locationservice.BatchGetDevicePositionInput) (*locationservice.BatchGetDevicePositionOutput, error)
	BatchGetDevicePositionWithContext(aws.Context, *locationservice.BatchGetDevicePositionInput, ...request.Option) (*locationservice.BatchGetDevicePositionOutput, error)
	BatchGetDevicePositionRequest(*locationservice.BatchGetDevicePositionInput) (*request.Request, *locationservice.BatchGetDevicePositionOutput)

	BatchPutGeofence(*locationservice.BatchPutGeofenceInput) (*locationservice.BatchPutGeofenceOutput, error)
	BatchPutGeofenceWithContext(aws.Context, *locationservice.BatchPutGeofenceInput, ...request.Option) (*locationservice.BatchPutGeofenceOutput, error)
	BatchPutGeofenceRequest(*locationservice.BatchPutGeofenceInput) (*request.Request, *locationservice.BatchPutGeofenceOutput)

	BatchUpdateDevicePosition(*locationservice.BatchUpdateDevicePositionInput) (*locationservice.BatchUpdateDevicePositionOutput, error)
	BatchUpdateDevicePositionWithContext(aws.Context, *locationservice.BatchUpdateDevicePositionInput, ...request.Option) (*locationservice.BatchUpdateDevicePositionOutput, error)
	BatchUpdateDevicePositionRequest(*locationservice.BatchUpdateDevicePositionInput) (*request.Request, *locationservice.BatchUpdateDevicePositionOutput)

	CalculateRoute(*locationservice.CalculateRouteInput) (*locationservice.CalculateRouteOutput, error)
	CalculateRouteWithContext(aws.Context, *locationservice.CalculateRouteInput, ...request.Option) (*locationservice.CalculateRouteOutput, error)
	CalculateRouteRequest(*locationservice.CalculateRouteInput) (*request.Request, *locationservice.CalculateRouteOutput)

	CreateGeofenceCollection(*locationservice.CreateGeofenceCollectionInput) (*locationservice.CreateGeofenceCollectionOutput, error)
	CreateGeofenceCollectionWithContext(aws.Context, *locationservice.CreateGeofenceCollectionInput, ...request.Option) (*locationservice.CreateGeofenceCollectionOutput, error)
	CreateGeofenceCollectionRequest(*locationservice.CreateGeofenceCollectionInput) (*request.Request, *locationservice.CreateGeofenceCollectionOutput)

	CreateMap(*locationservice.CreateMapInput) (*locationservice.CreateMapOutput, error)
	CreateMapWithContext(aws.Context, *locationservice.CreateMapInput, ...request.Option) (*locationservice.CreateMapOutput, error)
	CreateMapRequest(*locationservice.CreateMapInput) (*request.Request, *locationservice.CreateMapOutput)

	CreatePlaceIndex(*locationservice.CreatePlaceIndexInput) (*locationservice.CreatePlaceIndexOutput, error)
	CreatePlaceIndexWithContext(aws.Context, *locationservice.CreatePlaceIndexInput, ...request.Option) (*locationservice.CreatePlaceIndexOutput, error)
	CreatePlaceIndexRequest(*locationservice.CreatePlaceIndexInput) (*request.Request, *locationservice.CreatePlaceIndexOutput)

	CreateRouteCalculator(*locationservice.CreateRouteCalculatorInput) (*locationservice.CreateRouteCalculatorOutput, error)
	CreateRouteCalculatorWithContext(aws.Context, *locationservice.CreateRouteCalculatorInput, ...request.Option) (*locationservice.CreateRouteCalculatorOutput, error)
	CreateRouteCalculatorRequest(*locationservice.CreateRouteCalculatorInput) (*request.Request, *locationservice.CreateRouteCalculatorOutput)

	CreateTracker(*locationservice.CreateTrackerInput) (*locationservice.CreateTrackerOutput, error)
	CreateTrackerWithContext(aws.Context, *locationservice.CreateTrackerInput, ...request.Option) (*locationservice.CreateTrackerOutput, error)
	CreateTrackerRequest(*locationservice.CreateTrackerInput) (*request.Request, *locationservice.CreateTrackerOutput)

	DeleteGeofenceCollection(*locationservice.DeleteGeofenceCollectionInput) (*locationservice.DeleteGeofenceCollectionOutput, error)
	DeleteGeofenceCollectionWithContext(aws.Context, *locationservice.DeleteGeofenceCollectionInput, ...request.Option) (*locationservice.DeleteGeofenceCollectionOutput, error)
	DeleteGeofenceCollectionRequest(*locationservice.DeleteGeofenceCollectionInput) (*request.Request, *locationservice.DeleteGeofenceCollectionOutput)

	DeleteMap(*locationservice.DeleteMapInput) (*locationservice.DeleteMapOutput, error)
	DeleteMapWithContext(aws.Context, *locationservice.DeleteMapInput, ...request.Option) (*locationservice.DeleteMapOutput, error)
	DeleteMapRequest(*locationservice.DeleteMapInput) (*request.Request, *locationservice.DeleteMapOutput)

	DeletePlaceIndex(*locationservice.DeletePlaceIndexInput) (*locationservice.DeletePlaceIndexOutput, error)
	DeletePlaceIndexWithContext(aws.Context, *locationservice.DeletePlaceIndexInput, ...request.Option) (*locationservice.DeletePlaceIndexOutput, error)
	DeletePlaceIndexRequest(*locationservice.DeletePlaceIndexInput) (*request.Request, *locationservice.DeletePlaceIndexOutput)

	DeleteRouteCalculator(*locationservice.DeleteRouteCalculatorInput) (*locationservice.DeleteRouteCalculatorOutput, error)
	DeleteRouteCalculatorWithContext(aws.Context, *locationservice.DeleteRouteCalculatorInput, ...request.Option) (*locationservice.DeleteRouteCalculatorOutput, error)
	DeleteRouteCalculatorRequest(*locationservice.DeleteRouteCalculatorInput) (*request.Request, *locationservice.DeleteRouteCalculatorOutput)

	DeleteTracker(*locationservice.DeleteTrackerInput) (*locationservice.DeleteTrackerOutput, error)
	DeleteTrackerWithContext(aws.Context, *locationservice.DeleteTrackerInput, ...request.Option) (*locationservice.DeleteTrackerOutput, error)
	DeleteTrackerRequest(*locationservice.DeleteTrackerInput) (*request.Request, *locationservice.DeleteTrackerOutput)

	DescribeGeofenceCollection(*locationservice.DescribeGeofenceCollectionInput) (*locationservice.DescribeGeofenceCollectionOutput, error)
	DescribeGeofenceCollectionWithContext(aws.Context, *locationservice.DescribeGeofenceCollectionInput, ...request.Option) (*locationservice.DescribeGeofenceCollectionOutput, error)
	DescribeGeofenceCollectionRequest(*locationservice.DescribeGeofenceCollectionInput) (*request.Request, *locationservice.DescribeGeofenceCollectionOutput)

	DescribeMap(*locationservice.DescribeMapInput) (*locationservice.DescribeMapOutput, error)
	DescribeMapWithContext(aws.Context, *locationservice.DescribeMapInput, ...request.Option) (*locationservice.DescribeMapOutput, error)
	DescribeMapRequest(*locationservice.DescribeMapInput) (*request.Request, *locationservice.DescribeMapOutput)

	DescribePlaceIndex(*locationservice.DescribePlaceIndexInput) (*locationservice.DescribePlaceIndexOutput, error)
	DescribePlaceIndexWithContext(aws.Context, *locationservice.DescribePlaceIndexInput, ...request.Option) (*locationservice.DescribePlaceIndexOutput, error)
	DescribePlaceIndexRequest(*locationservice.DescribePlaceIndexInput) (*request.Request, *locationservice.DescribePlaceIndexOutput)

	DescribeRouteCalculator(*locationservice.DescribeRouteCalculatorInput) (*locationservice.DescribeRouteCalculatorOutput, error)
	DescribeRouteCalculatorWithContext(aws.Context, *locationservice.DescribeRouteCalculatorInput, ...request.Option) (*locationservice.DescribeRouteCalculatorOutput, error)
	DescribeRouteCalculatorRequest(*locationservice.DescribeRouteCalculatorInput) (*request.Request, *locationservice.DescribeRouteCalculatorOutput)

	DescribeTracker(*locationservice.DescribeTrackerInput) (*locationservice.DescribeTrackerOutput, error)
	DescribeTrackerWithContext(aws.Context, *locationservice.DescribeTrackerInput, ...request.Option) (*locationservice.DescribeTrackerOutput, error)
	DescribeTrackerRequest(*locationservice.DescribeTrackerInput) (*request.Request, *locationservice.DescribeTrackerOutput)

	DisassociateTrackerConsumer(*locationservice.DisassociateTrackerConsumerInput) (*locationservice.DisassociateTrackerConsumerOutput, error)
	DisassociateTrackerConsumerWithContext(aws.Context, *locationservice.DisassociateTrackerConsumerInput, ...request.Option) (*locationservice.DisassociateTrackerConsumerOutput, error)
	DisassociateTrackerConsumerRequest(*locationservice.DisassociateTrackerConsumerInput) (*request.Request, *locationservice.DisassociateTrackerConsumerOutput)

	GetDevicePosition(*locationservice.GetDevicePositionInput) (*locationservice.GetDevicePositionOutput, error)
	GetDevicePositionWithContext(aws.Context, *locationservice.GetDevicePositionInput, ...request.Option) (*locationservice.GetDevicePositionOutput, error)
	GetDevicePositionRequest(*locationservice.GetDevicePositionInput) (*request.Request, *locationservice.GetDevicePositionOutput)

	GetDevicePositionHistory(*locationservice.GetDevicePositionHistoryInput) (*locationservice.GetDevicePositionHistoryOutput, error)
	GetDevicePositionHistoryWithContext(aws.Context, *locationservice.GetDevicePositionHistoryInput, ...request.Option) (*locationservice.GetDevicePositionHistoryOutput, error)
	GetDevicePositionHistoryRequest(*locationservice.GetDevicePositionHistoryInput) (*request.Request, *locationservice.GetDevicePositionHistoryOutput)

	GetDevicePositionHistoryPages(*locationservice.GetDevicePositionHistoryInput, func(*locationservice.GetDevicePositionHistoryOutput, bool) bool) error
	GetDevicePositionHistoryPagesWithContext(aws.Context, *locationservice.GetDevicePositionHistoryInput, func(*locationservice.GetDevicePositionHistoryOutput, bool) bool, ...request.Option) error

	GetGeofence(*locationservice.GetGeofenceInput) (*locationservice.GetGeofenceOutput, error)
	GetGeofenceWithContext(aws.Context, *locationservice.GetGeofenceInput, ...request.Option) (*locationservice.GetGeofenceOutput, error)
	GetGeofenceRequest(*locationservice.GetGeofenceInput) (*request.Request, *locationservice.GetGeofenceOutput)

	GetMapGlyphs(*locationservice.GetMapGlyphsInput) (*locationservice.GetMapGlyphsOutput, error)
	GetMapGlyphsWithContext(aws.Context, *locationservice.GetMapGlyphsInput, ...request.Option) (*locationservice.GetMapGlyphsOutput, error)
	GetMapGlyphsRequest(*locationservice.GetMapGlyphsInput) (*request.Request, *locationservice.GetMapGlyphsOutput)

	GetMapSprites(*locationservice.GetMapSpritesInput) (*locationservice.GetMapSpritesOutput, error)
	GetMapSpritesWithContext(aws.Context, *locationservice.GetMapSpritesInput, ...request.Option) (*locationservice.GetMapSpritesOutput, error)
	GetMapSpritesRequest(*locationservice.GetMapSpritesInput) (*request.Request, *locationservice.GetMapSpritesOutput)

	GetMapStyleDescriptor(*locationservice.GetMapStyleDescriptorInput) (*locationservice.GetMapStyleDescriptorOutput, error)
	GetMapStyleDescriptorWithContext(aws.Context, *locationservice.GetMapStyleDescriptorInput, ...request.Option) (*locationservice.GetMapStyleDescriptorOutput, error)
	GetMapStyleDescriptorRequest(*locationservice.GetMapStyleDescriptorInput) (*request.Request, *locationservice.GetMapStyleDescriptorOutput)

	GetMapTile(*locationservice.GetMapTileInput) (*locationservice.GetMapTileOutput, error)
	GetMapTileWithContext(aws.Context, *locationservice.GetMapTileInput, ...request.Option) (*locationservice.GetMapTileOutput, error)
	GetMapTileRequest(*locationservice.GetMapTileInput) (*request.Request, *locationservice.GetMapTileOutput)

	ListDevicePositions(*locationservice.ListDevicePositionsInput) (*locationservice.ListDevicePositionsOutput, error)
	ListDevicePositionsWithContext(aws.Context, *locationservice.ListDevicePositionsInput, ...request.Option) (*locationservice.ListDevicePositionsOutput, error)
	ListDevicePositionsRequest(*locationservice.ListDevicePositionsInput) (*request.Request, *locationservice.ListDevicePositionsOutput)

	ListDevicePositionsPages(*locationservice.ListDevicePositionsInput, func(*locationservice.ListDevicePositionsOutput, bool) bool) error
	ListDevicePositionsPagesWithContext(aws.Context, *locationservice.ListDevicePositionsInput, func(*locationservice.ListDevicePositionsOutput, bool) bool, ...request.Option) error

	ListGeofenceCollections(*locationservice.ListGeofenceCollectionsInput) (*locationservice.ListGeofenceCollectionsOutput, error)
	ListGeofenceCollectionsWithContext(aws.Context, *locationservice.ListGeofenceCollectionsInput, ...request.Option) (*locationservice.ListGeofenceCollectionsOutput, error)
	ListGeofenceCollectionsRequest(*locationservice.ListGeofenceCollectionsInput) (*request.Request, *locationservice.ListGeofenceCollectionsOutput)

	ListGeofenceCollectionsPages(*locationservice.ListGeofenceCollectionsInput, func(*locationservice.ListGeofenceCollectionsOutput, bool) bool) error
	ListGeofenceCollectionsPagesWithContext(aws.Context, *locationservice.ListGeofenceCollectionsInput, func(*locationservice.ListGeofenceCollectionsOutput, bool) bool, ...request.Option) error

	ListGeofences(*locationservice.ListGeofencesInput) (*locationservice.ListGeofencesOutput, error)
	ListGeofencesWithContext(aws.Context, *locationservice.ListGeofencesInput, ...request.Option) (*locationservice.ListGeofencesOutput, error)
	ListGeofencesRequest(*locationservice.ListGeofencesInput) (*request.Request, *locationservice.ListGeofencesOutput)

	ListGeofencesPages(*locationservice.ListGeofencesInput, func(*locationservice.ListGeofencesOutput, bool) bool) error
	ListGeofencesPagesWithContext(aws.Context, *locationservice.ListGeofencesInput, func(*locationservice.ListGeofencesOutput, bool) bool, ...request.Option) error

	ListMaps(*locationservice.ListMapsInput) (*locationservice.ListMapsOutput, error)
	ListMapsWithContext(aws.Context, *locationservice.ListMapsInput, ...request.Option) (*locationservice.ListMapsOutput, error)
	ListMapsRequest(*locationservice.ListMapsInput) (*request.Request, *locationservice.ListMapsOutput)

	ListMapsPages(*locationservice.ListMapsInput, func(*locationservice.ListMapsOutput, bool) bool) error
	ListMapsPagesWithContext(aws.Context, *locationservice.ListMapsInput, func(*locationservice.ListMapsOutput, bool) bool, ...request.Option) error

	ListPlaceIndexes(*locationservice.ListPlaceIndexesInput) (*locationservice.ListPlaceIndexesOutput, error)
	ListPlaceIndexesWithContext(aws.Context, *locationservice.ListPlaceIndexesInput, ...request.Option) (*locationservice.ListPlaceIndexesOutput, error)
	ListPlaceIndexesRequest(*locationservice.ListPlaceIndexesInput) (*request.Request, *locationservice.ListPlaceIndexesOutput)

	ListPlaceIndexesPages(*locationservice.ListPlaceIndexesInput, func(*locationservice.ListPlaceIndexesOutput, bool) bool) error
	ListPlaceIndexesPagesWithContext(aws.Context, *locationservice.ListPlaceIndexesInput, func(*locationservice.ListPlaceIndexesOutput, bool) bool, ...request.Option) error

	ListRouteCalculators(*locationservice.ListRouteCalculatorsInput) (*locationservice.ListRouteCalculatorsOutput, error)
	ListRouteCalculatorsWithContext(aws.Context, *locationservice.ListRouteCalculatorsInput, ...request.Option) (*locationservice.ListRouteCalculatorsOutput, error)
	ListRouteCalculatorsRequest(*locationservice.ListRouteCalculatorsInput) (*request.Request, *locationservice.ListRouteCalculatorsOutput)

	ListRouteCalculatorsPages(*locationservice.ListRouteCalculatorsInput, func(*locationservice.ListRouteCalculatorsOutput, bool) bool) error
	ListRouteCalculatorsPagesWithContext(aws.Context, *locationservice.ListRouteCalculatorsInput, func(*locationservice.ListRouteCalculatorsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*locationservice.ListTagsForResourceInput) (*locationservice.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *locationservice.ListTagsForResourceInput, ...request.Option) (*locationservice.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*locationservice.ListTagsForResourceInput) (*request.Request, *locationservice.ListTagsForResourceOutput)

	ListTrackerConsumers(*locationservice.ListTrackerConsumersInput) (*locationservice.ListTrackerConsumersOutput, error)
	ListTrackerConsumersWithContext(aws.Context, *locationservice.ListTrackerConsumersInput, ...request.Option) (*locationservice.ListTrackerConsumersOutput, error)
	ListTrackerConsumersRequest(*locationservice.ListTrackerConsumersInput) (*request.Request, *locationservice.ListTrackerConsumersOutput)

	ListTrackerConsumersPages(*locationservice.ListTrackerConsumersInput, func(*locationservice.ListTrackerConsumersOutput, bool) bool) error
	ListTrackerConsumersPagesWithContext(aws.Context, *locationservice.ListTrackerConsumersInput, func(*locationservice.ListTrackerConsumersOutput, bool) bool, ...request.Option) error

	ListTrackers(*locationservice.ListTrackersInput) (*locationservice.ListTrackersOutput, error)
	ListTrackersWithContext(aws.Context, *locationservice.ListTrackersInput, ...request.Option) (*locationservice.ListTrackersOutput, error)
	ListTrackersRequest(*locationservice.ListTrackersInput) (*request.Request, *locationservice.ListTrackersOutput)

	ListTrackersPages(*locationservice.ListTrackersInput, func(*locationservice.ListTrackersOutput, bool) bool) error
	ListTrackersPagesWithContext(aws.Context, *locationservice.ListTrackersInput, func(*locationservice.ListTrackersOutput, bool) bool, ...request.Option) error

	PutGeofence(*locationservice.PutGeofenceInput) (*locationservice.PutGeofenceOutput, error)
	PutGeofenceWithContext(aws.Context, *locationservice.PutGeofenceInput, ...request.Option) (*locationservice.PutGeofenceOutput, error)
	PutGeofenceRequest(*locationservice.PutGeofenceInput) (*request.Request, *locationservice.PutGeofenceOutput)

	SearchPlaceIndexForPosition(*locationservice.SearchPlaceIndexForPositionInput) (*locationservice.SearchPlaceIndexForPositionOutput, error)
	SearchPlaceIndexForPositionWithContext(aws.Context, *locationservice.SearchPlaceIndexForPositionInput, ...request.Option) (*locationservice.SearchPlaceIndexForPositionOutput, error)
	SearchPlaceIndexForPositionRequest(*locationservice.SearchPlaceIndexForPositionInput) (*request.Request, *locationservice.SearchPlaceIndexForPositionOutput)

	SearchPlaceIndexForText(*locationservice.SearchPlaceIndexForTextInput) (*locationservice.SearchPlaceIndexForTextOutput, error)
	SearchPlaceIndexForTextWithContext(aws.Context, *locationservice.SearchPlaceIndexForTextInput, ...request.Option) (*locationservice.SearchPlaceIndexForTextOutput, error)
	SearchPlaceIndexForTextRequest(*locationservice.SearchPlaceIndexForTextInput) (*request.Request, *locationservice.SearchPlaceIndexForTextOutput)

	TagResource(*locationservice.TagResourceInput) (*locationservice.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *locationservice.TagResourceInput, ...request.Option) (*locationservice.TagResourceOutput, error)
	TagResourceRequest(*locationservice.TagResourceInput) (*request.Request, *locationservice.TagResourceOutput)

	UntagResource(*locationservice.UntagResourceInput) (*locationservice.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *locationservice.UntagResourceInput, ...request.Option) (*locationservice.UntagResourceOutput, error)
	UntagResourceRequest(*locationservice.UntagResourceInput) (*request.Request, *locationservice.UntagResourceOutput)
}

var _ LocationServiceAPI = (*locationservice.LocationService)(nil)
