// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/core/v3/udp_socket_config.proto

package envoy_config_core_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on UdpSocketConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *UdpSocketConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UdpSocketConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UdpSocketConfigMultiError, or nil if none found.
func (m *UdpSocketConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *UdpSocketConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetMaxRxDatagramSize(); wrapper != nil {

		if val := wrapper.GetValue(); val <= 0 || val >= 65536 {
			err := UdpSocketConfigValidationError{
				field:  "MaxRxDatagramSize",
				reason: "value must be inside range (0, 65536)",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetPreferGro()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UdpSocketConfigValidationError{
					field:  "PreferGro",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UdpSocketConfigValidationError{
					field:  "PreferGro",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPreferGro()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UdpSocketConfigValidationError{
				field:  "PreferGro",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UdpSocketConfigMultiError(errors)
	}
	return nil
}

// UdpSocketConfigMultiError is an error wrapping multiple validation errors
// returned by UdpSocketConfig.ValidateAll() if the designated constraints
// aren't met.
type UdpSocketConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UdpSocketConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UdpSocketConfigMultiError) AllErrors() []error { return m }

// UdpSocketConfigValidationError is the validation error returned by
// UdpSocketConfig.Validate if the designated constraints aren't met.
type UdpSocketConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UdpSocketConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UdpSocketConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UdpSocketConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UdpSocketConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UdpSocketConfigValidationError) ErrorName() string { return "UdpSocketConfigValidationError" }

// Error satisfies the builtin error interface
func (e UdpSocketConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUdpSocketConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UdpSocketConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UdpSocketConfigValidationError{}
