// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: contrib/envoy/extensions/filters/http/sxg/v3alpha/sxg.proto

package envoy_extensions_filters_http_sxg_v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on SXG with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *SXG) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SXG with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in SXGMultiError, or nil if none found.
func (m *SXG) ValidateAll() error {
	return m.validate(true)
}

func (m *SXG) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetCertificate()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, SXGValidationError{
					field:  "Certificate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, SXGValidationError{
					field:  "Certificate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCertificate()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SXGValidationError{
				field:  "Certificate",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPrivateKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, SXGValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, SXGValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrivateKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SXGValidationError{
				field:  "PrivateKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDuration()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, SXGValidationError{
					field:  "Duration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, SXGValidationError{
					field:  "Duration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDuration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return SXGValidationError{
				field:  "Duration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for MiRecordSize

	if utf8.RuneCountInString(m.GetCborUrl()) < 1 {
		err := SXGValidationError{
			field:  "CborUrl",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !strings.HasPrefix(m.GetCborUrl(), "/") {
		err := SXGValidationError{
			field:  "CborUrl",
			reason: "value does not have prefix \"/\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetValidityUrl()) < 1 {
		err := SXGValidationError{
			field:  "ValidityUrl",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !strings.HasPrefix(m.GetValidityUrl(), "/") {
		err := SXGValidationError{
			field:  "ValidityUrl",
			reason: "value does not have prefix \"/\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetClientCanAcceptSxgHeader() != "" {

		if !_SXG_ClientCanAcceptSxgHeader_Pattern.MatchString(m.GetClientCanAcceptSxgHeader()) {
			err := SXGValidationError{
				field:  "ClientCanAcceptSxgHeader",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetShouldEncodeSxgHeader() != "" {

		if !_SXG_ShouldEncodeSxgHeader_Pattern.MatchString(m.GetShouldEncodeSxgHeader()) {
			err := SXGValidationError{
				field:  "ShouldEncodeSxgHeader",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	for idx, item := range m.GetHeaderPrefixFilters() {
		_, _ = idx, item

		if !_SXG_HeaderPrefixFilters_Pattern.MatchString(item) {
			err := SXGValidationError{
				field:  fmt.Sprintf("HeaderPrefixFilters[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return SXGMultiError(errors)
	}
	return nil
}

// SXGMultiError is an error wrapping multiple validation errors returned by
// SXG.ValidateAll() if the designated constraints aren't met.
type SXGMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SXGMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SXGMultiError) AllErrors() []error { return m }

// SXGValidationError is the validation error returned by SXG.Validate if the
// designated constraints aren't met.
type SXGValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SXGValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SXGValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SXGValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SXGValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SXGValidationError) ErrorName() string { return "SXGValidationError" }

// Error satisfies the builtin error interface
func (e SXGValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSXG.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SXGValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SXGValidationError{}

var _SXG_ClientCanAcceptSxgHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _SXG_ShouldEncodeSxgHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _SXG_HeaderPrefixFilters_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")
