/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	cephrookiov1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephClusters implements CephClusterInterface
type FakeCephClusters struct {
	Fake *FakeCephV1
	ns   string
}

var cephclustersResource = schema.GroupVersionResource{Group: "ceph.rook.io", Version: "v1", Resource: "cephclusters"}

var cephclustersKind = schema.GroupVersionKind{Group: "ceph.rook.io", Version: "v1", Kind: "CephCluster"}

// Get takes name of the cephCluster, and returns the corresponding cephCluster object, and an error if there is any.
func (c *FakeCephClusters) Get(ctx context.Context, name string, options v1.GetOptions) (result *cephrookiov1.CephCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cephclustersResource, c.ns, name), &cephrookiov1.CephCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCluster), err
}

// List takes label and field selectors, and returns the list of CephClusters that match those selectors.
func (c *FakeCephClusters) List(ctx context.Context, opts v1.ListOptions) (result *cephrookiov1.CephClusterList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cephclustersResource, cephclustersKind, c.ns, opts), &cephrookiov1.CephClusterList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &cephrookiov1.CephClusterList{ListMeta: obj.(*cephrookiov1.CephClusterList).ListMeta}
	for _, item := range obj.(*cephrookiov1.CephClusterList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephClusters.
func (c *FakeCephClusters) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cephclustersResource, c.ns, opts))

}

// Create takes the representation of a cephCluster and creates it.  Returns the server's representation of the cephCluster, and an error, if there is any.
func (c *FakeCephClusters) Create(ctx context.Context, cephCluster *cephrookiov1.CephCluster, opts v1.CreateOptions) (result *cephrookiov1.CephCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cephclustersResource, c.ns, cephCluster), &cephrookiov1.CephCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCluster), err
}

// Update takes the representation of a cephCluster and updates it. Returns the server's representation of the cephCluster, and an error, if there is any.
func (c *FakeCephClusters) Update(ctx context.Context, cephCluster *cephrookiov1.CephCluster, opts v1.UpdateOptions) (result *cephrookiov1.CephCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cephclustersResource, c.ns, cephCluster), &cephrookiov1.CephCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCluster), err
}

// Delete takes name of the cephCluster and deletes it. Returns an error if one occurs.
func (c *FakeCephClusters) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cephclustersResource, c.ns, name), &cephrookiov1.CephCluster{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephClusters) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cephclustersResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &cephrookiov1.CephClusterList{})
	return err
}

// Patch applies the patch and returns the patched cephCluster.
func (c *FakeCephClusters) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *cephrookiov1.CephCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cephclustersResource, c.ns, name, pt, data, subresources...), &cephrookiov1.CephCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephCluster), err
}
