---
title: "operator-sdk run"
---
## operator-sdk run

Run an Operator in a variety of environments

### Synopsis

This command will run or deploy your Operator in two different modes: locally
and using OLM. These modes are controlled by setting --local and --olm run mode
flags. Each run mode has a separate set of flags that configure 'run' for that
mode. Run 'operator-sdk run --help' for more information on these flags.

Read more about the --olm run mode and configuration options here:
https://github.com/operator-framework/operator-sdk/blob/master/doc/user/olm-catalog/olm-cli.md


```
operator-sdk run [flags]
```

### Options

```
      --kubeconfig string           The file path to kubernetes configuration file. Defaults to location specified by $KUBECONFIG, or to default file rules if not set
      --namespace string            (Deprecated: use --watch-namespace instead.)The namespace where the operator watches for changes.
      --olm                         The operator to be run will be managed by OLM in a cluster. Cannot be set with another run-type flag
      --olm-namespace string        [olm only] The namespace where OLM is installed (default "olm")
      --operator-namespace string   [olm only] The namespace where operator resources are created. It must already exist in the cluster or be defined in a manifest passed to --include
      --manifests string            [olm only] Directory containing operator bundle directories and metadata
      --operator-version string     [olm only] Version of operator to deploy
      --install-mode string         [olm only] InstallMode to create OperatorGroup with. Format: InstallModeType[=ns1,ns2[, ...]]
      --include strings             [olm only] Path to Kubernetes resource manifests, ex. Role, Subscription. These supplement or override defaults generated by run/cleanup
      --timeout duration            [olm only] Time to wait for the command to complete before failing (default 2m0s)
      --local                       The operator will be run locally by building the operator binary with the ability to access a kubernetes cluster using a kubeconfig file. Cannot be set with another run-type flag.
      --watch-namespace string      [local only] The namespace where the operator watches for changes. Set "" for AllNamespaces, set "ns1,ns2" for MultiNamespace
      --operator-flags string       [local only] The flags that the operator needs. Example: "--flag1 value1 --flag2=value2"
      --go-ldflags string           [local only] Set Go linker options
      --enable-delve                [local only] Start the operator using the delve debugger
  -h, --help                        help for run
```

### SEE ALSO

* [operator-sdk](../operator-sdk)	 - An SDK for building operators with ease

