//*
// LVMd manages logical volumes of an LVM volume group.
//
// The protocol consists of two services:
// - VGService provides information of the volume group.
// - LVService provides management functions for logical volumes on the volume group.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.15.0
// source: lvmd/proto/lvmd.proto

package proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Empty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Empty) Reset() {
	*x = Empty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{0}
}

// Represents a logical volume.
type LogicalVolume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                          // The logical volume name.
	SizeGb   uint64   `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`       // Volume size in GiB.
	DevMajor uint32   `protobuf:"varint,3,opt,name=dev_major,json=devMajor,proto3" json:"dev_major,omitempty"` // Device major number.
	DevMinor uint32   `protobuf:"varint,4,opt,name=dev_minor,json=devMinor,proto3" json:"dev_minor,omitempty"` // Device minor number.
	Tags     []string `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`                          // Tags to add to the volume during creation
}

func (x *LogicalVolume) Reset() {
	*x = LogicalVolume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalVolume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalVolume) ProtoMessage() {}

func (x *LogicalVolume) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalVolume.ProtoReflect.Descriptor instead.
func (*LogicalVolume) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{1}
}

func (x *LogicalVolume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LogicalVolume) GetSizeGb() uint64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *LogicalVolume) GetDevMajor() uint32 {
	if x != nil {
		return x.DevMajor
	}
	return 0
}

func (x *LogicalVolume) GetDevMinor() uint32 {
	if x != nil {
		return x.DevMinor
	}
	return 0
}

func (x *LogicalVolume) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// Represents the input for CreateLV.
type CreateLVRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                    // The logical volume name.
	SizeGb      uint64   `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"` // Volume size in GiB.
	Tags        []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`                    // Tags to add to the volume during creation
	DeviceClass string   `protobuf:"bytes,4,opt,name=device_class,json=deviceClass,proto3" json:"device_class,omitempty"`
}

func (x *CreateLVRequest) Reset() {
	*x = CreateLVRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateLVRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLVRequest) ProtoMessage() {}

func (x *CreateLVRequest) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLVRequest.ProtoReflect.Descriptor instead.
func (*CreateLVRequest) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{2}
}

func (x *CreateLVRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateLVRequest) GetSizeGb() uint64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *CreateLVRequest) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *CreateLVRequest) GetDeviceClass() string {
	if x != nil {
		return x.DeviceClass
	}
	return ""
}

// Represents the response of CreateLV.
type CreateLVResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Volume *LogicalVolume `protobuf:"bytes,1,opt,name=volume,proto3" json:"volume,omitempty"` // Information of the created volume.
}

func (x *CreateLVResponse) Reset() {
	*x = CreateLVResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateLVResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLVResponse) ProtoMessage() {}

func (x *CreateLVResponse) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLVResponse.ProtoReflect.Descriptor instead.
func (*CreateLVResponse) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{3}
}

func (x *CreateLVResponse) GetVolume() *LogicalVolume {
	if x != nil {
		return x.Volume
	}
	return nil
}

// Represents the input for RemoveLV.
type RemoveLVRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"` // The logical volume name.
	DeviceClass string `protobuf:"bytes,2,opt,name=device_class,json=deviceClass,proto3" json:"device_class,omitempty"`
}

func (x *RemoveLVRequest) Reset() {
	*x = RemoveLVRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveLVRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveLVRequest) ProtoMessage() {}

func (x *RemoveLVRequest) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveLVRequest.ProtoReflect.Descriptor instead.
func (*RemoveLVRequest) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{4}
}

func (x *RemoveLVRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RemoveLVRequest) GetDeviceClass() string {
	if x != nil {
		return x.DeviceClass
	}
	return ""
}

// Represents the input for ResizeLV.
//
// The volume must already exist.
// The volume size will be set to exactly "size_gb".
type ResizeLVRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                    // The logical volume name.
	SizeGb      uint64 `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"` // Volume size in GiB.
	DeviceClass string `protobuf:"bytes,3,opt,name=device_class,json=deviceClass,proto3" json:"device_class,omitempty"`
}

func (x *ResizeLVRequest) Reset() {
	*x = ResizeLVRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResizeLVRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResizeLVRequest) ProtoMessage() {}

func (x *ResizeLVRequest) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResizeLVRequest.ProtoReflect.Descriptor instead.
func (*ResizeLVRequest) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{5}
}

func (x *ResizeLVRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResizeLVRequest) GetSizeGb() uint64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *ResizeLVRequest) GetDeviceClass() string {
	if x != nil {
		return x.DeviceClass
	}
	return ""
}

// Represents the response of GetLVList.
type GetLVListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Volumes []*LogicalVolume `protobuf:"bytes,1,rep,name=volumes,proto3" json:"volumes,omitempty"` // Information of volumes.
}

func (x *GetLVListResponse) Reset() {
	*x = GetLVListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLVListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLVListResponse) ProtoMessage() {}

func (x *GetLVListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLVListResponse.ProtoReflect.Descriptor instead.
func (*GetLVListResponse) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{6}
}

func (x *GetLVListResponse) GetVolumes() []*LogicalVolume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

// Represents the response of GetFreeBytes.
type GetFreeBytesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FreeBytes uint64 `protobuf:"varint,1,opt,name=free_bytes,json=freeBytes,proto3" json:"free_bytes,omitempty"` // Free space of the volume group in bytes.
}

func (x *GetFreeBytesResponse) Reset() {
	*x = GetFreeBytesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFreeBytesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFreeBytesResponse) ProtoMessage() {}

func (x *GetFreeBytesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFreeBytesResponse.ProtoReflect.Descriptor instead.
func (*GetFreeBytesResponse) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{7}
}

func (x *GetFreeBytesResponse) GetFreeBytes() uint64 {
	if x != nil {
		return x.FreeBytes
	}
	return 0
}

type GetLVListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DeviceClass string `protobuf:"bytes,1,opt,name=device_class,json=deviceClass,proto3" json:"device_class,omitempty"`
}

func (x *GetLVListRequest) Reset() {
	*x = GetLVListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLVListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLVListRequest) ProtoMessage() {}

func (x *GetLVListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLVListRequest.ProtoReflect.Descriptor instead.
func (*GetLVListRequest) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{8}
}

func (x *GetLVListRequest) GetDeviceClass() string {
	if x != nil {
		return x.DeviceClass
	}
	return ""
}

type GetFreeBytesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DeviceClass string `protobuf:"bytes,1,opt,name=device_class,json=deviceClass,proto3" json:"device_class,omitempty"`
}

func (x *GetFreeBytesRequest) Reset() {
	*x = GetFreeBytesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFreeBytesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFreeBytesRequest) ProtoMessage() {}

func (x *GetFreeBytesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFreeBytesRequest.ProtoReflect.Descriptor instead.
func (*GetFreeBytesRequest) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{9}
}

func (x *GetFreeBytesRequest) GetDeviceClass() string {
	if x != nil {
		return x.DeviceClass
	}
	return ""
}

// Represents the stream output from Watch.
type WatchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FreeBytes uint64       `protobuf:"varint,1,opt,name=free_bytes,json=freeBytes,proto3" json:"free_bytes,omitempty"` // Free space of the default volume group in bytes.
	Items     []*WatchItem `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *WatchResponse) Reset() {
	*x = WatchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchResponse) ProtoMessage() {}

func (x *WatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchResponse.ProtoReflect.Descriptor instead.
func (*WatchResponse) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{10}
}

func (x *WatchResponse) GetFreeBytes() uint64 {
	if x != nil {
		return x.FreeBytes
	}
	return 0
}

func (x *WatchResponse) GetItems() []*WatchItem {
	if x != nil {
		return x.Items
	}
	return nil
}

type WatchItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FreeBytes   uint64 `protobuf:"varint,1,opt,name=free_bytes,json=freeBytes,proto3" json:"free_bytes,omitempty"` // Free space of the volume group in bytes.
	DeviceClass string `protobuf:"bytes,2,opt,name=device_class,json=deviceClass,proto3" json:"device_class,omitempty"`
	SizeBytes   uint64 `protobuf:"varint,3,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"` // Size of the volume group in bytes.
}

func (x *WatchItem) Reset() {
	*x = WatchItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_lvmd_proto_lvmd_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WatchItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchItem) ProtoMessage() {}

func (x *WatchItem) ProtoReflect() protoreflect.Message {
	mi := &file_lvmd_proto_lvmd_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchItem.ProtoReflect.Descriptor instead.
func (*WatchItem) Descriptor() ([]byte, []int) {
	return file_lvmd_proto_lvmd_proto_rawDescGZIP(), []int{11}
}

func (x *WatchItem) GetFreeBytes() uint64 {
	if x != nil {
		return x.FreeBytes
	}
	return 0
}

func (x *WatchItem) GetDeviceClass() string {
	if x != nil {
		return x.DeviceClass
	}
	return ""
}

func (x *WatchItem) GetSizeBytes() uint64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

var File_lvmd_proto_lvmd_proto protoreflect.FileDescriptor

var file_lvmd_proto_lvmd_proto_rawDesc = []byte{
	0x0a, 0x15, 0x6c, 0x76, 0x6d, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6c, 0x76, 0x6d,
	0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x07,
	0x0a, 0x05, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x8a, 0x01, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x69,
	0x63, 0x61, 0x6c, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06,
	0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x5f, 0x6d, 0x61,
	0x6a, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x64, 0x65, 0x76, 0x4d, 0x61,
	0x6a, 0x6f, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x5f, 0x6d, 0x69, 0x6e, 0x6f, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x64, 0x65, 0x76, 0x4d, 0x69, 0x6e, 0x6f, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x22, 0x75, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x56,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x73, 0x69,
	0x7a, 0x65, 0x47, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x40, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x56, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x2c, 0x0a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x22, 0x48, 0x0a,
	0x0f, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4c, 0x56, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6c, 0x61, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x61, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x4c, 0x56, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x43, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x4c, 0x56, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x2e, 0x0a, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x22,
	0x35, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x46, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x72, 0x65, 0x65, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72, 0x65,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x35, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4c, 0x56, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x38, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x46, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6c, 0x61, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x56, 0x0a, 0x0d, 0x57, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x72, 0x65, 0x65,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x66, 0x72,
	0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x57,
	0x61, 0x74, 0x63, 0x68, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22,
	0x6c, 0x0a, 0x09, 0x57, 0x61, 0x74, 0x63, 0x68, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x1d, 0x0a, 0x0a,
	0x66, 0x72, 0x65, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x09, 0x66, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x1d,
	0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x32, 0xac, 0x01,
	0x0a, 0x09, 0x4c, 0x56, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x56, 0x12, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x56, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x17, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x56,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x08, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x4c, 0x56, 0x12, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x4c, 0x56, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x0c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x30, 0x0a, 0x08, 0x52, 0x65,
	0x73, 0x69, 0x7a, 0x65, 0x4c, 0x56, 0x12, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x52,
	0x65, 0x73, 0x69, 0x7a, 0x65, 0x4c, 0x56, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x0c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x32, 0xc3, 0x01, 0x0a,
	0x09, 0x56, 0x47, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x09, 0x47, 0x65,
	0x74, 0x4c, 0x56, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x17, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x47, 0x65, 0x74, 0x4c, 0x56, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x56, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x47, 0x65,
	0x74, 0x46, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1a, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x47,
	0x65, 0x74, 0x46, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x57, 0x61, 0x74, 0x63, 0x68, 0x12, 0x0c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x14, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x57, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x30, 0x01, 0x42, 0x27, 0x5a, 0x25, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x76, 0x6d, 0x2f, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x76, 0x6d,
	0x2f, 0x6c, 0x76, 0x6d, 0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_lvmd_proto_lvmd_proto_rawDescOnce sync.Once
	file_lvmd_proto_lvmd_proto_rawDescData = file_lvmd_proto_lvmd_proto_rawDesc
)

func file_lvmd_proto_lvmd_proto_rawDescGZIP() []byte {
	file_lvmd_proto_lvmd_proto_rawDescOnce.Do(func() {
		file_lvmd_proto_lvmd_proto_rawDescData = protoimpl.X.CompressGZIP(file_lvmd_proto_lvmd_proto_rawDescData)
	})
	return file_lvmd_proto_lvmd_proto_rawDescData
}

var file_lvmd_proto_lvmd_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_lvmd_proto_lvmd_proto_goTypes = []interface{}{
	(*Empty)(nil),                // 0: proto.Empty
	(*LogicalVolume)(nil),        // 1: proto.LogicalVolume
	(*CreateLVRequest)(nil),      // 2: proto.CreateLVRequest
	(*CreateLVResponse)(nil),     // 3: proto.CreateLVResponse
	(*RemoveLVRequest)(nil),      // 4: proto.RemoveLVRequest
	(*ResizeLVRequest)(nil),      // 5: proto.ResizeLVRequest
	(*GetLVListResponse)(nil),    // 6: proto.GetLVListResponse
	(*GetFreeBytesResponse)(nil), // 7: proto.GetFreeBytesResponse
	(*GetLVListRequest)(nil),     // 8: proto.GetLVListRequest
	(*GetFreeBytesRequest)(nil),  // 9: proto.GetFreeBytesRequest
	(*WatchResponse)(nil),        // 10: proto.WatchResponse
	(*WatchItem)(nil),            // 11: proto.WatchItem
}
var file_lvmd_proto_lvmd_proto_depIdxs = []int32{
	1,  // 0: proto.CreateLVResponse.volume:type_name -> proto.LogicalVolume
	1,  // 1: proto.GetLVListResponse.volumes:type_name -> proto.LogicalVolume
	11, // 2: proto.WatchResponse.items:type_name -> proto.WatchItem
	2,  // 3: proto.LVService.CreateLV:input_type -> proto.CreateLVRequest
	4,  // 4: proto.LVService.RemoveLV:input_type -> proto.RemoveLVRequest
	5,  // 5: proto.LVService.ResizeLV:input_type -> proto.ResizeLVRequest
	8,  // 6: proto.VGService.GetLVList:input_type -> proto.GetLVListRequest
	9,  // 7: proto.VGService.GetFreeBytes:input_type -> proto.GetFreeBytesRequest
	0,  // 8: proto.VGService.Watch:input_type -> proto.Empty
	3,  // 9: proto.LVService.CreateLV:output_type -> proto.CreateLVResponse
	0,  // 10: proto.LVService.RemoveLV:output_type -> proto.Empty
	0,  // 11: proto.LVService.ResizeLV:output_type -> proto.Empty
	6,  // 12: proto.VGService.GetLVList:output_type -> proto.GetLVListResponse
	7,  // 13: proto.VGService.GetFreeBytes:output_type -> proto.GetFreeBytesResponse
	10, // 14: proto.VGService.Watch:output_type -> proto.WatchResponse
	9,  // [9:15] is the sub-list for method output_type
	3,  // [3:9] is the sub-list for method input_type
	3,  // [3:3] is the sub-list for extension type_name
	3,  // [3:3] is the sub-list for extension extendee
	0,  // [0:3] is the sub-list for field type_name
}

func init() { file_lvmd_proto_lvmd_proto_init() }
func file_lvmd_proto_lvmd_proto_init() {
	if File_lvmd_proto_lvmd_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_lvmd_proto_lvmd_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Empty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalVolume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateLVRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateLVResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveLVRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResizeLVRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLVListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFreeBytesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLVListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFreeBytesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WatchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_lvmd_proto_lvmd_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WatchItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_lvmd_proto_lvmd_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_lvmd_proto_lvmd_proto_goTypes,
		DependencyIndexes: file_lvmd_proto_lvmd_proto_depIdxs,
		MessageInfos:      file_lvmd_proto_lvmd_proto_msgTypes,
	}.Build()
	File_lvmd_proto_lvmd_proto = out.File
	file_lvmd_proto_lvmd_proto_rawDesc = nil
	file_lvmd_proto_lvmd_proto_goTypes = nil
	file_lvmd_proto_lvmd_proto_depIdxs = nil
}
