/// <reference types="react" />
import { UseK8sWatchResource, UseK8sWatchResources, ConsoleFetch, ConsoleFetchJSON, ConsoleFetchText, HorizontalNavProps, UseResolvedExtensions } from '../extensions/console-types';
export declare const useK8sWatchResource: UseK8sWatchResource;
export declare const useK8sWatchResources: UseK8sWatchResources;
export declare const useResolvedExtensions: UseResolvedExtensions;
export declare const consoleFetch: ConsoleFetch;
export declare const consoleFetchJSON: ConsoleFetchJSON;
export declare const consoleFetchText: ConsoleFetchText;
/**
 * A component that creates a Navigation bar. It takes array of NavPage objects and renderes a NavBar.
 * Routing is handled as part of the component.
 * @example
 * const HomePage: React.FC = (props) => {
 *     const page = {
 *       href: '/home',
 *       name: 'Home',
 *       component: () => <>Home</>
 *     }
 *     return <HorizontalNav match={props.match} pages={[page]} />
 * }
 *
 * @param {object=} resource - The resource associated with this Navigation, an object of K8sResourceCommon type
 * @param {NavPage[]} pages - An array of page objects
 * @param {object} match - match object provided by React Router
 */
export declare const HorizontalNav: React.FC<HorizontalNavProps>;
