/// <reference types="react" />
/// <reference types="console" />
import { ExtensionK8sModel } from '../api/common-types';
import { CodeRef, Extension, ExtensionDeclaration } from '../types';
/** Properties of custom CreateResource component. */
export declare type CreateResourceComponentProps = {
    namespace?: string;
};
export declare type CreateResource = ExtensionDeclaration<'console.resource/create', {
    /** The model for which this create resource page will be rendered. */
    model: ExtensionK8sModel;
    /** The component to be rendered when the model matches */
    component: CodeRef<React.ComponentType<CreateResourceComponentProps>>;
}>;
export declare const isCreateResource: (e: Extension<any>) => e is ExtensionDeclaration<"console.resource/create", {
    /** The model for which this create resource page will be rendered. */
    model: ExtensionK8sModel;
    /** The component to be rendered when the model matches */
    component: CodeRef<import("react").ComponentType<CreateResourceComponentProps>>;
}>;
