export { ResolvedExtension } from '../types';
export declare type ExtensionHook<T, R = any> = (options: R) => ExtensionHookResult<T>;
export declare type ExtensionHookResult<T> = [T, boolean, any];
export declare type ExtensionK8sModel = {
    group: string;
    version: string;
    kind: string;
};
export declare type ExtensionK8sGroupModel = {
    group: string;
    version?: string;
    kind?: string;
};
export declare type ExtensionK8sGroupKindModel = {
    group: string;
    version?: string;
    kind: string;
};
export declare type ExtensionK8sKindVersionModel = {
    group?: string;
    version: string;
    kind: string;
};
export declare type K8sModel = {
    abbr: string;
    kind: string;
    label: string;
    labelKey?: string;
    labelPlural: string;
    labelPluralKey?: string;
    plural: string;
    propagationPolicy?: 'Foreground' | 'Background';
    id?: string;
    crd?: boolean;
    apiVersion: string;
    apiGroup?: string;
    namespaced?: boolean;
    selector?: Selector;
    labels?: {
        [key: string]: string;
    };
    annotations?: {
        [key: string]: string;
    };
    verbs?: K8sVerb[];
    shortNames?: string[];
    badge?: BadgeType;
    color?: string;
    legacyPluralURL?: boolean;
};
/**
 * @deprecated migrated to new type K8sModel, use K8sModel over K8sKind
 */
export declare type K8sKind = K8sModel;
export declare enum Operator {
    Exists = "Exists",
    DoesNotExist = "DoesNotExist",
    In = "In",
    NotIn = "NotIn",
    Equals = "Equals",
    NotEqual = "NotEqual",
    GreaterThan = "GreaterThan",
    LessThan = "LessThan",
    NotEquals = "NotEquals"
}
export declare type MatchExpression = {
    key: string;
    operator: Operator | string;
    values?: string[];
    value?: string;
};
export declare type MatchLabels = {
    [key: string]: string;
};
export declare type Selector = {
    matchLabels?: MatchLabels;
    matchExpressions?: MatchExpression[];
};
declare type K8sVerb = 'create' | 'get' | 'list' | 'update' | 'patch' | 'delete' | 'deletecollection' | 'watch';
declare enum BadgeType {
    DEV = "Dev Preview",
    TECH = "Tech Preview"
}
export declare const enum AlertStates {
    Firing = "firing",
    NotFiring = "not-firing",
    Pending = "pending",
    Silenced = "silenced"
}
export declare const enum SilenceStates {
    Active = "active",
    Expired = "expired",
    Pending = "pending"
}
export declare const enum AlertSeverity {
    Critical = "critical",
    Info = "info",
    None = "none",
    Warning = "warning"
}
export declare const enum RuleStates {
    Firing = "firing",
    Inactive = "inactive",
    Pending = "pending",
    Silenced = "silenced"
}
export declare type Silence = {
    comment: string;
    createdBy: string;
    endsAt: string;
    firingAlerts: Alert[];
    id?: string;
    matchers: {
        name: string;
        value: string;
        isRegex: boolean;
    }[];
    name?: string;
    startsAt: string;
    status?: {
        state: SilenceStates;
    };
    updatedAt?: string;
};
export declare type PrometheusAlert = {
    activeAt?: string;
    annotations: PrometheusLabels;
    labels: PrometheusLabels & {
        alertname: string;
        severity?: AlertSeverity | string;
    };
    state: AlertStates;
    value?: number | string;
};
export declare type Alert = PrometheusAlert & {
    rule: Rule;
    silencedBy?: Silence[];
};
export declare type PrometheusRule = {
    alerts: PrometheusAlert[];
    annotations: PrometheusLabels;
    duration: number;
    labels: PrometheusLabels & {
        severity?: string;
    };
    name: string;
    query: string;
    state: RuleStates;
    type: string;
};
export declare type Rule = PrometheusRule & {
    id: string;
    silencedBy?: Silence[];
};
export declare type PrometheusLabels = {
    [key: string]: string;
};
export declare type PrometheusValue = [number, string];
