import * as webpack from 'webpack';
import { ConsolePluginMetadata } from '../schema/plugin-package';
import { Extension } from '../types';
import { ValidationResult } from './ValidationResult';
declare type ExtensionCodeRefData = {
    index: number;
    propToCodeRefValue: {
        [propName: string]: string;
    };
};
declare type ExposedPluginModules = ConsolePluginMetadata['exposedModules'];
export declare const collectCodeRefData: (extensions: Extension<any>[]) => ExtensionCodeRefData[];
export declare const findWebpackModules: (compilation: webpack.Compilation, exposedModules: {
    [moduleName: string]: string;
}) => {
    [moduleName: string]: webpack.Module;
};
export declare class ExtensionValidator {
    readonly result: ValidationResult;
    constructor(description: string);
    validate(compilation: webpack.Compilation, extensions: Extension[], exposedModules: ExposedPluginModules, dataVar?: string): ValidationResult;
}
export {};
