/// <reference types="react" />
import { TFunction } from 'i18next';
import { HealthState, K8sResourceCommon, PrometheusResponse, ResourcesObject, WatchK8sResults, FirehoseResourcesResult, FirehoseResult } from './console-types';
export declare type DashboardCardSpan = 4 | 6 | 12;
export declare type GetOperatorsWithStatuses<R extends K8sResourceCommon = K8sResourceCommon> = (resources: FirehoseResourcesResult) => OperatorStatusWithResources<R>[];
export declare type K8sActivityProps<R extends K8sResourceCommon = K8sResourceCommon> = {
    resource: R;
};
export declare type OperatorRowProps<R extends K8sResourceCommon = K8sResourceCommon> = {
    operatorStatus: OperatorStatusWithResources<R>;
};
export declare type OperatorStatusWithResources<R extends K8sResourceCommon = K8sResourceCommon> = {
    operators: R[];
    status: OperatorStatusPriority;
};
export declare type OperatorStatusPriority = {
    title: string;
    priority: number;
    icon: React.ReactNode;
    health: keyof typeof HealthState;
};
export declare type PrometheusHealthHandler = (responses: {
    response: PrometheusResponse;
    error: any;
}[], t?: TFunction, additionalResource?: FirehoseResult<K8sResourceCommon | K8sResourceCommon[]>) => SubsystemHealth;
export declare type PrometheusHealthPopupProps = {
    responses: {
        response: PrometheusResponse;
        error: any;
    }[];
    k8sResult?: FirehoseResult<K8sResourceCommon | K8sResourceCommon[]>;
};
export declare type PrometheusActivityProps = {
    results: PrometheusResponse[];
};
export declare type ResourceHealthHandler<R extends ResourcesObject> = (resourcesResult: WatchK8sResults<R>, t?: TFunction) => SubsystemHealth;
export declare type SubsystemHealth = {
    message?: string;
    state: HealthState;
};
export declare type URLHealthHandler<R, T extends K8sResourceCommon | K8sResourceCommon[] = K8sResourceCommon | K8sResourceCommon[]> = (response: R, error: any, additionalResource?: FirehoseResult<T>) => SubsystemHealth;
