// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	rest "k8s.io/client-go/rest"
	v1alpha1 "open-cluster-management.io/cluster-proxy/pkg/apis/proxy/v1alpha1"
	"open-cluster-management.io/cluster-proxy/pkg/generated/clientset/versioned/scheme"
)

type ProxyV1alpha1Interface interface {
	RESTClient() rest.Interface
	ManagedProxyConfigurationsGetter
}

// ProxyV1alpha1Client is used to interact with features provided by the proxy.open-cluster-management.io group.
type ProxyV1alpha1Client struct {
	restClient rest.Interface
}

func (c *ProxyV1alpha1Client) ManagedProxyConfigurations() ManagedProxyConfigurationInterface {
	return newManagedProxyConfigurations(c)
}

// NewForConfig creates a new ProxyV1alpha1Client for the given config.
func NewForConfig(c *rest.Config) (*ProxyV1alpha1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &ProxyV1alpha1Client{client}, nil
}

// NewForConfigOrDie creates a new ProxyV1alpha1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ProxyV1alpha1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ProxyV1alpha1Client for the given RESTClient.
func New(c rest.Interface) *ProxyV1alpha1Client {
	return &ProxyV1alpha1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1alpha1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ProxyV1alpha1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
