// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.19.1
// source: envoy/config/filter/network/http_connection_manager/v2/http_connection_manager.proto

package envoy_config_filter_network_http_connection_manager_v2

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v21 "github.com/envoyproxy/go-control-plane/envoy/api/v2"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	v2 "github.com/envoyproxy/go-control-plane/envoy/config/filter/accesslog/v2"
	v23 "github.com/envoyproxy/go-control-plane/envoy/config/trace/v2"
	_type "github.com/envoyproxy/go-control-plane/envoy/type"
	v22 "github.com/envoyproxy/go-control-plane/envoy/type/tracing/v2"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type HttpConnectionManager_CodecType int32

const (
	// For every new connection, the connection manager will determine which
	// codec to use. This mode supports both ALPN for TLS listeners as well as
	// protocol inference for plaintext listeners. If ALPN data is available, it
	// is preferred, otherwise protocol inference is used. In almost all cases,
	// this is the right option to choose for this setting.
	HttpConnectionManager_AUTO HttpConnectionManager_CodecType = 0
	// The connection manager will assume that the client is speaking HTTP/1.1.
	HttpConnectionManager_HTTP1 HttpConnectionManager_CodecType = 1
	// The connection manager will assume that the client is speaking HTTP/2
	// (Envoy does not require HTTP/2 to take place over TLS or to use ALPN.
	// Prior knowledge is allowed).
	HttpConnectionManager_HTTP2 HttpConnectionManager_CodecType = 2
	// [#not-implemented-hide:] QUIC implementation is not production ready yet. Use this enum with
	// caution to prevent accidental execution of QUIC code. I.e. `!= HTTP2` is no longer sufficient
	// to distinguish HTTP1 and HTTP2 traffic.
	HttpConnectionManager_HTTP3 HttpConnectionManager_CodecType = 3
)

// Enum value maps for HttpConnectionManager_CodecType.
var (
	HttpConnectionManager_CodecType_name = map[int32]string{
		0: "AUTO",
		1: "HTTP1",
		2: "HTTP2",
		3: "HTTP3",
	}
	HttpConnectionManager_CodecType_value = map[string]int32{
		"AUTO":  0,
		"HTTP1": 1,
		"HTTP2": 2,
		"HTTP3": 3,
	}
)

func (x HttpConnectionManager_CodecType) Enum() *HttpConnectionManager_CodecType {
	p := new(HttpConnectionManager_CodecType)
	*p = x
	return p
}

func (x HttpConnectionManager_CodecType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpConnectionManager_CodecType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[0].Descriptor()
}

func (HttpConnectionManager_CodecType) Type() protoreflect.EnumType {
	return &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[0]
}

func (x HttpConnectionManager_CodecType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpConnectionManager_CodecType.Descriptor instead.
func (HttpConnectionManager_CodecType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 0}
}

type HttpConnectionManager_ServerHeaderTransformation int32

const (
	// Overwrite any Server header with the contents of server_name.
	HttpConnectionManager_OVERWRITE HttpConnectionManager_ServerHeaderTransformation = 0
	// If no Server header is present, append Server server_name
	// If a Server header is present, pass it through.
	HttpConnectionManager_APPEND_IF_ABSENT HttpConnectionManager_ServerHeaderTransformation = 1
	// Pass through the value of the server header, and do not append a header
	// if none is present.
	HttpConnectionManager_PASS_THROUGH HttpConnectionManager_ServerHeaderTransformation = 2
)

// Enum value maps for HttpConnectionManager_ServerHeaderTransformation.
var (
	HttpConnectionManager_ServerHeaderTransformation_name = map[int32]string{
		0: "OVERWRITE",
		1: "APPEND_IF_ABSENT",
		2: "PASS_THROUGH",
	}
	HttpConnectionManager_ServerHeaderTransformation_value = map[string]int32{
		"OVERWRITE":        0,
		"APPEND_IF_ABSENT": 1,
		"PASS_THROUGH":     2,
	}
)

func (x HttpConnectionManager_ServerHeaderTransformation) Enum() *HttpConnectionManager_ServerHeaderTransformation {
	p := new(HttpConnectionManager_ServerHeaderTransformation)
	*p = x
	return p
}

func (x HttpConnectionManager_ServerHeaderTransformation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpConnectionManager_ServerHeaderTransformation) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[1].Descriptor()
}

func (HttpConnectionManager_ServerHeaderTransformation) Type() protoreflect.EnumType {
	return &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[1]
}

func (x HttpConnectionManager_ServerHeaderTransformation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpConnectionManager_ServerHeaderTransformation.Descriptor instead.
func (HttpConnectionManager_ServerHeaderTransformation) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 1}
}

// How to handle the :ref:`config_http_conn_man_headers_x-forwarded-client-cert` (XFCC) HTTP
// header.
type HttpConnectionManager_ForwardClientCertDetails int32

const (
	// Do not send the XFCC header to the next hop. This is the default value.
	HttpConnectionManager_SANITIZE HttpConnectionManager_ForwardClientCertDetails = 0
	// When the client connection is mTLS (Mutual TLS), forward the XFCC header
	// in the request.
	HttpConnectionManager_FORWARD_ONLY HttpConnectionManager_ForwardClientCertDetails = 1
	// When the client connection is mTLS, append the client certificate
	// information to the request’s XFCC header and forward it.
	HttpConnectionManager_APPEND_FORWARD HttpConnectionManager_ForwardClientCertDetails = 2
	// When the client connection is mTLS, reset the XFCC header with the client
	// certificate information and send it to the next hop.
	HttpConnectionManager_SANITIZE_SET HttpConnectionManager_ForwardClientCertDetails = 3
	// Always forward the XFCC header in the request, regardless of whether the
	// client connection is mTLS.
	HttpConnectionManager_ALWAYS_FORWARD_ONLY HttpConnectionManager_ForwardClientCertDetails = 4
)

// Enum value maps for HttpConnectionManager_ForwardClientCertDetails.
var (
	HttpConnectionManager_ForwardClientCertDetails_name = map[int32]string{
		0: "SANITIZE",
		1: "FORWARD_ONLY",
		2: "APPEND_FORWARD",
		3: "SANITIZE_SET",
		4: "ALWAYS_FORWARD_ONLY",
	}
	HttpConnectionManager_ForwardClientCertDetails_value = map[string]int32{
		"SANITIZE":            0,
		"FORWARD_ONLY":        1,
		"APPEND_FORWARD":      2,
		"SANITIZE_SET":        3,
		"ALWAYS_FORWARD_ONLY": 4,
	}
)

func (x HttpConnectionManager_ForwardClientCertDetails) Enum() *HttpConnectionManager_ForwardClientCertDetails {
	p := new(HttpConnectionManager_ForwardClientCertDetails)
	*p = x
	return p
}

func (x HttpConnectionManager_ForwardClientCertDetails) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpConnectionManager_ForwardClientCertDetails) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[2].Descriptor()
}

func (HttpConnectionManager_ForwardClientCertDetails) Type() protoreflect.EnumType {
	return &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[2]
}

func (x HttpConnectionManager_ForwardClientCertDetails) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpConnectionManager_ForwardClientCertDetails.Descriptor instead.
func (HttpConnectionManager_ForwardClientCertDetails) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 2}
}

type HttpConnectionManager_Tracing_OperationName int32

const (
	// The HTTP listener is used for ingress/incoming requests.
	HttpConnectionManager_Tracing_INGRESS HttpConnectionManager_Tracing_OperationName = 0
	// The HTTP listener is used for egress/outgoing requests.
	HttpConnectionManager_Tracing_EGRESS HttpConnectionManager_Tracing_OperationName = 1
)

// Enum value maps for HttpConnectionManager_Tracing_OperationName.
var (
	HttpConnectionManager_Tracing_OperationName_name = map[int32]string{
		0: "INGRESS",
		1: "EGRESS",
	}
	HttpConnectionManager_Tracing_OperationName_value = map[string]int32{
		"INGRESS": 0,
		"EGRESS":  1,
	}
)

func (x HttpConnectionManager_Tracing_OperationName) Enum() *HttpConnectionManager_Tracing_OperationName {
	p := new(HttpConnectionManager_Tracing_OperationName)
	*p = x
	return p
}

func (x HttpConnectionManager_Tracing_OperationName) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpConnectionManager_Tracing_OperationName) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[3].Descriptor()
}

func (HttpConnectionManager_Tracing_OperationName) Type() protoreflect.EnumType {
	return &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes[3]
}

func (x HttpConnectionManager_Tracing_OperationName) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpConnectionManager_Tracing_OperationName.Descriptor instead.
func (HttpConnectionManager_Tracing_OperationName) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 0, 0}
}

// [#next-free-field: 37]
type HttpConnectionManager struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Supplies the type of codec that the connection manager should use.
	CodecType HttpConnectionManager_CodecType `protobuf:"varint,1,opt,name=codec_type,json=codecType,proto3,enum=envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_CodecType" json:"codec_type,omitempty"`
	// The human readable prefix to use when emitting statistics for the
	// connection manager. See the :ref:`statistics documentation <config_http_conn_man_stats>` for
	// more information.
	StatPrefix string `protobuf:"bytes,2,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Types that are assignable to RouteSpecifier:
	//	*HttpConnectionManager_Rds
	//	*HttpConnectionManager_RouteConfig
	//	*HttpConnectionManager_ScopedRoutes
	RouteSpecifier isHttpConnectionManager_RouteSpecifier `protobuf_oneof:"route_specifier"`
	// A list of individual HTTP filters that make up the filter chain for
	// requests made to the connection manager. :ref:`Order matters <arch_overview_http_filters_ordering>`
	// as the filters are processed sequentially as request events happen.
	HttpFilters []*HttpFilter `protobuf:"bytes,5,rep,name=http_filters,json=httpFilters,proto3" json:"http_filters,omitempty"`
	// Whether the connection manager manipulates the :ref:`config_http_conn_man_headers_user-agent`
	// and :ref:`config_http_conn_man_headers_downstream-service-cluster` headers. See the linked
	// documentation for more information. Defaults to false.
	AddUserAgent *wrappers.BoolValue `protobuf:"bytes,6,opt,name=add_user_agent,json=addUserAgent,proto3" json:"add_user_agent,omitempty"`
	// Presence of the object defines whether the connection manager
	// emits :ref:`tracing <arch_overview_tracing>` data to the :ref:`configured tracing provider
	// <envoy_api_msg_config.trace.v2.Tracing>`.
	Tracing *HttpConnectionManager_Tracing `protobuf:"bytes,7,opt,name=tracing,proto3" json:"tracing,omitempty"`
	// Additional settings for HTTP requests handled by the connection manager. These will be
	// applicable to both HTTP1 and HTTP2 requests.
	CommonHttpProtocolOptions *core.HttpProtocolOptions `protobuf:"bytes,35,opt,name=common_http_protocol_options,json=commonHttpProtocolOptions,proto3" json:"common_http_protocol_options,omitempty"`
	// Additional HTTP/1 settings that are passed to the HTTP/1 codec.
	HttpProtocolOptions *core.Http1ProtocolOptions `protobuf:"bytes,8,opt,name=http_protocol_options,json=httpProtocolOptions,proto3" json:"http_protocol_options,omitempty"`
	// Additional HTTP/2 settings that are passed directly to the HTTP/2 codec.
	Http2ProtocolOptions *core.Http2ProtocolOptions `protobuf:"bytes,9,opt,name=http2_protocol_options,json=http2ProtocolOptions,proto3" json:"http2_protocol_options,omitempty"`
	// An optional override that the connection manager will write to the server
	// header in responses. If not set, the default is *envoy*.
	ServerName string `protobuf:"bytes,10,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
	// Defines the action to be applied to the Server header on the response path.
	// By default, Envoy will overwrite the header with the value specified in
	// server_name.
	ServerHeaderTransformation HttpConnectionManager_ServerHeaderTransformation `protobuf:"varint,34,opt,name=server_header_transformation,json=serverHeaderTransformation,proto3,enum=envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_ServerHeaderTransformation" json:"server_header_transformation,omitempty"`
	// The maximum request headers size for incoming connections.
	// If unconfigured, the default max request headers allowed is 60 KiB.
	// Requests that exceed this limit will receive a 431 response.
	MaxRequestHeadersKb *wrappers.UInt32Value `protobuf:"bytes,29,opt,name=max_request_headers_kb,json=maxRequestHeadersKb,proto3" json:"max_request_headers_kb,omitempty"`
	// The idle timeout for connections managed by the connection manager. The
	// idle timeout is defined as the period in which there are no active
	// requests. If not set, there is no idle timeout. When the idle timeout is
	// reached the connection will be closed. If the connection is an HTTP/2
	// connection a drain sequence will occur prior to closing the connection.
	// This field is deprecated. Use :ref:`idle_timeout
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.common_http_protocol_options>`
	// instead.
	//
	// Deprecated: Do not use.
	IdleTimeout *duration.Duration `protobuf:"bytes,11,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// The stream idle timeout for connections managed by the connection manager.
	// If not specified, this defaults to 5 minutes. The default value was selected
	// so as not to interfere with any smaller configured timeouts that may have
	// existed in configurations prior to the introduction of this feature, while
	// introducing robustness to TCP connections that terminate without a FIN.
	//
	// This idle timeout applies to new streams and is overridable by the
	// :ref:`route-level idle_timeout
	// <envoy_api_field_route.RouteAction.idle_timeout>`. Even on a stream in
	// which the override applies, prior to receipt of the initial request
	// headers, the :ref:`stream_idle_timeout
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.stream_idle_timeout>`
	// applies. Each time an encode/decode event for headers or data is processed
	// for the stream, the timer will be reset. If the timeout fires, the stream
	// is terminated with a 408 Request Timeout error code if no upstream response
	// header has been received, otherwise a stream reset occurs.
	//
	// This timeout also specifies the amount of time that Envoy will wait for the peer to open enough
	// window to write any remaining stream data once the entirety of stream data (local end stream is
	// true) has been buffered pending available window. In other words, this timeout defends against
	// a peer that does not release enough window to completely write the stream, even though all
	// data has been proxied within available flow control windows. If the timeout is hit in this
	// case, the :ref:`tx_flush_timeout <config_http_conn_man_stats_per_codec>` counter will be
	// incremented. Note that :ref:`max_stream_duration
	// <envoy_api_field_core.HttpProtocolOptions.max_stream_duration>` does not apply to this corner
	// case.
	//
	// Note that it is possible to idle timeout even if the wire traffic for a stream is non-idle, due
	// to the granularity of events presented to the connection manager. For example, while receiving
	// very large request headers, it may be the case that there is traffic regularly arriving on the
	// wire while the connection manage is only able to observe the end-of-headers event, hence the
	// stream may still idle timeout.
	//
	// A value of 0 will completely disable the connection manager stream idle
	// timeout, although per-route idle timeout overrides will continue to apply.
	StreamIdleTimeout *duration.Duration `protobuf:"bytes,24,opt,name=stream_idle_timeout,json=streamIdleTimeout,proto3" json:"stream_idle_timeout,omitempty"`
	// The amount of time that Envoy will wait for the entire request to be received.
	// The timer is activated when the request is initiated, and is disarmed when the last byte of the
	// request is sent upstream (i.e. all decoding filters have processed the request), OR when the
	// response is initiated. If not specified or set to 0, this timeout is disabled.
	RequestTimeout *duration.Duration `protobuf:"bytes,28,opt,name=request_timeout,json=requestTimeout,proto3" json:"request_timeout,omitempty"`
	// The time that Envoy will wait between sending an HTTP/2 “shutdown
	// notification” (GOAWAY frame with max stream ID) and a final GOAWAY frame.
	// This is used so that Envoy provides a grace period for new streams that
	// race with the final GOAWAY frame. During this grace period, Envoy will
	// continue to accept new streams. After the grace period, a final GOAWAY
	// frame is sent and Envoy will start refusing new streams. Draining occurs
	// both when a connection hits the idle timeout or during general server
	// draining. The default grace period is 5000 milliseconds (5 seconds) if this
	// option is not specified.
	DrainTimeout *duration.Duration `protobuf:"bytes,12,opt,name=drain_timeout,json=drainTimeout,proto3" json:"drain_timeout,omitempty"`
	// The delayed close timeout is for downstream connections managed by the HTTP connection manager.
	// It is defined as a grace period after connection close processing has been locally initiated
	// during which Envoy will wait for the peer to close (i.e., a TCP FIN/RST is received by Envoy
	// from the downstream connection) prior to Envoy closing the socket associated with that
	// connection.
	// NOTE: This timeout is enforced even when the socket associated with the downstream connection
	// is pending a flush of the write buffer. However, any progress made writing data to the socket
	// will restart the timer associated with this timeout. This means that the total grace period for
	// a socket in this state will be
	// <total_time_waiting_for_write_buffer_flushes>+<delayed_close_timeout>.
	//
	// Delaying Envoy's connection close and giving the peer the opportunity to initiate the close
	// sequence mitigates a race condition that exists when downstream clients do not drain/process
	// data in a connection's receive buffer after a remote close has been detected via a socket
	// write(). This race leads to such clients failing to process the response code sent by Envoy,
	// which could result in erroneous downstream processing.
	//
	// If the timeout triggers, Envoy will close the connection's socket.
	//
	// The default timeout is 1000 ms if this option is not specified.
	//
	// .. NOTE::
	//    To be useful in avoiding the race condition described above, this timeout must be set
	//    to *at least* <max round trip time expected between clients and Envoy>+<100ms to account for
	//    a reasonable "worst" case processing time for a full iteration of Envoy's event loop>.
	//
	// .. WARNING::
	//    A value of 0 will completely disable delayed close processing. When disabled, the downstream
	//    connection's socket will be closed immediately after the write flush is completed or will
	//    never close if the write flush does not complete.
	DelayedCloseTimeout *duration.Duration `protobuf:"bytes,26,opt,name=delayed_close_timeout,json=delayedCloseTimeout,proto3" json:"delayed_close_timeout,omitempty"`
	// Configuration for :ref:`HTTP access logs <arch_overview_access_logs>`
	// emitted by the connection manager.
	AccessLog []*v2.AccessLog `protobuf:"bytes,13,rep,name=access_log,json=accessLog,proto3" json:"access_log,omitempty"`
	// If set to true, the connection manager will use the real remote address
	// of the client connection when determining internal versus external origin and manipulating
	// various headers. If set to false or absent, the connection manager will use the
	// :ref:`config_http_conn_man_headers_x-forwarded-for` HTTP header. See the documentation for
	// :ref:`config_http_conn_man_headers_x-forwarded-for`,
	// :ref:`config_http_conn_man_headers_x-envoy-internal`, and
	// :ref:`config_http_conn_man_headers_x-envoy-external-address` for more information.
	UseRemoteAddress *wrappers.BoolValue `protobuf:"bytes,14,opt,name=use_remote_address,json=useRemoteAddress,proto3" json:"use_remote_address,omitempty"`
	// The number of additional ingress proxy hops from the right side of the
	// :ref:`config_http_conn_man_headers_x-forwarded-for` HTTP header to trust when
	// determining the origin client's IP address. The default is zero if this option
	// is not specified. See the documentation for
	// :ref:`config_http_conn_man_headers_x-forwarded-for` for more information.
	XffNumTrustedHops uint32 `protobuf:"varint,19,opt,name=xff_num_trusted_hops,json=xffNumTrustedHops,proto3" json:"xff_num_trusted_hops,omitempty"`
	// Configures what network addresses are considered internal for stats and header sanitation
	// purposes. If unspecified, only RFC1918 IP addresses will be considered internal.
	// See the documentation for :ref:`config_http_conn_man_headers_x-envoy-internal` for more
	// information about internal/external addresses.
	InternalAddressConfig *HttpConnectionManager_InternalAddressConfig `protobuf:"bytes,25,opt,name=internal_address_config,json=internalAddressConfig,proto3" json:"internal_address_config,omitempty"`
	// If set, Envoy will not append the remote address to the
	// :ref:`config_http_conn_man_headers_x-forwarded-for` HTTP header. This may be used in
	// conjunction with HTTP filters that explicitly manipulate XFF after the HTTP connection manager
	// has mutated the request headers. While :ref:`use_remote_address
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.use_remote_address>`
	// will also suppress XFF addition, it has consequences for logging and other
	// Envoy uses of the remote address, so *skip_xff_append* should be used
	// when only an elision of XFF addition is intended.
	SkipXffAppend bool `protobuf:"varint,21,opt,name=skip_xff_append,json=skipXffAppend,proto3" json:"skip_xff_append,omitempty"`
	// Via header value to append to request and response headers. If this is
	// empty, no via header will be appended.
	Via string `protobuf:"bytes,22,opt,name=via,proto3" json:"via,omitempty"`
	// Whether the connection manager will generate the :ref:`x-request-id
	// <config_http_conn_man_headers_x-request-id>` header if it does not exist. This defaults to
	// true. Generating a random UUID4 is expensive so in high throughput scenarios where this feature
	// is not desired it can be disabled.
	GenerateRequestId *wrappers.BoolValue `protobuf:"bytes,15,opt,name=generate_request_id,json=generateRequestId,proto3" json:"generate_request_id,omitempty"`
	// Whether the connection manager will keep the :ref:`x-request-id
	// <config_http_conn_man_headers_x-request-id>` header if passed for a request that is edge
	// (Edge request is the request from external clients to front Envoy) and not reset it, which
	// is the current Envoy behaviour. This defaults to false.
	PreserveExternalRequestId bool `protobuf:"varint,32,opt,name=preserve_external_request_id,json=preserveExternalRequestId,proto3" json:"preserve_external_request_id,omitempty"`
	// How to handle the :ref:`config_http_conn_man_headers_x-forwarded-client-cert` (XFCC) HTTP
	// header.
	ForwardClientCertDetails HttpConnectionManager_ForwardClientCertDetails `protobuf:"varint,16,opt,name=forward_client_cert_details,json=forwardClientCertDetails,proto3,enum=envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_ForwardClientCertDetails" json:"forward_client_cert_details,omitempty"`
	// This field is valid only when :ref:`forward_client_cert_details
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.forward_client_cert_details>`
	// is APPEND_FORWARD or SANITIZE_SET and the client connection is mTLS. It specifies the fields in
	// the client certificate to be forwarded. Note that in the
	// :ref:`config_http_conn_man_headers_x-forwarded-client-cert` header, *Hash* is always set, and
	// *By* is always set when the client certificate presents the URI type Subject Alternative Name
	// value.
	SetCurrentClientCertDetails *HttpConnectionManager_SetCurrentClientCertDetails `protobuf:"bytes,17,opt,name=set_current_client_cert_details,json=setCurrentClientCertDetails,proto3" json:"set_current_client_cert_details,omitempty"`
	// If proxy_100_continue is true, Envoy will proxy incoming "Expect:
	// 100-continue" headers upstream, and forward "100 Continue" responses
	// downstream. If this is false or not set, Envoy will instead strip the
	// "Expect: 100-continue" header, and send a "100 Continue" response itself.
	Proxy_100Continue bool `protobuf:"varint,18,opt,name=proxy_100_continue,json=proxy100Continue,proto3" json:"proxy_100_continue,omitempty"`
	// If
	// :ref:`use_remote_address
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.use_remote_address>`
	// is true and represent_ipv4_remote_address_as_ipv4_mapped_ipv6 is true and the remote address is
	// an IPv4 address, the address will be mapped to IPv6 before it is appended to *x-forwarded-for*.
	// This is useful for testing compatibility of upstream services that parse the header value. For
	// example, 50.0.0.1 is represented as ::FFFF:50.0.0.1. See `IPv4-Mapped IPv6 Addresses
	// <https://tools.ietf.org/html/rfc4291#section-2.5.5.2>`_ for details. This will also affect the
	// :ref:`config_http_conn_man_headers_x-envoy-external-address` header. See
	// :ref:`http_connection_manager.represent_ipv4_remote_address_as_ipv4_mapped_ipv6
	// <config_http_conn_man_runtime_represent_ipv4_remote_address_as_ipv4_mapped_ipv6>` for runtime
	// control.
	// [#not-implemented-hide:]
	RepresentIpv4RemoteAddressAsIpv4MappedIpv6 bool                                   `protobuf:"varint,20,opt,name=represent_ipv4_remote_address_as_ipv4_mapped_ipv6,json=representIpv4RemoteAddressAsIpv4MappedIpv6,proto3" json:"represent_ipv4_remote_address_as_ipv4_mapped_ipv6,omitempty"`
	UpgradeConfigs                             []*HttpConnectionManager_UpgradeConfig `protobuf:"bytes,23,rep,name=upgrade_configs,json=upgradeConfigs,proto3" json:"upgrade_configs,omitempty"`
	// Should paths be normalized according to RFC 3986 before any processing of
	// requests by HTTP filters or routing? This affects the upstream *:path* header
	// as well. For paths that fail this check, Envoy will respond with 400 to
	// paths that are malformed. This defaults to false currently but will default
	// true in the future. When not specified, this value may be overridden by the
	// runtime variable
	// :ref:`http_connection_manager.normalize_path<config_http_conn_man_runtime_normalize_path>`.
	// See `Normalization and Comparison <https://tools.ietf.org/html/rfc3986#section-6>`_
	// for details of normalization.
	// Note that Envoy does not perform
	// `case normalization <https://tools.ietf.org/html/rfc3986#section-6.2.2.1>`_
	NormalizePath *wrappers.BoolValue `protobuf:"bytes,30,opt,name=normalize_path,json=normalizePath,proto3" json:"normalize_path,omitempty"`
	// Determines if adjacent slashes in the path are merged into one before any processing of
	// requests by HTTP filters or routing. This affects the upstream *:path* header as well. Without
	// setting this option, incoming requests with path `//dir///file` will not match against route
	// with `prefix` match set to `/dir`. Defaults to `false`. Note that slash merging is not part of
	// `HTTP spec <https://tools.ietf.org/html/rfc3986>`_ and is provided for convenience.
	MergeSlashes bool `protobuf:"varint,33,opt,name=merge_slashes,json=mergeSlashes,proto3" json:"merge_slashes,omitempty"`
	// The configuration of the request ID extension. This includes operations such as
	// generation, validation, and associated tracing operations.
	//
	// If not set, Envoy uses the default UUID-based behavior:
	//
	// 1. Request ID is propagated using *x-request-id* header.
	//
	// 2. Request ID is a universally unique identifier (UUID).
	//
	// 3. Tracing decision (sampled, forced, etc) is set in 14th byte of the UUID.
	RequestIdExtension *RequestIDExtension `protobuf:"bytes,36,opt,name=request_id_extension,json=requestIdExtension,proto3" json:"request_id_extension,omitempty"`
}

func (x *HttpConnectionManager) Reset() {
	*x = HttpConnectionManager{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpConnectionManager) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpConnectionManager) ProtoMessage() {}

func (x *HttpConnectionManager) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpConnectionManager.ProtoReflect.Descriptor instead.
func (*HttpConnectionManager) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0}
}

func (x *HttpConnectionManager) GetCodecType() HttpConnectionManager_CodecType {
	if x != nil {
		return x.CodecType
	}
	return HttpConnectionManager_AUTO
}

func (x *HttpConnectionManager) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (m *HttpConnectionManager) GetRouteSpecifier() isHttpConnectionManager_RouteSpecifier {
	if m != nil {
		return m.RouteSpecifier
	}
	return nil
}

func (x *HttpConnectionManager) GetRds() *Rds {
	if x, ok := x.GetRouteSpecifier().(*HttpConnectionManager_Rds); ok {
		return x.Rds
	}
	return nil
}

func (x *HttpConnectionManager) GetRouteConfig() *v21.RouteConfiguration {
	if x, ok := x.GetRouteSpecifier().(*HttpConnectionManager_RouteConfig); ok {
		return x.RouteConfig
	}
	return nil
}

func (x *HttpConnectionManager) GetScopedRoutes() *ScopedRoutes {
	if x, ok := x.GetRouteSpecifier().(*HttpConnectionManager_ScopedRoutes); ok {
		return x.ScopedRoutes
	}
	return nil
}

func (x *HttpConnectionManager) GetHttpFilters() []*HttpFilter {
	if x != nil {
		return x.HttpFilters
	}
	return nil
}

func (x *HttpConnectionManager) GetAddUserAgent() *wrappers.BoolValue {
	if x != nil {
		return x.AddUserAgent
	}
	return nil
}

func (x *HttpConnectionManager) GetTracing() *HttpConnectionManager_Tracing {
	if x != nil {
		return x.Tracing
	}
	return nil
}

func (x *HttpConnectionManager) GetCommonHttpProtocolOptions() *core.HttpProtocolOptions {
	if x != nil {
		return x.CommonHttpProtocolOptions
	}
	return nil
}

func (x *HttpConnectionManager) GetHttpProtocolOptions() *core.Http1ProtocolOptions {
	if x != nil {
		return x.HttpProtocolOptions
	}
	return nil
}

func (x *HttpConnectionManager) GetHttp2ProtocolOptions() *core.Http2ProtocolOptions {
	if x != nil {
		return x.Http2ProtocolOptions
	}
	return nil
}

func (x *HttpConnectionManager) GetServerName() string {
	if x != nil {
		return x.ServerName
	}
	return ""
}

func (x *HttpConnectionManager) GetServerHeaderTransformation() HttpConnectionManager_ServerHeaderTransformation {
	if x != nil {
		return x.ServerHeaderTransformation
	}
	return HttpConnectionManager_OVERWRITE
}

func (x *HttpConnectionManager) GetMaxRequestHeadersKb() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxRequestHeadersKb
	}
	return nil
}

// Deprecated: Do not use.
func (x *HttpConnectionManager) GetIdleTimeout() *duration.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

func (x *HttpConnectionManager) GetStreamIdleTimeout() *duration.Duration {
	if x != nil {
		return x.StreamIdleTimeout
	}
	return nil
}

func (x *HttpConnectionManager) GetRequestTimeout() *duration.Duration {
	if x != nil {
		return x.RequestTimeout
	}
	return nil
}

func (x *HttpConnectionManager) GetDrainTimeout() *duration.Duration {
	if x != nil {
		return x.DrainTimeout
	}
	return nil
}

func (x *HttpConnectionManager) GetDelayedCloseTimeout() *duration.Duration {
	if x != nil {
		return x.DelayedCloseTimeout
	}
	return nil
}

func (x *HttpConnectionManager) GetAccessLog() []*v2.AccessLog {
	if x != nil {
		return x.AccessLog
	}
	return nil
}

func (x *HttpConnectionManager) GetUseRemoteAddress() *wrappers.BoolValue {
	if x != nil {
		return x.UseRemoteAddress
	}
	return nil
}

func (x *HttpConnectionManager) GetXffNumTrustedHops() uint32 {
	if x != nil {
		return x.XffNumTrustedHops
	}
	return 0
}

func (x *HttpConnectionManager) GetInternalAddressConfig() *HttpConnectionManager_InternalAddressConfig {
	if x != nil {
		return x.InternalAddressConfig
	}
	return nil
}

func (x *HttpConnectionManager) GetSkipXffAppend() bool {
	if x != nil {
		return x.SkipXffAppend
	}
	return false
}

func (x *HttpConnectionManager) GetVia() string {
	if x != nil {
		return x.Via
	}
	return ""
}

func (x *HttpConnectionManager) GetGenerateRequestId() *wrappers.BoolValue {
	if x != nil {
		return x.GenerateRequestId
	}
	return nil
}

func (x *HttpConnectionManager) GetPreserveExternalRequestId() bool {
	if x != nil {
		return x.PreserveExternalRequestId
	}
	return false
}

func (x *HttpConnectionManager) GetForwardClientCertDetails() HttpConnectionManager_ForwardClientCertDetails {
	if x != nil {
		return x.ForwardClientCertDetails
	}
	return HttpConnectionManager_SANITIZE
}

func (x *HttpConnectionManager) GetSetCurrentClientCertDetails() *HttpConnectionManager_SetCurrentClientCertDetails {
	if x != nil {
		return x.SetCurrentClientCertDetails
	}
	return nil
}

func (x *HttpConnectionManager) GetProxy_100Continue() bool {
	if x != nil {
		return x.Proxy_100Continue
	}
	return false
}

func (x *HttpConnectionManager) GetRepresentIpv4RemoteAddressAsIpv4MappedIpv6() bool {
	if x != nil {
		return x.RepresentIpv4RemoteAddressAsIpv4MappedIpv6
	}
	return false
}

func (x *HttpConnectionManager) GetUpgradeConfigs() []*HttpConnectionManager_UpgradeConfig {
	if x != nil {
		return x.UpgradeConfigs
	}
	return nil
}

func (x *HttpConnectionManager) GetNormalizePath() *wrappers.BoolValue {
	if x != nil {
		return x.NormalizePath
	}
	return nil
}

func (x *HttpConnectionManager) GetMergeSlashes() bool {
	if x != nil {
		return x.MergeSlashes
	}
	return false
}

func (x *HttpConnectionManager) GetRequestIdExtension() *RequestIDExtension {
	if x != nil {
		return x.RequestIdExtension
	}
	return nil
}

type isHttpConnectionManager_RouteSpecifier interface {
	isHttpConnectionManager_RouteSpecifier()
}

type HttpConnectionManager_Rds struct {
	// The connection manager’s route table will be dynamically loaded via the RDS API.
	Rds *Rds `protobuf:"bytes,3,opt,name=rds,proto3,oneof"`
}

type HttpConnectionManager_RouteConfig struct {
	// The route table for the connection manager is static and is specified in this property.
	RouteConfig *v21.RouteConfiguration `protobuf:"bytes,4,opt,name=route_config,json=routeConfig,proto3,oneof"`
}

type HttpConnectionManager_ScopedRoutes struct {
	// A route table will be dynamically assigned to each request based on request attributes
	// (e.g., the value of a header). The "routing scopes" (i.e., route tables) and "scope keys" are
	// specified in this message.
	ScopedRoutes *ScopedRoutes `protobuf:"bytes,31,opt,name=scoped_routes,json=scopedRoutes,proto3,oneof"`
}

func (*HttpConnectionManager_Rds) isHttpConnectionManager_RouteSpecifier() {}

func (*HttpConnectionManager_RouteConfig) isHttpConnectionManager_RouteSpecifier() {}

func (*HttpConnectionManager_ScopedRoutes) isHttpConnectionManager_RouteSpecifier() {}

type Rds struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration source specifier for RDS.
	ConfigSource *core.ConfigSource `protobuf:"bytes,1,opt,name=config_source,json=configSource,proto3" json:"config_source,omitempty"`
	// The name of the route configuration. This name will be passed to the RDS
	// API. This allows an Envoy configuration with multiple HTTP listeners (and
	// associated HTTP connection manager filters) to use different route
	// configurations.
	RouteConfigName string `protobuf:"bytes,2,opt,name=route_config_name,json=routeConfigName,proto3" json:"route_config_name,omitempty"`
}

func (x *Rds) Reset() {
	*x = Rds{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rds) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rds) ProtoMessage() {}

func (x *Rds) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rds.ProtoReflect.Descriptor instead.
func (*Rds) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{1}
}

func (x *Rds) GetConfigSource() *core.ConfigSource {
	if x != nil {
		return x.ConfigSource
	}
	return nil
}

func (x *Rds) GetRouteConfigName() string {
	if x != nil {
		return x.RouteConfigName
	}
	return ""
}

// This message is used to work around the limitations with 'oneof' and repeated fields.
type ScopedRouteConfigurationsList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ScopedRouteConfigurations []*v21.ScopedRouteConfiguration `protobuf:"bytes,1,rep,name=scoped_route_configurations,json=scopedRouteConfigurations,proto3" json:"scoped_route_configurations,omitempty"`
}

func (x *ScopedRouteConfigurationsList) Reset() {
	*x = ScopedRouteConfigurationsList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScopedRouteConfigurationsList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedRouteConfigurationsList) ProtoMessage() {}

func (x *ScopedRouteConfigurationsList) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScopedRouteConfigurationsList.ProtoReflect.Descriptor instead.
func (*ScopedRouteConfigurationsList) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{2}
}

func (x *ScopedRouteConfigurationsList) GetScopedRouteConfigurations() []*v21.ScopedRouteConfiguration {
	if x != nil {
		return x.ScopedRouteConfigurations
	}
	return nil
}

// [#next-free-field: 6]
type ScopedRoutes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name assigned to the scoped routing configuration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The algorithm to use for constructing a scope key for each request.
	ScopeKeyBuilder *ScopedRoutes_ScopeKeyBuilder `protobuf:"bytes,2,opt,name=scope_key_builder,json=scopeKeyBuilder,proto3" json:"scope_key_builder,omitempty"`
	// Configuration source specifier for RDS.
	// This config source is used to subscribe to RouteConfiguration resources specified in
	// ScopedRouteConfiguration messages.
	RdsConfigSource *core.ConfigSource `protobuf:"bytes,3,opt,name=rds_config_source,json=rdsConfigSource,proto3" json:"rds_config_source,omitempty"`
	// Types that are assignable to ConfigSpecifier:
	//	*ScopedRoutes_ScopedRouteConfigurationsList
	//	*ScopedRoutes_ScopedRds
	ConfigSpecifier isScopedRoutes_ConfigSpecifier `protobuf_oneof:"config_specifier"`
}

func (x *ScopedRoutes) Reset() {
	*x = ScopedRoutes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScopedRoutes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedRoutes) ProtoMessage() {}

func (x *ScopedRoutes) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScopedRoutes.ProtoReflect.Descriptor instead.
func (*ScopedRoutes) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{3}
}

func (x *ScopedRoutes) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ScopedRoutes) GetScopeKeyBuilder() *ScopedRoutes_ScopeKeyBuilder {
	if x != nil {
		return x.ScopeKeyBuilder
	}
	return nil
}

func (x *ScopedRoutes) GetRdsConfigSource() *core.ConfigSource {
	if x != nil {
		return x.RdsConfigSource
	}
	return nil
}

func (m *ScopedRoutes) GetConfigSpecifier() isScopedRoutes_ConfigSpecifier {
	if m != nil {
		return m.ConfigSpecifier
	}
	return nil
}

func (x *ScopedRoutes) GetScopedRouteConfigurationsList() *ScopedRouteConfigurationsList {
	if x, ok := x.GetConfigSpecifier().(*ScopedRoutes_ScopedRouteConfigurationsList); ok {
		return x.ScopedRouteConfigurationsList
	}
	return nil
}

func (x *ScopedRoutes) GetScopedRds() *ScopedRds {
	if x, ok := x.GetConfigSpecifier().(*ScopedRoutes_ScopedRds); ok {
		return x.ScopedRds
	}
	return nil
}

type isScopedRoutes_ConfigSpecifier interface {
	isScopedRoutes_ConfigSpecifier()
}

type ScopedRoutes_ScopedRouteConfigurationsList struct {
	// The set of routing scopes corresponding to the HCM. A scope is assigned to a request by
	// matching a key constructed from the request's attributes according to the algorithm specified
	// by the
	// :ref:`ScopeKeyBuilder<envoy_api_msg_config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder>`
	// in this message.
	ScopedRouteConfigurationsList *ScopedRouteConfigurationsList `protobuf:"bytes,4,opt,name=scoped_route_configurations_list,json=scopedRouteConfigurationsList,proto3,oneof"`
}

type ScopedRoutes_ScopedRds struct {
	// The set of routing scopes associated with the HCM will be dynamically loaded via the SRDS
	// API. A scope is assigned to a request by matching a key constructed from the request's
	// attributes according to the algorithm specified by the
	// :ref:`ScopeKeyBuilder<envoy_api_msg_config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder>`
	// in this message.
	ScopedRds *ScopedRds `protobuf:"bytes,5,opt,name=scoped_rds,json=scopedRds,proto3,oneof"`
}

func (*ScopedRoutes_ScopedRouteConfigurationsList) isScopedRoutes_ConfigSpecifier() {}

func (*ScopedRoutes_ScopedRds) isScopedRoutes_ConfigSpecifier() {}

type ScopedRds struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration source specifier for scoped RDS.
	ScopedRdsConfigSource *core.ConfigSource `protobuf:"bytes,1,opt,name=scoped_rds_config_source,json=scopedRdsConfigSource,proto3" json:"scoped_rds_config_source,omitempty"`
}

func (x *ScopedRds) Reset() {
	*x = ScopedRds{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScopedRds) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedRds) ProtoMessage() {}

func (x *ScopedRds) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScopedRds.ProtoReflect.Descriptor instead.
func (*ScopedRds) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{4}
}

func (x *ScopedRds) GetScopedRdsConfigSource() *core.ConfigSource {
	if x != nil {
		return x.ScopedRdsConfigSource
	}
	return nil
}

type HttpFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the filter to instantiate. The name must match a
	// :ref:`supported filter <config_http_filters>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter specific configuration which depends on the filter being instantiated. See the supported
	// filters for further documentation.
	//
	// Types that are assignable to ConfigType:
	//	*HttpFilter_Config
	//	*HttpFilter_TypedConfig
	ConfigType isHttpFilter_ConfigType `protobuf_oneof:"config_type"`
}

func (x *HttpFilter) Reset() {
	*x = HttpFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpFilter) ProtoMessage() {}

func (x *HttpFilter) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpFilter.ProtoReflect.Descriptor instead.
func (*HttpFilter) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{5}
}

func (x *HttpFilter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *HttpFilter) GetConfigType() isHttpFilter_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

// Deprecated: Do not use.
func (x *HttpFilter) GetConfig() *_struct.Struct {
	if x, ok := x.GetConfigType().(*HttpFilter_Config); ok {
		return x.Config
	}
	return nil
}

func (x *HttpFilter) GetTypedConfig() *any.Any {
	if x, ok := x.GetConfigType().(*HttpFilter_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

type isHttpFilter_ConfigType interface {
	isHttpFilter_ConfigType()
}

type HttpFilter_Config struct {
	// Deprecated: Do not use.
	Config *_struct.Struct `protobuf:"bytes,2,opt,name=config,proto3,oneof"`
}

type HttpFilter_TypedConfig struct {
	TypedConfig *any.Any `protobuf:"bytes,4,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

func (*HttpFilter_Config) isHttpFilter_ConfigType() {}

func (*HttpFilter_TypedConfig) isHttpFilter_ConfigType() {}

type RequestIDExtension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request ID extension specific configuration.
	TypedConfig *any.Any `protobuf:"bytes,1,opt,name=typed_config,json=typedConfig,proto3" json:"typed_config,omitempty"`
}

func (x *RequestIDExtension) Reset() {
	*x = RequestIDExtension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestIDExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestIDExtension) ProtoMessage() {}

func (x *RequestIDExtension) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestIDExtension.ProtoReflect.Descriptor instead.
func (*RequestIDExtension) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{6}
}

func (x *RequestIDExtension) GetTypedConfig() *any.Any {
	if x != nil {
		return x.TypedConfig
	}
	return nil
}

// [#next-free-field: 10]
type HttpConnectionManager_Tracing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The span name will be derived from this field. If
	// :ref:`traffic_direction <envoy_api_field_Listener.traffic_direction>` is
	// specified on the parent listener, then it is used instead of this field.
	//
	// .. attention::
	//  This field has been deprecated in favor of `traffic_direction`.
	//
	// Deprecated: Do not use.
	OperationName HttpConnectionManager_Tracing_OperationName `protobuf:"varint,1,opt,name=operation_name,json=operationName,proto3,enum=envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_Tracing_OperationName" json:"operation_name,omitempty"`
	// A list of header names used to create tags for the active span. The header name is used to
	// populate the tag name, and the header value is used to populate the tag value. The tag is
	// created if the specified header name is present in the request's headers.
	//
	// .. attention::
	//  This field has been deprecated in favor of :ref:`custom_tags
	//  <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.tracing.custom_tags>`.
	//
	// Deprecated: Do not use.
	RequestHeadersForTags []string `protobuf:"bytes,2,rep,name=request_headers_for_tags,json=requestHeadersForTags,proto3" json:"request_headers_for_tags,omitempty"`
	// Target percentage of requests managed by this HTTP connection manager that will be force
	// traced if the :ref:`x-client-trace-id <config_http_conn_man_headers_x-client-trace-id>`
	// header is set. This field is a direct analog for the runtime variable
	// 'tracing.client_sampling' in the :ref:`HTTP Connection Manager
	// <config_http_conn_man_runtime>`.
	// Default: 100%
	ClientSampling *_type.Percent `protobuf:"bytes,3,opt,name=client_sampling,json=clientSampling,proto3" json:"client_sampling,omitempty"`
	// Target percentage of requests managed by this HTTP connection manager that will be randomly
	// selected for trace generation, if not requested by the client or not forced. This field is
	// a direct analog for the runtime variable 'tracing.random_sampling' in the
	// :ref:`HTTP Connection Manager <config_http_conn_man_runtime>`.
	// Default: 100%
	RandomSampling *_type.Percent `protobuf:"bytes,4,opt,name=random_sampling,json=randomSampling,proto3" json:"random_sampling,omitempty"`
	// Target percentage of requests managed by this HTTP connection manager that will be traced
	// after all other sampling checks have been applied (client-directed, force tracing, random
	// sampling). This field functions as an upper limit on the total configured sampling rate. For
	// instance, setting client_sampling to 100% but overall_sampling to 1% will result in only 1%
	// of client requests with the appropriate headers to be force traced. This field is a direct
	// analog for the runtime variable 'tracing.global_enabled' in the
	// :ref:`HTTP Connection Manager <config_http_conn_man_runtime>`.
	// Default: 100%
	OverallSampling *_type.Percent `protobuf:"bytes,5,opt,name=overall_sampling,json=overallSampling,proto3" json:"overall_sampling,omitempty"`
	// Whether to annotate spans with additional data. If true, spans will include logs for stream
	// events.
	Verbose bool `protobuf:"varint,6,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// Maximum length of the request path to extract and include in the HttpUrl tag. Used to
	// truncate lengthy request paths to meet the needs of a tracing backend.
	// Default: 256
	MaxPathTagLength *wrappers.UInt32Value `protobuf:"bytes,7,opt,name=max_path_tag_length,json=maxPathTagLength,proto3" json:"max_path_tag_length,omitempty"`
	// A list of custom tags with unique tag name to create tags for the active span.
	CustomTags []*v22.CustomTag `protobuf:"bytes,8,rep,name=custom_tags,json=customTags,proto3" json:"custom_tags,omitempty"`
	// Configuration for an external tracing provider.
	// If not specified, no tracing will be performed.
	//
	// .. attention::
	//   Please be aware that *envoy.tracers.opencensus* provider can only be configured once
	//   in Envoy lifetime.
	//   Any attempts to reconfigure it or to use different configurations for different HCM filters
	//   will be rejected.
	//   Such a constraint is inherent to OpenCensus itself. It cannot be overcome without changes
	//   on OpenCensus side.
	Provider *v23.Tracing_Http `protobuf:"bytes,9,opt,name=provider,proto3" json:"provider,omitempty"`
}

func (x *HttpConnectionManager_Tracing) Reset() {
	*x = HttpConnectionManager_Tracing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpConnectionManager_Tracing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpConnectionManager_Tracing) ProtoMessage() {}

func (x *HttpConnectionManager_Tracing) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpConnectionManager_Tracing.ProtoReflect.Descriptor instead.
func (*HttpConnectionManager_Tracing) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 0}
}

// Deprecated: Do not use.
func (x *HttpConnectionManager_Tracing) GetOperationName() HttpConnectionManager_Tracing_OperationName {
	if x != nil {
		return x.OperationName
	}
	return HttpConnectionManager_Tracing_INGRESS
}

// Deprecated: Do not use.
func (x *HttpConnectionManager_Tracing) GetRequestHeadersForTags() []string {
	if x != nil {
		return x.RequestHeadersForTags
	}
	return nil
}

func (x *HttpConnectionManager_Tracing) GetClientSampling() *_type.Percent {
	if x != nil {
		return x.ClientSampling
	}
	return nil
}

func (x *HttpConnectionManager_Tracing) GetRandomSampling() *_type.Percent {
	if x != nil {
		return x.RandomSampling
	}
	return nil
}

func (x *HttpConnectionManager_Tracing) GetOverallSampling() *_type.Percent {
	if x != nil {
		return x.OverallSampling
	}
	return nil
}

func (x *HttpConnectionManager_Tracing) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *HttpConnectionManager_Tracing) GetMaxPathTagLength() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxPathTagLength
	}
	return nil
}

func (x *HttpConnectionManager_Tracing) GetCustomTags() []*v22.CustomTag {
	if x != nil {
		return x.CustomTags
	}
	return nil
}

func (x *HttpConnectionManager_Tracing) GetProvider() *v23.Tracing_Http {
	if x != nil {
		return x.Provider
	}
	return nil
}

type HttpConnectionManager_InternalAddressConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether unix socket addresses should be considered internal.
	UnixSockets bool `protobuf:"varint,1,opt,name=unix_sockets,json=unixSockets,proto3" json:"unix_sockets,omitempty"`
}

func (x *HttpConnectionManager_InternalAddressConfig) Reset() {
	*x = HttpConnectionManager_InternalAddressConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpConnectionManager_InternalAddressConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpConnectionManager_InternalAddressConfig) ProtoMessage() {}

func (x *HttpConnectionManager_InternalAddressConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpConnectionManager_InternalAddressConfig.ProtoReflect.Descriptor instead.
func (*HttpConnectionManager_InternalAddressConfig) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 1}
}

func (x *HttpConnectionManager_InternalAddressConfig) GetUnixSockets() bool {
	if x != nil {
		return x.UnixSockets
	}
	return false
}

// [#next-free-field: 7]
type HttpConnectionManager_SetCurrentClientCertDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to forward the subject of the client cert. Defaults to false.
	Subject *wrappers.BoolValue `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// Whether to forward the entire client cert in URL encoded PEM format. This will appear in the
	// XFCC header comma separated from other values with the value Cert="PEM".
	// Defaults to false.
	Cert bool `protobuf:"varint,3,opt,name=cert,proto3" json:"cert,omitempty"`
	// Whether to forward the entire client cert chain (including the leaf cert) in URL encoded PEM
	// format. This will appear in the XFCC header comma separated from other values with the value
	// Chain="PEM".
	// Defaults to false.
	Chain bool `protobuf:"varint,6,opt,name=chain,proto3" json:"chain,omitempty"`
	// Whether to forward the DNS type Subject Alternative Names of the client cert.
	// Defaults to false.
	Dns bool `protobuf:"varint,4,opt,name=dns,proto3" json:"dns,omitempty"`
	// Whether to forward the URI type Subject Alternative Name of the client cert. Defaults to
	// false.
	Uri bool `protobuf:"varint,5,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) Reset() {
	*x = HttpConnectionManager_SetCurrentClientCertDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpConnectionManager_SetCurrentClientCertDetails) ProtoMessage() {}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpConnectionManager_SetCurrentClientCertDetails.ProtoReflect.Descriptor instead.
func (*HttpConnectionManager_SetCurrentClientCertDetails) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 2}
}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) GetSubject() *wrappers.BoolValue {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) GetCert() bool {
	if x != nil {
		return x.Cert
	}
	return false
}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) GetChain() bool {
	if x != nil {
		return x.Chain
	}
	return false
}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) GetDns() bool {
	if x != nil {
		return x.Dns
	}
	return false
}

func (x *HttpConnectionManager_SetCurrentClientCertDetails) GetUri() bool {
	if x != nil {
		return x.Uri
	}
	return false
}

// The configuration for HTTP upgrades.
// For each upgrade type desired, an UpgradeConfig must be added.
//
// .. warning::
//
//    The current implementation of upgrade headers does not handle
//    multi-valued upgrade headers. Support for multi-valued headers may be
//    added in the future if needed.
//
// .. warning::
//    The current implementation of upgrade headers does not work with HTTP/2
//    upstreams.
type HttpConnectionManager_UpgradeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The case-insensitive name of this upgrade, e.g. "websocket".
	// For each upgrade type present in upgrade_configs, requests with
	// Upgrade: [upgrade_type]
	// will be proxied upstream.
	UpgradeType string `protobuf:"bytes,1,opt,name=upgrade_type,json=upgradeType,proto3" json:"upgrade_type,omitempty"`
	// If present, this represents the filter chain which will be created for
	// this type of upgrade. If no filters are present, the filter chain for
	// HTTP connections will be used for this upgrade type.
	Filters []*HttpFilter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	// Determines if upgrades are enabled or disabled by default. Defaults to true.
	// This can be overridden on a per-route basis with :ref:`cluster
	// <envoy_api_field_route.RouteAction.upgrade_configs>` as documented in the
	// :ref:`upgrade documentation <arch_overview_upgrades>`.
	Enabled *wrappers.BoolValue `protobuf:"bytes,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *HttpConnectionManager_UpgradeConfig) Reset() {
	*x = HttpConnectionManager_UpgradeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpConnectionManager_UpgradeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpConnectionManager_UpgradeConfig) ProtoMessage() {}

func (x *HttpConnectionManager_UpgradeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpConnectionManager_UpgradeConfig.ProtoReflect.Descriptor instead.
func (*HttpConnectionManager_UpgradeConfig) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{0, 3}
}

func (x *HttpConnectionManager_UpgradeConfig) GetUpgradeType() string {
	if x != nil {
		return x.UpgradeType
	}
	return ""
}

func (x *HttpConnectionManager_UpgradeConfig) GetFilters() []*HttpFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *HttpConnectionManager_UpgradeConfig) GetEnabled() *wrappers.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// Specifies the mechanism for constructing "scope keys" based on HTTP request attributes. These
// keys are matched against a set of :ref:`Key<envoy_api_msg_ScopedRouteConfiguration.Key>`
// objects assembled from :ref:`ScopedRouteConfiguration<envoy_api_msg_ScopedRouteConfiguration>`
// messages distributed via SRDS (the Scoped Route Discovery Service) or assigned statically via
// :ref:`scoped_route_configurations_list<envoy_api_field_config.filter.network.http_connection_manager.v2.ScopedRoutes.scoped_route_configurations_list>`.
//
// Upon receiving a request's headers, the Router will build a key using the algorithm specified
// by this message. This key will be used to look up the routing table (i.e., the
// :ref:`RouteConfiguration<envoy_api_msg_RouteConfiguration>`) to use for the request.
type ScopedRoutes_ScopeKeyBuilder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The final(built) scope key consists of the ordered union of these fragments, which are compared in order with the
	// fragments of a :ref:`ScopedRouteConfiguration<envoy_api_msg_ScopedRouteConfiguration>`.
	// A missing fragment during comparison will make the key invalid, i.e., the computed key doesn't match any key.
	Fragments []*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder `protobuf:"bytes,1,rep,name=fragments,proto3" json:"fragments,omitempty"`
}

func (x *ScopedRoutes_ScopeKeyBuilder) Reset() {
	*x = ScopedRoutes_ScopeKeyBuilder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScopedRoutes_ScopeKeyBuilder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedRoutes_ScopeKeyBuilder) ProtoMessage() {}

func (x *ScopedRoutes_ScopeKeyBuilder) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScopedRoutes_ScopeKeyBuilder.ProtoReflect.Descriptor instead.
func (*ScopedRoutes_ScopeKeyBuilder) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ScopedRoutes_ScopeKeyBuilder) GetFragments() []*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder {
	if x != nil {
		return x.Fragments
	}
	return nil
}

// Specifies the mechanism for constructing key fragments which are composed into scope keys.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_
	Type isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_Type `protobuf_oneof:"type"`
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) Reset() {
	*x = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) ProtoMessage() {}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScopedRoutes_ScopeKeyBuilder_FragmentBuilder.ProtoReflect.Descriptor instead.
func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{3, 0, 0}
}

func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) GetType() isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) GetHeaderValueExtractor() *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor {
	if x, ok := x.GetType().(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_); ok {
		return x.HeaderValueExtractor
	}
	return nil
}

type isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_Type interface {
	isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_Type()
}

type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_ struct {
	// Specifies how a header field's value should be extracted.
	HeaderValueExtractor *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor `protobuf:"bytes,1,opt,name=header_value_extractor,json=headerValueExtractor,proto3,oneof"`
}

func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_) isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_Type() {
}

// Specifies how the value of a header should be extracted.
// The following example maps the structure of a header to the fields in this message.
//
// .. code::
//
//              <0> <1>   <-- index
//    X-Header: a=b;c=d
//    |         || |
//    |         || \----> <element_separator>
//    |         ||
//    |         |\----> <element.separator>
//    |         |
//    |         \----> <element.key>
//    |
//    \----> <name>
//
//    Each 'a=b' key-value pair constitutes an 'element' of the header field.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the header field to extract the value from.
	//
	// .. note::
	//
	//   If the header appears multiple times only the first value is used.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The element separator (e.g., ';' separates 'a;b;c;d').
	// Default: empty string. This causes the entirety of the header field to be extracted.
	// If this field is set to an empty string and 'index' is used in the oneof below, 'index'
	// must be set to 0.
	ElementSeparator string `protobuf:"bytes,2,opt,name=element_separator,json=elementSeparator,proto3" json:"element_separator,omitempty"`
	// Types that are assignable to ExtractType:
	//	*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Index
	//	*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Element
	ExtractType isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_ExtractType `protobuf_oneof:"extract_type"`
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) Reset() {
	*x = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) ProtoMessage() {}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor.ProtoReflect.Descriptor instead.
func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{3, 0, 0, 0}
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) GetElementSeparator() string {
	if x != nil {
		return x.ElementSeparator
	}
	return ""
}

func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) GetExtractType() isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_ExtractType {
	if m != nil {
		return m.ExtractType
	}
	return nil
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) GetIndex() uint32 {
	if x, ok := x.GetExtractType().(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Index); ok {
		return x.Index
	}
	return 0
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) GetElement() *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement {
	if x, ok := x.GetExtractType().(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Element); ok {
		return x.Element
	}
	return nil
}

type isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_ExtractType interface {
	isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_ExtractType()
}

type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Index struct {
	// Specifies the zero based index of the element to extract.
	// Note Envoy concatenates multiple values of the same header key into a comma separated
	// string, the splitting always happens after the concatenation.
	Index uint32 `protobuf:"varint,3,opt,name=index,proto3,oneof"`
}

type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Element struct {
	// Specifies the key value pair to extract the value from.
	Element *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement `protobuf:"bytes,4,opt,name=element,proto3,oneof"`
}

func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Index) isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_ExtractType() {
}

func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Element) isScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_ExtractType() {
}

// Specifies a header field's key value pair to match on.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The separator between key and value (e.g., '=' separates 'k=v;...').
	// If an element is an empty string, the element is ignored.
	// If an element contains no separator, the whole element is parsed as key and the
	// fragment value is an empty string.
	// If there are multiple values for a matched key, the first value is returned.
	Separator string `protobuf:"bytes,1,opt,name=separator,proto3" json:"separator,omitempty"`
	// The key to match on.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) Reset() {
	*x = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) ProtoMessage() {}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement.ProtoReflect.Descriptor instead.
func (*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) Descriptor() ([]byte, []int) {
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP(), []int{3, 0, 0, 0, 0}
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) GetSeparator() string {
	if x != nil {
		return x.Separator
	}
	return ""
}

func (x *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

var File_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto protoreflect.FileDescriptor

var file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDesc = []byte{
	0x0a, 0x54, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x36, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a, 0x25,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x32, 0x2f,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6c, 0x6f,
	0x67, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6c, 0x6f, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x68, 0x74, 0x74, 0x70,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x75,
	0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75,
	0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5, 0x23, 0x0a, 0x15, 0x48, 0x74, 0x74, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12,
	0x80, 0x01, 0x0a, 0x0a, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x57, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x28, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x20, 0x01,
	0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x4f, 0x0a, 0x03,
	0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x64, 0x73, 0x48, 0x00, 0x52, 0x03, 0x72, 0x64, 0x73, 0x12, 0x45, 0x0a,
	0x0c, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x6b, 0x0a, 0x0d, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x65, 0x0a, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x48, 0x74, 0x74, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0b, 0x68, 0x74, 0x74,
	0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0e, 0x61, 0x64, 0x64, 0x5f,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x61, 0x64,
	0x64, 0x55, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x6f, 0x0a, 0x07, 0x74, 0x72,
	0x61, 0x63, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x69,
	0x6e, 0x67, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x12, 0x67, 0x0a, 0x1c, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x48, 0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5b, 0x0a, 0x15, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x31, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x13, 0x68, 0x74,
	0x74, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x5d, 0x0a, 0x16, 0x68, 0x74, 0x74, 0x70, 0x32, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x32, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x14, 0x68, 0x74, 0x74, 0x70,
	0x32, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0xb4, 0x01, 0x0a, 0x1c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x68, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x1a, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x5f,
	0x6b, 0x62, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0a, 0xfa, 0x42, 0x07, 0x2a, 0x05, 0x18, 0x80, 0x40,
	0x20, 0x00, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x4b, 0x62, 0x12, 0x46, 0x0a, 0x0c, 0x69, 0x64, 0x6c, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x18, 0x01, 0xb8, 0xee, 0xf2, 0xd2,
	0x05, 0x01, 0x52, 0x0b, 0x69, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12,
	0x49, 0x0a, 0x13, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49,
	0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x42, 0x0a, 0x0f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x1c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x3e,
	0x0a, 0x0d, 0x64, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x64, 0x72, 0x61, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x4d,
	0x0a, 0x15, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x65,
	0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x4a, 0x0a,
	0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x52, 0x09,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x12, 0x48, 0x0a, 0x12, 0x75, 0x73, 0x65,
	0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x10, 0x75, 0x73, 0x65, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x78, 0x66, 0x66, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x68, 0x6f, 0x70, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x11, 0x78, 0x66, 0x66, 0x4e, 0x75, 0x6d, 0x54, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64,
	0x48, 0x6f, 0x70, 0x73, 0x12, 0x9b, 0x01, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x63, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x48, 0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x78, 0x66, 0x66, 0x5f, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x6b, 0x69,
	0x70, 0x58, 0x66, 0x66, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x76, 0x69,
	0x61, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x76, 0x69, 0x61, 0x12, 0x4a, 0x0a, 0x13,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x1c, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x20, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19,
	0x70, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0xaf, 0x01, 0x0a, 0x1b, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x66, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x18, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x1f,
	0x73, 0x65, 0x74, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x69, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x1b, 0x73, 0x65, 0x74, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x31, 0x30, 0x30, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x69,
	0x6e, 0x75, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x31, 0x30, 0x30, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x12, 0x65, 0x0a, 0x31, 0x72,
	0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x61, 0x73, 0x5f,
	0x69, 0x70, 0x76, 0x34, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x76, 0x36,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x2a, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x49, 0x70, 0x76, 0x34, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x41, 0x73, 0x49, 0x70, 0x76, 0x34, 0x4d, 0x61, 0x70, 0x70, 0x65, 0x64, 0x49, 0x70,
	0x76, 0x36, 0x12, 0x84, 0x01, 0x0a, 0x0f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x75, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x41, 0x0a, 0x0e, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x6e,
	0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0d,
	0x6d, 0x65, 0x72, 0x67, 0x65, 0x5f, 0x73, 0x6c, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x21, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x53, 0x6c, 0x61, 0x73, 0x68, 0x65,
	0x73, 0x12, 0x7c, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x5f,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x44, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a,
	0xb6, 0x05, 0x0a, 0x07, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x12, 0x9c, 0x01, 0x0a, 0x0e,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x63, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x10, 0x18, 0x01, 0xfa, 0x42, 0x05,
	0x82, 0x01, 0x02, 0x10, 0x01, 0xb8, 0xee, 0xf2, 0xd2, 0x05, 0x01, 0x52, 0x0d, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x18, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x66, 0x6f,
	0x72, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x46, 0x6f, 0x72, 0x54, 0x61, 0x67, 0x73, 0x12, 0x3c, 0x0a, 0x0f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x3c, 0x0a, 0x0f, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x5f,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x52, 0x0e, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x3e, 0x0a, 0x10, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x5f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x52, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x12, 0x4b, 0x0a,
	0x13, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x74,
	0x68, 0x54, 0x61, 0x67, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x0b, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x74, 0x72, 0x61,
	0x63, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61,
	0x67, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x73, 0x12, 0x3f, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x2e,
	0x48, 0x74, 0x74, 0x70, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0x28,
	0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x1a, 0x3a, 0x0a, 0x15, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x21, 0x0a, 0x0c, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x75, 0x6e, 0x69, 0x78, 0x53, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x1a, 0xa7, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x43, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x65,
	0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x63, 0x65, 0x72, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x03, 0x64, 0x6e, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x03, 0x75, 0x72, 0x69, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x1a, 0xc6,
	0x01, 0x0a, 0x0d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x21, 0x0a, 0x0c, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x36, 0x0a, 0x09, 0x43, 0x6f, 0x64, 0x65, 0x63,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x48, 0x54, 0x54, 0x50, 0x31, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x54, 0x54,
	0x50, 0x32, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x54, 0x54, 0x50, 0x33, 0x10, 0x03, 0x22,
	0x53, 0x0a, 0x1a, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0d, 0x0a,
	0x09, 0x4f, 0x56, 0x45, 0x52, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10,
	0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x5f, 0x49, 0x46, 0x5f, 0x41, 0x42, 0x53, 0x45, 0x4e, 0x54,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x41, 0x53, 0x53, 0x5f, 0x54, 0x48, 0x52, 0x4f, 0x55,
	0x47, 0x48, 0x10, 0x02, 0x22, 0x79, 0x0a, 0x18, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x41, 0x4e, 0x49, 0x54, 0x49, 0x5a, 0x45, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x12, 0x0a, 0x0e, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41,
	0x52, 0x44, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x41, 0x4e, 0x49, 0x54, 0x49, 0x5a, 0x45,
	0x5f, 0x53, 0x45, 0x54, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53,
	0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x04, 0x42,
	0x16, 0x0a, 0x0f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x4a, 0x04, 0x08, 0x1b, 0x10, 0x1c, 0x22, 0x8a, 0x01,
	0x0a, 0x03, 0x52, 0x64, 0x73, 0x12, 0x4e, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0xfa,
	0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x33, 0x0a, 0x11, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x20, 0x01, 0x52, 0x0f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x1d, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x70, 0x0a, 0x1b,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01,
	0x02, 0x08, 0x01, 0x52, 0x19, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa4,
	0x0a, 0x0a, 0x0c, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa,
	0x42, 0x04, 0x72, 0x02, 0x20, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8a, 0x01, 0x0a,
	0x11, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x4b, 0x65, 0x79, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x4b,
	0x65, 0x79, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x11, 0x72, 0x64, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x0f, 0x72, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0xa0, 0x01, 0x0a, 0x20, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x1d, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x0a, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x5f, 0x72, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x64, 0x73, 0x48, 0x00, 0x52, 0x09, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x64, 0x52, 0x64, 0x73, 0x1a, 0xf2, 0x05, 0x0a, 0x0f, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x4b, 0x65, 0x79, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x8c, 0x01, 0x0a, 0x09,
	0x66, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x64, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x4b, 0x65, 0x79, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x46, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x65, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52,
	0x09, 0x66, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xcf, 0x04, 0x0a, 0x0f, 0x46,
	0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x12, 0xb1,
	0x01, 0x0a, 0x16, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x4b, 0x65, 0x79, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x46, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x14, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x1a, 0xfa, 0x02, 0x0a, 0x14, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1b, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02,
	0x20, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x70, 0x61,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0xa0, 0x01,
	0x0a, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x83, 0x01, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x4b, 0x65, 0x79, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x46, 0x72, 0x61, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x4b, 0x76, 0x45, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x1a, 0x4d, 0x0a, 0x09, 0x4b, 0x76, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a,
	0x09, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x20, 0x01, 0x52, 0x09, 0x73, 0x65, 0x70, 0x61, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x20, 0x01, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x42,
	0x0e, 0x0a, 0x0c, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42,
	0x0b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x42, 0x17, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0x6f, 0x0a, 0x09, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52,
	0x64, 0x73, 0x12, 0x62, 0x0a, 0x18, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x5f, 0x72, 0x64, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52,
	0x15, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x52, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x0a, 0x48, 0x74, 0x74, 0x70, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x20, 0x01, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x48,
	0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x0c, 0x74, 0x79, 0x70,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x79, 0x70, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x22, 0x4d, 0x0a, 0x12, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x44, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x37, 0x0a, 0x0c, 0x74, 0x79, 0x70, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0b, 0x74, 0x79, 0x70,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0xaf, 0x01, 0x0a, 0x44, 0x69, 0x6f, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x42, 0x1a, 0x48, 0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0xf2,
	0x98, 0xfe, 0x8f, 0x05, 0x3d, 0x12, 0x3b, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x33, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescOnce sync.Once
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescData = file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDesc
)

func file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescGZIP() []byte {
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescOnce.Do(func() {
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescData)
	})
	return file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDescData
}

var file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_goTypes = []interface{}{
	(HttpConnectionManager_CodecType)(0),                                                // 0: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.CodecType
	(HttpConnectionManager_ServerHeaderTransformation)(0),                               // 1: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.ServerHeaderTransformation
	(HttpConnectionManager_ForwardClientCertDetails)(0),                                 // 2: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.ForwardClientCertDetails
	(HttpConnectionManager_Tracing_OperationName)(0),                                    // 3: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.OperationName
	(*HttpConnectionManager)(nil),                                                       // 4: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager
	(*Rds)(nil),                                                                         // 5: envoy.config.filter.network.http_connection_manager.v2.Rds
	(*ScopedRouteConfigurationsList)(nil),                                               // 6: envoy.config.filter.network.http_connection_manager.v2.ScopedRouteConfigurationsList
	(*ScopedRoutes)(nil),                                                                // 7: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes
	(*ScopedRds)(nil),                                                                   // 8: envoy.config.filter.network.http_connection_manager.v2.ScopedRds
	(*HttpFilter)(nil),                                                                  // 9: envoy.config.filter.network.http_connection_manager.v2.HttpFilter
	(*RequestIDExtension)(nil),                                                          // 10: envoy.config.filter.network.http_connection_manager.v2.RequestIDExtension
	(*HttpConnectionManager_Tracing)(nil),                                               // 11: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing
	(*HttpConnectionManager_InternalAddressConfig)(nil),                                 // 12: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.InternalAddressConfig
	(*HttpConnectionManager_SetCurrentClientCertDetails)(nil),                           // 13: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.SetCurrentClientCertDetails
	(*HttpConnectionManager_UpgradeConfig)(nil),                                         // 14: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.UpgradeConfig
	(*ScopedRoutes_ScopeKeyBuilder)(nil),                                                // 15: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder
	(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder)(nil),                                // 16: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder
	(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor)(nil),           // 17: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder.HeaderValueExtractor
	(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement)(nil), // 18: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder.HeaderValueExtractor.KvElement
	(*v21.RouteConfiguration)(nil),                                                      // 19: envoy.api.v2.RouteConfiguration
	(*wrappers.BoolValue)(nil),                                                          // 20: google.protobuf.BoolValue
	(*core.HttpProtocolOptions)(nil),                                                    // 21: envoy.api.v2.core.HttpProtocolOptions
	(*core.Http1ProtocolOptions)(nil),                                                   // 22: envoy.api.v2.core.Http1ProtocolOptions
	(*core.Http2ProtocolOptions)(nil),                                                   // 23: envoy.api.v2.core.Http2ProtocolOptions
	(*wrappers.UInt32Value)(nil),                                                        // 24: google.protobuf.UInt32Value
	(*duration.Duration)(nil),                                                           // 25: google.protobuf.Duration
	(*v2.AccessLog)(nil),                                                                // 26: envoy.config.filter.accesslog.v2.AccessLog
	(*core.ConfigSource)(nil),                                                           // 27: envoy.api.v2.core.ConfigSource
	(*v21.ScopedRouteConfiguration)(nil),                                                // 28: envoy.api.v2.ScopedRouteConfiguration
	(*_struct.Struct)(nil),                                                              // 29: google.protobuf.Struct
	(*any.Any)(nil),                                                                     // 30: google.protobuf.Any
	(*_type.Percent)(nil),                                                               // 31: envoy.type.Percent
	(*v22.CustomTag)(nil),                                                               // 32: envoy.type.tracing.v2.CustomTag
	(*v23.Tracing_Http)(nil),                                                            // 33: envoy.config.trace.v2.Tracing.Http
}
var file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_depIdxs = []int32{
	0,  // 0: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.codec_type:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.CodecType
	5,  // 1: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.rds:type_name -> envoy.config.filter.network.http_connection_manager.v2.Rds
	19, // 2: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.route_config:type_name -> envoy.api.v2.RouteConfiguration
	7,  // 3: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.scoped_routes:type_name -> envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes
	9,  // 4: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.http_filters:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpFilter
	20, // 5: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.add_user_agent:type_name -> google.protobuf.BoolValue
	11, // 6: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.tracing:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing
	21, // 7: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.common_http_protocol_options:type_name -> envoy.api.v2.core.HttpProtocolOptions
	22, // 8: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.http_protocol_options:type_name -> envoy.api.v2.core.Http1ProtocolOptions
	23, // 9: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.http2_protocol_options:type_name -> envoy.api.v2.core.Http2ProtocolOptions
	1,  // 10: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.server_header_transformation:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.ServerHeaderTransformation
	24, // 11: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.max_request_headers_kb:type_name -> google.protobuf.UInt32Value
	25, // 12: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.idle_timeout:type_name -> google.protobuf.Duration
	25, // 13: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.stream_idle_timeout:type_name -> google.protobuf.Duration
	25, // 14: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.request_timeout:type_name -> google.protobuf.Duration
	25, // 15: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.drain_timeout:type_name -> google.protobuf.Duration
	25, // 16: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.delayed_close_timeout:type_name -> google.protobuf.Duration
	26, // 17: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.access_log:type_name -> envoy.config.filter.accesslog.v2.AccessLog
	20, // 18: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.use_remote_address:type_name -> google.protobuf.BoolValue
	12, // 19: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.internal_address_config:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.InternalAddressConfig
	20, // 20: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.generate_request_id:type_name -> google.protobuf.BoolValue
	2,  // 21: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.forward_client_cert_details:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.ForwardClientCertDetails
	13, // 22: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.set_current_client_cert_details:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.SetCurrentClientCertDetails
	14, // 23: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.upgrade_configs:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.UpgradeConfig
	20, // 24: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.normalize_path:type_name -> google.protobuf.BoolValue
	10, // 25: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.request_id_extension:type_name -> envoy.config.filter.network.http_connection_manager.v2.RequestIDExtension
	27, // 26: envoy.config.filter.network.http_connection_manager.v2.Rds.config_source:type_name -> envoy.api.v2.core.ConfigSource
	28, // 27: envoy.config.filter.network.http_connection_manager.v2.ScopedRouteConfigurationsList.scoped_route_configurations:type_name -> envoy.api.v2.ScopedRouteConfiguration
	15, // 28: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.scope_key_builder:type_name -> envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder
	27, // 29: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.rds_config_source:type_name -> envoy.api.v2.core.ConfigSource
	6,  // 30: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.scoped_route_configurations_list:type_name -> envoy.config.filter.network.http_connection_manager.v2.ScopedRouteConfigurationsList
	8,  // 31: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.scoped_rds:type_name -> envoy.config.filter.network.http_connection_manager.v2.ScopedRds
	27, // 32: envoy.config.filter.network.http_connection_manager.v2.ScopedRds.scoped_rds_config_source:type_name -> envoy.api.v2.core.ConfigSource
	29, // 33: envoy.config.filter.network.http_connection_manager.v2.HttpFilter.config:type_name -> google.protobuf.Struct
	30, // 34: envoy.config.filter.network.http_connection_manager.v2.HttpFilter.typed_config:type_name -> google.protobuf.Any
	30, // 35: envoy.config.filter.network.http_connection_manager.v2.RequestIDExtension.typed_config:type_name -> google.protobuf.Any
	3,  // 36: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.operation_name:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.OperationName
	31, // 37: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.client_sampling:type_name -> envoy.type.Percent
	31, // 38: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.random_sampling:type_name -> envoy.type.Percent
	31, // 39: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.overall_sampling:type_name -> envoy.type.Percent
	24, // 40: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.max_path_tag_length:type_name -> google.protobuf.UInt32Value
	32, // 41: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.custom_tags:type_name -> envoy.type.tracing.v2.CustomTag
	33, // 42: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing.provider:type_name -> envoy.config.trace.v2.Tracing.Http
	20, // 43: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.SetCurrentClientCertDetails.subject:type_name -> google.protobuf.BoolValue
	9,  // 44: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.UpgradeConfig.filters:type_name -> envoy.config.filter.network.http_connection_manager.v2.HttpFilter
	20, // 45: envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.UpgradeConfig.enabled:type_name -> google.protobuf.BoolValue
	16, // 46: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.fragments:type_name -> envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder
	17, // 47: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder.header_value_extractor:type_name -> envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder.HeaderValueExtractor
	18, // 48: envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder.HeaderValueExtractor.element:type_name -> envoy.config.filter.network.http_connection_manager.v2.ScopedRoutes.ScopeKeyBuilder.FragmentBuilder.HeaderValueExtractor.KvElement
	49, // [49:49] is the sub-list for method output_type
	49, // [49:49] is the sub-list for method input_type
	49, // [49:49] is the sub-list for extension type_name
	49, // [49:49] is the sub-list for extension extendee
	0,  // [0:49] is the sub-list for field type_name
}

func init() {
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_init()
}
func file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_init() {
	if File_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpConnectionManager); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rds); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScopedRouteConfigurationsList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScopedRoutes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScopedRds); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestIDExtension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpConnectionManager_Tracing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpConnectionManager_InternalAddressConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpConnectionManager_SetCurrentClientCertDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpConnectionManager_UpgradeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScopedRoutes_ScopeKeyBuilder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*HttpConnectionManager_Rds)(nil),
		(*HttpConnectionManager_RouteConfig)(nil),
		(*HttpConnectionManager_ScopedRoutes)(nil),
	}
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ScopedRoutes_ScopedRouteConfigurationsList)(nil),
		(*ScopedRoutes_ScopedRds)(nil),
	}
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*HttpFilter_Config)(nil),
		(*HttpFilter_TypedConfig)(nil),
	}
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_)(nil),
	}
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Index)(nil),
		(*ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Element)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_goTypes,
		DependencyIndexes: file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_depIdxs,
		EnumInfos:         file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_enumTypes,
		MessageInfos:      file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_msgTypes,
	}.Build()
	File_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto = out.File
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_rawDesc = nil
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_goTypes = nil
	file_envoy_config_filter_network_http_connection_manager_v2_http_connection_manager_proto_depIdxs = nil
}
