import { SerializedTimings } from '../utils/timers';
import { GenericConfigObject } from '../utils/mergeOptions';
import { ModuleJSON } from '../Module';
import { RawSourceMap } from 'source-map';
import Program from '../ast/nodes/Program';
import { Node } from '../ast/nodes/shared/Node';
import { WatcherOptions } from '../watch/index';
import { TransformContext } from '../utils/transform';
import { SourceMap } from 'magic-string';
export declare const VERSION = "<@VERSION@>";
export declare type SourceDescription = {
    code: string;
    map?: RawSourceMap;
    ast?: Program;
};
export declare type ResolveIdHook = (id: string, parent: string) => Promise<string | boolean | void> | string | boolean | void;
export declare type MissingExportHook = (exportName: string, importingModule: string, importedModule: string, importerStart?: number) => void;
export declare type IsExternalHook = (id: string, parentId: string, isResolved: boolean) => Promise<boolean | void> | boolean | void;
export declare type LoadHook = (id: string) => Promise<SourceDescription | string | void> | SourceDescription | string | void;
export declare type TransformHook = (this: TransformContext, code: string, id: String) => Promise<SourceDescription | string | void>;
export declare type TransformBundleHook = (code: string, options: OutputOptions) => Promise<SourceDescription | string>;
export declare type ResolveDynamicImportHook = (specifier: string | Node, parentId: string) => Promise<string | void> | string | void;
export interface Plugin {
    name: string;
    options?: (options: InputOptions) => void;
    load?: LoadHook;
    resolveId?: ResolveIdHook;
    missingExport?: MissingExportHook;
    transform?: TransformHook;
    transformBundle?: TransformBundleHook;
    ongenerate?: (options: OutputOptions, source: SourceDescription) => void;
    onwrite?: (options: OutputOptions, source: SourceDescription) => void;
    resolveDynamicImport?: ResolveDynamicImportHook;
    banner?: () => string;
    footer?: () => string;
    intro?: () => string;
    outro?: () => string;
}
export interface TreeshakingOptions {
    propertyReadSideEffects: boolean;
    pureExternalModules: boolean;
}
export declare type ExternalOption = string[] | IsExternalHook;
export declare type GlobalsOption = {
    [name: string]: string;
} | ((name: string) => string);
export interface InputOptions {
    input: string | string[] | {
        [entryAlias: string]: string;
    };
    manualChunks?: {
        [chunkAlias: string]: string[];
    };
    external?: ExternalOption;
    plugins?: Plugin[];
    onwarn?: WarningHandler;
    cache?: {
        modules: ModuleJSON[];
    };
    acorn?: {};
    acornInjectPlugins?: Function[];
    treeshake?: boolean | TreeshakingOptions;
    context?: string;
    moduleContext?: string | ((id: string) => string) | {
        [id: string]: string;
    };
    watch?: WatcherOptions;
    experimentalDynamicImport?: boolean;
    experimentalCodeSplitting?: boolean;
    preserveSymlinks?: boolean;
    experimentalPreserveModules?: boolean;
    optimizeChunks?: boolean;
    chunkGroupingSize?: number;
    pureExternalModules?: boolean;
    preferConst?: boolean;
    perf?: boolean;
    entry?: string;
    transform?: TransformHook;
    load?: LoadHook;
    resolveId?: ResolveIdHook;
    resolveExternal?: any;
}
export declare type ModuleFormat = 'amd' | 'cjs' | 'system' | 'es' | 'es6' | 'iife' | 'umd';
export declare type OptionsPaths = Record<string, string> | ((id: string) => string);
export interface OutputOptions {
    file?: string;
    dir?: string;
    format?: ModuleFormat;
    name?: string;
    globals?: GlobalsOption;
    chunkNames?: string;
    entryNames?: string;
    paths?: OptionsPaths;
    banner?: string;
    footer?: string;
    intro?: string;
    outro?: string;
    sourcemap?: boolean | 'inline';
    sourcemapFile?: string;
    interop?: boolean;
    extend?: boolean;
    exports?: 'default' | 'named' | 'none' | 'auto';
    amd?: {
        id?: string;
        define?: string;
    };
    indent?: boolean;
    strict?: boolean;
    freeze?: boolean;
    namespaceToStringTag?: boolean;
    legacy?: boolean;
    noConflict?: boolean;
    dest?: string;
    moduleId?: string;
}
export interface RollupWarning {
    message?: string;
    code?: string;
    loc?: {
        file: string;
        line: number;
        column: number;
    };
    deprecations?: {
        old: string;
        new: string;
    }[];
    modules?: string[];
    names?: string[];
    source?: string;
    importer?: string;
    frame?: any;
    missing?: string;
    exporter?: string;
    name?: string;
    sources?: string[];
    reexporter?: string;
    guess?: string;
    url?: string;
    id?: string;
    plugin?: string;
    pos?: number;
    pluginCode?: string;
}
export declare type WarningHandler = (warning: string | RollupWarning) => void;
export interface OutputChunk {
    imports: string[];
    exports: string[];
    modules: string[];
    code: string;
    map?: SourceMap;
}
export interface Bundle {
    imports: string[];
    exports: string[];
    modules: ModuleJSON[];
    cache: {
        modules: ModuleJSON[];
    };
    generate: (outputOptions: OutputOptions) => Promise<OutputChunk>;
    write: (options: OutputOptions) => Promise<OutputChunk>;
    getTimings?: () => SerializedTimings;
}
export interface BundleSet {
    cache: {
        modules: ModuleJSON[];
    };
    generate: (outputOptions: OutputOptions) => Promise<{
        [chunkName: string]: OutputChunk;
    }>;
    write: (options: OutputOptions) => Promise<{
        [chunkName: string]: OutputChunk;
    }>;
    getTimings?: () => SerializedTimings;
}
export default function rollup(rawInputOptions: GenericConfigObject | InputOptions): Promise<Bundle | BundleSet>;
