/*
Copyright 2020 The vm import Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"time"

	scheme "github.com/kubevirt/vm-import-operator/pkg/api-client/clientset/versioned/scheme"
	v1beta1 "github.com/kubevirt/vm-import-operator/pkg/apis/v2v/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// VirtualMachineImportsGetter has a method to return a VirtualMachineImportInterface.
// A group's client should implement this interface.
type VirtualMachineImportsGetter interface {
	VirtualMachineImports(namespace string) VirtualMachineImportInterface
}

// VirtualMachineImportInterface has methods to work with VirtualMachineImport resources.
type VirtualMachineImportInterface interface {
	Create(*v1beta1.VirtualMachineImport) (*v1beta1.VirtualMachineImport, error)
	Update(*v1beta1.VirtualMachineImport) (*v1beta1.VirtualMachineImport, error)
	UpdateStatus(*v1beta1.VirtualMachineImport) (*v1beta1.VirtualMachineImport, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta1.VirtualMachineImport, error)
	List(opts v1.ListOptions) (*v1beta1.VirtualMachineImportList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.VirtualMachineImport, err error)
	VirtualMachineImportExpansion
}

// virtualMachineImports implements VirtualMachineImportInterface
type virtualMachineImports struct {
	client rest.Interface
	ns     string
}

// newVirtualMachineImports returns a VirtualMachineImports
func newVirtualMachineImports(c *V2vV1beta1Client, namespace string) *virtualMachineImports {
	return &virtualMachineImports{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the virtualMachineImport, and returns the corresponding virtualMachineImport object, and an error if there is any.
func (c *virtualMachineImports) Get(name string, options v1.GetOptions) (result *v1beta1.VirtualMachineImport, err error) {
	result = &v1beta1.VirtualMachineImport{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of VirtualMachineImports that match those selectors.
func (c *virtualMachineImports) List(opts v1.ListOptions) (result *v1beta1.VirtualMachineImportList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.VirtualMachineImportList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested virtualMachineImports.
func (c *virtualMachineImports) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a virtualMachineImport and creates it.  Returns the server's representation of the virtualMachineImport, and an error, if there is any.
func (c *virtualMachineImports) Create(virtualMachineImport *v1beta1.VirtualMachineImport) (result *v1beta1.VirtualMachineImport, err error) {
	result = &v1beta1.VirtualMachineImport{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		Body(virtualMachineImport).
		Do().
		Into(result)
	return
}

// Update takes the representation of a virtualMachineImport and updates it. Returns the server's representation of the virtualMachineImport, and an error, if there is any.
func (c *virtualMachineImports) Update(virtualMachineImport *v1beta1.VirtualMachineImport) (result *v1beta1.VirtualMachineImport, err error) {
	result = &v1beta1.VirtualMachineImport{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		Name(virtualMachineImport.Name).
		Body(virtualMachineImport).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *virtualMachineImports) UpdateStatus(virtualMachineImport *v1beta1.VirtualMachineImport) (result *v1beta1.VirtualMachineImport, err error) {
	result = &v1beta1.VirtualMachineImport{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		Name(virtualMachineImport.Name).
		SubResource("status").
		Body(virtualMachineImport).
		Do().
		Into(result)
	return
}

// Delete takes name of the virtualMachineImport and deletes it. Returns an error if one occurs.
func (c *virtualMachineImports) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *virtualMachineImports) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualmachineimports").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched virtualMachineImport.
func (c *virtualMachineImports) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.VirtualMachineImport, err error) {
	result = &v1beta1.VirtualMachineImport{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("virtualmachineimports").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
