// Code generated by go-swagger; DO NOT EDIT.

package package_appr

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewListPackagesParams creates a new ListPackagesParams object
// with the default values initialized.
func NewListPackagesParams() *ListPackagesParams {
	var ()
	return &ListPackagesParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewListPackagesParamsWithTimeout creates a new ListPackagesParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewListPackagesParamsWithTimeout(timeout time.Duration) *ListPackagesParams {
	var ()
	return &ListPackagesParams{

		timeout: timeout,
	}
}

// NewListPackagesParamsWithContext creates a new ListPackagesParams object
// with the default values initialized, and the ability to set a context for a request
func NewListPackagesParamsWithContext(ctx context.Context) *ListPackagesParams {
	var ()
	return &ListPackagesParams{

		Context: ctx,
	}
}

// NewListPackagesParamsWithHTTPClient creates a new ListPackagesParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewListPackagesParamsWithHTTPClient(client *http.Client) *ListPackagesParams {
	var ()
	return &ListPackagesParams{
		HTTPClient: client,
	}
}

/*ListPackagesParams contains all the parameters to send to the API endpoint
for the list packages operation typically these are written to a http.Request
*/
type ListPackagesParams struct {

	/*MediaType
	  Filter by media-type

	*/
	MediaType *string
	/*Namespace
	  Filter by namespace

	*/
	Namespace *string
	/*Query
	  Lookup value for package search

	*/
	Query *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the list packages params
func (o *ListPackagesParams) WithTimeout(timeout time.Duration) *ListPackagesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list packages params
func (o *ListPackagesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list packages params
func (o *ListPackagesParams) WithContext(ctx context.Context) *ListPackagesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list packages params
func (o *ListPackagesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list packages params
func (o *ListPackagesParams) WithHTTPClient(client *http.Client) *ListPackagesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list packages params
func (o *ListPackagesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithMediaType adds the mediaType to the list packages params
func (o *ListPackagesParams) WithMediaType(mediaType *string) *ListPackagesParams {
	o.SetMediaType(mediaType)
	return o
}

// SetMediaType adds the mediaType to the list packages params
func (o *ListPackagesParams) SetMediaType(mediaType *string) {
	o.MediaType = mediaType
}

// WithNamespace adds the namespace to the list packages params
func (o *ListPackagesParams) WithNamespace(namespace *string) *ListPackagesParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the list packages params
func (o *ListPackagesParams) SetNamespace(namespace *string) {
	o.Namespace = namespace
}

// WithQuery adds the query to the list packages params
func (o *ListPackagesParams) WithQuery(query *string) *ListPackagesParams {
	o.SetQuery(query)
	return o
}

// SetQuery adds the query to the list packages params
func (o *ListPackagesParams) SetQuery(query *string) {
	o.Query = query
}

// WriteToRequest writes these params to a swagger request
func (o *ListPackagesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.MediaType != nil {

		// query param media_type
		var qrMediaType string
		if o.MediaType != nil {
			qrMediaType = *o.MediaType
		}
		qMediaType := qrMediaType
		if qMediaType != "" {
			if err := r.SetQueryParam("media_type", qMediaType); err != nil {
				return err
			}
		}

	}

	if o.Namespace != nil {

		// query param namespace
		var qrNamespace string
		if o.Namespace != nil {
			qrNamespace = *o.Namespace
		}
		qNamespace := qrNamespace
		if qNamespace != "" {
			if err := r.SetQueryParam("namespace", qNamespace); err != nil {
				return err
			}
		}

	}

	if o.Query != nil {

		// query param query
		var qrQuery string
		if o.Query != nil {
			qrQuery = *o.Query
		}
		qQuery := qrQuery
		if qQuery != "" {
			if err := r.SetQueryParam("query", qQuery); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
