// Code generated by go-swagger; DO NOT EDIT.

package package_appr

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/operator-framework/go-appr/models"
)

// CreatePackageReader is a Reader for the CreatePackage structure.
type CreatePackageReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreatePackageReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewCreatePackageOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 401:
		result := NewCreatePackageUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewCreatePackageNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 409:
		result := NewCreatePackageConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 422:
		result := NewCreatePackageUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewCreatePackageOK creates a CreatePackageOK with default headers values
func NewCreatePackageOK() *CreatePackageOK {
	return &CreatePackageOK{}
}

/*CreatePackageOK handles this case with default header values.

successful operation
*/
type CreatePackageOK struct {
	Payload *models.Package
}

func (o *CreatePackageOK) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages][%d] createPackageOK  %+v", 200, o.Payload)
}

func (o *CreatePackageOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Package)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePackageUnauthorized creates a CreatePackageUnauthorized with default headers values
func NewCreatePackageUnauthorized() *CreatePackageUnauthorized {
	return &CreatePackageUnauthorized{}
}

/*CreatePackageUnauthorized handles this case with default header values.

Not authorized to create the package
*/
type CreatePackageUnauthorized struct {
	Payload *models.Error
}

func (o *CreatePackageUnauthorized) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages][%d] createPackageUnauthorized  %+v", 401, o.Payload)
}

func (o *CreatePackageUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePackageNotFound creates a CreatePackageNotFound with default headers values
func NewCreatePackageNotFound() *CreatePackageNotFound {
	return &CreatePackageNotFound{}
}

/*CreatePackageNotFound handles this case with default header values.

Package not found (if force=true)
*/
type CreatePackageNotFound struct {
	Payload *models.Error
}

func (o *CreatePackageNotFound) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages][%d] createPackageNotFound  %+v", 404, o.Payload)
}

func (o *CreatePackageNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePackageConflict creates a CreatePackageConflict with default headers values
func NewCreatePackageConflict() *CreatePackageConflict {
	return &CreatePackageConflict{}
}

/*CreatePackageConflict handles this case with default header values.

Package already exists
*/
type CreatePackageConflict struct {
	Payload *models.Error
}

func (o *CreatePackageConflict) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages][%d] createPackageConflict  %+v", 409, o.Payload)
}

func (o *CreatePackageConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePackageUnprocessableEntity creates a CreatePackageUnprocessableEntity with default headers values
func NewCreatePackageUnprocessableEntity() *CreatePackageUnprocessableEntity {
	return &CreatePackageUnprocessableEntity{}
}

/*CreatePackageUnprocessableEntity handles this case with default header values.

Bad version or name format
*/
type CreatePackageUnprocessableEntity struct {
	Payload *models.Error
}

func (o *CreatePackageUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages][%d] createPackageUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *CreatePackageUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
