# Deployment on Arbitrary Cluster

In this guide we will cover installation of Open vSwitch, Multus and ovs-cni on
your arbitrary cluster.

## Requirements

This guide requires you to have your own Kubernetes/OpenShift cluster. If you
don't have one and just want to try ovs-cni out, please refer to [deployment on
local cluster](deployment-on-local-cluster.md) guide.

## Open vSwitch

### Kubernetes

Open vSwitch must be installed and running on all nodes (unless you do
[scheduling](scheduling.md)). OVS is available in repositories of all major
distributions.

On CentOS:

```shell
yum install openvswitch
systemctl start openvswitch
```

On Fedora:

```shell
dnf install openvswitch
systemctl start openvswitch
```

If you use other platform, please check [Open vSwitch documentation](https://github.com/openvswitch/ovs).

You can verify that OVS is properly running.

```shell
ovs-vsctl add-br test-br
ovs-vsctl list-br
ovs-vsctl del-br test-br
```

### OpenShift

For OpenShift, Open vSwitch deployment is a part of OVS CNI.

## Multus

TODO: Webhook support is not yet available, update docs once it is.

### Kubernetes

Installation of Multus is currently a little tricky. If you have not installed
any network plugin (Calico, Flannel,...) on your cluster, you can follow [quick
start guide](https://github.com/intel/multus-cni#quickstart-guide) of Multus.
However, if you already have a network plugin running, you need to do some
extra work. I would recommend you to study the quickstart guide and modify it
for your own case. Multus should soon include better documentation of the
installation process.

### OpenShift

Installation of Multus on OpenShift should be easier. Please note that this is
not officially supported by OpenShift, it is only a dev preview with no warranties.

```shell
kubectl apply -f https://raw.githubusercontent.com/kubevirt/ovs-cni/master/examples/multus.yml
```

## Open vSwitch CNI plugin

Installation of ovs-cni can be done simply by deploying a daemon set that will
deploy ovs-cni binaries on your nodes. Following command will install the
latest image from this repository.

### Kubernetes

```shell
kubectl apply -f https://raw.githubusercontent.com/kubevirt/ovs-cni/master/examples/kubernetes-ovs-cni.yml
```

### OpenShift

```shell
kubectl apply -f https://raw.githubusercontent.com/kubevirt/ovs-cni/master/examples/openshift-ovs-cni.yml
```

You can stop here and play with the cluster on your own or continue to
[demo](demo.md) that will guide you through definition of kubernetes networks,
configuration of Open vSwitch bridges and attachment of pods to them.
