#!/bin/sh

BRANCH=$( git rev-parse --abbrev-ref HEAD )
REVISION=$( git rev-parse --short HEAD )
VERSION="${1}"
if [ -z "${VERSION}" ]; then
	VERSION=$( git describe --abbrev=0 )
fi

echo "// autogenerated. Don't edit!"
echo
echo "package version"
echo
echo "const ("
echo "  COMPONENT = \"pack8s\""
echo "  BRANCH = \"${BRANCH}\""
echo "  REVISION = \"${REVISION}\""
echo "  VERSION = \"${VERSION}\""
echo ")"

