#!/bin/bash

set -e

if [ -z "$1" ]; then
	echo "usage: $0 tag (WITHOUT the leading 'v')"
	exit 1
fi
TAG="${1}"
DIR="kubevirt-ssp-operator-${TAG}"

[ ! -f ${DIR}.tar.gz ] && curl -s -L https://github.com/MarSik/kubevirt-ssp-operator/archive/v${TAG}.tar.gz -o ${DIR}.tar.gz

tar zxf ${DIR}.tar.gz

cp ${DIR}/watches.yaml .
cp ${DIR}/build/preprocess_template.py .

rm -rf ./roles
cp -a ${DIR}/roles .

echo
echo "*** temporarily NOT upgrading playbooks, please check differences manually"
echo
#rm -rf ./playbooks
cp -a ${DIR}/playbooks ./playbooks.us

rm -rf ${DIR}

echo "sources updated to upstream tag ${TAG}"
echo
echo "*** NOT updated: patch.yaml - please check d/s values!"
echo
echo "*** NOT updated: _defaults.yml - please check d/s values!"
echo
