#!/bin/bash

set -e

if [ -z "$1" ]; then
	echo "usage: $0 tag (WITHOUT the leading 'v')"
	exit 1
fi
export TAG="${1}"

curl -L https://github.com/fromanirh/kubevirt-metrics-collector/archive/v${TAG}.tar.gz -o kubevirt-metrics-collector-${TAG}.tar.gz

export VERSION="v${TAG}"
# hack to avoid expansion of GOPATH
export GOPATH='${GOPATH}'
envsubst < Dockerfile.in > Dockerfile
