// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mesh/v1alpha1/config.proto

// Configuration affecting the service mesh as a whole.

package v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	v1alpha3 "istio.io/api/networking/v1alpha3"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type MeshConfig_IngressControllerMode int32

const (
	// Disables Istio ingress controller.
	MeshConfig_OFF MeshConfig_IngressControllerMode = 0
	// Istio ingress controller will act on ingress resources that do not
	// contain any annotation or whose annotations match the value
	// specified in the ingress_class parameter described earlier. Use this
	// mode if Istio ingress controller will be the default ingress
	// controller for the entireKubernetes cluster.
	MeshConfig_DEFAULT MeshConfig_IngressControllerMode = 1
	// Istio ingress controller will only act on ingress resources whose
	// annotations match the value specified in the ingress_class parameter
	// described earlier. Use this mode if Istio ingress controller will be
	// a secondary ingress controller (e.g., in addition to a
	// cloud-provided ingress controller).
	MeshConfig_STRICT MeshConfig_IngressControllerMode = 2
)

var MeshConfig_IngressControllerMode_name = map[int32]string{
	0: "OFF",
	1: "DEFAULT",
	2: "STRICT",
}

var MeshConfig_IngressControllerMode_value = map[string]int32{
	"OFF":     0,
	"DEFAULT": 1,
	"STRICT":  2,
}

func (x MeshConfig_IngressControllerMode) String() string {
	return proto.EnumName(MeshConfig_IngressControllerMode_name, int32(x))
}

func (MeshConfig_IngressControllerMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 0}
}

// $hide_from_docs
type MeshConfig_AuthPolicy int32

const (
	MeshConfig_NONE       MeshConfig_AuthPolicy = 0
	MeshConfig_MUTUAL_TLS MeshConfig_AuthPolicy = 1
)

var MeshConfig_AuthPolicy_name = map[int32]string{
	0: "NONE",
	1: "MUTUAL_TLS",
}

var MeshConfig_AuthPolicy_value = map[string]int32{
	"NONE":       0,
	"MUTUAL_TLS": 1,
}

func (x MeshConfig_AuthPolicy) String() string {
	return proto.EnumName(MeshConfig_AuthPolicy_name, int32(x))
}

func (MeshConfig_AuthPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 1}
}

type MeshConfig_AccessLogEncoding int32

const (
	MeshConfig_TEXT MeshConfig_AccessLogEncoding = 0
	MeshConfig_JSON MeshConfig_AccessLogEncoding = 1
)

var MeshConfig_AccessLogEncoding_name = map[int32]string{
	0: "TEXT",
	1: "JSON",
}

var MeshConfig_AccessLogEncoding_value = map[string]int32{
	"TEXT": 0,
	"JSON": 1,
}

func (x MeshConfig_AccessLogEncoding) String() string {
	return proto.EnumName(MeshConfig_AccessLogEncoding_name, int32(x))
}

func (MeshConfig_AccessLogEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 2}
}

type MeshConfig_OutboundTrafficPolicy_Mode int32

const (
	// outbound traffic will be restricted to services defined in the
	// service registry as well as those defined through ServiceEntries
	MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY MeshConfig_OutboundTrafficPolicy_Mode = 0
	// outbound traffic to unknown destinations will be allowed, in case
	// there are no services or ServiceEntries for the destination port
	MeshConfig_OutboundTrafficPolicy_ALLOW_ANY MeshConfig_OutboundTrafficPolicy_Mode = 1
)

var MeshConfig_OutboundTrafficPolicy_Mode_name = map[int32]string{
	0: "REGISTRY_ONLY",
	1: "ALLOW_ANY",
}

var MeshConfig_OutboundTrafficPolicy_Mode_value = map[string]int32{
	"REGISTRY_ONLY": 0,
	"ALLOW_ANY":     1,
}

func (x MeshConfig_OutboundTrafficPolicy_Mode) String() string {
	return proto.EnumName(MeshConfig_OutboundTrafficPolicy_Mode_name, int32(x))
}

func (MeshConfig_OutboundTrafficPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 0, 0}
}

// MeshConfig defines mesh-wide variables shared by all Envoy instances in the
// Istio service mesh.
//
// NOTE: This configuration type should be used for the low-level global
// configuration, such as component addresses and port numbers. It should not
// be used for the features of the mesh that can be scoped by service or by
// namespace. Some of the fields in the mesh config are going to be deprecated
// and replaced with several individual configuration types (for example,
// tracing configuration).
type MeshConfig struct {
	// Address of the server that will be used by the proxies for policy
	// check calls. By using different names for mixerCheckServer and
	// mixerReportServer, it is possible to have one set of Mixer servers handle
	// policy check calls while another set of Mixer servers handle telemetry
	// calls.
	//
	// NOTE: Omitting mixerCheckServer while specifying mixerReportServer is
	// equivalent to setting disablePolicyChecks to true.
	MixerCheckServer string `protobuf:"bytes,1,opt,name=mixer_check_server,json=mixerCheckServer,proto3" json:"mixer_check_server,omitempty"`
	// Address of the server that will be used by the proxies for policy report
	// calls.
	MixerReportServer string `protobuf:"bytes,2,opt,name=mixer_report_server,json=mixerReportServer,proto3" json:"mixer_report_server,omitempty"`
	// Disable policy checks by the Mixer service. Default
	// is false, i.e. Mixer policy check is enabled by default.
	DisablePolicyChecks bool `protobuf:"varint,3,opt,name=disable_policy_checks,json=disablePolicyChecks,proto3" json:"disable_policy_checks,omitempty"`
	// Allow all traffic in cases when the Mixer policy service cannot be reached.
	// Default is false which means the traffic is denied when the client is unable
	// to connect to Mixer.
	PolicyCheckFailOpen bool `protobuf:"varint,25,opt,name=policy_check_fail_open,json=policyCheckFailOpen,proto3" json:"policy_check_fail_open,omitempty"`
	// Enable session affinity for Envoy Mixer reports so that calls from a proxy will
	// always target the same Mixer instance.
	SidecarToTelemetrySessionAffinity bool `protobuf:"varint,30,opt,name=sidecar_to_telemetry_session_affinity,json=sidecarToTelemetrySessionAffinity,proto3" json:"sidecar_to_telemetry_session_affinity,omitempty"`
	// Port on which Envoy should listen for incoming connections from
	// other services.
	ProxyListenPort int32 `protobuf:"varint,4,opt,name=proxy_listen_port,json=proxyListenPort,proto3" json:"proxy_listen_port,omitempty"`
	// Port on which Envoy should listen for HTTP PROXY requests if set.
	ProxyHttpPort int32 `protobuf:"varint,5,opt,name=proxy_http_port,json=proxyHttpPort,proto3" json:"proxy_http_port,omitempty"`
	// Connection timeout used by Envoy. (MUST BE >=1ms)
	ConnectTimeout *types.Duration `protobuf:"bytes,6,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	// If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives.
	TcpKeepalive *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,28,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	// Class of ingress resources to be processed by Istio ingress
	// controller.  This corresponds to the value of
	// "kubernetes.io/ingress.class" annotation.
	IngressClass string `protobuf:"bytes,7,opt,name=ingress_class,json=ingressClass,proto3" json:"ingress_class,omitempty"`
	// Name of theKubernetes service used for the istio ingress controller.
	IngressService string `protobuf:"bytes,8,opt,name=ingress_service,json=ingressService,proto3" json:"ingress_service,omitempty"`
	// Defines whether to use Istio ingress controller for annotated or all ingress resources.
	IngressControllerMode MeshConfig_IngressControllerMode `protobuf:"varint,9,opt,name=ingress_controller_mode,json=ingressControllerMode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_IngressControllerMode" json:"ingress_controller_mode,omitempty"`
	// $hide_from_docs
	AuthPolicy MeshConfig_AuthPolicy `protobuf:"varint,10,opt,name=auth_policy,json=authPolicy,proto3,enum=istio.mesh.v1alpha1.MeshConfig_AuthPolicy" json:"auth_policy,omitempty"` // Deprecated: Do not use.
	// $hide_from_docs
	RdsRefreshDelay *types.Duration `protobuf:"bytes,11,opt,name=rds_refresh_delay,json=rdsRefreshDelay,proto3" json:"rds_refresh_delay,omitempty"` // Deprecated: Do not use.
	// Flag to control generation of trace spans and request IDs.
	// Requires a trace span collector defined in the proxy configuration.
	EnableTracing bool `protobuf:"varint,12,opt,name=enable_tracing,json=enableTracing,proto3" json:"enable_tracing,omitempty"`
	// File address for the proxy access log (e.g. /dev/stdout).
	// Empty value disables access logging.
	AccessLogFile string `protobuf:"bytes,13,opt,name=access_log_file,json=accessLogFile,proto3" json:"access_log_file,omitempty"`
	// Format for the proxy access log
	// Empty value results in proxy's default access log format
	AccessLogFormat string `protobuf:"bytes,24,opt,name=access_log_format,json=accessLogFormat,proto3" json:"access_log_format,omitempty"`
	// Encoding for the proxy access log (text or json).
	// Default value is text.
	AccessLogEncoding MeshConfig_AccessLogEncoding `protobuf:"varint,27,opt,name=access_log_encoding,json=accessLogEncoding,proto3,enum=istio.mesh.v1alpha1.MeshConfig_AccessLogEncoding" json:"access_log_encoding,omitempty"`
	// Default proxy config used by the proxy injection mechanism operating in the mesh
	// (e.g. Kubernetes admission controller)
	// In case of Kubernetes, the proxy config is applied once during the injection process,
	// and remain constant for the duration of the pod. The rest of the mesh config can be changed
	// at runtime and config gets distributed dynamically.
	DefaultConfig *ProxyConfig `protobuf:"bytes,14,opt,name=default_config,json=defaultConfig,proto3" json:"default_config,omitempty"`
	// $hide_from_docs
	MixerAddress string `protobuf:"bytes,16,opt,name=mixer_address,json=mixerAddress,proto3" json:"mixer_address,omitempty"` // Deprecated: Do not use.
	// Set the default behavior of the sidecar for handling outbound traffic
	// from the application.  If your application uses one or more external
	// services that are not known apriori, setting the policy to ALLOW_ANY
	// will cause the sidecars to route any unknown traffic originating from
	// the application to its requested destination.  Users are strongly
	// encouraged to use ServiceEntries to explicitly declare any external
	// dependencies, instead of using allow_any, so that traffic to these
	// services can be monitored.
	OutboundTrafficPolicy *MeshConfig_OutboundTrafficPolicy `protobuf:"bytes,17,opt,name=outbound_traffic_policy,json=outboundTrafficPolicy,proto3" json:"outbound_traffic_policy,omitempty"`
	// Enables clide side policy checks.
	EnableClientSidePolicyCheck bool `protobuf:"varint,19,opt,name=enable_client_side_policy_check,json=enableClientSidePolicyCheck,proto3" json:"enable_client_side_policy_check,omitempty"`
	// Unix Domain Socket through which Envoy communicates with NodeAgent SDS to get key/cert for mTLS.
	// Use secret-mount files instead of SDS if set to empty.
	SdsUdsPath string `protobuf:"bytes,20,opt,name=sds_uds_path,json=sdsUdsPath,proto3" json:"sds_uds_path,omitempty"`
	// $hide_from_docs
	SdsRefreshDelay *types.Duration `protobuf:"bytes,21,opt,name=sds_refresh_delay,json=sdsRefreshDelay,proto3" json:"sds_refresh_delay,omitempty"` // Deprecated: Do not use.
	// ConfigSource describes a source of configuration data for networking
	// rules, and other Istio configuration artifacts. Multiple data sources
	// can be configured for a single control plane.
	ConfigSources []*ConfigSource `protobuf:"bytes,22,rep,name=config_sources,json=configSources,proto3" json:"config_sources,omitempty"`
	// $hide_from_docs
	// This flag is used by secret discovery service(SDS).
	// If set to true ([prerequisite](https://kubernetes.io/docs/concepts/storage/volumes/#projected)), Istio will inject volumes mount
	// for Kubernetes service account trustworthy JWT(which is available with Kubernetes 1.12 or higher), so that the Kubernetes API server
	// mounts Kubernetes service account trustworthy JWT to the Envoy container, which will be used to request key/cert eventually.
	// This isn't supported for non-Kubernetes cases.
	EnableSdsTokenMount bool `protobuf:"varint,23,opt,name=enable_sds_token_mount,json=enableSdsTokenMount,proto3" json:"enable_sds_token_mount,omitempty"`
	// $hide_from_docs
	// This flag is used by secret discovery service(SDS).
	// If set to true, Envoy will fetch a normal Kubernetes service account JWT from '/var/run/secrets/kubernetes.io/serviceaccount/token'
	// (https://kubernetes.io/docs/tasks/access-application-cluster/access-cluster/#accessing-the-api-from-a-pod)
	// and pass to sds server, which will be used to request key/cert eventually.
	// If both enable_sds_token_mount and sds_use_k8s_sa_jwt are set to true, enable_sds_token_mount(trustworthy jwt) takes precedence.
	// This isn't supported for non-k8s case.
	SdsUseK8SSaJwt bool `protobuf:"varint,29,opt,name=sds_use_k8s_sa_jwt,json=sdsUseK8sSaJwt,proto3" json:"sds_use_k8s_sa_jwt,omitempty"`
	// The trust domain corresponds to the trust root of a system.
	// Refer to [SPIFEE-ID](https://github.com/spiffe/spiffe/blob/master/standards/SPIFFE-ID.md#21-trust-domain)
	// Fallback to old identity format(without trust domain) if not set.
	TrustDomain string `protobuf:"bytes,26,opt,name=trust_domain,json=trustDomain,proto3" json:"trust_domain,omitempty"`
	// $hide_from_docs
	// The default value for the ServiceEntry.export_to field and services
	// imported through container registry integrations, e.g. this applies to
	// Kubernetes Service resources. The value is a list of namespace names and
	// reserved namespace aliases. The allowed namespace aliases are:
	//
	// * - All Namespaces
	// . - Current Namespace
	// ~ - No Namespace
	//
	// If not set the system will use "*" as the default value which implies that
	// services are exported to all namespaces.
	//
	// 'All namespaces' is a reasonable default for implementations that don't
	// need to restrict access or visibility of services across namespace
	// boundaries. If that requirement is present it is generally good practice to
	// make the default 'Current namespace' so that services are only visible
	// within their own namespaces by default. Operators can then expand the
	// visibility of services to other namespaces as needed. Use of 'No Namespace'
	// is expected to be rare but can have utility for deployments where
	// dependency management needs to be precise even within the scope of a single
	// namespace.
	//
	// For further discussion see the reference documentation for ServiceEntry,
	// Sidecar, and Gateway.
	DefaultServiceExportTo []string `protobuf:"bytes,31,rep,name=default_service_export_to,json=defaultServiceExportTo,proto3" json:"default_service_export_to,omitempty"`
	// $hide_from_docs
	// The default value for the VirtualService.export_to field. Has the same
	// syntax as 'default_service_export_to'.
	//
	// If not set the system will use "*" as the default value which implies that
	// virtual services are exported to all namespaces
	DefaultVirtualServiceExportTo []string `protobuf:"bytes,32,rep,name=default_virtual_service_export_to,json=defaultVirtualServiceExportTo,proto3" json:"default_virtual_service_export_to,omitempty"`
	// $hide_from_docs
	// The default value for the DestinationRule.export_to field. Has the same
	// syntax as 'default_service_export_to'.
	//
	// If not set the system will use "*" as the default value which implies that
	// destination rules are exported to all namespaces
	DefaultDestinationRuleExportTo []string `protobuf:"bytes,33,rep,name=default_destination_rule_export_to,json=defaultDestinationRuleExportTo,proto3" json:"default_destination_rule_export_to,omitempty"`
	// $hide_from_docs
	// The namespace to treat as the administrative root namespace for
	// Istio configuration. When processing a leaf namespace Istio will search for
	// declarations in that namespace first and if none are found it will
	// search in the root namespace. Any matching declaration found in the root
	// namespace is processed as if it were declared in the leaf namespace.
	//
	// The precise semantics of this processing are documented on each resource
	// type.
	//
	// There is no default value for this flag in 1.1 but in later releases it
	// is expected to default to a new namespace, `istio-config`, which is
	// maintained separately from the `istio-system` namespace where an instance
	// of the control plane runtime is deployed. This separates the concerns of
	// configuring the control-plane runtime from configuration of the mesh.
	RootNamespace string `protobuf:"bytes,34,opt,name=root_namespace,json=rootNamespace,proto3" json:"root_namespace,omitempty"`
	// Locality based load balancing distribution or failover settings.
	LocalityLbSetting *LocalityLoadBalancerSetting `protobuf:"bytes,35,opt,name=locality_lb_setting,json=localityLbSetting,proto3" json:"locality_lb_setting,omitempty"`
	// Configures DNS refresh rate for Envoy clusters of type STRICT_DNS
	DnsRefreshRate       *types.Duration `protobuf:"bytes,36,opt,name=dns_refresh_rate,json=dnsRefreshRate,proto3" json:"dns_refresh_rate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *MeshConfig) Reset()         { *m = MeshConfig{} }
func (m *MeshConfig) String() string { return proto.CompactTextString(m) }
func (*MeshConfig) ProtoMessage()    {}
func (*MeshConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0}
}
func (m *MeshConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig.Merge(m, src)
}
func (m *MeshConfig) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig proto.InternalMessageInfo

func (m *MeshConfig) GetMixerCheckServer() string {
	if m != nil {
		return m.MixerCheckServer
	}
	return ""
}

func (m *MeshConfig) GetMixerReportServer() string {
	if m != nil {
		return m.MixerReportServer
	}
	return ""
}

func (m *MeshConfig) GetDisablePolicyChecks() bool {
	if m != nil {
		return m.DisablePolicyChecks
	}
	return false
}

func (m *MeshConfig) GetPolicyCheckFailOpen() bool {
	if m != nil {
		return m.PolicyCheckFailOpen
	}
	return false
}

func (m *MeshConfig) GetSidecarToTelemetrySessionAffinity() bool {
	if m != nil {
		return m.SidecarToTelemetrySessionAffinity
	}
	return false
}

func (m *MeshConfig) GetProxyListenPort() int32 {
	if m != nil {
		return m.ProxyListenPort
	}
	return 0
}

func (m *MeshConfig) GetProxyHttpPort() int32 {
	if m != nil {
		return m.ProxyHttpPort
	}
	return 0
}

func (m *MeshConfig) GetConnectTimeout() *types.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return nil
}

func (m *MeshConfig) GetTcpKeepalive() *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if m != nil {
		return m.TcpKeepalive
	}
	return nil
}

func (m *MeshConfig) GetIngressClass() string {
	if m != nil {
		return m.IngressClass
	}
	return ""
}

func (m *MeshConfig) GetIngressService() string {
	if m != nil {
		return m.IngressService
	}
	return ""
}

func (m *MeshConfig) GetIngressControllerMode() MeshConfig_IngressControllerMode {
	if m != nil {
		return m.IngressControllerMode
	}
	return MeshConfig_OFF
}

// Deprecated: Do not use.
func (m *MeshConfig) GetAuthPolicy() MeshConfig_AuthPolicy {
	if m != nil {
		return m.AuthPolicy
	}
	return MeshConfig_NONE
}

// Deprecated: Do not use.
func (m *MeshConfig) GetRdsRefreshDelay() *types.Duration {
	if m != nil {
		return m.RdsRefreshDelay
	}
	return nil
}

func (m *MeshConfig) GetEnableTracing() bool {
	if m != nil {
		return m.EnableTracing
	}
	return false
}

func (m *MeshConfig) GetAccessLogFile() string {
	if m != nil {
		return m.AccessLogFile
	}
	return ""
}

func (m *MeshConfig) GetAccessLogFormat() string {
	if m != nil {
		return m.AccessLogFormat
	}
	return ""
}

func (m *MeshConfig) GetAccessLogEncoding() MeshConfig_AccessLogEncoding {
	if m != nil {
		return m.AccessLogEncoding
	}
	return MeshConfig_TEXT
}

func (m *MeshConfig) GetDefaultConfig() *ProxyConfig {
	if m != nil {
		return m.DefaultConfig
	}
	return nil
}

// Deprecated: Do not use.
func (m *MeshConfig) GetMixerAddress() string {
	if m != nil {
		return m.MixerAddress
	}
	return ""
}

func (m *MeshConfig) GetOutboundTrafficPolicy() *MeshConfig_OutboundTrafficPolicy {
	if m != nil {
		return m.OutboundTrafficPolicy
	}
	return nil
}

func (m *MeshConfig) GetEnableClientSidePolicyCheck() bool {
	if m != nil {
		return m.EnableClientSidePolicyCheck
	}
	return false
}

func (m *MeshConfig) GetSdsUdsPath() string {
	if m != nil {
		return m.SdsUdsPath
	}
	return ""
}

// Deprecated: Do not use.
func (m *MeshConfig) GetSdsRefreshDelay() *types.Duration {
	if m != nil {
		return m.SdsRefreshDelay
	}
	return nil
}

func (m *MeshConfig) GetConfigSources() []*ConfigSource {
	if m != nil {
		return m.ConfigSources
	}
	return nil
}

func (m *MeshConfig) GetEnableSdsTokenMount() bool {
	if m != nil {
		return m.EnableSdsTokenMount
	}
	return false
}

func (m *MeshConfig) GetSdsUseK8SSaJwt() bool {
	if m != nil {
		return m.SdsUseK8SSaJwt
	}
	return false
}

func (m *MeshConfig) GetTrustDomain() string {
	if m != nil {
		return m.TrustDomain
	}
	return ""
}

func (m *MeshConfig) GetDefaultServiceExportTo() []string {
	if m != nil {
		return m.DefaultServiceExportTo
	}
	return nil
}

func (m *MeshConfig) GetDefaultVirtualServiceExportTo() []string {
	if m != nil {
		return m.DefaultVirtualServiceExportTo
	}
	return nil
}

func (m *MeshConfig) GetDefaultDestinationRuleExportTo() []string {
	if m != nil {
		return m.DefaultDestinationRuleExportTo
	}
	return nil
}

func (m *MeshConfig) GetRootNamespace() string {
	if m != nil {
		return m.RootNamespace
	}
	return ""
}

func (m *MeshConfig) GetLocalityLbSetting() *LocalityLoadBalancerSetting {
	if m != nil {
		return m.LocalityLbSetting
	}
	return nil
}

func (m *MeshConfig) GetDnsRefreshRate() *types.Duration {
	if m != nil {
		return m.DnsRefreshRate
	}
	return nil
}

type MeshConfig_OutboundTrafficPolicy struct {
	Mode                 MeshConfig_OutboundTrafficPolicy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_OutboundTrafficPolicy_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *MeshConfig_OutboundTrafficPolicy) Reset()         { *m = MeshConfig_OutboundTrafficPolicy{} }
func (m *MeshConfig_OutboundTrafficPolicy) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_OutboundTrafficPolicy) ProtoMessage()    {}
func (*MeshConfig_OutboundTrafficPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{0, 0}
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshConfig_OutboundTrafficPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshConfig_OutboundTrafficPolicy.Merge(m, src)
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_Size() int {
	return m.Size()
}
func (m *MeshConfig_OutboundTrafficPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshConfig_OutboundTrafficPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MeshConfig_OutboundTrafficPolicy proto.InternalMessageInfo

func (m *MeshConfig_OutboundTrafficPolicy) GetMode() MeshConfig_OutboundTrafficPolicy_Mode {
	if m != nil {
		return m.Mode
	}
	return MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY
}

// ConfigSource describes information about a configuration store inside a
// mesh. A single control plane instance can interact with one or more data
// sources.
type ConfigSource struct {
	// Address of the server implementing the Istio Mesh Configuration
	// protocol (MCP). Can be IP address or a fully qualified DNS name.
	// Use fs:/// to specify a file-based backend with absolute path to the directory.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the tls_settings to specify the tls mode to use. If the MCP server
	// uses Istio mutual TLS and shares the root CA with Pilot, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings          *v1alpha3.TLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tls_settings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ConfigSource) Reset()         { *m = ConfigSource{} }
func (m *ConfigSource) String() string { return proto.CompactTextString(m) }
func (*ConfigSource) ProtoMessage()    {}
func (*ConfigSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{1}
}
func (m *ConfigSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSource.Merge(m, src)
}
func (m *ConfigSource) XXX_Size() int {
	return m.Size()
}
func (m *ConfigSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSource.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSource proto.InternalMessageInfo

func (m *ConfigSource) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *ConfigSource) GetTlsSettings() *v1alpha3.TLSSettings {
	if m != nil {
		return m.TlsSettings
	}
	return nil
}

// Locality-weighted load balancing allows administrators to control the
// distribution of traffic to endpoints based on the localities of where the
// traffic originates and where it will terminate. These localities are
// specified using arbitrary labels that designate a hierarchy of localities in
// {region}/{zone}/{sub-zone} form. For additional detail refer to
// [Locality Weight](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/load_balancing/locality_weight)
// The following example shows how to setup locality weights mesh-wide.
//
// Given a mesh with workloads and their service deployed to "us-west/zone1/*"
// and "us-west/zone2/*". This example specifies that when traffic accessing a
// service originates from workloads in "us-west/zone1/*", 80% of the traffic
// will be sent to endpoints in "us-west/zone1/*", i.e the same zone, and the
// remaining 20% will go to endpoints in "us-west/zone2/*". This setup is
// intended to favor routing traffic to endpoints in the same locality.
// A similar setting is specified for traffic originating in "us-west/zone2/*".
//
// ```yaml
//   distribute:
//     - from: us-west/zone1/*
//       to:
//         "us-west/zone1/*": 80
//         "us-west/zone2/*": 20
//     - from: us-west/zone2/*
//       to:
//         "us-west/zone1/*": 20
//         "us-west/zone2/*": 80
// ```
//
// If the goal of the operator is not to distribute load across zones and
// regions but rather to restrict the regionality of failover to meet other
// operational requirements an operator can set a 'failover' policy instead of
// a 'distribute' policy.
//
// The following example sets up a locality failover policy for regions.
// Assume a service resides in zones within us-east, us-west & eu-west
// this example specifies that when endpoints within us-east become unhealthy
// traffic should failover to endpoints in any zone or sub-zone within eu-west
// and similarly us-west should failover to us-east.
//
// ```yaml
//  failover:
//    - from: us-east
//      to: eu-west
//    - from: us-west
//      to: us-east
// ```
// Locality load balancing settings.
type LocalityLoadBalancerSetting struct {
	// Optional: only one of distribute or failover can be set.
	// Explicitly specify loadbalancing weight across different zones and geographical locations.
	// Refer to [Locality weighted load balancing](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/load_balancing/locality_weight)
	// If empty, the locality weight is set according to the endpoints number within it.
	Distribute []*LocalityLoadBalancerSetting_Distribute `protobuf:"bytes,1,rep,name=distribute,proto3" json:"distribute,omitempty"`
	// Optional: only failover or distribute can be set.
	// Explicitly specify the region traffic will land on when endpoints in local region becomes unhealthy.
	// Should be used together with OutlierDetection to detect unhealthy endpoints.
	// Note: if no OutlierDetection specified, this will not take effect.
	Failover             []*LocalityLoadBalancerSetting_Failover `protobuf:"bytes,2,rep,name=failover,proto3" json:"failover,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *LocalityLoadBalancerSetting) Reset()         { *m = LocalityLoadBalancerSetting{} }
func (m *LocalityLoadBalancerSetting) String() string { return proto.CompactTextString(m) }
func (*LocalityLoadBalancerSetting) ProtoMessage()    {}
func (*LocalityLoadBalancerSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{2}
}
func (m *LocalityLoadBalancerSetting) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalityLoadBalancerSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalityLoadBalancerSetting.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalityLoadBalancerSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalityLoadBalancerSetting.Merge(m, src)
}
func (m *LocalityLoadBalancerSetting) XXX_Size() int {
	return m.Size()
}
func (m *LocalityLoadBalancerSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalityLoadBalancerSetting.DiscardUnknown(m)
}

var xxx_messageInfo_LocalityLoadBalancerSetting proto.InternalMessageInfo

func (m *LocalityLoadBalancerSetting) GetDistribute() []*LocalityLoadBalancerSetting_Distribute {
	if m != nil {
		return m.Distribute
	}
	return nil
}

func (m *LocalityLoadBalancerSetting) GetFailover() []*LocalityLoadBalancerSetting_Failover {
	if m != nil {
		return m.Failover
	}
	return nil
}

// Describes how traffic originating in the 'from' zone or sub-zone is
// distributed over a set of 'to' zones. Syntax for specifying a zone is
// {region}/{zone}/{sub-zone} and terminal wildcards are allowed on any
// segment of the specification. Examples:
// * - matches all localities
// us-west/* - all zones and sub-zones within the us-west region
// us-west/zone-1/* - all sub-zones within us-west/zone-1
type LocalityLoadBalancerSetting_Distribute struct {
	// Originating locality, '/' separated, e.g. 'region/zone/sub_zone'.
	From string `protobuf:"bytes,1,opt,name=from,proto3" json:"from,omitempty"`
	// Map of upstream localities to traffic distribution weights. The sum of
	// all weights should be == 100. Any locality not assigned a weight will
	// receive no traffic.
	To                   map[string]uint32 `protobuf:"bytes,2,rep,name=to,proto3" json:"to,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LocalityLoadBalancerSetting_Distribute) Reset() {
	*m = LocalityLoadBalancerSetting_Distribute{}
}
func (m *LocalityLoadBalancerSetting_Distribute) String() string { return proto.CompactTextString(m) }
func (*LocalityLoadBalancerSetting_Distribute) ProtoMessage()    {}
func (*LocalityLoadBalancerSetting_Distribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{2, 0}
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalityLoadBalancerSetting_Distribute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalityLoadBalancerSetting_Distribute.Merge(m, src)
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Size() int {
	return m.Size()
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalityLoadBalancerSetting_Distribute.DiscardUnknown(m)
}

var xxx_messageInfo_LocalityLoadBalancerSetting_Distribute proto.InternalMessageInfo

func (m *LocalityLoadBalancerSetting_Distribute) GetFrom() string {
	if m != nil {
		return m.From
	}
	return ""
}

func (m *LocalityLoadBalancerSetting_Distribute) GetTo() map[string]uint32 {
	if m != nil {
		return m.To
	}
	return nil
}

// Specify the traffic failover policy across regions. Since zone and sub-zone
// failover is supported by default this only needs to be specified for
// regions when the operator needs to constrain traffic failover so that
// the default behavior of failing over to any endpoint globally does not
// apply. This is useful when failing over traffic across regions would not
// improve service health or may need to be restricted for other reasons
// like regulatory controls.
type LocalityLoadBalancerSetting_Failover struct {
	// Originating region.
	From string `protobuf:"bytes,1,opt,name=from,proto3" json:"from,omitempty"`
	// Destination region the traffic will fail over to when endpoints in
	// the 'from' region becomes unhealthy.
	To                   string   `protobuf:"bytes,2,opt,name=to,proto3" json:"to,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocalityLoadBalancerSetting_Failover) Reset()         { *m = LocalityLoadBalancerSetting_Failover{} }
func (m *LocalityLoadBalancerSetting_Failover) String() string { return proto.CompactTextString(m) }
func (*LocalityLoadBalancerSetting_Failover) ProtoMessage()    {}
func (*LocalityLoadBalancerSetting_Failover) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5c7ece76d5d5022, []int{2, 1}
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalityLoadBalancerSetting_Failover.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalityLoadBalancerSetting_Failover.Merge(m, src)
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Size() int {
	return m.Size()
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalityLoadBalancerSetting_Failover.DiscardUnknown(m)
}

var xxx_messageInfo_LocalityLoadBalancerSetting_Failover proto.InternalMessageInfo

func (m *LocalityLoadBalancerSetting_Failover) GetFrom() string {
	if m != nil {
		return m.From
	}
	return ""
}

func (m *LocalityLoadBalancerSetting_Failover) GetTo() string {
	if m != nil {
		return m.To
	}
	return ""
}

func init() {
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_IngressControllerMode", MeshConfig_IngressControllerMode_name, MeshConfig_IngressControllerMode_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_AuthPolicy", MeshConfig_AuthPolicy_name, MeshConfig_AuthPolicy_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_AccessLogEncoding", MeshConfig_AccessLogEncoding_name, MeshConfig_AccessLogEncoding_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_OutboundTrafficPolicy_Mode", MeshConfig_OutboundTrafficPolicy_Mode_name, MeshConfig_OutboundTrafficPolicy_Mode_value)
	proto.RegisterType((*MeshConfig)(nil), "istio.mesh.v1alpha1.MeshConfig")
	proto.RegisterType((*MeshConfig_OutboundTrafficPolicy)(nil), "istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy")
	proto.RegisterType((*ConfigSource)(nil), "istio.mesh.v1alpha1.ConfigSource")
	proto.RegisterType((*LocalityLoadBalancerSetting)(nil), "istio.mesh.v1alpha1.LocalityLoadBalancerSetting")
	proto.RegisterType((*LocalityLoadBalancerSetting_Distribute)(nil), "istio.mesh.v1alpha1.LocalityLoadBalancerSetting.Distribute")
	proto.RegisterMapType((map[string]uint32)(nil), "istio.mesh.v1alpha1.LocalityLoadBalancerSetting.Distribute.ToEntry")
	proto.RegisterType((*LocalityLoadBalancerSetting_Failover)(nil), "istio.mesh.v1alpha1.LocalityLoadBalancerSetting.Failover")
}

func init() { proto.RegisterFile("mesh/v1alpha1/config.proto", fileDescriptor_b5c7ece76d5d5022) }

var fileDescriptor_b5c7ece76d5d5022 = []byte{
	// 1482 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0xdd, 0x72, 0xdb, 0xb8,
	0x15, 0x0e, 0x65, 0x25, 0x96, 0x8f, 0x7e, 0x4c, 0x41, 0x71, 0x96, 0x56, 0xba, 0x5e, 0x59, 0xdb,
	0x24, 0x1a, 0x4f, 0x87, 0x6e, 0xec, 0xd9, 0x99, 0x64, 0x7b, 0x65, 0x4b, 0xf2, 0xc6, 0x5e, 0xd9,
	0xf2, 0x50, 0x74, 0xda, 0xb4, 0x17, 0x28, 0x4c, 0x42, 0x12, 0x6a, 0x8a, 0xe0, 0x10, 0xa0, 0x13,
	0xbd, 0x53, 0xdb, 0xe9, 0x63, 0xf4, 0xb2, 0x8f, 0xd0, 0xc9, 0x93, 0x74, 0x08, 0x90, 0x96, 0xe2,
	0xd5, 0xac, 0xbb, 0xed, 0x9d, 0xf0, 0x9d, 0xef, 0x7c, 0x20, 0xce, 0xf9, 0x70, 0x48, 0x41, 0x73,
	0x46, 0xc5, 0x74, 0xff, 0xf6, 0x35, 0x09, 0xa2, 0x29, 0x79, 0xbd, 0xef, 0xf1, 0x70, 0xcc, 0x26,
	0x76, 0x14, 0x73, 0xc9, 0x51, 0x83, 0x09, 0xc9, 0xb8, 0x9d, 0x32, 0xec, 0x9c, 0xd1, 0xdc, 0x99,
	0x70, 0x3e, 0x09, 0xe8, 0xbe, 0xa2, 0x5c, 0x27, 0xe3, 0x7d, 0x3f, 0x89, 0x89, 0x64, 0x3c, 0xd4,
	0x49, 0xcd, 0xed, 0x2f, 0x05, 0xa3, 0x98, 0x7f, 0x9a, 0x67, 0xa1, 0xbd, 0x90, 0xca, 0x8f, 0x3c,
	0xbe, 0x61, 0xe1, 0x24, 0x27, 0x1c, 0xee, 0xfb, 0x54, 0x48, 0x16, 0x2a, 0x05, 0x1c, 0x27, 0x01,
	0xd5, 0xdc, 0xf6, 0xdf, 0x1b, 0x00, 0xe7, 0x54, 0x4c, 0xbb, 0xea, 0x81, 0xd0, 0x6f, 0x00, 0xcd,
	0xd8, 0x27, 0x1a, 0x63, 0x6f, 0x4a, 0xbd, 0x1b, 0x2c, 0x68, 0x7c, 0x4b, 0x63, 0xcb, 0x68, 0x19,
	0x9d, 0x0d, 0xc7, 0x54, 0x91, 0x6e, 0x1a, 0x18, 0x29, 0x1c, 0xd9, 0xd0, 0xd0, 0xec, 0x98, 0x46,
	0x3c, 0x96, 0x39, 0xbd, 0xa0, 0xe8, 0x75, 0x15, 0x72, 0x54, 0x24, 0xe3, 0x1f, 0xc0, 0x96, 0xcf,
	0x04, 0xb9, 0x0e, 0x28, 0x8e, 0x78, 0xc0, 0xbc, 0xb9, 0xde, 0x46, 0x58, 0x6b, 0x2d, 0xa3, 0x53,
	0x72, 0x1a, 0x59, 0xf0, 0x52, 0xc5, 0xd4, 0x46, 0x02, 0x1d, 0xc2, 0xb3, 0x65, 0x2e, 0x1e, 0x13,
	0x16, 0x60, 0x1e, 0xd1, 0xd0, 0xda, 0xd6, 0x49, 0xd1, 0x82, 0x7d, 0x42, 0x58, 0x30, 0x8c, 0x68,
	0x88, 0x2e, 0xe1, 0x85, 0x60, 0x3e, 0xf5, 0x48, 0x8c, 0x25, 0xc7, 0x92, 0x06, 0x74, 0x46, 0x65,
	0x3c, 0xc7, 0x82, 0x0a, 0x91, 0x16, 0x80, 0x8c, 0xc7, 0x2c, 0x64, 0x72, 0x6e, 0xed, 0x28, 0x8d,
	0xdd, 0x8c, 0xec, 0x72, 0x37, 0xa7, 0x8e, 0x34, 0xf3, 0x28, 0x23, 0xa2, 0x3d, 0xa8, 0xab, 0x12,
	0xe3, 0x80, 0x09, 0x49, 0x43, 0x9c, 0x9e, 0xca, 0x2a, 0xb6, 0x8c, 0xce, 0x63, 0x67, 0x53, 0x05,
	0x06, 0x0a, 0xbf, 0xe4, 0xb1, 0x44, 0x2f, 0x41, 0x43, 0x78, 0x2a, 0x65, 0xa4, 0x99, 0x8f, 0x15,
	0xb3, 0xaa, 0xe0, 0x77, 0x52, 0x46, 0x8a, 0x77, 0x0c, 0x9b, 0x1e, 0x0f, 0x43, 0xea, 0x49, 0x2c,
	0xd9, 0x8c, 0xf2, 0x44, 0x5a, 0x4f, 0x5a, 0x46, 0xa7, 0x7c, 0xb0, 0x6d, 0xeb, 0xe6, 0xdb, 0x79,
	0xf3, 0xed, 0x5e, 0xd6, 0x7c, 0xa7, 0x96, 0x65, 0xb8, 0x3a, 0x01, 0x71, 0xa8, 0x4a, 0x2f, 0xc2,
	0x37, 0x94, 0x46, 0x24, 0x60, 0xb7, 0xd4, 0xfa, 0x95, 0x52, 0x38, 0xb3, 0xb5, 0xa7, 0x16, 0x4e,
	0xc8, 0x9d, 0x75, 0x68, 0x77, 0xb5, 0x02, 0xe3, 0xe1, 0x25, 0xe7, 0xc1, 0x88, 0x4a, 0xc9, 0xc2,
	0x89, 0xb0, 0xdd, 0xee, 0xe5, 0xe2, 0xb7, 0x17, 0xfd, 0x98, 0x2b, 0x3a, 0x15, 0xb9, 0xb4, 0x42,
	0xdf, 0x42, 0x95, 0x85, 0x93, 0x98, 0x0a, 0x81, 0xbd, 0x80, 0x08, 0x61, 0xad, 0xab, 0x6e, 0x57,
	0x32, 0xb0, 0x9b, 0x62, 0xe8, 0x15, 0x6c, 0xe6, 0xa4, 0xd4, 0x13, 0xcc, 0xa3, 0x56, 0x49, 0xd1,
	0x6a, 0x19, 0x3c, 0xd2, 0x28, 0x9a, 0xc1, 0x57, 0x77, 0x6a, 0x3c, 0x94, 0x31, 0x0f, 0x02, 0x1a,
	0xe3, 0x19, 0xf7, 0xa9, 0xb5, 0xd1, 0x32, 0x3a, 0xb5, 0x83, 0xef, 0xec, 0x15, 0x97, 0xc3, 0x5e,
	0x38, 0xd6, 0x3e, 0xcd, 0xf6, 0xbd, 0xcb, 0x3e, 0xe7, 0x3e, 0x75, 0xb6, 0xd8, 0x2a, 0x18, 0x0d,
	0xa1, 0x4c, 0x12, 0x39, 0xcd, 0xdc, 0x67, 0x81, 0xda, 0x62, 0xef, 0xa1, 0x2d, 0x8e, 0x12, 0x39,
	0xd5, 0x9e, 0x3c, 0x2e, 0x58, 0x86, 0x03, 0xe4, 0x6e, 0x8d, 0x4e, 0xa1, 0x1e, 0xfb, 0x02, 0xc7,
	0x74, 0x1c, 0x53, 0x31, 0xc5, 0x3e, 0x0d, 0xc8, 0xdc, 0x2a, 0x3f, 0xd0, 0x44, 0xa5, 0xb2, 0x19,
	0xfb, 0xc2, 0xd1, 0x69, 0xbd, 0x34, 0x0b, 0xbd, 0x80, 0x1a, 0x0d, 0xd5, 0xdd, 0x90, 0x31, 0xf1,
	0x58, 0x38, 0xb1, 0x2a, 0xca, 0x9c, 0x55, 0x8d, 0xba, 0x1a, 0x4c, 0xcd, 0x45, 0x3c, 0x2f, 0x2d,
	0x58, 0xc0, 0x27, 0x78, 0xcc, 0x02, 0x6a, 0x55, 0x55, 0x69, 0xab, 0x1a, 0x1e, 0xf0, 0xc9, 0x09,
	0x0b, 0x68, 0x6a, 0xd8, 0x65, 0x1e, 0x8f, 0x67, 0x44, 0x5a, 0x96, 0x62, 0x6e, 0x2e, 0x98, 0x0a,
	0x46, 0x04, 0x1a, 0x4b, 0x5c, 0x1a, 0x7a, 0xdc, 0x4f, 0xf7, 0x7f, 0xae, 0xca, 0xf3, 0xfa, 0xc1,
	0xf2, 0xe4, 0x6a, 0xfd, 0x2c, 0xd1, 0xa9, 0x93, 0xfb, 0x10, 0xfa, 0x01, 0x6a, 0x3e, 0x1d, 0x93,
	0x24, 0x90, 0x58, 0xcf, 0x3e, 0xab, 0xa6, 0xaa, 0xd4, 0x5a, 0xa9, 0x7e, 0x99, 0xde, 0x13, 0x2d,
	0xef, 0x54, 0xb3, 0xbc, 0x6c, 0x42, 0xbd, 0x82, 0xaa, 0x9e, 0x39, 0xc4, 0xf7, 0xd3, 0x0e, 0x5b,
	0x66, 0x7a, 0x26, 0x55, 0xd2, 0x8a, 0x0a, 0x1c, 0x69, 0x3c, 0xb5, 0x16, 0x4f, 0xe4, 0x35, 0x4f,
	0x42, 0x3f, 0xad, 0xe8, 0x78, 0xcc, 0xbc, 0xbc, 0xef, 0x75, 0xb5, 0xf5, 0x83, 0xd6, 0x1a, 0x66,
	0xe9, 0xae, 0xce, 0xd6, 0x2d, 0x77, 0xb6, 0xf8, 0x2a, 0x18, 0xf5, 0xe0, 0x9b, 0xac, 0x7d, 0x5e,
	0xc0, 0x68, 0x28, 0x71, 0x3a, 0x53, 0xbe, 0x18, 0x73, 0x56, 0x43, 0xf5, 0xf3, 0xb9, 0xa6, 0x75,
	0x15, 0x6b, 0xc4, 0xfc, 0xe5, 0x71, 0x87, 0x5a, 0x50, 0x11, 0xbe, 0xc0, 0x89, 0x2f, 0x70, 0x44,
	0xe4, 0xd4, 0x7a, 0xaa, 0x1a, 0x06, 0xc2, 0x17, 0x57, 0xbe, 0xb8, 0x24, 0x72, 0x9a, 0x3a, 0x4e,
	0xfc, 0xc4, 0x71, 0x5b, 0xff, 0x95, 0xe3, 0xc4, 0x3d, 0xc7, 0xbd, 0x83, 0x9a, 0xee, 0x05, 0x16,
	0x3c, 0x89, 0x3d, 0x2a, 0xac, 0x67, 0xad, 0xb5, 0x4e, 0xf9, 0x60, 0x77, 0x65, 0x61, 0x74, 0x51,
	0x46, 0x8a, 0xe9, 0x54, 0xbd, 0xa5, 0x95, 0x1a, 0xd2, 0xd9, 0xe1, 0xd3, 0x67, 0x93, 0xfc, 0x86,
	0x86, 0x78, 0xc6, 0x93, 0x50, 0x5a, 0x5f, 0xe9, 0x21, 0xad, 0xa3, 0x23, 0x5f, 0xb8, 0x69, 0xec,
	0x3c, 0x0d, 0xa1, 0x3d, 0x40, 0xea, 0xac, 0x82, 0xe2, 0x9b, 0x37, 0x02, 0x0b, 0x82, 0xff, 0xf2,
	0x51, 0x5a, 0x5f, 0xab, 0x84, 0x5a, 0x7a, 0x62, 0x41, 0x7f, 0x7c, 0x23, 0x46, 0xe4, 0xec, 0xa3,
	0x44, 0xbb, 0x50, 0x91, 0x71, 0x22, 0x24, 0xf6, 0xf9, 0x8c, 0xb0, 0xd0, 0x6a, 0xaa, 0xba, 0x94,
	0x15, 0xd6, 0x53, 0x10, 0x7a, 0x0b, 0xdb, 0xb9, 0xc3, 0xb2, 0x99, 0x83, 0xe9, 0x27, 0xf5, 0x5a,
	0x92, 0xdc, 0xfa, 0xa6, 0xb5, 0xd6, 0xd9, 0x70, 0x9e, 0x65, 0x84, 0x6c, 0xfa, 0xf4, 0x55, 0xd8,
	0xe5, 0xe8, 0x1d, 0xec, 0xe6, 0xa9, 0xb7, 0x2c, 0x96, 0x09, 0x09, 0x56, 0x48, 0xb4, 0x94, 0xc4,
	0xd7, 0x19, 0xf1, 0xbd, 0xe6, 0xdd, 0x57, 0x3a, 0x83, 0x76, 0xae, 0x74, 0xff, 0x85, 0xbb, 0x24,
	0xb5, 0xab, 0xa4, 0x76, 0x32, 0x66, 0x6f, 0x41, 0x74, 0x92, 0x60, 0xa1, 0xf5, 0x02, 0x6a, 0x31,
	0xe7, 0x12, 0x87, 0x64, 0x46, 0x45, 0x44, 0x3c, 0x6a, 0xb5, 0xf5, 0x45, 0x4f, 0xd1, 0x8b, 0x1c,
	0x44, 0x7f, 0x86, 0x46, 0xc0, 0x3d, 0x12, 0x30, 0x39, 0xc7, 0xc1, 0x35, 0x16, 0x7a, 0x86, 0x5b,
	0xdf, 0x2a, 0x4b, 0xfc, 0x76, 0x65, 0x2b, 0x07, 0x19, 0x7f, 0xc0, 0x89, 0x7f, 0x4c, 0x02, 0x12,
	0x7a, 0x34, 0xce, 0x66, 0xbf, 0x53, 0xcf, 0xc5, 0x06, 0xd7, 0x19, 0x84, 0xba, 0x60, 0xfa, 0xe1,
	0xc2, 0x72, 0x31, 0x91, 0xd4, 0xfa, 0xf5, 0x83, 0x2f, 0x2a, 0x3f, 0xcc, 0xdd, 0xe6, 0x10, 0x49,
	0x9b, 0x7f, 0x33, 0x60, 0x6b, 0xe5, 0x85, 0x42, 0x17, 0x50, 0x54, 0x03, 0xdf, 0x50, 0xe3, 0xe6,
	0xfb, 0xff, 0xe9, 0x56, 0xda, 0x6a, 0xea, 0x2b, 0x9d, 0x76, 0x0f, 0x8a, 0x6a, 0xd8, 0xd7, 0xa1,
	0xea, 0xf4, 0x7f, 0x38, 0x1d, 0xb9, 0xce, 0x07, 0x3c, 0xbc, 0x18, 0x7c, 0x30, 0x1f, 0xa1, 0x2a,
	0x6c, 0x1c, 0x0d, 0x06, 0xc3, 0xdf, 0xe3, 0xa3, 0x8b, 0x0f, 0xa6, 0xd1, 0x2e, 0x96, 0x0a, 0x66,
	0x61, 0xef, 0xe9, 0xfb, 0x53, 0xc7, 0xbd, 0x3a, 0x1a, 0xe0, 0x51, 0xdf, 0x79, 0x7f, 0xda, 0xed,
	0x2b, 0x72, 0xfb, 0x2d, 0x6c, 0xad, 0x7c, 0xb5, 0xa0, 0x75, 0x58, 0x1b, 0x9e, 0x9c, 0x98, 0x8f,
	0x50, 0x19, 0xd6, 0x7b, 0xfd, 0x93, 0xa3, 0xab, 0x81, 0x6b, 0x1a, 0x08, 0xe0, 0xc9, 0xc8, 0x75,
	0x4e, 0xbb, 0xae, 0x59, 0x68, 0xbf, 0x04, 0x58, 0xbc, 0x32, 0x50, 0x09, 0x8a, 0x17, 0xc3, 0x8b,
	0xbe, 0xf9, 0x08, 0xd5, 0x00, 0xce, 0xaf, 0xd4, 0x4e, 0xee, 0x60, 0x64, 0x1a, 0xed, 0x57, 0x50,
	0xff, 0xc9, 0xec, 0x4c, 0xe9, 0x6e, 0xff, 0x0f, 0xae, 0xf9, 0x28, 0xfd, 0x75, 0x36, 0x1a, 0x5e,
	0x98, 0xc6, 0x59, 0xb1, 0xb4, 0x69, 0x9a, 0x67, 0xc5, 0x12, 0x32, 0x1b, 0x6d, 0x01, 0x95, 0xe5,
	0x9b, 0x88, 0x2c, 0x58, 0xcf, 0x27, 0xa1, 0xfe, 0x4c, 0xcb, 0x97, 0xe8, 0x14, 0x2a, 0x32, 0x10,
	0xb9, 0x21, 0x84, 0xfa, 0x2c, 0x2b, 0x1f, 0xbc, 0xfc, 0x99, 0x2f, 0x03, 0x77, 0x30, 0xca, 0x3f,
	0x01, 0x9c, 0xb2, 0x0c, 0x44, 0xbe, 0x68, 0xff, 0x63, 0x0d, 0x9e, 0xff, 0x8c, 0x69, 0xd0, 0x9f,
	0x00, 0x7c, 0x26, 0x64, 0xcc, 0xae, 0x13, 0x99, 0x36, 0x32, 0x9d, 0x22, 0xbf, 0xfb, 0xa5, 0xd6,
	0xb3, 0x7b, 0x77, 0x12, 0xce, 0x92, 0x1c, 0xba, 0x82, 0x52, 0xfa, 0xd1, 0xc7, 0xf5, 0xa7, 0x65,
	0x2a, 0xfd, 0xf6, 0x17, 0x4b, 0x9f, 0x64, 0x02, 0xce, 0x9d, 0x54, 0xf3, 0xaf, 0x06, 0xc0, 0x62,
	0x47, 0x84, 0xa0, 0x38, 0x8e, 0xf9, 0x2c, 0x2b, 0xa2, 0xfa, 0x8d, 0x46, 0x50, 0x90, 0x3c, 0xdb,
	0xb3, 0xfb, 0x7f, 0x1c, 0xc7, 0x76, 0x79, 0x3f, 0x94, 0xf1, 0xdc, 0x29, 0x48, 0xde, 0xfc, 0x0e,
	0xd6, 0xb3, 0x25, 0x32, 0x61, 0xed, 0x86, 0xce, 0xb3, 0x2d, 0xd3, 0x9f, 0xe8, 0x29, 0x3c, 0xbe,
	0x25, 0x41, 0x42, 0x55, 0xb3, 0xaa, 0x8e, 0x5e, 0x7c, 0x5f, 0x78, 0x63, 0x34, 0x6d, 0x28, 0xe5,
	0x87, 0x58, 0xf9, 0xac, 0xb5, 0xec, 0x59, 0x53, 0xa4, 0x20, 0xf9, 0x71, 0xe7, 0x9f, 0x9f, 0x77,
	0x8c, 0x7f, 0x7d, 0xde, 0x31, 0xfe, 0xfd, 0x79, 0xc7, 0xf8, 0x63, 0x53, 0x3f, 0x3c, 0xe3, 0xfb,
	0x24, 0x62, 0xfb, 0x5f, 0xfc, 0x75, 0xb8, 0x7e, 0xa2, 0x2e, 0xef, 0xe1, 0x7f, 0x02, 0x00, 0x00,
	0xff, 0xff, 0x33, 0x88, 0x4e, 0x58, 0xa3, 0x0c, 0x00, 0x00,
}

func (m *MeshConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.MixerCheckServer) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.MixerCheckServer)))
		i += copy(dAtA[i:], m.MixerCheckServer)
	}
	if len(m.MixerReportServer) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.MixerReportServer)))
		i += copy(dAtA[i:], m.MixerReportServer)
	}
	if m.DisablePolicyChecks {
		dAtA[i] = 0x18
		i++
		if m.DisablePolicyChecks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ProxyListenPort != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ProxyListenPort))
	}
	if m.ProxyHttpPort != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ProxyHttpPort))
	}
	if m.ConnectTimeout != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ConnectTimeout.Size()))
		n1, err := m.ConnectTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.IngressClass) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngressClass)))
		i += copy(dAtA[i:], m.IngressClass)
	}
	if len(m.IngressService) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngressService)))
		i += copy(dAtA[i:], m.IngressService)
	}
	if m.IngressControllerMode != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.IngressControllerMode))
	}
	if m.AuthPolicy != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.AuthPolicy))
	}
	if m.RdsRefreshDelay != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.RdsRefreshDelay.Size()))
		n2, err := m.RdsRefreshDelay.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.EnableTracing {
		dAtA[i] = 0x60
		i++
		if m.EnableTracing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.AccessLogFile) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AccessLogFile)))
		i += copy(dAtA[i:], m.AccessLogFile)
	}
	if m.DefaultConfig != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.DefaultConfig.Size()))
		n3, err := m.DefaultConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.MixerAddress) > 0 {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.MixerAddress)))
		i += copy(dAtA[i:], m.MixerAddress)
	}
	if m.OutboundTrafficPolicy != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.OutboundTrafficPolicy.Size()))
		n4, err := m.OutboundTrafficPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.EnableClientSidePolicyCheck {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		if m.EnableClientSidePolicyCheck {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.SdsUdsPath) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.SdsUdsPath)))
		i += copy(dAtA[i:], m.SdsUdsPath)
	}
	if m.SdsRefreshDelay != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.SdsRefreshDelay.Size()))
		n5, err := m.SdsRefreshDelay.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.ConfigSources) > 0 {
		for _, msg := range m.ConfigSources {
			dAtA[i] = 0xb2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.EnableSdsTokenMount {
		dAtA[i] = 0xb8
		i++
		dAtA[i] = 0x1
		i++
		if m.EnableSdsTokenMount {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.AccessLogFormat) > 0 {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AccessLogFormat)))
		i += copy(dAtA[i:], m.AccessLogFormat)
	}
	if m.PolicyCheckFailOpen {
		dAtA[i] = 0xc8
		i++
		dAtA[i] = 0x1
		i++
		if m.PolicyCheckFailOpen {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.TrustDomain) > 0 {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.TrustDomain)))
		i += copy(dAtA[i:], m.TrustDomain)
	}
	if m.AccessLogEncoding != 0 {
		dAtA[i] = 0xd8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.AccessLogEncoding))
	}
	if m.TcpKeepalive != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.TcpKeepalive.Size()))
		n6, err := m.TcpKeepalive.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.SdsUseK8SSaJwt {
		dAtA[i] = 0xe8
		i++
		dAtA[i] = 0x1
		i++
		if m.SdsUseK8SSaJwt {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SidecarToTelemetrySessionAffinity {
		dAtA[i] = 0xf0
		i++
		dAtA[i] = 0x1
		i++
		if m.SidecarToTelemetrySessionAffinity {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.DefaultServiceExportTo) > 0 {
		for _, s := range m.DefaultServiceExportTo {
			dAtA[i] = 0xfa
			i++
			dAtA[i] = 0x1
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.DefaultVirtualServiceExportTo) > 0 {
		for _, s := range m.DefaultVirtualServiceExportTo {
			dAtA[i] = 0x82
			i++
			dAtA[i] = 0x2
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.DefaultDestinationRuleExportTo) > 0 {
		for _, s := range m.DefaultDestinationRuleExportTo {
			dAtA[i] = 0x8a
			i++
			dAtA[i] = 0x2
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.RootNamespace) > 0 {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.RootNamespace)))
		i += copy(dAtA[i:], m.RootNamespace)
	}
	if m.LocalityLbSetting != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.LocalityLbSetting.Size()))
		n7, err := m.LocalityLbSetting.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.DnsRefreshRate != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.DnsRefreshRate.Size()))
		n8, err := m.DnsRefreshRate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MeshConfig_OutboundTrafficPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_OutboundTrafficPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Mode != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Mode))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Address) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.TlsSettings != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.TlsSettings.Size()))
		n9, err := m.TlsSettings.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LocalityLoadBalancerSetting) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityLoadBalancerSetting) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Distribute) > 0 {
		for _, msg := range m.Distribute {
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Failover) > 0 {
		for _, msg := range m.Failover {
			dAtA[i] = 0x12
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LocalityLoadBalancerSetting_Distribute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityLoadBalancerSetting_Distribute) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.From) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.From)))
		i += copy(dAtA[i:], m.From)
	}
	if len(m.To) > 0 {
		for k, _ := range m.To {
			dAtA[i] = 0x12
			i++
			v := m.To[k]
			mapSize := 1 + len(k) + sovConfig(uint64(len(k))) + 1 + sovConfig(uint64(v))
			i = encodeVarintConfig(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintConfig(dAtA, i, uint64(v))
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LocalityLoadBalancerSetting_Failover) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityLoadBalancerSetting_Failover) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.From) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.From)))
		i += copy(dAtA[i:], m.From)
	}
	if len(m.To) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.To)))
		i += copy(dAtA[i:], m.To)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *MeshConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MixerCheckServer)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.MixerReportServer)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.DisablePolicyChecks {
		n += 2
	}
	if m.ProxyListenPort != 0 {
		n += 1 + sovConfig(uint64(m.ProxyListenPort))
	}
	if m.ProxyHttpPort != 0 {
		n += 1 + sovConfig(uint64(m.ProxyHttpPort))
	}
	if m.ConnectTimeout != nil {
		l = m.ConnectTimeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.IngressClass)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.IngressService)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.IngressControllerMode != 0 {
		n += 1 + sovConfig(uint64(m.IngressControllerMode))
	}
	if m.AuthPolicy != 0 {
		n += 1 + sovConfig(uint64(m.AuthPolicy))
	}
	if m.RdsRefreshDelay != nil {
		l = m.RdsRefreshDelay.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.EnableTracing {
		n += 2
	}
	l = len(m.AccessLogFile)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.DefaultConfig != nil {
		l = m.DefaultConfig.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.MixerAddress)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.OutboundTrafficPolicy != nil {
		l = m.OutboundTrafficPolicy.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.EnableClientSidePolicyCheck {
		n += 3
	}
	l = len(m.SdsUdsPath)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.SdsRefreshDelay != nil {
		l = m.SdsRefreshDelay.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if len(m.ConfigSources) > 0 {
		for _, e := range m.ConfigSources {
			l = e.Size()
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if m.EnableSdsTokenMount {
		n += 3
	}
	l = len(m.AccessLogFormat)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.PolicyCheckFailOpen {
		n += 3
	}
	l = len(m.TrustDomain)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.AccessLogEncoding != 0 {
		n += 2 + sovConfig(uint64(m.AccessLogEncoding))
	}
	if m.TcpKeepalive != nil {
		l = m.TcpKeepalive.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.SdsUseK8SSaJwt {
		n += 3
	}
	if m.SidecarToTelemetrySessionAffinity {
		n += 3
	}
	if len(m.DefaultServiceExportTo) > 0 {
		for _, s := range m.DefaultServiceExportTo {
			l = len(s)
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if len(m.DefaultVirtualServiceExportTo) > 0 {
		for _, s := range m.DefaultVirtualServiceExportTo {
			l = len(s)
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	if len(m.DefaultDestinationRuleExportTo) > 0 {
		for _, s := range m.DefaultDestinationRuleExportTo {
			l = len(s)
			n += 2 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.RootNamespace)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.LocalityLbSetting != nil {
		l = m.LocalityLbSetting.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.DnsRefreshRate != nil {
		l = m.DnsRefreshRate.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MeshConfig_OutboundTrafficPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovConfig(uint64(m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigSource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.TlsSettings != nil {
		l = m.TlsSettings.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalityLoadBalancerSetting) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Distribute) > 0 {
		for _, e := range m.Distribute {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if len(m.Failover) > 0 {
		for _, e := range m.Failover {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalityLoadBalancerSetting_Distribute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.From)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.To) > 0 {
		for k, v := range m.To {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + 1 + sovConfig(uint64(v))
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalityLoadBalancerSetting_Failover) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.From)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.To)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MeshConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MeshConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MeshConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerCheckServer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MixerCheckServer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerReportServer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MixerReportServer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisablePolicyChecks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisablePolicyChecks = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyListenPort", wireType)
			}
			m.ProxyListenPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyListenPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyHttpPort", wireType)
			}
			m.ProxyHttpPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyHttpPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectTimeout == nil {
				m.ConnectTimeout = &types.Duration{}
			}
			if err := m.ConnectTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngressClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngressService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressControllerMode", wireType)
			}
			m.IngressControllerMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IngressControllerMode |= MeshConfig_IngressControllerMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthPolicy", wireType)
			}
			m.AuthPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AuthPolicy |= MeshConfig_AuthPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RdsRefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RdsRefreshDelay == nil {
				m.RdsRefreshDelay = &types.Duration{}
			}
			if err := m.RdsRefreshDelay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableTracing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableTracing = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLogFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultConfig == nil {
				m.DefaultConfig = &ProxyConfig{}
			}
			if err := m.DefaultConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MixerAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutboundTrafficPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutboundTrafficPolicy == nil {
				m.OutboundTrafficPolicy = &MeshConfig_OutboundTrafficPolicy{}
			}
			if err := m.OutboundTrafficPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableClientSidePolicyCheck", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableClientSidePolicyCheck = bool(v != 0)
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsUdsPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SdsUdsPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsRefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SdsRefreshDelay == nil {
				m.SdsRefreshDelay = &types.Duration{}
			}
			if err := m.SdsRefreshDelay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigSources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigSources = append(m.ConfigSources, &ConfigSource{})
			if err := m.ConfigSources[len(m.ConfigSources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableSdsTokenMount", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableSdsTokenMount = bool(v != 0)
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLogFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyCheckFailOpen", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PolicyCheckFailOpen = bool(v != 0)
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustDomain", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustDomain = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogEncoding", wireType)
			}
			m.AccessLogEncoding = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AccessLogEncoding |= MeshConfig_AccessLogEncoding(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpKeepalive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpKeepalive == nil {
				m.TcpKeepalive = &v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive{}
			}
			if err := m.TcpKeepalive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsUseK8SSaJwt", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SdsUseK8SSaJwt = bool(v != 0)
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SidecarToTelemetrySessionAffinity", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SidecarToTelemetrySessionAffinity = bool(v != 0)
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultServiceExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultServiceExportTo = append(m.DefaultServiceExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultVirtualServiceExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultVirtualServiceExportTo = append(m.DefaultVirtualServiceExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultDestinationRuleExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultDestinationRuleExportTo = append(m.DefaultDestinationRuleExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RootNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityLbSetting", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalityLbSetting == nil {
				m.LocalityLbSetting = &LocalityLoadBalancerSetting{}
			}
			if err := m.LocalityLbSetting.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsRefreshRate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsRefreshRate == nil {
				m.DnsRefreshRate = &types.Duration{}
			}
			if err := m.DnsRefreshRate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_OutboundTrafficPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutboundTrafficPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutboundTrafficPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= MeshConfig_OutboundTrafficPolicy_Mode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsSettings == nil {
				m.TlsSettings = &v1alpha3.TLSSettings{}
			}
			if err := m.TlsSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityLoadBalancerSetting) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalityLoadBalancerSetting: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalityLoadBalancerSetting: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Distribute", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Distribute = append(m.Distribute, &LocalityLoadBalancerSetting_Distribute{})
			if err := m.Distribute[len(m.Distribute)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failover", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Failover = append(m.Failover, &LocalityLoadBalancerSetting_Failover{})
			if err := m.Failover[len(m.Failover)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityLoadBalancerSetting_Distribute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Distribute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Distribute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.From = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = make(map[string]uint32)
			}
			var mapkey string
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.To[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityLoadBalancerSetting_Failover) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Failover: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Failover: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.From = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.To = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthConfig
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)
