/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/eventing-contrib/kafka/source/pkg/apis/sources/v1alpha1"
	scheme "knative.dev/eventing-contrib/kafka/source/pkg/client/clientset/versioned/scheme"
)

// KafkaSourcesGetter has a method to return a KafkaSourceInterface.
// A group's client should implement this interface.
type KafkaSourcesGetter interface {
	KafkaSources(namespace string) KafkaSourceInterface
}

// KafkaSourceInterface has methods to work with KafkaSource resources.
type KafkaSourceInterface interface {
	Create(*v1alpha1.KafkaSource) (*v1alpha1.KafkaSource, error)
	Update(*v1alpha1.KafkaSource) (*v1alpha1.KafkaSource, error)
	UpdateStatus(*v1alpha1.KafkaSource) (*v1alpha1.KafkaSource, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.KafkaSource, error)
	List(opts v1.ListOptions) (*v1alpha1.KafkaSourceList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.KafkaSource, err error)
	KafkaSourceExpansion
}

// kafkaSources implements KafkaSourceInterface
type kafkaSources struct {
	client rest.Interface
	ns     string
}

// newKafkaSources returns a KafkaSources
func newKafkaSources(c *SourcesV1alpha1Client, namespace string) *kafkaSources {
	return &kafkaSources{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the kafkaSource, and returns the corresponding kafkaSource object, and an error if there is any.
func (c *kafkaSources) Get(name string, options v1.GetOptions) (result *v1alpha1.KafkaSource, err error) {
	result = &v1alpha1.KafkaSource{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kafkasources").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KafkaSources that match those selectors.
func (c *kafkaSources) List(opts v1.ListOptions) (result *v1alpha1.KafkaSourceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.KafkaSourceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kafkasources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kafkaSources.
func (c *kafkaSources) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("kafkasources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a kafkaSource and creates it.  Returns the server's representation of the kafkaSource, and an error, if there is any.
func (c *kafkaSources) Create(kafkaSource *v1alpha1.KafkaSource) (result *v1alpha1.KafkaSource, err error) {
	result = &v1alpha1.KafkaSource{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("kafkasources").
		Body(kafkaSource).
		Do().
		Into(result)
	return
}

// Update takes the representation of a kafkaSource and updates it. Returns the server's representation of the kafkaSource, and an error, if there is any.
func (c *kafkaSources) Update(kafkaSource *v1alpha1.KafkaSource) (result *v1alpha1.KafkaSource, err error) {
	result = &v1alpha1.KafkaSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kafkasources").
		Name(kafkaSource.Name).
		Body(kafkaSource).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *kafkaSources) UpdateStatus(kafkaSource *v1alpha1.KafkaSource) (result *v1alpha1.KafkaSource, err error) {
	result = &v1alpha1.KafkaSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kafkasources").
		Name(kafkaSource.Name).
		SubResource("status").
		Body(kafkaSource).
		Do().
		Into(result)
	return
}

// Delete takes name of the kafkaSource and deletes it. Returns an error if one occurs.
func (c *kafkaSources) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kafkasources").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kafkaSources) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kafkasources").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched kafkaSource.
func (c *kafkaSources) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.KafkaSource, err error) {
	result = &v1alpha1.KafkaSource{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("kafkasources").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
